/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen;

import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;

public class TypeParameterCaptureVisitor
extends Visitor {
    @Override
    public void visit(Tree.ClassOrInterface that) {
        ClassOrInterface model = that.getDeclarationModel();
        if (!(model == null || model.isAlias() || model.isToplevel() || model.isMember())) {
            this.captureTypeParameters(model);
        }
        super.visit(that);
    }

    private void captureTypeParameters(ClassOrInterface model) {
        for (Scope container = model.getContainer(); container != null && !(container instanceof Package); container = container.getContainer()) {
            if (!(container instanceof Function)) continue;
            for (TypeParameter tp : ((Function)container).getTypeParameters()) {
                tp.setCaptured(true);
            }
        }
    }
}

