/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen;

import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.compiler.java.codegen.AnnotationInvocationVisitor;
import com.redhat.ceylon.compiler.java.codegen.AnnotationUtil;
import com.redhat.ceylon.compiler.java.codegen.ErroneousException;
import com.redhat.ceylon.compiler.java.codegen.ExpressionTransformer;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.compiler.typechecker.util.NativeUtil;
import com.redhat.ceylon.model.loader.JvmBackendUtil;
import com.redhat.ceylon.model.loader.model.OutputElement;
import java.util.EnumSet;
import java.util.List;

public class UnsupportedVisitor
extends Visitor {
    static final String DYNAMIC_UNSUPPORTED_ERR = "dynamic is not supported on the JVM";

    @Override
    public void visit(Tree.Annotation that) {
        String msg = AnnotationInvocationVisitor.checkForBannedJavaAnnotation(that);
        if (msg != null) {
            that.addError(msg, Backend.Java);
        }
        super.visit(that);
    }

    @Override
    public void visit(Tree.FloatLiteral that) {
        try {
            ExpressionTransformer.literalValue(that);
        }
        catch (ErroneousException e) {
            that.addError(e.getMessage(), Backend.Java);
        }
        super.visit(that);
    }

    @Override
    public void visit(Tree.NaturalLiteral that) {
        try {
            ExpressionTransformer.literalValue(that);
        }
        catch (ErroneousException e) {
            that.addError(e.getMessage(), Backend.Java);
        }
        super.visit(that);
    }

    @Override
    public void visit(Tree.NegativeOp that) {
        if (that.getTerm() instanceof Tree.NaturalLiteral) {
            try {
                ExpressionTransformer.literalValue(that);
            }
            catch (ErroneousException e) {
                that.addError(e.getMessage(), Backend.Java);
            }
        } else {
            super.visit(that);
        }
    }

    @Override
    public void visit(Tree.AttributeGetterDefinition that) {
        if (!NativeUtil.isForBackend(that, Backend.Java)) {
            return;
        }
        this.interopAnnotationTargeting(AnnotationUtil.outputs(that), that.getAnnotationList());
        super.visit(that);
    }

    @Override
    public void visit(Tree.AttributeSetterDefinition that) {
        if (!NativeUtil.isForBackend(that, Backend.Java)) {
            return;
        }
        this.interopAnnotationTargeting(AnnotationUtil.outputs(that), that.getAnnotationList());
        super.visit(that);
    }

    @Override
    public void visit(Tree.AttributeDeclaration that) {
        if (!NativeUtil.isForBackend(that, Backend.Java)) {
            return;
        }
        this.interopAnnotationTargeting(AnnotationUtil.outputs(that), that.getAnnotationList());
        super.visit(that);
    }

    @Override
    public void visit(Tree.ObjectDefinition that) {
        if (!NativeUtil.isForBackend(that, Backend.Java)) {
            return;
        }
        this.interopAnnotationTargeting(AnnotationUtil.outputs(that), that.getAnnotationList());
        super.visit(that);
    }

    @Override
    public void visit(Tree.AnyClass that) {
        if (!NativeUtil.isForBackend(that, Backend.Java)) {
            return;
        }
        this.interopAnnotationTargeting(AnnotationUtil.outputs(that), that.getAnnotationList());
        super.visit(that);
    }

    @Override
    public void visit(Tree.Constructor that) {
        if (!NativeUtil.isForBackend(that, Backend.Java)) {
            return;
        }
        this.interopAnnotationTargeting(AnnotationUtil.outputs(that), that.getAnnotationList());
        super.visit(that);
    }

    @Override
    public void visit(Tree.Enumerated that) {
        if (!NativeUtil.isForBackend(that, Backend.Java)) {
            return;
        }
        this.interopAnnotationTargeting(AnnotationUtil.outputs(that), that.getAnnotationList());
        super.visit(that);
    }

    @Override
    public void visit(Tree.AnyInterface that) {
        if (!NativeUtil.isForBackend(that, Backend.Java)) {
            return;
        }
        this.interopAnnotationTargeting(AnnotationUtil.outputs(that), that.getAnnotationList());
        super.visit(that);
    }

    @Override
    public void visit(Tree.AnyMethod that) {
        if (!NativeUtil.isForBackend(that, Backend.Java)) {
            return;
        }
        this.interopAnnotationTargeting(AnnotationUtil.outputs(that), that.getAnnotationList());
        super.visit(that);
    }

    private void interopAnnotationTargeting(EnumSet<OutputElement> outputs, Tree.AnnotationList annotationList) {
        List<Tree.Annotation> annotations = annotationList.getAnnotations();
        for (Tree.Annotation annotation : annotations) {
            AnnotationUtil.interopAnnotationTargeting(outputs, annotation, true);
        }
        AnnotationUtil.duplicateInteropAnnotation(outputs, annotations);
    }

    @Override
    public void visit(Tree.TypeConstraint that) {
        if (that.getSatisfiedTypes() != null) {
            for (Tree.StaticType t : that.getSatisfiedTypes().getTypes()) {
                if (t.getTypeModel() == null || !JvmBackendUtil.isJavaArray(t.getTypeModel().getDeclaration())) continue;
                t.addError("Type parameter cannot be bounded by a Java array", Backend.Java);
            }
        }
        super.visit(that);
    }
}

