/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen.recovery;

import com.redhat.ceylon.compiler.java.codegen.recovery.HasErrorException;
import com.redhat.ceylon.compiler.typechecker.analyzer.UsageWarning;
import com.redhat.ceylon.compiler.typechecker.tree.Message;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import java.util.List;

class StatementErrorVisitor
extends Visitor {
    StatementErrorVisitor() {
    }

    public boolean hasErrors(Node target) {
        try {
            target.visit(this);
            return false;
        }
        catch (HasErrorException x) {
            return true;
        }
    }

    public HasErrorException getFirstErrorMessage(Node target) {
        try {
            target.visit(this);
            return null;
        }
        catch (HasErrorException x) {
            return x;
        }
    }

    @Override
    public void handleException(Exception e, Node that) {
        throw (RuntimeException)e;
    }

    @Override
    public void visitAny(Node that) {
        this.throwIfError(that);
        super.visitAny(that);
    }

    protected void throwIfError(Node that) {
        Message m = this.hasError(that);
        if (m != null) {
            throw new HasErrorException(that, m);
        }
    }

    protected Message hasError(Node that) {
        List<Message> errors = that.getErrors();
        int l = errors.size();
        for (int i = 0; i < l; ++i) {
            Message message = errors.get(i);
            if (!this.isError(that, message)) continue;
            return message;
        }
        return null;
    }

    protected boolean isError(Node that, Message message) {
        return !(message instanceof UsageWarning);
    }

    @Override
    public void visit(Tree.Block that) {
    }

    @Override
    public void visit(Tree.Declaration that) {
    }

    @Override
    public void visit(Tree.Variable that) {
        this.visitAny(that);
    }
}

