/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.language;

import ceylon.language.AssertionError;
import ceylon.language.Boolean;
import ceylon.language.Callable;
import ceylon.language.Iterator;
import ceylon.language.Null;
import ceylon.language.emptyIterator_;
import ceylon.language.impl.BaseIterable;
import com.redhat.ceylon.compiler.java.language.AbstractArrayIterator;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;

public abstract class AbstractArrayIterable<Element, ArrayType>
extends BaseIterable<Element, Null> {
    private final TypeDescriptor $reified$Element;
    private final ArrayType array;
    protected final int start;
    protected final int step;
    protected final int len;

    @Override
    public TypeDescriptor $getType$() {
        return TypeDescriptor.klass(AbstractArrayIterable.class, this.$reified$Element);
    }

    @Ignore
    public AbstractArrayIterable(TypeDescriptor $reified$Element, ArrayType array, int length) {
        this($reified$Element, array, 0, length, 1);
    }

    @Ignore
    protected AbstractArrayIterable(TypeDescriptor $reified$Element, ArrayType array, int start, int len, int step) {
        super($reified$Element, Null.$TypeDescriptor$);
        if (start < 0) {
            throw new AssertionError("start must be non-negative");
        }
        if (len < 0) {
            throw new AssertionError("len must be non-negative");
        }
        if (step <= 0) {
            throw new AssertionError("step size must be greater than zero");
        }
        this.array = array;
        this.$reified$Element = $reified$Element;
        this.start = start;
        this.len = len;
        this.step = step;
    }

    protected abstract AbstractArrayIterable<Element, ArrayType> newInstance(ArrayType var1, int var2, int var3, int var4);

    protected abstract Element get(ArrayType var1, int var2);

    @Ignore
    public ArrayType arrayValue() {
        return this.array;
    }

    @Override
    public boolean getEmpty() {
        return this.len == 0;
    }

    @Override
    public Element getFirst() {
        return this.getEmpty() ? null : (Element)this.get(this.array, this.start);
    }

    @Override
    public Element getLast() {
        return this.getEmpty() ? null : (Element)this.get(this.array, this.start + this.step * this.len - 1);
    }

    @Override
    public AbstractArrayIterable<Element, ArrayType> getRest() {
        return this.getEmpty() ? this : this.newInstance(this.array, this.start + this.step, this.len - 1, this.step);
    }

    @Override
    @Ignore
    public long getSize() {
        return Math.max(0, this.len);
    }

    @Override
    public Iterator<? extends Element> iterator() {
        if (this.getEmpty()) {
            return emptyIterator_.get_();
        }
        return new AbstractArrayIterator<Element>(this.$reified$Element, this.start, this.len, this.step){

            @Override
            protected Element get(int index) {
                return AbstractArrayIterable.this.get(AbstractArrayIterable.this.array, index);
            }
        };
    }

    @Override
    public boolean longerThan(long length) {
        return this.getSize() > length;
    }

    @Override
    public boolean shorterThan(long length) {
        return this.getSize() < length;
    }

    @Override
    public AbstractArrayIterable<Element, ArrayType> skip(long skip) {
        if (skip <= 0L) {
            return this;
        }
        return this.newInstance(this.array, this.start + (int)skip * this.step, this.len - (int)skip, this.step);
    }

    @Override
    public AbstractArrayIterable<Element, ArrayType> take(long take) {
        if (take >= this.getSize()) {
            return this;
        }
        return this.newInstance(this.array, this.start, (int)take, this.step);
    }

    @Override
    public AbstractArrayIterable<Element, ArrayType> by(long step) {
        return this.newInstance(this.array, this.start, (int)(((long)this.len + step - 1L) / step), this.step * (int)step);
    }

    @Override
    public Object each(Callable<? extends Object> step) {
        int end = this.start + this.len;
        for (int i = this.start; i < end; i += this.step) {
            step.$call$((Object)this.get(this.array, i));
        }
        return null;
    }

    @Override
    public long count(Callable<? extends Boolean> selecting) {
        int count = 0;
        int end = this.start + this.len;
        for (int i = this.start; i < end; i += this.step) {
            if (!selecting.$call$((Object)this.get(this.array, i)).booleanValue()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean any(Callable<? extends Boolean> selecting) {
        int end = this.start + this.len;
        for (int i = this.start; i < end; i += this.step) {
            if (!selecting.$call$((Object)this.get(this.array, i)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean every(Callable<? extends Boolean> selecting) {
        int end = this.start + this.len;
        for (int i = this.start; i < end; i += this.step) {
            if (selecting.$call$((Object)this.get(this.array, i)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Element find(Callable<? extends Boolean> selecting) {
        int end = this.start + this.len;
        for (int i = this.start; i < end; i += this.step) {
            Element elem = this.get(this.array, i);
            if (!selecting.$call$((Object)elem).booleanValue()) continue;
            return elem;
        }
        return null;
    }

    @Override
    public Element findLast(Callable<? extends Boolean> selecting) {
        int end = this.start + this.len;
        for (int i = this.start; i < end; i += this.step) {
            Element elem = this.get(this.array, i);
            if (!selecting.$call$((Object)elem).booleanValue()) continue;
            return elem;
        }
        return null;
    }

    @Override
    public <Result> Object reduce(@Ignore TypeDescriptor $reifiedResult, Callable<? extends Result> accumulating) {
        if (this.len == 0) {
            return null;
        }
        Object partial = this.get(this.array, this.start);
        int end = this.start + this.len;
        for (int i = this.start + 1; i < end; i += this.step) {
            partial = accumulating.$call$(partial, (Object)this.get(this.array, i));
        }
        return partial;
    }
}

