/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.language;

import ceylon.language.Boolean;
import ceylon.language.Callable;
import ceylon.language.Iterator;
import ceylon.language.Null;
import ceylon.language.String;
import ceylon.language.finished_;
import ceylon.language.impl.BaseIterable;
import ceylon.language.impl.BaseIterator;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Class;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.SatisfiedTypes;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;

@Ceylon(major=8)
@Class(extendsType="ceylon.language::Object", basic=false, identifiable=false)
@SatisfiedTypes(value={"ceylon.language::Iterable<ceylon.language::String,ceylon.language::Null>"})
public class StringTokens
extends BaseIterable<String, Object> {
    private final java.lang.String str;
    private final Callable<? extends Boolean> separator;
    private final boolean keepSeparators;
    private final boolean groupSeparators;

    public StringTokens(java.lang.String str, @TypeInfo(value="ceylon.language::Callable<ceylon.language::Boolean,ceylon.language::Tuple<ceylon.language::Character,ceylon.language::Character,ceylon.language::Empty>>") Callable<? extends Boolean> separator, boolean keepSeparators, boolean groupSeparators) {
        super(String.$TypeDescriptor$, Null.$TypeDescriptor$);
        this.str = str;
        this.separator = separator;
        this.keepSeparators = keepSeparators;
        this.groupSeparators = groupSeparators;
    }

    @TypeInfo(value="ceylon.language::Callable<ceylon.language::Boolean,ceylon.language::Tuple<ceylon.language::Character,ceylon.language::Character,ceylon.language::Empty>>")
    private final Callable<? extends Boolean> getSeparator$priv() {
        return this.separator;
    }

    @Override
    public Iterator<? extends String> iterator() {
        return new TokenIterator(){

            @Override
            protected final boolean peekSeparator() {
                if (this.eof()) {
                    return false;
                }
                int charCodePoint = Character.codePointAt(StringTokens.this.str, this.index);
                return ((Boolean)StringTokens.this.separator.$call$((Object)ceylon.language.Character.instance(charCodePoint))).booleanValue();
            }
        };
    }

    @Override
    public boolean getEmpty() {
        return this.iterator().next() == finished_.get_();
    }

    @Override
    @Ignore
    public TypeDescriptor $getType$() {
        return TypeDescriptor.klass(StringTokens.class, new TypeDescriptor[0]);
    }

    abstract class TokenIterator
    extends BaseIterator<String> {
        protected int index;
        private boolean first;
        private boolean lastTokenWasSeparator;

        public TokenIterator() {
            super(String.$TypeDescriptor$);
            this.index = 0;
            this.first = true;
            this.lastTokenWasSeparator = false;
        }

        @Override
        public Object next() {
            if (!this.eof()) {
                int start = this.index;
                if ((this.first && start == 0 || this.lastTokenWasSeparator) && this.peekSeparator()) {
                    this.first = false;
                    this.lastTokenWasSeparator = false;
                    return String.instance("");
                }
                if (this.eatSeparator()) {
                    if (StringTokens.this.groupSeparators) {
                        while (this.eatSeparator()) {
                        }
                    }
                    if (StringTokens.this.keepSeparators) {
                        this.lastTokenWasSeparator = true;
                        return String.instance(StringTokens.this.str.substring(start, this.index));
                    }
                    start = this.index;
                }
                while (!this.eof() && !this.peekSeparator()) {
                    this.eatChar();
                }
                this.lastTokenWasSeparator = false;
                return String.instance(StringTokens.this.str.substring(start, this.index));
            }
            if (this.lastTokenWasSeparator) {
                this.lastTokenWasSeparator = false;
                return String.instance("");
            }
            return finished_.get_();
        }

        protected boolean eof() {
            return this.index >= StringTokens.this.str.length();
        }

        private boolean eatSeparator() {
            boolean ret = this.peekSeparator();
            if (ret) {
                this.eatChar();
            }
            return ret;
        }

        private void eatChar() {
            this.index = Character.isHighSurrogate(StringTokens.this.str.charAt(this.index)) ? (this.index += 2) : ++this.index;
        }

        protected abstract boolean peekSeparator();

        @Override
        @Ignore
        public TypeDescriptor $getType$() {
            return TypeDescriptor.klass(TokenIterator.class, new TypeDescriptor[0]);
        }
    }
}

