/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.launcher;

import com.redhat.ceylon.common.tools.SourceArgumentsResolver;
import com.redhat.ceylon.compiler.EnvironmentException;
import com.redhat.ceylon.compiler.java.tools.CeylonLocation;
import com.redhat.ceylon.compiler.java.tools.CeylonLog;
import com.redhat.ceylon.compiler.java.tools.CeyloncFileManager;
import com.redhat.ceylon.compiler.java.tools.LanguageCompiler;
import com.redhat.ceylon.compiler.java.util.Timer;
import com.redhat.ceylon.javax.annotation.processing.Processor;
import com.redhat.ceylon.javax.tools.JavaFileManager;
import com.redhat.ceylon.javax.tools.JavaFileObject;
import com.redhat.ceylon.javax.tools.StandardLocation;
import com.redhat.ceylon.langtools.tools.javac.code.Source;
import com.redhat.ceylon.langtools.tools.javac.file.JavacFileManager;
import com.redhat.ceylon.langtools.tools.javac.jvm.Target;
import com.redhat.ceylon.langtools.tools.javac.main.JavaCompiler;
import com.redhat.ceylon.langtools.tools.javac.main.JavacOption;
import com.redhat.ceylon.langtools.tools.javac.main.RecognizedOptions;
import com.redhat.ceylon.langtools.tools.javac.processing.AnnotationProcessingError;
import com.redhat.ceylon.langtools.tools.javac.util.ClientCodeException;
import com.redhat.ceylon.langtools.tools.javac.util.Context;
import com.redhat.ceylon.langtools.tools.javac.util.FatalError;
import com.redhat.ceylon.langtools.tools.javac.util.JavacMessages;
import com.redhat.ceylon.langtools.tools.javac.util.ListBuffer;
import com.redhat.ceylon.langtools.tools.javac.util.Log;
import com.redhat.ceylon.langtools.tools.javac.util.Options;
import com.redhat.ceylon.langtools.tools.javac.util.PropagatedException;
import com.redhat.ceylon.model.cmr.RepositoryException;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.MissingResourceException;

public class Main
extends com.redhat.ceylon.langtools.tools.javac.main.Main {
    String ownName;
    PrintWriter out;
    boolean fatalErrors;
    public static final int EXIT_OK = 0;
    public static final int EXIT_ERROR = 1;
    public static final int EXIT_CMDERR = 2;
    public static final int EXIT_SYSERR = 3;
    public static final int EXIT_ABNORMAL = 4;
    private JavacOption.Option[] recognizedOptions = RecognizedOptions.getJavaCompilerOptions(new RecognizedOptions.OptionHelper(){

        @Override
        public void setOut(PrintWriter out) {
            Main.this.out = out;
        }

        @Override
        public void error(String key, Object ... args) {
            Main.this.error(key, args);
        }

        @Override
        public void printVersion() {
            Log.printLines(Main.this.out, Main.getLocalizedString("version", Main.this.ownName, JavaCompiler.version()));
        }

        @Override
        public void printFullVersion() {
            Log.printLines(Main.this.out, Main.getLocalizedString("fullVersion", Main.this.ownName, JavaCompiler.fullVersion()));
        }

        @Override
        public void printHelp() {
            Main.this.help();
        }

        @Override
        public void printXhelp() {
            Main.this.xhelp();
        }

        @Override
        public void addFile(File f) {
            if (!Main.this.filenames.contains(f)) {
                Main.this.filenames.append(f);
            }
        }

        @Override
        public void addClassName(String s) {
            Main.this.classnames.append(s);
        }
    });
    private Options options = null;
    private Timer timer = null;
    public ListBuffer<File> filenames = null;
    public ListBuffer<String> classnames = null;
    public ExitState exitState = null;
    private JavaFileManager fileManager;
    private static final String javacBundleName = "com.redhat.ceylon.langtools.tools.javac.resources.ceylonc";
    private static JavacMessages messages;

    public Main(String name) {
        this(name, new PrintWriter(System.err, true));
    }

    public Main(String name, PrintWriter out) {
        super(name, out);
        this.ownName = name;
        this.out = out;
    }

    void error(String key, Object ... args) {
        if (this.fatalErrors) {
            String msg = Main.getLocalizedString(key, args);
            throw new PropagatedException(new IllegalStateException(msg));
        }
        this.warning(key, args);
        Log.printLines(this.out, Main.getLocalizedString("msg.usage", this.ownName));
    }

    void warning(String key, Object ... args) {
        Log.printLines(this.out, this.ownName + ": " + Main.getLocalizedString(key, args));
    }

    @Override
    public JavacOption.Option getOption(String flag) {
        for (JavacOption.Option option : this.recognizedOptions) {
            if (!option.matches(flag)) continue;
            return option;
        }
        return null;
    }

    @Override
    public void setOptions(Options options) {
        if (options == null) {
            throw new NullPointerException();
        }
        this.options = options;
    }

    public void setFatalErrors(boolean fatalErrors) {
        this.fatalErrors = fatalErrors;
    }

    @Override
    public com.redhat.ceylon.langtools.tools.javac.util.List<File> processArgs(String[] flags) {
        Target target;
        int ac = 0;
        while (ac < flags.length) {
            int firstOptionToCheck;
            int j;
            String flag = flags[ac];
            ++ac;
            for (j = firstOptionToCheck = flag.charAt(0) == '-' ? 0 : this.recognizedOptions.length - 1; j < this.recognizedOptions.length && !this.recognizedOptions[j].matches(flag); ++j) {
            }
            if (j == this.recognizedOptions.length) {
                this.error("err.invalid.flag", flag);
                return null;
            }
            JavacOption.Option option = this.recognizedOptions[j];
            if (option.hasArg()) {
                if (ac == flags.length) {
                    this.error("err.req.arg", flag);
                    return null;
                }
                String operand = flags[ac];
                ++ac;
                if (!option.process(this.options, flag, operand)) continue;
                return null;
            }
            if (!option.process(this.options, flag)) continue;
            return null;
        }
        if (!this.checkDirectoryOrURL("-d")) {
            return null;
        }
        if (!this.checkDirectory("-s")) {
            return null;
        }
        String sourceString = this.options.get("-source");
        Source source = sourceString != null ? Source.lookup(sourceString) : Source.DEFAULT;
        String targetString = this.options.get("-target");
        Target target2 = target = targetString != null ? Target.lookup(targetString) : Target.DEFAULT;
        if (Character.isDigit(target.name.charAt(0))) {
            if (target.compareTo(source.requiredTarget()) < 0) {
                if (targetString != null) {
                    if (sourceString == null) {
                        this.warning("warn.target.default.source.conflict", targetString, source.requiredTarget().name);
                    } else {
                        this.warning("warn.source.target.conflict", sourceString, source.requiredTarget().name);
                    }
                    return null;
                }
                this.options.put("-target", source.requiredTarget().name);
            } else if (targetString == null && !source.allowGenerics()) {
                this.options.put("-target", Target.JDK1_4.name);
            }
        }
        return this.filenames.toList();
    }

    private boolean checkDirectory(String optName) {
        String value = this.options.get(optName);
        if (value == null) {
            return true;
        }
        File file = new File(value);
        if (!file.exists()) {
            this.error("err.dir.not.found", value);
            return false;
        }
        if (!file.isDirectory()) {
            this.error("err.file.not.directory", value);
            return false;
        }
        return true;
    }

    private boolean checkDirectoryOrURL(String optName) {
        String value = this.options.get(optName);
        if (value == null) {
            return true;
        }
        try {
            URL url = new URL(value);
            String scheme = url.getProtocol();
            if ("http".equals(scheme) || "https".equals(scheme)) {
                return true;
            }
            this.error("ceylon.err.output.repo.not.supported", value);
            return false;
        }
        catch (MalformedURLException url) {
            File file = new File(value);
            if (file.exists() && !file.isDirectory()) {
                this.error("err.file.not.directory", value);
                return false;
            }
            return true;
        }
    }

    @Override
    public int compile(String[] args) {
        Context context = new Context();
        CeyloncFileManager.preRegister(context);
        CeylonLog.preRegister(context);
        int result = this.compile(args, context);
        if (this.fileManager instanceof JavacFileManager) {
            ((JavacFileManager)this.fileManager).close();
        }
        return result;
    }

    @Override
    public int compile(String[] args, Context context) {
        return this.compile(args, context, com.redhat.ceylon.langtools.tools.javac.util.List.nil(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int compile(String[] args, Context context, com.redhat.ceylon.langtools.tools.javac.util.List<JavaFileObject> fileObjects, Iterable<? extends Processor> processors) {
        int n;
        if (this.options == null) {
            this.options = Options.instance(context);
        }
        this.filenames = new ListBuffer();
        this.classnames = new ListBuffer();
        this.exitState = null;
        JavaCompiler comp = null;
        try {
            boolean forceStdOut;
            if (args.length == 0 && fileObjects.isEmpty()) {
                this.help();
                this.exitState = ExitState.cmderror();
                int n2 = 2;
                return n2;
            }
            com.redhat.ceylon.langtools.tools.javac.util.List<File> filenames = this.processArgs(args);
            if (filenames == null) {
                this.exitState = ExitState.cmderror();
                int n3 = 2;
                return n3;
            }
            if (filenames.isEmpty() && fileObjects.isEmpty() && this.classnames.isEmpty()) {
                if (this.options.get("-help") != null || this.options.get("-jhelp") != null || this.options.get("-X") != null || this.options.get("-version") != null || this.options.get("-fullversion") != null) {
                    int n4 = 0;
                    return n4;
                }
                this.error("err.no.source.files", new Object[0]);
                this.exitState = ExitState.cmderror();
                int n5 = 2;
                return n5;
            }
            this.timer = Timer.instance(context);
            this.timer.init();
            boolean bl = forceStdOut = this.options.get("stdout") != null;
            if (forceStdOut) {
                this.out.flush();
                this.out = new PrintWriter(System.out, true);
            }
            context.put(Log.outKey, this.out);
            this.fileManager = context.get(JavaFileManager.class);
            comp = LanguageCompiler.instance(context);
            if (comp == null) {
                this.exitState = ExitState.systemError(null, null);
                int n6 = 3;
                return n6;
            }
            if (!this.classnames.isEmpty()) {
                filenames = this.addModuleFiles(filenames);
                this.classnames.clear();
            }
            if (!filenames.isEmpty()) {
                com.redhat.ceylon.langtools.tools.javac.util.List<JavaFileObject> otherFiles = com.redhat.ceylon.langtools.tools.javac.util.List.nil();
                JavacFileManager dfm = (JavacFileManager)this.fileManager;
                for (JavaFileObject javaFileObject : dfm.getJavaFileObjectsFromFiles(filenames)) {
                    otherFiles = otherFiles.append(javaFileObject);
                }
                fileObjects = fileObjects.prependList(otherFiles);
            }
            if (fileObjects.isEmpty()) {
                this.error("err.no.source.files", new Object[0]);
                this.exitState = ExitState.cmderror();
                int otherFiles = 2;
                return otherFiles;
            }
            comp.compile(fileObjects, this.classnames.toList(), processors);
            int errorCount = comp.errorCount();
            if (errorCount != 0) {
                this.exitState = ExitState.error(comp);
                int n7 = 1;
                return n7;
            }
        }
        catch (IOException ex) {
            this.ioMessage(ex);
            this.exitState = ExitState.systemError(null, ex);
            n = 3;
            return n;
        }
        catch (OutOfMemoryError ex) {
            this.resourceMessage(ex);
            this.exitState = ExitState.systemError(null, ex);
            n = 3;
            return n;
        }
        catch (StackOverflowError ex) {
            this.resourceMessage(ex);
            this.exitState = ExitState.systemError(null, ex);
            n = 3;
            return n;
        }
        catch (FatalError ex) {
            this.exitState = ExitState.systemError(comp, ex);
            if (this.exitState.javacExitCode == 3) {
                this.feMessage(ex);
            }
            n = this.exitState.javacExitCode;
            return n;
        }
        catch (AnnotationProcessingError ex) {
            this.apMessage(ex);
            this.exitState = ExitState.systemError(null, ex);
            n = 3;
            return n;
        }
        catch (ClientCodeException ex) {
            throw new RuntimeException(ex.getCause());
        }
        catch (PropagatedException ex) {
            throw ex.getCause();
        }
        catch (RepositoryException ex) {
            throw new EnvironmentException(ex);
        }
        catch (Throwable ex) {
            if (comp == null || comp.errorCount() == 0 || this.options == null || this.options.get("dev") != null) {
                this.bugMessage(ex);
            }
            this.exitState = ExitState.abnormal(comp, ex, this.options);
            n = 4;
            return n;
        }
        finally {
            if (comp != null) {
                comp.close();
            }
            this.filenames = null;
            this.options = null;
            if (this.timer != null) {
                this.timer.end();
            }
            this.timer = null;
        }
        this.exitState = ExitState.ok();
        return 0;
    }

    private com.redhat.ceylon.langtools.tools.javac.util.List<File> addModuleFiles(com.redhat.ceylon.langtools.tools.javac.util.List<File> filenames) throws IOException {
        Iterable<File> srcdirs = ((JavacFileManager)this.fileManager).getLocation(StandardLocation.SOURCE_PATH);
        Iterable<File> resdirs = ((JavacFileManager)this.fileManager).getLocation(CeylonLocation.RESOURCE_PATH);
        SourceArgumentsResolver resolver = new SourceArgumentsResolver(srcdirs, resdirs, ".ceylon", ".java");
        resolver.parse(this.classnames.toList());
        filenames = this.appendAll(filenames, resolver.getSourceFiles());
        filenames = this.appendAll(filenames, resolver.getResourceFiles());
        return filenames;
    }

    private com.redhat.ceylon.langtools.tools.javac.util.List<File> appendAll(com.redhat.ceylon.langtools.tools.javac.util.List<File> target, List<File> source) {
        for (File f : source) {
            target = target.append(f);
        }
        return target;
    }

    void bugMessage(Throwable ex) {
        Log.printLines(this.out, Main.getLocalizedString("msg.bug", JavaCompiler.version()));
        ex.printStackTrace(this.out);
    }

    void feMessage(Throwable ex) {
        Log.printLines(this.out, ex.getMessage());
    }

    void ioMessage(Throwable ex) {
        Log.printLines(this.out, Main.getLocalizedString("msg.io", new Object[0]));
        ex.printStackTrace(this.out);
    }

    void resourceMessage(Throwable ex) {
        Log.printLines(this.out, Main.getLocalizedString("msg.resource", new Object[0]));
        ex.printStackTrace(this.out);
    }

    void apMessage(AnnotationProcessingError ex) {
        Log.printLines(this.out, Main.getLocalizedString("msg.proc.annotation.uncaught.exception", new Object[0]));
        ex.getCause().printStackTrace();
    }

    public static String getLocalizedString(String key, Object ... args) {
        try {
            if (messages == null) {
                messages = new JavacMessages(javacBundleName);
            }
            return messages.getLocalizedString("javac." + key, args);
        }
        catch (MissingResourceException e) {
            throw new Error("Fatal Error: Resource for javac is missing", e);
        }
    }

    public static void useRawMessages(boolean enable) {
        messages = enable ? new JavacMessages(javacBundleName){

            @Override
            public String getLocalizedString(String key, Object ... args) {
                return key;
            }
        } : new JavacMessages(javacBundleName);
    }

    public static class ExitState {
        public final int javacExitCode;
        public final CeylonState ceylonState;
        public final int errorCount;
        public final Throwable abortingException;
        public final int ceylonCodegenExceptionCount;
        public final int ceylonCodegenErroneousCount;
        public final int ceylonCodegenGarbageCount;
        public final int nonCeylonErrorCount;

        private ExitState(int javacExitCode, CeylonState ceylonState, int errorCount, Throwable abortingException, JavaCompiler comp) {
            this.javacExitCode = javacExitCode;
            this.ceylonState = ceylonState;
            this.errorCount = errorCount;
            this.ceylonCodegenExceptionCount = comp != null ? ExitState.getCeylonCodegenExceptionCount(comp) : 0;
            this.ceylonCodegenErroneousCount = comp != null ? ExitState.getCeylonCodegenErroneousCount(comp) : 0;
            this.ceylonCodegenGarbageCount = comp != null ? ExitState.getCeylonCodegenGarbageTreeCount(comp) : 0;
            this.nonCeylonErrorCount = comp != null ? ExitState.getNonCeylonErrorCount(comp) : 0;
            this.abortingException = abortingException;
        }

        private ExitState(int javacExitCode, CeylonState ceylonState, int errorCount, Throwable abortingException) {
            this(javacExitCode, ceylonState, errorCount, abortingException, null);
        }

        public static ExitState error(JavaCompiler comp) {
            if (ExitState.hasCeylonCodegenErrors(comp)) {
                return new ExitState(1, CeylonState.BUG, comp.errorCount(), null, comp);
            }
            return new ExitState(1, CeylonState.ERROR, comp.errorCount(), null);
        }

        private static int getCeylonCodegenExceptionCount(JavaCompiler comp) {
            if (comp.log instanceof CeylonLog) {
                CeylonLog log = (CeylonLog)comp.log;
                return log.getCeylonCodegenExceptionCount();
            }
            return 0;
        }

        private static int getCeylonCodegenErroneousCount(JavaCompiler comp) {
            if (comp.log instanceof CeylonLog) {
                CeylonLog log = (CeylonLog)comp.log;
                return log.getCeylonCodegenErroneousCount();
            }
            return 0;
        }

        private static int getCeylonCodegenGarbageTreeCount(JavaCompiler comp) {
            if (comp.log instanceof CeylonLog) {
                CeylonLog log = (CeylonLog)comp.log;
                return log.getCeylonCodegenGarbageTreeCount();
            }
            return 0;
        }

        private static int getCeylonCodegenErrorCount(JavaCompiler comp) {
            return ExitState.getCeylonCodegenErroneousCount(comp) + ExitState.getCeylonCodegenExceptionCount(comp) + ExitState.getCeylonCodegenGarbageTreeCount(comp);
        }

        private static int getNonCeylonErrorCount(JavaCompiler comp) {
            if (comp.log instanceof CeylonLog) {
                CeylonLog log = (CeylonLog)comp.log;
                return log.getNonCeylonErrorCount();
            }
            return 0;
        }

        private static int getCeylonErrorCount(JavaCompiler comp) {
            if (comp.log instanceof CeylonLog) {
                CeylonLog log = (CeylonLog)comp.log;
                return log.getCeylonErrorCount();
            }
            return 0;
        }

        private static boolean hasCeylonCodegenErrors(JavaCompiler comp) {
            return ExitState.getNonCeylonErrorCount(comp) == 0 && ExitState.getCeylonErrorCount(comp) == 0 && ExitState.getCeylonCodegenErrorCount(comp) > 0;
        }

        public boolean hasCeylonCodegenErrors() {
            return this.ceylonCodegenErroneousCount > 0 || this.ceylonCodegenExceptionCount > 0 || this.nonCeylonErrorCount > 0;
        }

        private static boolean isAbnormalException(Throwable ex) {
            return ex instanceof RuntimeException && !ex.getClass().getName().startsWith("com.redhat.ceylon.") && (!(ex instanceof ClassCastException) || !ex.getMessage().contains("com.redhat.ceylon.langtools."));
        }

        public static ExitState ok() {
            return new ExitState(1, CeylonState.OK, 0, null, null);
        }

        public static ExitState abnormal(JavaCompiler comp, Throwable ex, Options options) {
            if (comp == null || comp.errorCount() == 0 || options == null || options.get("dev") != null) {
                return new ExitState(4, CeylonState.BUG, 0, ex, null);
            }
            if (ExitState.hasCeylonCodegenErrors(comp) || ExitState.isAbnormalException(ex)) {
                return new ExitState(4, CeylonState.BUG, comp.errorCount(), ex, comp);
            }
            return new ExitState(4, CeylonState.ERROR, comp.errorCount(), null, null);
        }

        public static ExitState systemError(JavaCompiler comp, Throwable ex) {
            if (comp instanceof LanguageCompiler && ((LanguageCompiler)comp).getTreatLikelyBugsAsErrors()) {
                if (ExitState.hasCeylonCodegenErrors(comp)) {
                    return new ExitState(1, CeylonState.BUG, comp.errorCount(), ex, comp);
                }
                return new ExitState(1, CeylonState.ERROR, 0, ex, null);
            }
            return new ExitState(3, CeylonState.SYS, 0, ex, null);
        }

        public static ExitState cmderror() {
            return new ExitState(2, CeylonState.BUG, 0, null, null);
        }

        public static enum CeylonState {
            OK,
            ERROR,
            SYS,
            BUG;

        }
    }
}

