/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.loader;

import com.redhat.ceylon.compiler.java.codegen.CeylonCompilationUnit;
import com.redhat.ceylon.compiler.java.codegen.Naming;
import com.redhat.ceylon.compiler.java.loader.AnnotationLoader;
import com.redhat.ceylon.compiler.java.loader.CeylonClassReader;
import com.redhat.ceylon.compiler.java.loader.ModelLoaderFactory;
import com.redhat.ceylon.compiler.java.loader.SourceDeclarationVisitor;
import com.redhat.ceylon.compiler.java.loader.TypeFactory;
import com.redhat.ceylon.compiler.java.loader.mirror.JavacClass;
import com.redhat.ceylon.compiler.java.loader.mirror.JavacMethod;
import com.redhat.ceylon.compiler.java.loader.model.CompilerModuleManager;
import com.redhat.ceylon.compiler.java.tools.CeylonLog;
import com.redhat.ceylon.compiler.java.tools.LanguageCompiler;
import com.redhat.ceylon.compiler.java.util.Timer;
import com.redhat.ceylon.compiler.java.util.Util;
import com.redhat.ceylon.compiler.typechecker.analyzer.ModuleSourceMapper;
import com.redhat.ceylon.compiler.typechecker.context.PhasedUnits;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.javax.lang.model.element.NestingKind;
import com.redhat.ceylon.javax.tools.JavaFileManager;
import com.redhat.ceylon.javax.tools.JavaFileObject;
import com.redhat.ceylon.javax.tools.StandardLocation;
import com.redhat.ceylon.langtools.tools.javac.code.Attribute;
import com.redhat.ceylon.langtools.tools.javac.code.Scope;
import com.redhat.ceylon.langtools.tools.javac.code.Symbol;
import com.redhat.ceylon.langtools.tools.javac.code.Symtab;
import com.redhat.ceylon.langtools.tools.javac.code.Type;
import com.redhat.ceylon.langtools.tools.javac.code.Types;
import com.redhat.ceylon.langtools.tools.javac.jvm.ClassReader;
import com.redhat.ceylon.langtools.tools.javac.main.OptionName;
import com.redhat.ceylon.langtools.tools.javac.util.Context;
import com.redhat.ceylon.langtools.tools.javac.util.Convert;
import com.redhat.ceylon.langtools.tools.javac.util.Log;
import com.redhat.ceylon.langtools.tools.javac.util.Name;
import com.redhat.ceylon.langtools.tools.javac.util.Names;
import com.redhat.ceylon.langtools.tools.javac.util.Options;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.cmr.JDKUtils;
import com.redhat.ceylon.model.loader.AbstractModelLoader;
import com.redhat.ceylon.model.loader.JvmBackendUtil;
import com.redhat.ceylon.model.loader.ModelLoader;
import com.redhat.ceylon.model.loader.ModelResolutionException;
import com.redhat.ceylon.model.loader.TypeParser;
import com.redhat.ceylon.model.loader.mirror.ClassMirror;
import com.redhat.ceylon.model.loader.mirror.MethodMirror;
import com.redhat.ceylon.model.loader.model.AnnotationProxyClass;
import com.redhat.ceylon.model.loader.model.AnnotationProxyMethod;
import com.redhat.ceylon.model.loader.model.LazyFunction;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.UnknownType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CeylonModelLoader
extends AbstractModelLoader {
    private Symtab symtab;
    private Names names;
    private ClassReader reader;
    private PhasedUnits phasedUnits;
    private Log log;
    private Types types;
    private Options options;
    private JavaFileManager fileManager;
    protected final Map<String, Boolean> packageExistence = new HashMap<String, Boolean>();
    private AnnotationLoader annotationLoader;
    private ModuleSourceMapper moduleSourceMapper;

    public static AbstractModelLoader instance(Context context) {
        AbstractModelLoader instance = context.get(AbstractModelLoader.class);
        if (instance == null) {
            ModelLoaderFactory factory = context.get(ModelLoaderFactory.class);
            instance = factory != null ? factory.createModelLoader(context) : new CeylonModelLoader(context);
            context.put(AbstractModelLoader.class, instance);
        }
        return instance;
    }

    private CeylonModelLoader(Context context) {
        this.phasedUnits = LanguageCompiler.getPhasedUnitsInstance(context);
        com.redhat.ceylon.compiler.typechecker.context.Context ceylonContext = LanguageCompiler.getCeylonContextInstance(context);
        this.symtab = Symtab.instance(context);
        this.names = Names.instance(context);
        this.reader = CeylonClassReader.instance(context);
        this.log = CeylonLog.instance(context);
        this.types = Types.instance(context);
        this.typeFactory = TypeFactory.instance(context);
        this.typeParser = new TypeParser(this);
        this.options = Options.instance(context);
        this.timer = Timer.instance(context);
        this.isBootstrap = this.options.get(OptionName.BOOTSTRAPCEYLON) != null;
        this.initModuleManager(this.phasedUnits.getModuleManager());
        this.modules = ceylonContext.getModules();
        this.fileManager = context.get(JavaFileManager.class);
        this.annotationLoader = new AnnotationLoader(this, this.typeFactory);
        this.moduleSourceMapper = this.phasedUnits.getModuleSourceMapper();
    }

    @Override
    protected boolean needsLocalDeclarations() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addModuleToClassPath(Module module, ArtifactResult artifact) {
        if (artifact != null) {
            ((CompilerModuleManager)this.phasedUnits.getModuleManager()).getCeylonEnter().addModuleToClassPath(module, true, artifact);
            Object object = this.getLock();
            synchronized (object) {
                ArrayList<String> clear = new ArrayList<String>(this.packageExistence.size());
                for (Map.Entry<String, Boolean> entry : this.packageExistence.entrySet()) {
                    if (entry.getValue().booleanValue()) continue;
                    clear.add(entry.getKey());
                }
                for (String key : clear) {
                    this.packageExistence.remove(key);
                }
            }
        }
    }

    @Override
    public boolean isModuleInClassPath(Module module) {
        return ((CompilerModuleManager)this.phasedUnits.getModuleManager()).getCeylonEnter().isModuleInClassPath(module);
    }

    @Override
    public void setupSourceFileObjects(List<?> treeHolders) {
        CeylonModelLoader.setupSourceFileObjects(treeHolders, this.reader, this.names);
        if (this.isBootstrap) {
            this.symtab.loadCeylonSymbols();
        }
    }

    public static void setupSourceFileObjects(List<?> treeHolders, final ClassReader reader, final Names names) {
        for (Object treeHolder : treeHolders) {
            if (!(treeHolder instanceof CeylonCompilationUnit)) continue;
            final CeylonCompilationUnit tree = (CeylonCompilationUnit)treeHolder;
            Tree.CompilationUnit ceylonTree = tree.ceylonTree;
            final String pkgName = tree.getPackageName() != null ? Util.quoteJavaKeywords(tree.getPackageName().toString()) : "";
            ceylonTree.visit(new SourceDeclarationVisitor(){

                @Override
                public void loadFromSource(Tree.Declaration decl) {
                    if (!this.checkNative(decl)) {
                        return;
                    }
                    String fqn = Naming.toplevelClassName(pkgName, decl);
                    try {
                        reader.enterClass(names.fromString(fqn), tree.getSourceFile());
                    }
                    catch (AssertionError assertionError) {
                        // empty catch block
                    }
                }

                @Override
                public void loadFromSource(Tree.ModuleDescriptor that) {
                    try {
                        reader.enterClass(names.fromString(pkgName + "." + "$module_"), tree.getSourceFile());
                    }
                    catch (AssertionError assertionError) {
                        // empty catch block
                    }
                }

                @Override
                public void loadFromSource(Tree.PackageDescriptor that) {
                    try {
                        reader.enterClass(names.fromString(pkgName + "." + "$package_"), tree.getSourceFile());
                    }
                    catch (AssertionError assertionError) {
                        // empty catch block
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadPackage(Module module, String packageName, boolean loadDeclarations) {
        Object object = this.getLock();
        synchronized (object) {
            Symbol.PackageSymbol ceylonPkg;
            packageName = Util.quoteJavaKeywords(packageName);
            String cacheKey = this.cacheKeyByModule(module, packageName);
            if (loadDeclarations) {
                if (!this.loadedPackages.add(cacheKey)) {
                    return true;
                }
            } else {
                Boolean exists = this.packageExistence.get(cacheKey);
                if (exists != null) {
                    return exists;
                }
            }
            Symbol.PackageSymbol packageSymbol = ceylonPkg = packageName.equals("") ? this.syms().unnamedPackage : this.reader.enterPackage(this.names.fromString(packageName));
            if (loadDeclarations) {
                this.logVerbose("load package " + packageName + " full");
                ceylonPkg.complete();
                for (Symbol m : ceylonPkg.members().getElements()) {
                    ClassMirror classMirror;
                    Symbol.ClassSymbol enclosingClass;
                    if (!(m instanceof Symbol.ClassSymbol) || (enclosingClass = this.getEnclosing((Symbol.ClassSymbol)m)) != m || Util.isLoadedFromSource(enclosingClass)) continue;
                    m.complete();
                    if (this.isAnonymousOrLocal((Symbol.ClassSymbol)m) || ((Symbol.ClassSymbol)m).getNestingKind() != NestingKind.TOP_LEVEL || this.isModuleOrPackageDescriptorName(m.name.toString()) || (classMirror = this.lookupClassMirror(module, m.getQualifiedName().toString())) == null) continue;
                    this.convertToDeclaration(module, classMirror, ModelLoader.DeclarationType.VALUE);
                }
                if (module.getNameAsString().equals("java.base") && packageName.equals("java.lang")) {
                    this.loadJavaBaseArrays();
                }
                return ceylonPkg.members().getElements().iterator().hasNext();
            }
            this.logVerbose("load package " + packageName + " light");
            try {
                Iterable<JavaFileObject> list = this.fileManager.list(StandardLocation.PLATFORM_CLASS_PATH, packageName, EnumSet.of(JavaFileObject.Kind.CLASS), false);
                if (list.iterator().hasNext()) {
                    this.packageExistence.put(cacheKey, Boolean.TRUE);
                    return true;
                }
                list = this.fileManager.list(StandardLocation.CLASS_PATH, packageName, EnumSet.of(JavaFileObject.Kind.CLASS), false);
                if (list.iterator().hasNext()) {
                    this.packageExistence.put(cacheKey, Boolean.TRUE);
                    return true;
                }
                this.packageExistence.put(cacheKey, Boolean.FALSE);
                return false;
            }
            catch (IOException e) {
                return false;
            }
        }
    }

    private boolean isAnonymousOrLocal(Symbol.ClassSymbol m) {
        switch (m.getNestingKind()) {
            case ANONYMOUS: {
                return true;
            }
            case LOCAL: {
                return true;
            }
            case TOP_LEVEL: {
                return false;
            }
            case MEMBER: {
                return this.isAnonymousOrLocal((Symbol.ClassSymbol)m.owner);
            }
        }
        return false;
    }

    private Symbol.ClassSymbol getEnclosing(Symbol.ClassSymbol c) {
        Symbol owner = c.owner;
        com.redhat.ceylon.langtools.tools.javac.util.List<Name> enclosing = Convert.enclosingCandidates(Convert.shortName(c.name));
        if (enclosing.isEmpty()) {
            return c;
        }
        Name name = (Name)enclosing.head;
        Symbol encl = owner.members().lookup((Name)name).sym;
        if (encl == null || !(encl instanceof Symbol.ClassSymbol)) {
            encl = this.symtab.classes.get(Symbol.TypeSymbol.formFlatName(name, owner));
        }
        if (encl != null) {
            return (Symbol.ClassSymbol)encl;
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClassMirror lookupNewClassMirror(Module module, String name) {
        Object object = this.getLock();
        synchronized (object) {
            ClassMirror classMirror = this.lookupNewClassMirror(name);
            if (classMirror == null) {
                return null;
            }
            Module classMirrorModule = this.findModuleForClassMirror(classMirror);
            if (classMirrorModule == null) {
                this.logVerbose("Found a class mirror with no module");
                return null;
            }
            if (this.isImported(module, classMirrorModule)) {
                return classMirror;
            }
            this.logVerbose("Found a class mirror that is not imported: " + name);
            return null;
        }
    }

    private ClassMirror lookupNewClassMirror(String name) {
        Symbol.ClassSymbol classSymbol = null;
        String outerName = name;
        this.loadClass(outerName);
        do {
            if ((classSymbol = this.symtab.classes.get(this.names.fromString(Util.quoteJavaKeywords(outerName)))) == null && this.lastPartHasLowerInitial(outerName) && !outerName.endsWith("_")) {
                classSymbol = this.symtab.classes.get(this.names.fromString(Util.quoteJavaKeywords(outerName + "_")));
            }
            if (classSymbol != null) {
                if (Util.isLoadedFromSource(classSymbol) && !Util.isJavaSource(classSymbol)) {
                    return null;
                }
                if (outerName.length() != name.length()) {
                    try {
                        classSymbol = this.lookupInnerClass(classSymbol, name.substring(outerName.length() + 1).split("\\."));
                    }
                    catch (Symbol.CompletionFailure x) {
                        classSymbol = null;
                    }
                }
                if (classSymbol != null && classSymbol.classfile == null && classSymbol.sourcefile == null) {
                    try {
                        classSymbol.complete();
                    }
                    catch (Symbol.CompletionFailure x) {
                        // empty catch block
                    }
                    if (classSymbol.classfile == null) {
                        Symbol.PackageSymbol pkg = classSymbol.packge();
                        if (pkg == null || !JDKUtils.isOracleJDKAnyPackage(pkg.getQualifiedName().toString())) {
                            this.logVerbose("Unable to find required class file for " + name);
                        }
                        return null;
                    }
                }
                return classSymbol != null ? new JavacClass(classSymbol) : null;
            }
            int lastDot = outerName.lastIndexOf(".");
            if (lastDot == -1 || lastDot == 0) {
                return null;
            }
            outerName = outerName.substring(0, lastDot);
        } while (classSymbol == null);
        return null;
    }

    private void loadClass(String className) {
        String quotedName = Util.quoteJavaKeywords(className);
        if (!this.loadClassInternal(quotedName) && this.lastPartHasLowerInitial(className) && !className.endsWith("_")) {
            this.loadClassInternal(Util.quoteJavaKeywords(className + "_"));
        }
    }

    private boolean loadClassInternal(String quotedClassName) {
        try {
            Name name = this.names.fromString(quotedClassName);
            if (this.syms().classes.containsKey(name)) {
                return true;
            }
            JavaFileObject fileObject = this.fileManager.getJavaFileForInput(StandardLocation.PLATFORM_CLASS_PATH, quotedClassName, JavaFileObject.Kind.CLASS);
            if (fileObject == null) {
                fileObject = this.fileManager.getJavaFileForInput(StandardLocation.CLASS_PATH, quotedClassName, JavaFileObject.Kind.CLASS);
            }
            if (fileObject != null) {
                this.reader.enterClass(name, fileObject);
                return true;
            }
            return false;
        }
        catch (IOException e) {
            this.logVerbose("IOException loading class: " + e.getMessage());
            return false;
        }
    }

    private Symbol.ClassSymbol lookupInnerClass(Symbol.ClassSymbol classSymbol, String[] parts) {
        for (String part : parts) {
            Symbol s2;
            block2: {
                for (Symbol s2 : classSymbol.getEnclosedElements()) {
                    if (!(s2 instanceof Symbol.ClassSymbol) || !s2.getSimpleName().toString().equals(part) && (!JvmBackendUtil.isInitialLowerCase(part) || !s2.getSimpleName().toString().equals(part + "_"))) continue;
                    break block2;
                }
                return null;
            }
            classSymbol = (Symbol.ClassSymbol)s2;
        }
        return classSymbol;
    }

    private Symbol.MethodSymbol getOverriddenMethod(Symbol.MethodSymbol method, Types types) {
        try {
            Symbol.TypeSymbol i;
            Symbol.MethodSymbol impl2 = null;
            if (method.owner.isInterface()) {
                return (Symbol.MethodSymbol)this.implemented(method, method.owner.type.tsym, types);
            }
            Type superType = types.supertype(method.owner.type);
            while (impl2 == null && superType.tsym != null && !(i = superType.tsym).getQualifiedName().toString().equals("ceylon.language.Anything")) {
                try {
                    Scope.Entry e = i.members().lookup(method.name);
                    while (impl2 == null && e.scope != null) {
                        if (!this.isIgnored(e.sym) && method.overrides(e.sym, (Symbol.TypeSymbol)method.owner, types, true)) {
                            impl2 = (Symbol.MethodSymbol)e.sym;
                        }
                        e = e.next();
                    }
                    if (impl2 == null) {
                        impl2 = (Symbol.MethodSymbol)this.implemented(method, i, types);
                    }
                }
                catch (Symbol.CompletionFailure completionFailure) {
                    // empty catch block
                }
                superType = types.supertype(superType);
            }
            if (impl2 == null) {
                impl2 = (Symbol.MethodSymbol)this.implemented(method, method.owner.type.tsym, types);
            }
            return impl2;
        }
        catch (Symbol.CompletionFailure x) {
            this.handleCompletionFailure(method, x);
            return null;
        }
    }

    private Symbol implemented(Symbol.MethodSymbol m, Symbol.TypeSymbol c, Types types) {
        Symbol impl2 = null;
        com.redhat.ceylon.langtools.tools.javac.util.List<Type> is = types.interfaces(c.type);
        while (impl2 == null && is.nonEmpty()) {
            Symbol.TypeSymbol i = ((Type)is.head).tsym;
            impl2 = this.implementedIn(m, i, types);
            if (impl2 == null) {
                impl2 = this.implemented(m, i, types);
            }
            is = is.tail;
        }
        return impl2;
    }

    private Symbol implementedIn(Symbol.MethodSymbol m, Symbol.TypeSymbol c, Types types) {
        Symbol impl2 = null;
        Scope.Entry e = c.members().lookup(m.name);
        while (impl2 == null && e.scope != null) {
            if (!this.isIgnored(e.sym) && m.overrides(e.sym, (Symbol.TypeSymbol)m.owner, types, true)) {
                impl2 = e.sym;
            }
            e = e.next();
        }
        return impl2;
    }

    public Symtab syms() {
        return this.symtab;
    }

    @Override
    protected void logVerbose(String message) {
        if (this.options.get(OptionName.VERBOSE) != null || this.options.get((Object)((Object)OptionName.VERBOSE) + ":loader") != null) {
            Log.printLines(this.log.noticeWriter, message);
        }
    }

    @Override
    protected void logWarning(String message) {
        this.log.warning("ceylon", message);
    }

    @Override
    protected void logError(String message) {
        this.log.error("ceylon", message);
    }

    @Override
    protected boolean isOverridingMethod(MethodMirror methodSymbol) {
        Symbol.MethodSymbol method = ((JavacMethod)methodSymbol).methodSymbol;
        if (method.owner.getQualifiedName().contentEquals("ceylon.language.Identifiable") && (method.name.contentEquals("equals") || method.name.contentEquals("hashCode"))) {
            return true;
        }
        if (method.owner.getQualifiedName().contentEquals("ceylon.language.Object") && (method.name.contentEquals("equals") || method.name.contentEquals("hashCode") || method.name.contentEquals("toString"))) {
            return false;
        }
        return this.getOverriddenMethod(method, this.types) != null;
    }

    @Override
    protected boolean isOverloadingMethod(MethodMirror methodMirror) {
        Symbol.MethodSymbol method = ((JavacMethod)methodMirror).methodSymbol;
        return this.isOverloadingMethod(method);
    }

    private boolean isOverloadingMethod(Symbol.MethodSymbol method) {
        try {
            Symbol.TypeSymbol i;
            String fqn;
            if (method.owner.isInterface()) {
                return this.overloaded(method, method.owner.type.tsym, this.types);
            }
            if (method.owner.type.tsym.getQualifiedName().toString().equals("ceylon.language.Exception")) {
                return false;
            }
            Type superType = this.types.supertype(method.owner.type);
            while (superType.tsym != null && !(fqn = (i = superType.tsym).getQualifiedName().toString()).equals("ceylon.language.Anything")) {
                try {
                    Scope.Entry e = i.members().lookup(method.name);
                    while (e.scope != null) {
                        if (!this.isIgnored(e.sym) && !method.overrides(e.sym, (Symbol.TypeSymbol)method.owner, this.types, false)) {
                            return true;
                        }
                        e = e.next();
                    }
                    if (this.overloaded(method, i, this.types)) {
                        return true;
                    }
                }
                catch (Symbol.CompletionFailure completionFailure) {
                    // empty catch block
                }
                if (fqn.equals("ceylon.language.Exception")) break;
                superType = this.types.supertype(superType);
            }
            return this.overloaded(method, method.owner.type.tsym, this.types);
        }
        catch (Symbol.CompletionFailure x) {
            this.handleCompletionFailure(method, x);
            return false;
        }
    }

    private boolean isIgnored(Symbol sym) {
        if (sym.kind != 16) {
            return true;
        }
        String name = sym.name.toString();
        if ((name.equals("finalize") || name.equals("clone")) && sym.owner != null && sym.owner.getQualifiedName().toString().equals("java.lang.Object")) {
            return true;
        }
        for (Attribute.Compound ann : sym.getAnnotationMirrors()) {
            if (!ann.type.tsym.getQualifiedName().toString().equals("com.redhat.ceylon.compiler.java.metadata.Ignore")) continue;
            return true;
        }
        return false;
    }

    private void handleCompletionFailure(Symbol.MethodSymbol method, Symbol.CompletionFailure x) {
        String pkgName;
        Symbol.PackageSymbol pkg;
        String methodPackageName;
        Symbol.PackageSymbol methodPackage;
        if (method.owner != null && (methodPackage = method.owner.packge()) != null && JDKUtils.isJDKAnyPackage(methodPackageName = methodPackage.getQualifiedName().toString()) && x.sym != null && x.sym instanceof Symbol.ClassSymbol && (pkg = ((Symbol.ClassSymbol)x.sym).packge()) != null && JDKUtils.isOracleJDKAnyPackage(pkgName = pkg.getQualifiedName().toString())) {
            this.logMissingOracleType(x.getMessage());
            return;
        }
        throw new ModelResolutionException("Failed to determine if " + method.name.toString() + " is overriding a super method" + (x.getLocalizedMessage() != null ? ": " + x.getLocalizedMessage() : ""), x);
    }

    private boolean overloaded(Symbol.MethodSymbol m, Symbol.TypeSymbol c, Types types) {
        com.redhat.ceylon.langtools.tools.javac.util.List<Type> is = types.interfaces(c.type);
        while (is.nonEmpty()) {
            Symbol.TypeSymbol i = ((Type)is.head).tsym;
            if (this.overloadedIn(m, i, types)) {
                return true;
            }
            if (this.overloaded(m, i, types)) {
                return true;
            }
            is = is.tail;
        }
        return false;
    }

    private boolean overloadedIn(Symbol.MethodSymbol m, Symbol.TypeSymbol c, Types types) {
        Scope.Entry e = c.members().lookup(m.name);
        while (e.scope != null) {
            if (!this.isIgnored(e.sym) && !m.overrides(e.sym, (Symbol.TypeSymbol)m.owner, types, true)) {
                return true;
            }
            e = e.next();
        }
        return false;
    }

    @Override
    public Module findModuleForClassMirror(ClassMirror classMirror) {
        String pkgName = this.getPackageNameForQualifiedClassName(classMirror);
        return this.lookupModuleByPackageName(pkgName);
    }

    @Override
    protected boolean isFlatClasspath() {
        return this.options.isSet(OptionName.CEYLONFLATCLASSPATH);
    }

    @Override
    protected boolean isAutoExportMavenDependencies() {
        return this.options.isSet(OptionName.CEYLONAUTOEXPORTMAVENDEPENDENCIES);
    }

    @Override
    protected void setAnnotationConstructor(LazyFunction method, MethodMirror meth) {
        this.annotationLoader.setAnnotationConstructor(method, meth);
    }

    @Override
    protected void makeInteropAnnotationConstructorInvocation(AnnotationProxyMethod ctor, AnnotationProxyClass klass, List<Parameter> ctorParams) {
        this.annotationLoader.makeInterorAnnotationConstructorInvocation(ctor, klass, ctorParams);
    }

    @Override
    protected UnknownType.ErrorReporter makeModelErrorReporter(Module module, String message) {
        return new ModuleErrorAttacherRunnable(this.moduleSourceMapper, module, message);
    }

    public static class ModuleErrorAttacherRunnable
    extends UnknownType.ErrorReporter {
        private Module module;
        private ModuleSourceMapper moduleSourceMapper;

        public ModuleErrorAttacherRunnable(ModuleSourceMapper moduleSourceMapper, Module module, String message) {
            super(message);
            this.moduleSourceMapper = moduleSourceMapper;
            this.module = module;
        }

        @Override
        public void reportError() {
            this.moduleSourceMapper.attachErrorToOriginalModuleImport(this.module, this.getMessage());
        }
    }
}

