/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.loader;

import com.redhat.ceylon.compiler.java.codegen.Decl;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.Constructor;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.Functional;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.ParameterList;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Setter;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class MethodOrValueReferenceVisitor
extends Visitor {
    private final TypedDeclaration declaration;
    private boolean inCapturingScope = false;
    private boolean inLazySpecifierExpression = false;
    private boolean defaultArgument;
    boolean invocationPrimary;

    public MethodOrValueReferenceVisitor(TypedDeclaration declaration) {
        this.declaration = declaration;
    }

    private boolean enterCapturingScope() {
        boolean cs = this.inCapturingScope;
        this.inCapturingScope = true;
        return cs;
    }

    private void exitCapturingScope(boolean cs) {
        this.inCapturingScope = cs;
    }

    @Override
    public void visit(Tree.BaseMemberExpression that) {
        this.visitReference(that);
    }

    private void visitReference(Tree.Primary that) {
        if (this.inCapturingScope) {
            this.capture(that);
        }
    }

    private void capture(Tree.Primary that) {
        this.capture(that, false);
    }

    private void capture(Tree.Primary that, boolean methodSpecifier) {
        if (that instanceof Tree.MemberOrTypeExpression) {
            Declaration decl = ((Tree.MemberOrTypeExpression)that).getDeclaration();
            if (!(decl instanceof TypedDeclaration)) {
                return;
            }
            TypedDeclaration d = (TypedDeclaration)decl;
            if (Decl.equal(d, this.declaration) || d.isNativeHeader() && d.getOverloads().contains(this.declaration)) {
                d = this.declaration;
                if (Decl.isParameter(d)) {
                    boolean sameScope;
                    Scope s = that.getScope();
                    boolean bl = sameScope = d.getContainer().equals(s) || s instanceof Declaration && (Decl.isParameter((Declaration)((Object)s)) || s instanceof Value && !((Value)s).isTransient()) && d.getContainer().equals(s.getScope());
                    if (!sameScope || methodSpecifier || this.inLazySpecifierExpression) {
                        ((FunctionOrValue)d).setCaptured(true);
                    }
                    if (that instanceof Tree.QualifiedMemberExpression && d instanceof TypedDeclaration && d.getOtherInstanceAccess()) {
                        ((FunctionOrValue)d).setCaptured(true);
                    }
                    if (this.isCapturableMplParameter(d)) {
                        ((FunctionOrValue)d).setCaptured(true);
                    }
                } else if (Decl.isValue(d) || Decl.isGetter(d)) {
                    Value v = (Value)d;
                    v.setCaptured(true);
                    if (Decl.isObjectValue(d)) {
                        v.setSelfCaptured(this.isSelfCaptured(that, d));
                    }
                    if (v.getSetter() != null) {
                        v.getSetter().setCaptured(true);
                    }
                } else if (d instanceof Function) {
                    ((Function)d).setCaptured(true);
                }
            }
        }
    }

    private boolean isSelfCaptured(Tree.Primary that, TypedDeclaration d) {
        Scope scope;
        TypeDeclaration type = d.getTypeDeclaration();
        for (scope = that.getScope(); scope != null && !(scope instanceof Package) && !Decl.equalScopeDecl(scope, type); scope = scope.getScope()) {
        }
        return Decl.equalScopeDecl(scope, type);
    }

    private boolean isCapturableMplParameter(Declaration d) {
        if (!(d instanceof FunctionOrValue)) {
            return false;
        }
        Parameter param = ((FunctionOrValue)d).getInitializerParameter();
        if (param == null) {
            return false;
        }
        Declaration paramDecl = param.getDeclaration();
        if (paramDecl instanceof Functional) {
            List<ParameterList> parameterLists = ((Functional)((Object)paramDecl)).getParameterLists();
            for (int i = 0; i < parameterLists.size() - 1; ++i) {
                if (!parameterLists.get(i).getParameters().contains(param)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void visit(Tree.InvocationExpression that) {
        boolean pip = this.invocationPrimary;
        this.invocationPrimary = true;
        that.getPrimary().visit(this);
        this.invocationPrimary = pip;
        if (that.getPositionalArgumentList() != null) {
            that.getPositionalArgumentList().visit(this);
        }
        if (that.getNamedArgumentList() != null) {
            that.getNamedArgumentList().visit(this);
        }
    }

    @Override
    public void visit(Tree.QualifiedMemberExpression that) {
        boolean isCallableReference;
        boolean cs = false;
        boolean bl = isCallableReference = !this.invocationPrimary && that.getDeclaration() instanceof Functional;
        if (isCallableReference) {
            cs = this.enterCapturingScope();
        }
        super.visit(that);
        if (this.isSelfReference(that.getPrimary())) {
            this.visitReference(that);
        } else {
            this.capture(that);
        }
        if (isCallableReference) {
            this.exitCapturingScope(cs);
        }
    }

    private boolean isSelfReference(Tree.Primary that) {
        return that instanceof Tree.This || that instanceof Tree.Outer;
    }

    @Override
    public void visit(Tree.Declaration that) {
        Declaration dm = that.getDeclarationModel();
        if ((dm == this.declaration.getContainer() || Decl.equal(dm, this.declaration) && !this.isClassWithConstructorMember(this.declaration) || dm instanceof Setter && ((Setter)dm).getGetter() == this.declaration) && !this.isCapturableMplParameter(this.declaration)) {
            this.inCapturingScope = false;
        }
        super.visit(that);
    }

    private boolean isClassWithConstructorMember(TypedDeclaration decl) {
        return decl.isClassMember() && ((Class)decl.getContainer()).hasConstructors();
    }

    @Override
    public void visit(Tree.ClassDefinition that) {
        if (!that.getDeclarationModel().hasConstructors()) {
            boolean cs = this.enterCapturingScope();
            super.visit(that);
            this.exitCapturingScope(cs);
        } else {
            if (!this.declaration.isCaptured() && this.declaration instanceof FunctionOrValue && this.declaration.isClassMember()) {
                HashMap<Constructor, ConstructorPlan> constructorPlans = new HashMap<Constructor, ConstructorPlan>();
                ArrayList<Tree.Statement> statements = new ArrayList<Tree.Statement>(that.getClassBody().getStatements().size());
                for (Tree.Statement stmt : that.getClassBody().getStatements()) {
                    if (stmt instanceof Tree.Constructor) {
                        Tree.ExtendedTypeExpression ete;
                        Tree.Constructor ctor = (Tree.Constructor)stmt;
                        ConstructorPlan plan = new ConstructorPlan();
                        plan.constructor = ctor;
                        constructorPlans.put(ctor.getConstructor(), plan);
                        if (ctor.getDelegatedConstructor() != null && ctor.getDelegatedConstructor().getInvocationExpression() != null && ctor.getDelegatedConstructor().getInvocationExpression().getPrimary() instanceof Tree.ExtendedTypeExpression && Decl.isConstructor((ete = (Tree.ExtendedTypeExpression)ctor.getDelegatedConstructor().getInvocationExpression().getPrimary()).getDeclaration()) && Decl.getConstructedClass(ete.getDeclaration()).equals(that.getDeclarationModel())) {
                            ConstructorPlan delegatePlan;
                            Constructor delegate = Decl.getConstructor(ete.getDeclaration());
                            plan.delegate = delegatePlan = (ConstructorPlan)constructorPlans.get(delegate);
                            delegatePlan.isDelegate = true;
                            plan.before.addAll(delegatePlan.after);
                        }
                        if (plan.delegate == null) {
                            plan.before.addAll(statements);
                        }
                        if (ctor.getBlock() == null) continue;
                        plan.before.addAll(ctor.getBlock().getStatements());
                        continue;
                    }
                    statements.add(stmt);
                    for (ConstructorPlan constructorPlan : constructorPlans.values()) {
                        constructorPlan.after.add(stmt);
                    }
                }
                for (ConstructorPlan constructorPlan : constructorPlans.values()) {
                    this.visitConstructorPlan(constructorPlan);
                    if (!this.declaration.isCaptured()) continue;
                    break;
                }
            }
            if (!this.declaration.isCaptured()) {
                super.visit(that);
            }
        }
    }

    private void visitConstructorPlan(ConstructorPlan constructorPlan) {
        Value val;
        if (constructorPlan.delegate == null && !constructorPlan.isDelegate) {
            return;
        }
        boolean cs = this.enterCapturingScope();
        int useCount = this.usedIn(constructorPlan, false);
        FunctionOrValue fov = (FunctionOrValue)this.declaration;
        fov.setCaptured(useCount > 1);
        if (fov instanceof Value && (val = (Value)fov).getSetter() != null) {
            val.getSetter().setCaptured(useCount > 1);
        }
        this.exitCapturingScope(cs);
    }

    private int usedIn(ConstructorPlan constructorPlan, boolean onlyBefore) {
        int usedAfter;
        int delegateCount = 0;
        if (constructorPlan.delegate != null) {
            delegateCount = this.usedIn(constructorPlan.delegate, true);
        }
        int usedBefore = this.usedIn(constructorPlan.before);
        int n = usedAfter = onlyBefore ? 0 : this.usedIn(constructorPlan.after);
        if (constructorPlan.isDelegate) {
            return delegateCount + usedBefore + usedAfter;
        }
        return delegateCount + Math.min(usedBefore + usedAfter, 1);
    }

    private int usedIn(List<Tree.Statement> stmts) {
        Value val;
        for (Tree.Statement stmt : stmts) {
            if (stmt instanceof Tree.TypedDeclaration && ((Tree.TypedDeclaration)stmt).getDeclarationModel() == this.declaration) {
                return 1;
            }
            stmt.visit(this);
            if (!this.declaration.isCaptured()) continue;
            break;
        }
        boolean used = this.declaration.isCaptured();
        FunctionOrValue fov = (FunctionOrValue)this.declaration;
        fov.setCaptured(false);
        if (fov instanceof Value && (val = (Value)fov).getSetter() != null) {
            val.getSetter().setCaptured(false);
        }
        return used ? 1 : 0;
    }

    @Override
    public void visit(Tree.ObjectDefinition that) {
        boolean cs = this.enterCapturingScope();
        super.visit(that);
        this.exitCapturingScope(cs);
    }

    @Override
    public void visit(Tree.MethodDefinition that) {
        boolean cs = this.enterCapturingScope();
        super.visit(that);
        if (Decl.withinClass(that)) {
            that.getDeclarationModel().setCaptured(true);
        }
        this.exitCapturingScope(cs);
    }

    @Override
    public void visit(Tree.AttributeDeclaration that) {
        super.visit(that);
        Tree.SpecifierOrInitializerExpression specifier = that.getSpecifierOrInitializerExpression();
        if (specifier != null && specifier instanceof Tree.LazySpecifierExpression) {
            boolean cs = this.enterCapturingScope();
            specifier.visit(this);
            this.exitCapturingScope(cs);
        }
    }

    @Override
    public void visit(Tree.AttributeGetterDefinition that) {
        boolean cs = this.enterCapturingScope();
        super.visit(that);
        this.exitCapturingScope(cs);
    }

    @Override
    public void visit(Tree.AttributeSetterDefinition that) {
        boolean cs = this.enterCapturingScope();
        super.visit(that);
        this.exitCapturingScope(cs);
    }

    @Override
    public void visit(Tree.ObjectArgument that) {
        boolean cs = this.enterCapturingScope();
        super.visit(that);
        this.exitCapturingScope(cs);
    }

    @Override
    public void visit(Tree.MethodArgument that) {
        boolean cs = this.enterCapturingScope();
        super.visit(that);
        this.exitCapturingScope(cs);
    }

    @Override
    public void visit(Tree.AttributeArgument that) {
        boolean cs = this.enterCapturingScope();
        super.visit(that);
        this.exitCapturingScope(cs);
    }

    @Override
    public void visit(Tree.ValueParameterDeclaration that) {
        this.defaultArgument = true;
        super.visit(that);
        this.defaultArgument = false;
    }

    @Override
    public void visit(Tree.SpecifierOrInitializerExpression that) {
        boolean cs = false;
        if (this.defaultArgument || this.inLazySpecifierExpression) {
            cs = this.enterCapturingScope();
        }
        super.visit(that);
        if (this.defaultArgument || this.inLazySpecifierExpression) {
            this.exitCapturingScope(cs);
        }
    }

    @Override
    public void visit(Tree.FunctionArgument that) {
        boolean cs = this.enterCapturingScope();
        super.visit(that);
        this.exitCapturingScope(cs);
    }

    @Override
    public void visit(Tree.MethodDeclaration that) {
        super.visit(that);
        Tree.SpecifierExpression specifier = that.getSpecifierExpression();
        if (specifier != null && specifier instanceof Tree.LazySpecifierExpression) {
            boolean cs = this.enterCapturingScope();
            specifier.visit(this);
            this.exitCapturingScope(cs);
        }
    }

    @Override
    public void visit(Tree.Comprehension that) {
        super.visit(that);
        boolean cs = this.enterCapturingScope();
        that.getInitialComprehensionClause().visit(this);
        this.exitCapturingScope(cs);
    }

    @Override
    public void visit(Tree.ForComprehensionClause that) {
        Tree.Expression expr;
        Tree.Term term;
        super.visit(that);
        Tree.SpecifierExpression specifier = that.getForIterator().getSpecifierExpression();
        if (specifier != null && (term = (expr = specifier.getExpression()).getTerm()) instanceof Tree.Primary) {
            this.capture((Tree.Primary)term, true);
        }
        that.getComprehensionClause().visit(this);
    }

    @Override
    public void visit(Tree.IfComprehensionClause that) {
        super.visit(that);
        that.getComprehensionClause().visit(this);
    }

    @Override
    public void visit(Tree.ExpressionComprehensionClause that) {
        super.visit(that);
        this.visitReference(that.getExpression());
    }

    @Override
    public void visit(Tree.SpecifierStatement that) {
        boolean cs = this.inCapturingScope;
        if (that.getRefinement()) {
            this.enterCapturingScope();
        }
        super.visit(that);
        if (that.getRefinement()) {
            this.exitCapturingScope(cs);
        }
    }

    @Override
    public void visit(Tree.LazySpecifierExpression that) {
        boolean lse = this.inLazySpecifierExpression;
        this.inLazySpecifierExpression = true;
        super.visit(that);
        this.inLazySpecifierExpression = lse;
    }

    @Override
    public void visit(Tree.SequencedArgument that) {
        boolean cs = this.enterCapturingScope();
        super.visit(that);
        this.exitCapturingScope(cs);
    }

    static class ConstructorPlan {
        public List<Tree.Statement> before = new LinkedList<Tree.Statement>();
        public List<Tree.Statement> after = new LinkedList<Tree.Statement>();
        public boolean isDelegate;
        public Tree.Constructor constructor;
        public ConstructorPlan delegate;

        ConstructorPlan() {
        }
    }
}

