/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.loader.model;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.ModuleDependencyInfo;
import com.redhat.ceylon.cmr.api.ModuleInfo;
import com.redhat.ceylon.cmr.api.Overrides;
import com.redhat.ceylon.cmr.api.VersionComparator;
import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.common.Backends;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.common.Versions;
import com.redhat.ceylon.compiler.typechecker.analyzer.ModuleSourceMapper;
import com.redhat.ceylon.compiler.typechecker.analyzer.Warning;
import com.redhat.ceylon.compiler.typechecker.context.Context;
import com.redhat.ceylon.compiler.typechecker.context.PhasedUnits;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.cmr.ImportType;
import com.redhat.ceylon.model.cmr.JDKUtils;
import com.redhat.ceylon.model.loader.AbstractModelLoader;
import com.redhat.ceylon.model.loader.model.LazyModule;
import com.redhat.ceylon.model.loader.model.LazyModuleManager;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.ModuleImport;
import com.redhat.ceylon.model.typechecker.util.ModuleManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class LazyModuleSourceMapper
extends ModuleSourceMapper {
    public LazyModuleSourceMapper(Context context, LazyModuleManager moduleManager) {
        super(context, moduleManager);
    }

    @Override
    protected LazyModuleManager getModuleManager() {
        return (LazyModuleManager)super.getModuleManager();
    }

    @Override
    public void resolveModule(ArtifactResult artifact, Module module, ModuleImport moduleImport, LinkedList<Module> dependencyTree, List<PhasedUnits> phasedUnitsOfDependencies, boolean forCompiledModule) {
        boolean isLanguageModule;
        String moduleName = module.getNameAsString();
        LazyModuleManager moduleManager = this.getModuleManager();
        boolean moduleLoadedFromSource = moduleManager.isModuleLoadedFromSource(moduleName);
        boolean bl = isLanguageModule = module == module.getLanguageModule();
        if (moduleLoadedFromSource || forCompiledModule) {
            String standardisedModuleName = ModuleUtil.toCeylonModuleName(moduleName);
            for (Module loadedModule : this.getContext().getModules().getListOfModules()) {
                String loadedModuleName = loadedModule.getNameAsString();
                String standardisedLoadedModuleName = ModuleUtil.toCeylonModuleName(loadedModuleName);
                boolean sameModule = loadedModuleName.equals(moduleName);
                boolean similarModule = standardisedLoadedModuleName.equals(standardisedModuleName);
                if (!sameModule && !similarModule || loadedModule.getVersion().equals(module.getVersion()) || !moduleManager.getModelLoader().isModuleInClassPath(loadedModule)) continue;
                if (sameModule) {
                    String[] versions = VersionComparator.orderVersions(module.getVersion(), loadedModule.getVersion());
                    String error = "source code imports two different versions of module '" + moduleName + "': " + "version '" + versions[0] + "' and version '" + versions[1] + "'";
                    this.addErrorToModule(dependencyTree.getFirst(), error);
                } else {
                    String moduleB;
                    String moduleA;
                    if (loadedModuleName.compareTo(moduleName) < 0) {
                        moduleA = ModuleUtil.makeModuleName(loadedModuleName, loadedModule.getVersion());
                        moduleB = ModuleUtil.makeModuleName(moduleName, module.getVersion());
                    } else {
                        moduleA = ModuleUtil.makeModuleName(moduleName, module.getVersion());
                        moduleB = ModuleUtil.makeModuleName(loadedModuleName, loadedModule.getVersion());
                    }
                    String error = "source code imports two different versions of similar modules '" + moduleA + "' and '" + moduleB + "'";
                    this.addWarningToModule(dependencyTree.getFirst(), Warning.similarModule, error);
                }
                return;
            }
        }
        if (moduleLoadedFromSource) {
            super.resolveModule(artifact, module, moduleImport, dependencyTree, phasedUnitsOfDependencies, forCompiledModule);
        } else if (forCompiledModule || isLanguageModule || moduleManager.shouldLoadTransitiveDependencies()) {
            LazyModule lazyModule;
            moduleManager.getModelLoader().addModuleToClassPath(module, artifact);
            if (!module.isDefault() && !moduleManager.getModelLoader().loadCompiledModule(module)) {
                ((LazyModule)module).setJava(true);
                module.setNativeBackends(Backend.Java.asSet());
                moduleManager.getModelLoader().loadJava9Module((LazyModule)module, artifact.artifact());
                List<ArtifactResult> deps = artifact.dependencies();
                for (ArtifactResult dep : deps) {
                    Module dependency = moduleManager.getOrCreateModule(ModuleManager.splitModuleName(dep.name()), dep.version());
                    ModuleImport depImport = moduleManager.findImport(module, dependency);
                    if (depImport != null) continue;
                    moduleImport = new ModuleImport(dependency, dep.importType() == ImportType.OPTIONAL, dep.importType() == ImportType.EXPORT, Backend.Java);
                    module.addImport(moduleImport);
                }
            }
            if (!(lazyModule = (LazyModule)module).isJava() && !module.isDefault()) {
                Overrides overrides = this.getContext().getRepositoryManager().getOverrides();
                if (overrides != null && overrides.getArtifactOverrides(new ArtifactContext(artifact.name(), artifact.version())) != null) {
                    HashSet<ModuleDependencyInfo> existingModuleDependencies = new HashSet<ModuleDependencyInfo>();
                    for (ModuleImport i : lazyModule.getImports()) {
                        Module m = i.getModule();
                        if (m == null) continue;
                        existingModuleDependencies.add(new ModuleDependencyInfo(m.getNameAsString(), m.getVersion(), i.isOptional(), i.isExport()));
                    }
                    ModuleInfo sourceModuleInfo = new ModuleInfo(null, existingModuleDependencies);
                    ModuleInfo newModuleInfo = overrides.applyOverrides(artifact.name(), artifact.version(), sourceModuleInfo);
                    ArrayList<ModuleImport> newModuleImports = new ArrayList<ModuleImport>();
                    for (ModuleDependencyInfo dep : newModuleInfo.getDependencies()) {
                        Module dependency = moduleManager.getOrCreateModule(ModuleManager.splitModuleName(dep.getName()), dep.getVersion());
                        Backends backends = dependency.getNativeBackends();
                        moduleImport = new ModuleImport(dependency, dep.isOptional(), dep.isExport(), backends);
                        newModuleImports.add(moduleImport);
                    }
                    module.overrideImports(newModuleImports);
                }
                if (!Versions.isJvmBinaryVersionSupported(lazyModule.getJvmMajor(), lazyModule.getJvmMinor())) {
                    this.attachErrorToDependencyDeclaration(moduleImport, dependencyTree, "version '" + lazyModule.getVersion() + "' of module '" + module.getNameAsString() + "' was compiled by an incompatible version of the compiler (binary version " + lazyModule.getJvmMajor() + "." + lazyModule.getJvmMinor() + " of module is not compatible with binary version " + 8 + "." + 0 + " of this compiler)");
                }
            }
            module.setAvailable(true);
        }
    }

    @Override
    public void attachErrorToDependencyDeclaration(ModuleImport moduleImport, List<Module> dependencyTree, String error) {
        String name = moduleImport.getModule().getNameAsString();
        if (AbstractModelLoader.isJDKModule(name)) {
            error = "imported module '" + name + "' depends on JDK version '\"" + moduleImport.getModule().getVersion() + "\"' and you're compiling with Java " + JDKUtils.jdk.version;
        }
        super.attachErrorToDependencyDeclaration(moduleImport, dependencyTree, error);
    }

    @Override
    public void addModuleDependencyDefinition(ModuleImport moduleImport, Node definition) {
        super.addModuleDependencyDefinition(moduleImport, definition);
        Module module = moduleImport.getModule();
        if (module == null) {
            return;
        }
        String nameAsString = module.getNameAsString();
        String version2 = module.getVersion();
        if (version2 != null && AbstractModelLoader.isJDKModule(nameAsString) && JDKUtils.jdk.isLowerVersion(version2)) {
            definition.addUsageWarning(Warning.importsOtherJdk, "You import JDK7, which is provided by the JDK8 you are running on, but we cannot check that you are not using any JDK8-specific classes or methods. Upgrade your import to JDK8 if you depend on JDK8 classes or methods.", Backend.Java);
        }
    }
}

