/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.runtime;

import com.redhat.ceylon.common.JVMModuleUtil;
import com.redhat.ceylon.common.tools.ModuleSpec;
import com.redhat.ceylon.compiler.java.runtime.Main;
import java.util.Arrays;

public class Main2 {
    public static void main(String[] args) {
        ModuleSpec moduleSpec;
        String arg;
        int idx = 0;
        boolean allowMissingModules = false;
        String overrides = null;
        String runClassOrMethod = null;
        for (int i = 0; i < args.length && (arg = args[i]).startsWith("-"); ++i) {
            if (arg.equals("--allow-missing-modules")) {
                allowMissingModules = true;
            } else if (arg.equals("--overrides") || arg.equals("--maven-overrides")) {
                if (i + 1 >= args.length) {
                    Main2.usage();
                }
                overrides = args[++i];
                ++idx;
            } else if (arg.equals("--run")) {
                if (i + 1 >= args.length) {
                    Main2.usage();
                }
                runClassOrMethod = args[++i];
                ++idx;
            } else {
                Main2.usage();
            }
            ++idx;
        }
        if (args.length < 1 + idx) {
            Main2.usage();
        }
        String version2 = (moduleSpec = ModuleSpec.parse(args[idx], ModuleSpec.Option.VERSION_REQUIRED)).getName().equals("default") ? null : moduleSpec.getVersion();
        String[] moduleArgs = Arrays.copyOfRange(args, 1 + idx, args.length);
        Main.instance().allowMissingModules(allowMissingModules).overrides(overrides).run(moduleSpec.getName(), version2, Main2.runSpecToJavaClass(moduleSpec.getName(), runClassOrMethod), moduleArgs);
    }

    private static String runSpecToJavaClass(String module, String runClassOrMethod) {
        String javaClass = runClassOrMethod == null || runClassOrMethod.isEmpty() ? (module.equals("default") ? "run" : module + "." + "run") : runClassOrMethod.replace("::", ".");
        char firstChar = javaClass.charAt(0);
        int lastDot = javaClass.lastIndexOf(46);
        if (lastDot > 0) {
            firstChar = javaClass.charAt(lastDot + 1);
            String lastPart = javaClass.substring(lastDot + 1);
            String pkgPart = javaClass.substring(0, lastDot);
            javaClass = JVMModuleUtil.quoteJavaKeywords(pkgPart) + "." + lastPart;
        }
        if (Character.isLowerCase(firstChar)) {
            javaClass = javaClass + "_";
        }
        return javaClass;
    }

    private static void usage() {
        System.err.println("Invalid arguments.");
        System.err.println("Usage: \n");
        System.err.println(Main2.class.getName() + " [--allow-missing-modules] [--overrides overridesFile.xml] [--run runClassOrMethod] moduleSpec args*");
        System.exit(1);
    }
}

