/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.runtime.metamodel;

import ceylon.language.Array;
import ceylon.language.Callable;
import ceylon.language.Entry;
import ceylon.language.Iterable;
import ceylon.language.Sequential;
import ceylon.language.empty_;
import ceylon.language.meta.model.Applicable;
import ceylon.language.meta.model.ClassModel;
import ceylon.language.meta.model.InvocationException;
import ceylon.language.meta.model.Type;
import com.redhat.ceylon.compiler.java.Util;
import com.redhat.ceylon.compiler.java.metadata.ConstructorName;
import com.redhat.ceylon.compiler.java.metadata.Jpa;
import com.redhat.ceylon.compiler.java.runtime.metamodel.DefaultValueProvider;
import com.redhat.ceylon.compiler.java.runtime.metamodel.Metamodel;
import com.redhat.ceylon.compiler.java.runtime.metamodel.MethodHandleUtil;
import com.redhat.ceylon.compiler.java.runtime.metamodel.decl.CallableConstructorDeclarationImpl;
import com.redhat.ceylon.compiler.java.runtime.metamodel.decl.ClassDeclarationImpl;
import com.redhat.ceylon.compiler.java.runtime.metamodel.meta.ClassImpl;
import com.redhat.ceylon.compiler.java.runtime.metamodel.meta.MemberClassImpl;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.Functional;
import com.redhat.ceylon.model.typechecker.model.Generic;
import com.redhat.ceylon.model.typechecker.model.Interface;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.Reference;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ConstructorDispatch<Type, Arguments extends Sequential<? extends Object>>
implements Callable<Type>,
DefaultValueProvider,
Applicable<Type, Arguments> {
    private final ClassDeclarationImpl freeClass;
    private final CallableConstructorDeclarationImpl freeConstructor;
    private MethodHandle constructor;
    public final int firstDefaulted;
    public final int variadicIndex;
    private MethodHandle[] dispatch;
    public final List<com.redhat.ceylon.model.typechecker.model.Type> parameterProducedTypes;
    final Sequential<? extends Type<? extends Object>> parameterTypes;
    final Object instance;
    private Reference constructorReference;

    public ConstructorDispatch(Reference constructorReference, ClassModel<Type, ?> appliedClass, CallableConstructorDeclarationImpl freeConstructor, List<Parameter> parameters, Object instance) {
        this.constructorReference = constructorReference;
        this.freeClass = (ClassDeclarationImpl)(appliedClass instanceof ClassImpl ? ((ClassImpl)appliedClass).declaration : ((MemberClassImpl)appliedClass).declaration);
        this.freeConstructor = freeConstructor;
        Class classDecl = (Class)this.freeClass.declaration;
        this.firstDefaulted = Metamodel.getFirstDefaultedParameter(parameters);
        this.variadicIndex = Metamodel.getVariadicParameter(parameters);
        boolean invokeOnCompanionInstance = instance != null && classDecl.getContainer() instanceof Interface && (freeConstructor != null || !classDecl.isShared());
        this.instance = invokeOnCompanionInstance ? Metamodel.getCompanionInstance(instance, (Interface)this.freeClass.declaration.getContainer()) : instance;
        this.dispatch = this.firstDefaulted != -1 ? new MethodHandle[parameters.size() + 1 - this.firstDefaulted] : new MethodHandle[1];
        this.parameterProducedTypes = Metamodel.getParameterProducedTypes(parameters, constructorReference);
        this.parameterTypes = Metamodel.getAppliedMetamodelSequential(this.parameterProducedTypes);
        java.lang.Class<?> javaClass = Metamodel.getJavaClass(this.freeClass.declaration);
        Method found = null;
        if (freeConstructor != null && ModelUtil.isConstructor(freeConstructor.declaration)) {
            this.namedConstructorDispatch(constructorReference, freeConstructor, javaClass);
        } else {
            int i;
            Object[] defaultedMethods;
            Object[] objectArray = defaultedMethods = this.firstDefaulted != -1 ? new Member[this.dispatch.length] : null;
            if (MethodHandleUtil.isJavaArray(javaClass)) {
                found = MethodHandleUtil.setupArrayConstructor(javaClass, defaultedMethods);
            } else if (!(javaClass.isMemberClass() && Metamodel.isCeylon((Class)this.freeClass.declaration) && classDecl.isShared())) {
                defaultedMethods = this.findConstructors(freeConstructor, javaClass);
                for (int i2 = 0; i2 < defaultedMethods.length; ++i2) {
                    if (defaultedMethods[i2] == null) {
                        throw Metamodel.newModelError("Missing defaulted constructor for " + this.freeClass.getName() + " with " + (i2 + this.firstDefaulted) + " parameters in " + javaClass);
                    }
                    this.dispatch[i2] = ConstructorDispatch.reflectionToMethodHandle(constructorReference, (Member)defaultedMethods[i2], javaClass, this.instance, this.parameterProducedTypes, ((Constructor)defaultedMethods[i2]).isVarArgs(), false);
                }
                this.constructor = this.dispatch[defaultedMethods.length - 1];
                if (this.constructor == null) {
                    throw new NullPointerException();
                }
            } else {
                java.lang.Class<?> outerJavaClass = Metamodel.getJavaClass((Declaration)((Object)this.freeClass.declaration.getContainer()));
                defaultedMethods = this.findInstantiators(freeConstructor, outerJavaClass);
                for (i = 0; i < defaultedMethods.length; ++i) {
                    if (defaultedMethods[i] == null) {
                        throw Metamodel.newModelError("Missing defaulted constructor for " + this.freeClass.getName() + " with " + (i + this.firstDefaulted) + " parameters in " + javaClass);
                    }
                    this.dispatch[i] = ConstructorDispatch.reflectionToMethodHandle(constructorReference, (Member)defaultedMethods[i], javaClass, this.instance, this.parameterProducedTypes, false, false);
                }
                this.constructor = this.dispatch[defaultedMethods.length - 1];
                if (this.constructor == null) {
                    throw new NullPointerException();
                }
            }
            if (found != null) {
                boolean jvmVarargs = MethodHandleUtil.isJvmVarargsMethodOrConstructor(found);
                this.constructor = ConstructorDispatch.reflectionToMethodHandle(constructorReference, found, javaClass, this.instance, this.parameterProducedTypes, jvmVarargs, false);
                if (defaultedMethods != null && !jvmVarargs) {
                    for (i = 0; i < defaultedMethods.length - 1; ++i) {
                        if (defaultedMethods[i] == null) {
                            throw Metamodel.newModelError("Missing defaulted constructor for " + this.freeClass.getName() + " with " + (i + this.firstDefaulted) + " parameters in " + javaClass);
                        }
                        this.dispatch[i] = ConstructorDispatch.reflectionToMethodHandle(constructorReference, (Member)defaultedMethods[i], javaClass, this.instance, this.parameterProducedTypes, jvmVarargs, false);
                    }
                    this.dispatch[i] = this.constructor;
                } else if (jvmVarargs) {
                    this.dispatch[0] = ConstructorDispatch.reflectionToMethodHandle(constructorReference, found, javaClass, this.instance, this.parameterProducedTypes, jvmVarargs, true);
                    this.dispatch[1] = this.constructor;
                }
            }
        }
    }

    protected void namedConstructorDispatch(Reference constructorReference, CallableConstructorDeclarationImpl freeConstructor, java.lang.Class<?> javaClass) {
        if (this.firstDefaulted != -1) {
            Class classDecl = (Class)this.freeClass.declaration;
            Executable[] defaultedMethods = !javaClass.isMemberClass() || !Metamodel.isCeylon((Class)this.freeClass.declaration) || !classDecl.isShared() || !freeConstructor.getShared() ? this.findConstructors(freeConstructor, javaClass) : this.findInstantiators(freeConstructor, javaClass.getEnclosingClass());
            for (int i = 0; i < defaultedMethods.length; ++i) {
                if (defaultedMethods[i] == null) {
                    throw Metamodel.newModelError("Missing defaulted constructor for " + this.freeClass.getName() + " with " + (i + this.firstDefaulted) + " parameters in " + javaClass);
                }
                this.dispatch[i] = ConstructorDispatch.reflectionToMethodHandle(constructorReference, defaultedMethods[i], javaClass, this.instance, this.parameterProducedTypes, false, false);
            }
            this.constructor = this.dispatch[defaultedMethods.length - 1];
        } else {
            Constructor<?> ctor = Metamodel.getJavaConstructor(ModelUtil.getConstructor(freeConstructor.declaration));
            this.constructor = ConstructorDispatch.reflectionToMethodHandle(constructorReference, ctor, javaClass, this.instance, this.parameterProducedTypes, false, false);
        }
    }

    protected Constructor<?>[] findConstructors(CallableConstructorDeclarationImpl freeConstructor, java.lang.Class<?> javaClass) {
        Constructor[] defaultedMethods = new Constructor[this.dispatch.length];
        String ctorName = freeConstructor == null ? null : freeConstructor.declaration.getName();
        block0: for (Constructor<?> constr : javaClass.getDeclaredConstructors()) {
            java.lang.Class<?>[] pts;
            if (constr.isAnnotationPresent(Jpa.class)) continue;
            int numTypeParameters = 0;
            int ii = 0;
            boolean jvmVarargs = MethodHandleUtil.isJvmVarargsMethodOrConstructor(constr);
            for (java.lang.Class<?> pt : pts = constr.getParameterTypes()) {
                if (ii == 0 && javaClass.isMemberClass()) {
                    ++ii;
                    continue;
                }
                if (TypeDescriptor.class.isAssignableFrom(pt)) {
                    ++numTypeParameters;
                    ++ii;
                    continue;
                }
                if (numTypeParameters != -1) {
                    if (numTypeParameters != ((Class)this.freeClass.declaration).getTypeParameters().size()) continue block0;
                    numTypeParameters = -1;
                }
                ConstructorName annotation = pt.getAnnotation(ConstructorName.class);
                if (ctorName != null) {
                    if (annotation == null || !ctorName.equals(annotation.value()) || annotation.delegation()) continue block0;
                    defaultedMethods[this.index((int)(++ii), pts, (boolean)jvmVarargs)] = constr;
                    continue block0;
                }
                if (annotation != null) continue block0;
                defaultedMethods[this.index((int)ii, pts, (boolean)jvmVarargs)] = constr;
                if (this.variadicIndex == -1 || !jvmVarargs) continue block0;
                defaultedMethods[this.variadicIndex - 1] = constr;
                continue block0;
            }
            if (freeConstructor != null && ctorName != null && !ctorName.isEmpty()) continue;
            defaultedMethods[this.index((int)ii, pts, (boolean)jvmVarargs)] = constr;
        }
        return defaultedMethods;
    }

    int index(int ii, java.lang.Class<?>[] pts, boolean jvmVarargs) {
        if (this.firstDefaulted == -1) {
            return 0;
        }
        if (this.variadicIndex == -1) {
            return pts.length - ii - this.firstDefaulted;
        }
        return jvmVarargs ? 0 : pts.length - ii - this.firstDefaulted;
    }

    protected Method[] findInstantiators(CallableConstructorDeclarationImpl freeConstructor, java.lang.Class<?> javaClass) {
        String builderName = this.freeClass.getName() + "$new$";
        Method[] defaultedMethods = new Method[this.dispatch.length];
        String ctorName = freeConstructor == null ? null : freeConstructor.declaration.getName();
        block0: for (Method constr : javaClass.getDeclaredMethods()) {
            if (constr.isSynthetic() || !constr.getName().equals(builderName)) continue;
            int ii = 0;
            java.lang.Class<?>[] pts = constr.getParameterTypes();
            if (pts.length == 0) {
                defaultedMethods[0] = constr;
                continue;
            }
            boolean jvmVarargs = MethodHandleUtil.isJvmVarargsMethodOrConstructor(constr);
            for (java.lang.Class<?> pt : pts) {
                if (TypeDescriptor.class.isAssignableFrom(pt)) {
                    ++ii;
                    continue;
                }
                ConstructorName annotation = pt.getAnnotation(ConstructorName.class);
                if (ctorName != null) {
                    if (annotation == null || !ctorName.equals(annotation.value()) || annotation.delegation()) continue block0;
                    defaultedMethods[this.index((int)(++ii), pts, (boolean)jvmVarargs)] = constr;
                    continue block0;
                }
                if (annotation != null) continue block0;
                defaultedMethods[this.index((int)ii, pts, (boolean)jvmVarargs)] = constr;
                continue block0;
            }
        }
        return defaultedMethods;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static MethodHandle reflectionToMethodHandle(Reference constructorReference, Member found, java.lang.Class<?> javaClass, Object instance, List<com.redhat.ceylon.model.typechecker.model.Type> parameterProducedTypes, boolean jvmVarargs, boolean bindVariadicParameterToEmptyArray) {
        com.redhat.ceylon.model.typechecker.model.Constructor constructorModel;
        List<TypeParameter> reifiedTypeParameters;
        int typeParametersCount;
        boolean isJavaArray;
        boolean isStatic;
        java.lang.Class<?> returnType;
        java.lang.Class<?>[] parameterTypes;
        Executable foundMethod;
        MethodHandle method = null;
        int skipParameters = 0;
        if (found instanceof Method) {
            Generic functionModel = (Generic)((Object)constructorReference.getDeclaration());
            foundMethod = (Method)found;
            parameterTypes = ((Method)foundMethod).getParameterTypes();
            returnType = ((Method)foundMethod).getReturnType();
            isStatic = Modifier.isStatic(((Method)foundMethod).getModifiers());
            isJavaArray = MethodHandleUtil.isJavaArray(javaClass);
            typeParametersCount = javaClass.getTypeParameters().length;
            try {
                if (isJavaArray) {
                    if (((Method)foundMethod).getName().equals("get")) {
                        method = MethodHandleUtil.getJavaArrayGetterMethodHandle(javaClass);
                    } else if (((Method)foundMethod).getName().equals("set")) {
                        method = MethodHandleUtil.getJavaArraySetterMethodHandle(javaClass);
                    } else if (((Method)foundMethod).getName().equals("copyTo")) {
                        found = MethodHandleUtil.getJavaArrayCopyToMethod(javaClass, (Method)foundMethod);
                    }
                }
                if (method == null) {
                    ((Method)foundMethod).setAccessible(true);
                    method = MethodHandles.lookup().unreflect((Method)foundMethod);
                }
            }
            catch (IllegalAccessException e) {
                throw Metamodel.newModelError("Problem getting a MH for constructor for: " + javaClass, e);
            }
            reifiedTypeParameters = functionModel.getTypeParameters();
            constructorModel = null;
        } else {
            if (!(found instanceof Constructor)) throw new RuntimeException();
            Declaration functionOrConstructorModel = constructorReference.getDeclaration();
            foundMethod = (Constructor)found;
            parameterTypes = ((Constructor)foundMethod).getParameterTypes();
            returnType = javaClass;
            isStatic = Modifier.isStatic(((Constructor)foundMethod).getDeclaringClass().getModifiers());
            ((Constructor)foundMethod).setAccessible(true);
            try {
                method = MethodHandles.lookup().unreflectConstructor((Constructor<?>)foundMethod);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            isJavaArray = false;
            typeParametersCount = javaClass.getTypeParameters().length;
            if (functionOrConstructorModel instanceof com.redhat.ceylon.model.typechecker.model.Constructor) {
                constructorModel = (com.redhat.ceylon.model.typechecker.model.Constructor)functionOrConstructorModel;
                reifiedTypeParameters = ModelUtil.getConstructedClass(constructorModel).getTypeParameters();
            } else if (functionOrConstructorModel instanceof Function) {
                constructorModel = (com.redhat.ceylon.model.typechecker.model.Constructor)((Function)functionOrConstructorModel).getTypeDeclaration();
                reifiedTypeParameters = ModelUtil.getConstructedClass(constructorModel).getTypeParameters();
            } else {
                if (!(functionOrConstructorModel instanceof Class)) throw new RuntimeException();
                constructorModel = null;
                reifiedTypeParameters = ((Class)functionOrConstructorModel).getTypeParameters();
            }
        }
        boolean isJavaMember = found instanceof Constructor && instance != null && !isStatic;
        method = MethodHandleUtil.boxReturnValue(method, returnType, constructorReference.getType());
        if (isJavaMember) {
            method = method.asType(MethodType.methodType(Object.class, parameterTypes));
        }
        if (instance != null && (isJavaArray || !isStatic)) {
            method = method.bindTo(instance);
        }
        if (!isJavaMember) {
            method = method.asType(MethodType.methodType(Object.class, parameterTypes));
        }
        if (isJavaMember) {
            ++skipParameters;
        }
        if (typeParametersCount != 0 && MethodHandleUtil.isReifiedTypeSupported(found, isJavaMember)) {
            ArrayList<com.redhat.ceylon.model.typechecker.model.Type> typeArguments = new ArrayList<com.redhat.ceylon.model.typechecker.model.Type>();
            Map<TypeParameter, com.redhat.ceylon.model.typechecker.model.Type> typeArgumentMap = constructorReference.getTypeArguments();
            for (TypeParameter tp : reifiedTypeParameters) {
                typeArguments.add(typeArgumentMap.get(tp));
            }
            method = MethodHandleUtil.insertReifiedTypeArguments(method, 0, typeArguments);
            skipParameters += typeParametersCount;
        }
        if (constructorModel == null) return MethodHandleUtil.unboxArguments(method, skipParameters, 0, parameterTypes, parameterProducedTypes, jvmVarargs, bindVariadicParameterToEmptyArray);
        if (constructorModel.getName() == null) return MethodHandleUtil.unboxArguments(method, skipParameters, 0, parameterTypes, parameterProducedTypes, jvmVarargs, bindVariadicParameterToEmptyArray);
        if (constructorModel.getName().isEmpty()) return MethodHandleUtil.unboxArguments(method, skipParameters, 0, parameterTypes, parameterProducedTypes, jvmVarargs, bindVariadicParameterToEmptyArray);
        method = MethodHandleUtil.insertConstructorNameArgument(method, 0, constructorModel);
        ++skipParameters;
        return MethodHandleUtil.unboxArguments(method, skipParameters, 0, parameterTypes, parameterProducedTypes, jvmVarargs, bindVariadicParameterToEmptyArray);
    }

    public void checkConstructor() {
        if (this.freeClass.getAbstract()) {
            throw new InvocationException("Abstract class cannot be instantiated");
        }
        if (this.freeClass.getAnonymous()) {
            throw new InvocationException("Object class cannot be instantiated");
        }
        if (this.constructor == null) {
            throw Metamodel.newModelError("No constructor found for: " + this.freeClass.getName());
        }
    }

    @Override
    public Type $call$() {
        try {
            if (this.firstDefaulted == -1) {
                return (Type)this.constructor.invokeExact();
            }
            return (Type)this.dispatch[0].invokeExact();
        }
        catch (Throwable e) {
            Util.rethrow(e);
            return null;
        }
    }

    @Override
    public Type $callvariadic$() {
        return this.$callvariadic$(empty_.get_());
    }

    @Override
    public Type $callvariadic$(Sequential<?> varargs) {
        return this.$call$((Object)varargs);
    }

    @Override
    public Type $call$(Object arg0) {
        try {
            if (this.firstDefaulted == -1) {
                return (Type)this.constructor.invokeExact(arg0);
            }
            return (Type)this.dispatch[1 - this.firstDefaulted].invokeExact(arg0);
        }
        catch (Throwable e) {
            Util.rethrow(e);
            return null;
        }
    }

    @Override
    public Type $callvariadic$(Object arg0) {
        return this.$callvariadic$(arg0, empty_.get_());
    }

    @Override
    public Type $callvariadic$(Object arg0, Sequential<?> varargs) {
        return this.$call$(arg0, (Object)varargs);
    }

    @Override
    public Type $call$(Object arg0, Object arg1) {
        try {
            if (this.firstDefaulted == -1) {
                return (Type)this.constructor.invokeExact(arg0, arg1);
            }
            return (Type)this.dispatch[2 - this.firstDefaulted].invokeExact(arg0, arg1);
        }
        catch (Throwable e) {
            Util.rethrow(e);
            return null;
        }
    }

    @Override
    public Type $callvariadic$(Object arg0, Object arg1) {
        return this.$callvariadic$(arg0, arg1, empty_.get_());
    }

    @Override
    public Type $callvariadic$(Object arg0, Object arg1, Sequential<?> varargs) {
        return this.$call$(arg0, arg1, (Object)varargs);
    }

    @Override
    public Type $call$(Object arg0, Object arg1, Object arg2) {
        try {
            if (this.firstDefaulted == -1) {
                return (Type)this.constructor.invokeExact(arg0, arg1, arg2);
            }
            return (Type)this.dispatch[3 - this.firstDefaulted].invokeExact(arg0, arg1, arg2);
        }
        catch (Throwable e) {
            Util.rethrow(e);
            return null;
        }
    }

    @Override
    public Type $callvariadic$(Object arg0, Object arg1, Object arg2) {
        return this.$callvariadic$(arg0, arg1, arg2, empty_.get_());
    }

    @Override
    public Type $callvariadic$(Object arg0, Object arg1, Object arg2, Sequential<?> varargs) {
        return this.$call$(arg0, arg1, arg2, varargs);
    }

    @Override
    public Type $call$(Object ... args) {
        try {
            if (this.firstDefaulted == -1) {
                return (Type)this.constructor.invokeWithArguments(args);
            }
            return (Type)this.dispatch[args.length - this.firstDefaulted].invokeWithArguments(args);
        }
        catch (Throwable e) {
            Util.rethrow(e);
            return null;
        }
    }

    @Override
    public Type $callvariadic$(Object ... argsAndVarargs) {
        return this.$call$(argsAndVarargs);
    }

    @Override
    public short $getVariadicParameterIndex$() {
        return (short)this.variadicIndex;
    }

    public Sequential<? extends Type<? extends Object>> getParameterTypes() {
        return this.parameterTypes;
    }

    public List<com.redhat.ceylon.model.typechecker.model.Type> getProducedParameterTypes() {
        return this.parameterProducedTypes;
    }

    @Override
    public Object getDefaultParameterValue(Parameter parameter, Array<Object> values, int collectedValueCount) {
        java.lang.Class<?> lookupClass;
        String name;
        Class decl = (Class)this.freeClass.declaration;
        java.lang.Class<?> javaClass = Metamodel.getJavaClass(decl);
        Method found = null;
        if (!javaClass.isMemberClass()) {
            name = "$default$" + parameter.getName();
            lookupClass = javaClass;
        } else {
            name = "$default$" + this.freeClass.getName() + "$" + parameter.getName();
            lookupClass = Metamodel.getJavaClass((Declaration)((Object)this.freeClass.declaration.getContainer()));
        }
        for (Method m : lookupClass.getDeclaredMethods()) {
            if (!m.getName().equals(name)) continue;
            found = m;
            break;
        }
        if (found == null) {
            throw Metamodel.newModelError("Default argument method for " + parameter.getName() + " not found");
        }
        int parameterCount = found.getParameterTypes().length;
        if (MethodHandleUtil.isReifiedTypeSupported(found, false)) {
            parameterCount -= found.getTypeParameters().length;
        }
        if (parameterCount != collectedValueCount) {
            throw Metamodel.newModelError("Default argument method for " + parameter.getName() + " requires wrong number of parameters: " + parameterCount + " should be " + collectedValueCount);
        }
        MethodHandle methodHandle = ConstructorDispatch.reflectionToMethodHandle(this.constructorReference, found, javaClass, this.instance, this.parameterProducedTypes, false, false);
        Object[] arguments = new Object[collectedValueCount];
        System.arraycopy(values.toArray(), 0, arguments, 0, collectedValueCount);
        try {
            return methodHandle.invokeWithArguments(arguments);
        }
        catch (Throwable e) {
            Util.rethrow(e);
            return null;
        }
    }

    @Override
    public Type apply() {
        return this.apply(empty_.get_());
    }

    @Override
    public Type apply(Sequential<? extends Object> arguments) {
        this.checkConstructor();
        return (Type)Metamodel.apply(this, arguments, this.parameterProducedTypes, this.firstDefaulted, this.variadicIndex);
    }

    @Override
    public Type namedApply(Iterable<? extends Entry<? extends ceylon.language.String, ? extends Object>, ? extends Object> arguments) {
        this.checkConstructor();
        return (Type)Metamodel.namedApply(this, this, (Functional)((Object)(this.freeConstructor != null ? this.freeConstructor.declaration : this.freeClass.declaration)), arguments, this.parameterProducedTypes);
    }
}

