/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.runtime.metamodel;

import ceylon.language.Boolean;
import ceylon.language.Byte;
import ceylon.language.Float;
import ceylon.language.Integer;
import ceylon.language.String;
import com.redhat.ceylon.compiler.java.Util;
import com.redhat.ceylon.compiler.java.language.BooleanArray;
import com.redhat.ceylon.compiler.java.language.ByteArray;
import com.redhat.ceylon.compiler.java.language.CharArray;
import com.redhat.ceylon.compiler.java.language.DoubleArray;
import com.redhat.ceylon.compiler.java.language.FloatArray;
import com.redhat.ceylon.compiler.java.language.IntArray;
import com.redhat.ceylon.compiler.java.language.LongArray;
import com.redhat.ceylon.compiler.java.language.ObjectArray;
import com.redhat.ceylon.compiler.java.language.ShortArray;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.runtime.metamodel.Metamodel;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;

public class MethodHandleUtil {
    public static MethodHandle insertReifiedTypeArguments(MethodHandle constructor, int insertAt, List<Type> typeArguments) {
        Object[] typeDescriptors = new TypeDescriptor[typeArguments.size()];
        for (int i = 0; i < typeDescriptors.length; ++i) {
            typeDescriptors[i] = Metamodel.getTypeDescriptorForProducedType(typeArguments.get(i));
        }
        return MethodHandles.insertArguments(constructor, insertAt, typeDescriptors);
    }

    public static MethodHandle insertConstructorNameArgument(MethodHandle constructor, int insertAt, com.redhat.ceylon.model.typechecker.model.Constructor ctor) {
        return MethodHandles.insertArguments(constructor, insertAt, new Object[]{null});
    }

    public static MethodHandle unboxArguments(MethodHandle method, int skippedParameters, int filterIndex, java.lang.Class<?>[] parameterTypes, List<Type> producedTypes) {
        return MethodHandleUtil.unboxArguments(method, skippedParameters, filterIndex, parameterTypes, parameterTypes.length, producedTypes, false);
    }

    public static MethodHandle unboxArguments(MethodHandle method, int skippedParameters, int filterIndex, java.lang.Class<?>[] parameterTypes, List<Type> producedTypes, boolean jvmVarargs, boolean bindVariadicParameterToEmptyArray) {
        if (bindVariadicParameterToEmptyArray) {
            MethodHandle ret = MethodHandleUtil.unboxArguments(method, skippedParameters, filterIndex, parameterTypes, parameterTypes.length - 1, producedTypes, false);
            java.lang.Class<?> paramType = parameterTypes[parameterTypes.length - 1];
            Object val = paramType == byte[].class ? new byte[]{} : (paramType == short[].class ? (Object)new short[0] : (paramType == int[].class ? (Object)new int[0] : (paramType == long[].class ? (Object)new long[0] : (paramType == float[].class ? (Object)new float[0] : (paramType == double[].class ? (Object)new double[0] : (paramType == boolean[].class ? (Object)new boolean[0] : (paramType == char[].class ? (Object)new char[0] : (paramType == Object[].class ? (Object)new Object[0] : (Object)Array.newInstance(paramType.getComponentType(), 0)))))))));
            return MethodHandles.insertArguments(ret, parameterTypes.length - 1 - skippedParameters, val);
        }
        return MethodHandleUtil.unboxArguments(method, skippedParameters, filterIndex, parameterTypes, parameterTypes.length, producedTypes, jvmVarargs);
    }

    public static MethodHandle unboxArguments(MethodHandle method, int skippedParameters, int filterIndex, java.lang.Class<?>[] parameterTypes, int parameterCount, List<Type> producedTypes, boolean jvmVarargs) {
        MethodHandle[] filters = new MethodHandle[parameterCount - skippedParameters];
        try {
            for (int i = 0; i < filters.length; ++i) {
                MethodHandle unbox;
                java.lang.Class<?> paramType = parameterTypes[i + skippedParameters];
                Type producedType = producedTypes.get(i);
                if (jvmVarargs && i == filters.length - 1) {
                    MethodHandle convert;
                    java.lang.String methodName = null;
                    Object[] empty = null;
                    java.lang.Class<Object> initialParamType = null;
                    if (paramType == boolean[].class) {
                        methodName = "toBooleanArray";
                        empty = new boolean[]{};
                        initialParamType = paramType;
                    } else if (paramType == byte[].class) {
                        methodName = "toByteArray";
                        empty = new byte[0];
                        initialParamType = byte[].class;
                    } else if (paramType == short[].class) {
                        methodName = "toShortArray";
                        empty = new long[0];
                        initialParamType = long[].class;
                    } else if (paramType == int[].class) {
                        methodName = "toIntArray";
                        empty = new long[0];
                        initialParamType = long[].class;
                    } else if (paramType == long[].class) {
                        methodName = "toLongArray";
                        empty = new long[0];
                        initialParamType = long[].class;
                    } else if (paramType == float[].class) {
                        methodName = "toFloatArray";
                        empty = new double[0];
                        initialParamType = double[].class;
                    } else if (paramType == double[].class) {
                        methodName = "toDoubleArray";
                        empty = new double[0];
                        initialParamType = double[].class;
                    } else if (paramType == char[].class) {
                        methodName = "toCharArray";
                        empty = new int[0];
                        initialParamType = int[].class;
                    } else if (paramType == java.lang.String[].class) {
                        methodName = "toJavaStringArray";
                        empty = new java.lang.String[0];
                        initialParamType = paramType;
                    }
                    if (methodName != null && empty != null && initialParamType != null) {
                        convert = MethodHandles.lookup().findStatic(Util.class, methodName, MethodType.methodType(paramType, ceylon.language.List.class, initialParamType));
                        convert = MethodHandles.insertArguments(convert, 1, new Object[]{empty});
                        filters[i] = convert.asType(MethodType.methodType(paramType, Object.class));
                        continue;
                    }
                    convert = MethodHandles.lookup().findStatic(Util.class, "toArray", MethodType.methodType(Object[].class, ceylon.language.List.class, java.lang.Class.class, Object[].class));
                    convert = MethodHandles.insertArguments(convert, 1, paramType.getComponentType(), new Object[0]);
                    filters[i] = convert.asType(MethodType.methodType(paramType, Object.class));
                    continue;
                }
                if (paramType == java.lang.String.class) {
                    unbox = MethodHandles.lookup().findVirtual(String.class, "toString", MethodType.methodType(java.lang.String.class));
                    filters[i] = unbox.asType(MethodType.methodType(java.lang.String.class, Object.class));
                    continue;
                }
                if (paramType == Short.TYPE || paramType == java.lang.Integer.TYPE && !MethodHandleUtil.isCeylonCharacter(producedType)) {
                    unbox = MethodHandles.lookup().findVirtual(Integer.class, "longValue", MethodType.methodType(Long.TYPE));
                    filters[i] = MethodHandles.explicitCastArguments(unbox, MethodType.methodType(paramType, Object.class));
                    continue;
                }
                if (paramType == java.lang.Byte.TYPE) {
                    unbox = MethodHandles.lookup().findVirtual(Byte.class, "byteValue", MethodType.methodType(java.lang.Byte.TYPE));
                    filters[i] = unbox.asType(MethodType.methodType(java.lang.Byte.TYPE, Object.class));
                    continue;
                }
                if (paramType == Long.TYPE) {
                    unbox = MethodHandles.lookup().findVirtual(Integer.class, "longValue", MethodType.methodType(Long.TYPE));
                    filters[i] = unbox.asType(MethodType.methodType(Long.TYPE, Object.class));
                    continue;
                }
                if (paramType == java.lang.Float.TYPE) {
                    unbox = MethodHandles.lookup().findVirtual(Float.class, "doubleValue", MethodType.methodType(Double.TYPE));
                    filters[i] = MethodHandles.explicitCastArguments(unbox, MethodType.methodType(java.lang.Float.TYPE, Object.class));
                    continue;
                }
                if (paramType == Double.TYPE) {
                    unbox = MethodHandles.lookup().findVirtual(Float.class, "doubleValue", MethodType.methodType(Double.TYPE));
                    filters[i] = unbox.asType(MethodType.methodType(Double.TYPE, Object.class));
                    continue;
                }
                if (paramType == java.lang.Integer.TYPE && MethodHandleUtil.isCeylonCharacter(producedType)) {
                    unbox = MethodHandles.lookup().findVirtual(ceylon.language.Character.class, "intValue", MethodType.methodType(java.lang.Integer.TYPE));
                    filters[i] = unbox.asType(MethodType.methodType(java.lang.Integer.TYPE, Object.class));
                    continue;
                }
                if (paramType == Character.TYPE) {
                    unbox = MethodHandles.lookup().findVirtual(ceylon.language.Character.class, "intValue", MethodType.methodType(java.lang.Integer.TYPE));
                    filters[i] = MethodHandles.explicitCastArguments(unbox, MethodType.methodType(Character.TYPE, Object.class));
                    continue;
                }
                if (paramType == java.lang.Boolean.TYPE) {
                    unbox = MethodHandles.lookup().findVirtual(Boolean.class, "booleanValue", MethodType.methodType(java.lang.Boolean.TYPE));
                    filters[i] = unbox.asType(MethodType.methodType(java.lang.Boolean.TYPE, Object.class));
                    continue;
                }
                if (paramType == Object.class) continue;
                unbox = MethodHandles.identity(Object.class);
                filters[i] = unbox.asType(MethodType.methodType(paramType, Object.class));
            }
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw Metamodel.newModelError("Failed to filter parameter", e);
        }
        return MethodHandles.filterArguments(method, filterIndex, filters);
    }

    private static boolean isCeylonCharacter(Type producedType) {
        if (producedType == null) {
            return false;
        }
        TypeDeclaration declaration = producedType.getDeclaration();
        if (!(declaration instanceof Class)) {
            return false;
        }
        return declaration.getQualifiedNameString().equals("ceylon.language::Character");
    }

    public static MethodHandle boxReturnValue(MethodHandle method, java.lang.Class<?> type, Type producedType) {
        try {
            if (type == java.lang.String.class) {
                MethodHandle box = MethodHandles.lookup().findStatic(String.class, "instance", MethodType.methodType(String.class, java.lang.String.class));
                method = MethodHandles.filterReturnValue(method, box);
            } else {
                if (type == java.lang.Integer.TYPE && MethodHandleUtil.isCeylonCharacter(producedType)) {
                    MethodHandle box = MethodHandles.lookup().findStatic(ceylon.language.Character.class, "instance", MethodType.methodType(ceylon.language.Character.class, java.lang.Integer.TYPE));
                    return MethodHandles.filterReturnValue(method, box);
                }
                if (type == java.lang.Integer.TYPE || type == Short.TYPE) {
                    MethodHandle box = MethodHandles.lookup().findStatic(Integer.class, "instance", MethodType.methodType(Integer.class, Long.TYPE));
                    box = box.asType(MethodType.methodType(Integer.class, type));
                    return MethodHandles.filterReturnValue(method, box);
                }
                if (type == java.lang.Byte.TYPE) {
                    MethodHandle box = MethodHandles.lookup().findStatic(Byte.class, "instance", MethodType.methodType(Byte.class, java.lang.Byte.TYPE));
                    box = box.asType(MethodType.methodType(Byte.class, type));
                    return MethodHandles.filterReturnValue(method, box);
                }
                if (type == Long.TYPE) {
                    MethodHandle box = MethodHandles.lookup().findStatic(Integer.class, "instance", MethodType.methodType(Integer.class, Long.TYPE));
                    return MethodHandles.filterReturnValue(method, box);
                }
                if (type == Double.TYPE) {
                    MethodHandle box = MethodHandles.lookup().findStatic(Float.class, "instance", MethodType.methodType(Float.class, Double.TYPE));
                    return MethodHandles.filterReturnValue(method, box);
                }
                if (type == java.lang.Float.TYPE) {
                    MethodHandle box = MethodHandles.lookup().findStatic(Float.class, "instance", MethodType.methodType(Float.class, Double.TYPE));
                    box = box.asType(MethodType.methodType(Float.class, type));
                    return MethodHandles.filterReturnValue(method, box);
                }
                if (type == Character.TYPE) {
                    MethodHandle box = MethodHandles.lookup().findStatic(ceylon.language.Character.class, "instance", MethodType.methodType(ceylon.language.Character.class, java.lang.Integer.TYPE));
                    box = box.asType(MethodType.methodType(ceylon.language.Character.class, type));
                    return MethodHandles.filterReturnValue(method, box);
                }
                if (type == java.lang.Boolean.TYPE) {
                    MethodHandle box = MethodHandles.lookup().findStatic(Boolean.class, "instance", MethodType.methodType(Boolean.class, java.lang.Boolean.TYPE));
                    return MethodHandles.filterReturnValue(method, box);
                }
            }
            return method;
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw Metamodel.newModelError("Failed to filter return value", e);
        }
    }

    public static boolean isReifiedTypeSupported(Object methodOrConstructor, boolean skipFirstParameter) {
        int start;
        boolean checkIgnoreAnnotations;
        Annotation[][] annotations;
        java.lang.Class<?>[] parameterTypes;
        int tpCount;
        if (methodOrConstructor instanceof Method) {
            Method method = (Method)methodOrConstructor;
            tpCount = method.getTypeParameters().length;
            parameterTypes = method.getParameterTypes();
            annotations = method.getParameterAnnotations();
            checkIgnoreAnnotations = method.getAnnotation(Ignore.class) == null;
        } else {
            Constructor constructor = (Constructor)methodOrConstructor;
            tpCount = constructor.getDeclaringClass().getTypeParameters().length;
            parameterTypes = constructor.getParameterTypes();
            annotations = constructor.getParameterAnnotations();
            checkIgnoreAnnotations = constructor.getAnnotation(Ignore.class) == null;
        }
        int n = start = skipFirstParameter ? 1 : 0;
        if (tpCount > parameterTypes.length - start) {
            return false;
        }
        int annotationOffset = parameterTypes.length - annotations.length;
        for (int i = 0; i < tpCount; ++i) {
            if (parameterTypes[i + start] != TypeDescriptor.class) {
                return false;
            }
            if (!checkIgnoreAnnotations || MethodHandleUtil.hasAnnotation(Ignore.class, annotations[i + start - annotationOffset])) continue;
            return false;
        }
        return true;
    }

    private static boolean hasAnnotation(java.lang.Class<?> toFind, Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (toFind != annotation.annotationType()) continue;
            return true;
        }
        return false;
    }

    public static boolean isJvmVarargsMethodOrConstructor(Object found) {
        if (found instanceof Constructor) {
            return ((Constructor)found).isVarArgs();
        }
        return ((Method)found).isVarArgs();
    }

    public static boolean isJavaArray(java.lang.Class<?> arrayClass) {
        return arrayClass == ByteArray.class || arrayClass == ShortArray.class || arrayClass == IntArray.class || arrayClass == LongArray.class || arrayClass == FloatArray.class || arrayClass == DoubleArray.class || arrayClass == CharArray.class || arrayClass == BooleanArray.class || arrayClass == ObjectArray.class;
    }

    public static Method setupArrayConstructor(java.lang.Class<?> arrayClass, Object[] defaultedMethods) {
        if (arrayClass == ByteArray.class) {
            return MethodHandleUtil.setupArrayConstructor("byteArrayConstructor", java.lang.Byte.TYPE, defaultedMethods);
        }
        if (arrayClass == ShortArray.class) {
            return MethodHandleUtil.setupArrayConstructor("shortArrayConstructor", Short.TYPE, defaultedMethods);
        }
        if (arrayClass == IntArray.class) {
            return MethodHandleUtil.setupArrayConstructor("intArrayConstructor", java.lang.Integer.TYPE, defaultedMethods);
        }
        if (arrayClass == LongArray.class) {
            return MethodHandleUtil.setupArrayConstructor("longArrayConstructor", Long.TYPE, defaultedMethods);
        }
        if (arrayClass == FloatArray.class) {
            return MethodHandleUtil.setupArrayConstructor("floatArrayConstructor", java.lang.Float.TYPE, defaultedMethods);
        }
        if (arrayClass == DoubleArray.class) {
            return MethodHandleUtil.setupArrayConstructor("doubleArrayConstructor", Double.TYPE, defaultedMethods);
        }
        if (arrayClass == CharArray.class) {
            return MethodHandleUtil.setupArrayConstructor("charArrayConstructor", Character.TYPE, defaultedMethods);
        }
        if (arrayClass == BooleanArray.class) {
            return MethodHandleUtil.setupArrayConstructor("booleanArrayConstructor", java.lang.Boolean.TYPE, defaultedMethods);
        }
        if (arrayClass == ObjectArray.class) {
            return MethodHandleUtil.setupArrayConstructor("objectArrayConstructor", Object.class, defaultedMethods, true);
        }
        throw Metamodel.newModelError("Array type not supported yet: " + arrayClass);
    }

    public static Method setupArrayConstructor(java.lang.String name, java.lang.Class<?> elementType, Object[] defaultedMethods) {
        return MethodHandleUtil.setupArrayConstructor(name, elementType, defaultedMethods, false);
    }

    public static Method setupArrayConstructor(java.lang.String name, java.lang.Class<?> elementType, Object[] defaultedMethods, boolean withTypeParameter) {
        try {
            Method found;
            if (withTypeParameter) {
                found = MethodHandleUtil.class.getDeclaredMethod(name, TypeDescriptor.class, java.lang.Integer.TYPE, elementType);
                defaultedMethods[0] = MethodHandleUtil.class.getDeclaredMethod(name, TypeDescriptor.class, java.lang.Integer.TYPE);
            } else {
                found = MethodHandleUtil.class.getDeclaredMethod(name, java.lang.Integer.TYPE, elementType);
                defaultedMethods[0] = MethodHandleUtil.class.getDeclaredMethod(name, java.lang.Integer.TYPE);
            }
            defaultedMethods[1] = found;
            return found;
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw Metamodel.newModelError("Failed to find array method constructor " + name + " in MethodHandleUtil", e);
        }
    }

    public static byte[] byteArrayConstructor(int size) {
        return new byte[size];
    }

    public static byte[] byteArrayConstructor(int size, byte element) {
        byte[] ret = new byte[size];
        Arrays.fill(ret, element);
        return ret;
    }

    public static short[] shortArrayConstructor(int size) {
        return new short[size];
    }

    public static short[] shortArrayConstructor(int size, short element) {
        short[] ret = new short[size];
        Arrays.fill(ret, element);
        return ret;
    }

    public static int[] intArrayConstructor(int size) {
        return new int[size];
    }

    public static int[] intArrayConstructor(int size, int element) {
        int[] ret = new int[size];
        Arrays.fill(ret, element);
        return ret;
    }

    public static long[] longArrayConstructor(int size) {
        return new long[size];
    }

    public static long[] longArrayConstructor(int size, long element) {
        long[] ret = new long[size];
        Arrays.fill(ret, element);
        return ret;
    }

    public static float[] floatArrayConstructor(int size) {
        return new float[size];
    }

    public static float[] floatArrayConstructor(int size, float element) {
        float[] ret = new float[size];
        Arrays.fill(ret, element);
        return ret;
    }

    public static double[] doubleArrayConstructor(int size) {
        return new double[size];
    }

    public static double[] doubleArrayConstructor(int size, double element) {
        double[] ret = new double[size];
        Arrays.fill(ret, element);
        return ret;
    }

    public static char[] charArrayConstructor(int size) {
        return new char[size];
    }

    public static char[] charArrayConstructor(int size, char element) {
        char[] ret = new char[size];
        Arrays.fill(ret, element);
        return ret;
    }

    public static boolean[] booleanArrayConstructor(int size) {
        return new boolean[size];
    }

    public static boolean[] booleanArrayConstructor(int size, boolean element) {
        boolean[] ret = new boolean[size];
        Arrays.fill(ret, element);
        return ret;
    }

    public static <T> T[] objectArrayConstructor(@Ignore TypeDescriptor $reifiedT, int size) {
        java.lang.Class componentType = Util.getJavaClassForDescriptor($reifiedT);
        return (Object[])Array.newInstance(componentType, size);
    }

    public static <T> T[] objectArrayConstructor(@Ignore TypeDescriptor $reifiedT, int size, T element) {
        java.lang.Class componentType = Util.getJavaClassForDescriptor($reifiedT);
        Object[] ret = (Object[])Array.newInstance(componentType, size);
        Arrays.fill(ret, element);
        return ret;
    }

    public static MethodHandle getJavaArrayGetterMethodHandle(java.lang.Class<?> arrayClass) {
        java.lang.Class<?> arrayType = MethodHandleUtil.getJavaArrayType(arrayClass);
        return MethodHandles.arrayElementGetter(arrayType);
    }

    public static MethodHandle getJavaArraySetterMethodHandle(java.lang.Class<?> arrayClass) {
        java.lang.Class<?> arrayType = MethodHandleUtil.getJavaArrayType(arrayClass);
        return MethodHandles.arrayElementSetter(arrayType);
    }

    private static java.lang.Class<?> getJavaArrayType(java.lang.Class<?> arrayClass) {
        java.lang.Class arrayType = null;
        if (arrayClass == ByteArray.class) {
            arrayType = byte[].class;
        }
        if (arrayClass == ShortArray.class) {
            arrayType = short[].class;
        }
        if (arrayClass == IntArray.class) {
            arrayType = int[].class;
        }
        if (arrayClass == LongArray.class) {
            arrayType = long[].class;
        }
        if (arrayClass == FloatArray.class) {
            arrayType = float[].class;
        }
        if (arrayClass == DoubleArray.class) {
            arrayType = double[].class;
        }
        if (arrayClass == CharArray.class) {
            arrayType = char[].class;
        }
        if (arrayClass == BooleanArray.class) {
            arrayType = boolean[].class;
        }
        if (arrayClass == ObjectArray.class) {
            arrayType = Object[].class;
        }
        if (arrayType == null) {
            throw Metamodel.newModelError("Array type not supported yet: " + arrayClass);
        }
        return arrayType;
    }

    public static Method getJavaArrayCopyToMethod(java.lang.Class<?> arrayClass, Method found) {
        java.lang.Class<?> arrayType = MethodHandleUtil.getJavaArrayType(arrayClass);
        try {
            switch (found.getParameterTypes().length) {
                case 1: {
                    return arrayClass.getDeclaredMethod("copyTo", arrayType, arrayType);
                }
                case 2: {
                    return arrayClass.getDeclaredMethod("copyTo", arrayType, arrayType, java.lang.Integer.TYPE);
                }
                case 3: {
                    return arrayClass.getDeclaredMethod("copyTo", arrayType, arrayType, java.lang.Integer.TYPE, java.lang.Integer.TYPE);
                }
                case 4: {
                    return arrayClass.getDeclaredMethod("copyTo", arrayType, arrayType, java.lang.Integer.TYPE, java.lang.Integer.TYPE, java.lang.Integer.TYPE);
                }
            }
            throw Metamodel.newModelError("Missing " + arrayClass + " static method copyTo with parameters: " + arrayType + " and " + found.getParameterTypes());
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw Metamodel.newModelError("Missing " + arrayClass + " static method copyTo with parameters: " + arrayType + " and " + found.getParameterTypes(), e);
        }
    }

    public static java.lang.Class<?>[] getJavaArrayGetArrayParameterTypes(java.lang.Class<?> arrayClass, java.lang.String getterName) {
        java.lang.Class<?> arrayType = MethodHandleUtil.getJavaArrayType(arrayClass);
        if (getterName.equals("getArray") || arrayClass == BooleanArray.class && getterName.equals("getBooleanArray") || arrayClass == ByteArray.class && getterName.equals("getByteArray") || arrayClass == LongArray.class && getterName.equals("getIntegerArray") || arrayClass == DoubleArray.class && getterName.equals("getFloatArray") || arrayClass == IntArray.class && getterName.equals("getCodePointArray")) {
            return new java.lang.Class[]{arrayType};
        }
        throw Metamodel.newModelError("No such property in Java array " + arrayClass + ": " + getterName);
    }
}

