/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.runtime.metamodel;

import ceylon.language.Annotated;
import ceylon.language.Annotation;
import ceylon.language.ConstrainedAnnotation;
import ceylon.language.Iterator;
import ceylon.language.List;
import ceylon.language.OptionalAnnotation;
import ceylon.language.SequencedAnnotation;
import ceylon.language.Sequential;
import ceylon.language.meta.declaration.AliasDeclaration;
import ceylon.language.meta.declaration.AnnotatedDeclaration;
import ceylon.language.meta.declaration.CallableConstructorDeclaration;
import ceylon.language.meta.declaration.ClassDeclaration;
import ceylon.language.meta.declaration.ClassOrInterfaceDeclaration;
import ceylon.language.meta.declaration.ClassWithConstructorsDeclaration;
import ceylon.language.meta.declaration.ClassWithInitializerDeclaration;
import ceylon.language.meta.declaration.ConstructorDeclaration;
import ceylon.language.meta.declaration.Declaration;
import ceylon.language.meta.declaration.FunctionDeclaration;
import ceylon.language.meta.declaration.FunctionOrValueDeclaration;
import ceylon.language.meta.declaration.InterfaceDeclaration;
import ceylon.language.meta.declaration.NestableDeclaration;
import ceylon.language.meta.declaration.ValueConstructorDeclaration;
import ceylon.language.meta.declaration.ValueDeclaration;
import ceylon.language.meta.model.ClassOrInterface;
import ceylon.language.meta.model.Type;
import ceylon.language.meta.model.nothingType_;
import com.redhat.ceylon.compiler.java.Util;
import com.redhat.ceylon.compiler.java.language.EnumeratedTypeError;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.runtime.metamodel.Metamodel;
import com.redhat.ceylon.compiler.java.runtime.metamodel.meta.IntersectionTypeImpl;
import com.redhat.ceylon.compiler.java.runtime.metamodel.meta.UnionTypeImpl;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.Constructor;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.Interface;
import com.redhat.ceylon.model.typechecker.model.TypeAlias;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.Arrays;

public class Predicates {
    private static final Predicate<?> FALSE = new Predicate<Object>(){

        @Override
        public boolean accept(Object candidate) {
            return false;
        }

        public String toString() {
            return "false";
        }
    };
    public static final Predicate<?> TRUE = new Predicate<Object>(){

        @Override
        public boolean accept(Object candidate) {
            return true;
        }

        public String toString() {
            return "true";
        }
    };
    private static final Predicate<com.redhat.ceylon.model.typechecker.model.Declaration> DECLARATION_IS_VALUE = new Predicate<com.redhat.ceylon.model.typechecker.model.Declaration>(){

        @Override
        public boolean accept(com.redhat.ceylon.model.typechecker.model.Declaration declaration) {
            return declaration instanceof Value && !(((Value)declaration).getTypeDeclaration() instanceof Constructor);
        }

        public String toString() {
            return "(kind = Value)";
        }
    };
    private static final Predicate<com.redhat.ceylon.model.typechecker.model.Declaration> DECLARATION_IS_FUNCTION = new Predicate<com.redhat.ceylon.model.typechecker.model.Declaration>(){

        @Override
        public boolean accept(com.redhat.ceylon.model.typechecker.model.Declaration declaration) {
            return declaration instanceof Function && !(((Function)declaration).getTypeDeclaration() instanceof Constructor);
        }

        public String toString() {
            return "(kind = Function)";
        }
    };
    private static final Predicate<com.redhat.ceylon.model.typechecker.model.Declaration> DECLARATION_IS_FUNCTION_OR_VALUE = new Predicate<com.redhat.ceylon.model.typechecker.model.Declaration>(){

        @Override
        public boolean accept(com.redhat.ceylon.model.typechecker.model.Declaration declaration) {
            return (declaration instanceof Value || declaration instanceof Function) && !(((FunctionOrValue)declaration).getTypeDeclaration() instanceof Constructor);
        }

        public String toString() {
            return "(kind = Value || kind = Function)";
        }
    };
    private static final Predicate<com.redhat.ceylon.model.typechecker.model.Declaration> DECLARATION_IS_CLASS = new Predicate<com.redhat.ceylon.model.typechecker.model.Declaration>(){

        @Override
        public boolean accept(com.redhat.ceylon.model.typechecker.model.Declaration declaration) {
            return declaration instanceof Class;
        }

        public String toString() {
            return "(kind = Class)";
        }
    };
    private static final Predicate<com.redhat.ceylon.model.typechecker.model.Declaration> DECLARATION_IS_CLASS_WITH_INIT = new Predicate<com.redhat.ceylon.model.typechecker.model.Declaration>(){

        @Override
        public boolean accept(com.redhat.ceylon.model.typechecker.model.Declaration declaration) {
            return declaration instanceof Class && !((Class)declaration).hasConstructors();
        }

        public String toString() {
            return "(kind = ClassWithInitializer)";
        }
    };
    private static final Predicate<com.redhat.ceylon.model.typechecker.model.Declaration> DECLARATION_IS_CLASS_WITH_CTORS = new Predicate<com.redhat.ceylon.model.typechecker.model.Declaration>(){

        @Override
        public boolean accept(com.redhat.ceylon.model.typechecker.model.Declaration declaration) {
            return declaration instanceof Class && ((Class)declaration).hasConstructors();
        }

        public String toString() {
            return "(kind = ClassWithConstructors)";
        }
    };
    private static final Predicate<com.redhat.ceylon.model.typechecker.model.Declaration> DECLARATION_IS_CONSTRUCTOR = new Predicate<com.redhat.ceylon.model.typechecker.model.Declaration>(){

        @Override
        public boolean accept(com.redhat.ceylon.model.typechecker.model.Declaration declaration) {
            return declaration instanceof FunctionOrValue && ((FunctionOrValue)declaration).getTypeDeclaration() instanceof Constructor;
        }

        public String toString() {
            return "(kind = Constructor)";
        }
    };
    private static final Predicate<com.redhat.ceylon.model.typechecker.model.Declaration> DECLARATION_IS_CALLABLE_CONSTRUCTOR = new Predicate<com.redhat.ceylon.model.typechecker.model.Declaration>(){

        @Override
        public boolean accept(com.redhat.ceylon.model.typechecker.model.Declaration declaration) {
            return declaration instanceof Function && ((Function)declaration).getTypeDeclaration() instanceof Constructor;
        }

        public String toString() {
            return "(kind = CallableConstructor)";
        }
    };
    private static final Predicate<com.redhat.ceylon.model.typechecker.model.Declaration> DECLARATION_IS_VALUE_CONSTRUCTOR = new Predicate<com.redhat.ceylon.model.typechecker.model.Declaration>(){

        @Override
        public boolean accept(com.redhat.ceylon.model.typechecker.model.Declaration declaration) {
            return declaration instanceof Value && ((Value)declaration).getTypeDeclaration() instanceof Constructor;
        }

        public String toString() {
            return "(kind = ValueConstructor)";
        }
    };
    private static final Predicate<com.redhat.ceylon.model.typechecker.model.Declaration> DECLARATION_IS_INTERFACE = new Predicate<com.redhat.ceylon.model.typechecker.model.Declaration>(){

        @Override
        public boolean accept(com.redhat.ceylon.model.typechecker.model.Declaration declaration) {
            return declaration instanceof Interface;
        }

        public String toString() {
            return "(kind = Interface)";
        }
    };
    private static final Predicate<com.redhat.ceylon.model.typechecker.model.Declaration> DECLARATION_IS_CLASS_OR_INTERFACE = new Predicate<com.redhat.ceylon.model.typechecker.model.Declaration>(){

        @Override
        public boolean accept(com.redhat.ceylon.model.typechecker.model.Declaration declaration) {
            return declaration instanceof com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
        }

        public String toString() {
            return "(kind = ClassOrInterface)";
        }
    };
    private static final Predicate<com.redhat.ceylon.model.typechecker.model.Declaration> DECLARATION_IS_ALIAS = new Predicate<com.redhat.ceylon.model.typechecker.model.Declaration>(){

        @Override
        public boolean accept(com.redhat.ceylon.model.typechecker.model.Declaration declaration) {
            return declaration instanceof TypeAlias;
        }

        public String toString() {
            return "(kind = Alias)";
        }
    };

    private Predicates() {
    }

    public static <T> Predicate<T> false_() {
        return FALSE;
    }

    static <T> Predicate<T> true_() {
        return TRUE;
    }

    public static NamePredicate isDeclarationNamed(String name) {
        return new NamePredicate(name);
    }

    @SafeVarargs
    public static <T> Predicate<T> and(Predicate<T> ... others) {
        if (others.length == 1) {
            return others[0];
        }
        for (Predicate<T> pred : others) {
            if (pred != FALSE) continue;
            return Predicates.false_();
        }
        return new And(others);
    }

    @SafeVarargs
    static <T> Predicate<T> or(Predicate<T> ... others) {
        if (others.length == 1) {
            return others[0];
        }
        for (Predicate<T> pred : others) {
            if (pred != TRUE) continue;
            return Predicates.true_();
        }
        return new Or<T>(others);
    }

    public static Predicate<com.redhat.ceylon.model.typechecker.model.Declaration> isDeclarationOfKind(TypeDescriptor kind) {
        if (kind instanceof TypeDescriptor.Class) {
            java.lang.Class<?> declarationClass = ((TypeDescriptor.Class)kind).getKlass();
            if (declarationClass == ValueDeclaration.class) {
                return DECLARATION_IS_VALUE;
            }
            if (declarationClass == FunctionDeclaration.class) {
                return DECLARATION_IS_FUNCTION;
            }
            if (declarationClass == FunctionOrValueDeclaration.class) {
                return DECLARATION_IS_FUNCTION_OR_VALUE;
            }
            if (declarationClass == ClassDeclaration.class) {
                return DECLARATION_IS_CLASS;
            }
            if (declarationClass == ClassWithInitializerDeclaration.class) {
                return DECLARATION_IS_CLASS_WITH_INIT;
            }
            if (declarationClass == ClassWithConstructorsDeclaration.class) {
                return DECLARATION_IS_CLASS_WITH_CTORS;
            }
            if (declarationClass == InterfaceDeclaration.class) {
                return DECLARATION_IS_INTERFACE;
            }
            if (declarationClass == ClassOrInterfaceDeclaration.class) {
                return DECLARATION_IS_CLASS_OR_INTERFACE;
            }
            if (declarationClass == AliasDeclaration.class) {
                return DECLARATION_IS_ALIAS;
            }
            if (declarationClass == ConstructorDeclaration.class) {
                return DECLARATION_IS_CONSTRUCTOR;
            }
            if (declarationClass == CallableConstructorDeclaration.class) {
                return DECLARATION_IS_CALLABLE_CONSTRUCTOR;
            }
            if (declarationClass == ValueConstructorDeclaration.class) {
                return DECLARATION_IS_VALUE_CONSTRUCTOR;
            }
            if (declarationClass == NestableDeclaration.class) {
                return Predicates.true_();
            }
            throw new EnumeratedTypeError("Supposedly exhaustive switch was not exhaustive");
        }
        if (kind instanceof TypeDescriptor.Union) {
            TypeDescriptor[] members = ((TypeDescriptor.Union)kind).getMembers();
            Predicate[] preds = new Predicate[members.length];
            int ii = 0;
            for (TypeDescriptor member : members) {
                preds[ii++] = Predicates.isDeclarationOfKind(member);
            }
            return Predicates.or(preds);
        }
        if (kind instanceof TypeDescriptor.Intersection) {
            TypeDescriptor[] members = ((TypeDescriptor.Intersection)kind).getMembers();
            Predicate[] preds = new Predicate[members.length];
            int ii = 0;
            for (TypeDescriptor member : members) {
                preds[ii++] = Predicates.isDeclarationOfKind(member);
            }
            return Predicates.and(preds);
        }
        if (kind == TypeDescriptor.NothingType) {
            return Predicates.false_();
        }
        throw new EnumeratedTypeError("Supposedly exhaustive switch was not exhaustive");
    }

    public static <Kind extends Declaration, A extends java.lang.annotation.Annotation> Predicate<com.redhat.ceylon.model.typechecker.model.Declaration> isDeclarationAnnotatedWith(TypeDescriptor annotation) {
        Type<?> at = Metamodel.getAppliedMetamodel(annotation);
        return Predicates.isDeclarationAnnotatedWith(annotation, at);
    }

    public static <A extends java.lang.annotation.Annotation> Predicate<com.redhat.ceylon.model.typechecker.model.Declaration> isDeclarationAnnotatedWith(TypeDescriptor annotation, Type<?> at) {
        if (at instanceof nothingType_) {
            return Predicates.false_();
        }
        if (at instanceof ClassOrInterface) {
            return new AnnotatedWith(annotation, (ClassOrInterface)at);
        }
        if (at instanceof UnionTypeImpl) {
            List caseTypes = ((UnionTypeImpl)at).getCaseTypes();
            return Predicates.or(Predicates.mapTypesToDeclarationAnnotatedWith(annotation, caseTypes));
        }
        if (at instanceof IntersectionTypeImpl) {
            List satisfiedTypes = ((IntersectionTypeImpl)at).getSatisfiedTypes();
            return Predicates.and(Predicates.mapTypesToDeclarationAnnotatedWith(annotation, satisfiedTypes));
        }
        throw new EnumeratedTypeError("Supposedly exhaustive switch was not exhaustive: " + at);
    }

    private static Predicate<com.redhat.ceylon.model.typechecker.model.Declaration>[] mapTypesToDeclarationAnnotatedWith(TypeDescriptor annotation, Sequential<? extends Type<?>> caseTypes) {
        Predicate[] preds = new Predicate[Util.toInt(caseTypes.getSize())];
        int ii = 0;
        Iterator iterator = caseTypes.iterator();
        Object element = iterator.next();
        while (element instanceof Type) {
            preds[ii++] = Predicates.isDeclarationAnnotatedWith(annotation, (Type)element);
            element = iterator.next();
        }
        return preds;
    }

    static <A extends java.lang.annotation.Annotation> Predicate<A> isAnnotationOfType(TypeDescriptor $reifiedAnnotation) {
        Type<?> at = Metamodel.getAppliedMetamodel($reifiedAnnotation);
        return Predicates.isAnnotationOfType($reifiedAnnotation, at);
    }

    private static <A extends java.lang.annotation.Annotation> Predicate<A> isAnnotationOfType(TypeDescriptor $reifiedAnnotation, Type<?> at) throws EnumeratedTypeError {
        if (at instanceof nothingType_) {
            return Predicates.false_();
        }
        if (at instanceof UnionTypeImpl) {
            List caseTypes = ((UnionTypeImpl)at).getCaseTypes();
            return Predicates.or(Predicates.mapTypesToIsAnnotationOfType($reifiedAnnotation, caseTypes));
        }
        if (at instanceof IntersectionTypeImpl) {
            List satisfiedTypes = ((IntersectionTypeImpl)at).getSatisfiedTypes();
            return Predicates.and(Predicates.mapTypesToIsAnnotationOfType($reifiedAnnotation, satisfiedTypes));
        }
        if (at instanceof ClassOrInterface) {
            AnnotationPredicate<A> predicate = Predicates.annotationPredicate($reifiedAnnotation, (ClassOrInterface)at);
            return predicate;
        }
        throw new EnumeratedTypeError("Supposedly exhaustive switch was not exhaustive: " + at);
    }

    private static <A extends java.lang.annotation.Annotation> Predicate<A>[] mapTypesToIsAnnotationOfType(TypeDescriptor $reifiedAnnotation, Sequential<? extends Type<?>> caseTypes) {
        Predicate[] preds = new Predicate[Util.toInt(caseTypes.getSize())];
        int ii = 0;
        Iterator iterator = caseTypes.iterator();
        Object element = iterator.next();
        while (element instanceof Type) {
            preds[ii++] = Predicates.isAnnotationOfType($reifiedAnnotation, (Type)element);
            element = iterator.next();
        }
        return preds;
    }

    private static <A extends java.lang.annotation.Annotation, Value extends java.lang.annotation.Annotation, Values, ProgramElement extends Annotated> AnnotationPredicate<A> annotationPredicate(final TypeDescriptor $reifiedValues, ClassOrInterface<? extends java.lang.annotation.Annotation> annotationType) {
        java.lang.Class<?> refAnnotationWrapperType;
        java.lang.Class<?> refAnnotationType;
        final java.lang.Class<?> refAnnotationClass = Metamodel.getReflectedAnnotationClass(annotationType);
        if (java.lang.annotation.Annotation.class == refAnnotationClass || Annotation.class == refAnnotationClass || ConstrainedAnnotation.class == refAnnotationClass || OptionalAnnotation.class == refAnnotationClass || SequencedAnnotation.class == refAnnotationClass) {
            return new AnnotationPredicate<A>(){

                @Override
                public boolean shouldInstantiate(java.lang.Class<? extends java.lang.annotation.Annotation> jAnnotationType) {
                    return true;
                }

                @Override
                public boolean accept(A cAnnotation) {
                    return Metamodel.isReified(cAnnotation, $reifiedValues);
                }
            };
        }
        if (refAnnotationClass.getAnnotation(Ceylon.class) == null) {
            refAnnotationType = refAnnotationClass;
            refAnnotationWrapperType = null;
        } else {
            java.lang.Class<?> c;
            try {
                refAnnotationType = java.lang.Class.forName(refAnnotationClass.getName() + "$annotation$", false, refAnnotationClass.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw Metamodel.newModelError("Class not found: " + refAnnotationClass.getName() + "$annotation$");
            }
            try {
                c = java.lang.Class.forName(refAnnotationClass.getName() + "$annotations$", false, refAnnotationClass.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                c = null;
            }
            refAnnotationWrapperType = c;
        }
        return new AnnotationPredicate<A>(){

            @Override
            public boolean shouldInstantiate(java.lang.Class<? extends java.lang.annotation.Annotation> jAnnotationType) {
                return refAnnotationType == null || refAnnotationType.isAssignableFrom(jAnnotationType) || refAnnotationWrapperType != null && refAnnotationWrapperType.isAssignableFrom(jAnnotationType);
            }

            @Override
            public boolean accept(A cAnnotation) {
                return refAnnotationClass.isInstance(cAnnotation);
            }
        };
    }

    static interface AnnotationPredicate<A extends java.lang.annotation.Annotation>
    extends Predicate<A> {
        public boolean shouldInstantiate(java.lang.Class<? extends java.lang.annotation.Annotation> var1);

        @Override
        public boolean accept(A var1);
    }

    private static class AnnotatedWith<A extends java.lang.annotation.Annotation>
    implements Predicate<com.redhat.ceylon.model.typechecker.model.Declaration> {
        private final TypeDescriptor annotation;
        private final ClassOrInterface<A> at;

        public AnnotatedWith(TypeDescriptor annotation, ClassOrInterface<A> at) {
            this.annotation = annotation;
            this.at = at;
        }

        @Override
        public boolean accept(com.redhat.ceylon.model.typechecker.model.Declaration memberModel) {
            AnnotatedDeclaration member = (AnnotatedDeclaration)Metamodel.getOrCreateMetamodel(memberModel);
            Sequential annotations = Metamodel.annotations(this.annotation, member);
            return !annotations.getEmpty();
        }

        public String toString() {
            return "(having-annotation " + this.at + ")";
        }
    }

    private static final class Or<T>
    implements Predicate<T> {
        private final Predicate<T>[] others;

        public Or(Predicate<T>[] others) {
            this.others = others;
        }

        @Override
        public boolean accept(T candidate) {
            for (Predicate<T> other : this.others) {
                if (!other.accept(candidate)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return "(or " + Arrays.toString(this.others) + ")";
        }
    }

    private static final class And<T>
    implements Predicate<T> {
        private final Predicate<T>[] others;

        private And(Predicate<T>[] others) {
            this.others = others;
        }

        @Override
        public boolean accept(T candidate) {
            for (Predicate<T> other : this.others) {
                if (other.accept(candidate)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return "(and " + Arrays.toString(this.others) + ")";
        }
    }

    private static final class NamePredicate
    implements Predicate<com.redhat.ceylon.model.typechecker.model.Declaration> {
        private String name;

        NamePredicate(String name) {
            this.name = name;
        }

        @Override
        public boolean accept(com.redhat.ceylon.model.typechecker.model.Declaration candidate) {
            return candidate.getName().equals(this.name);
        }
    }

    public static interface Predicate<T> {
        public boolean accept(T var1);
    }
}

