/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.runtime.metamodel;

import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.runtime.metamodel.Metamodel;
import com.redhat.ceylon.model.loader.NamingBase;
import com.redhat.ceylon.model.typechecker.model.ClassAlias;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;

public class Reflection {
    private Reflection() {
    }

    static Method getDeclaredMethod(Class<?> cls, String name, Class<?> ... parameterTypes) {
        for (Method method : cls.getDeclaredMethods()) {
            if (!method.getName().equals(name) || method.isSynthetic() || method.isBridge() || !Arrays.equals(method.getParameterTypes(), parameterTypes)) continue;
            method.setAccessible(true);
            return method;
        }
        return null;
    }

    public static Method getDeclaredSetter(Class<?> cls, String setterName) {
        for (Method method : cls.getDeclaredMethods()) {
            if (!method.getName().equals(setterName) || method.isSynthetic() || method.isBridge() || method.getReturnType() != Void.TYPE || method.getParameterTypes().length != 1) continue;
            method.setAccessible(true);
            return method;
        }
        return null;
    }

    public static Method getDeclaredGetter(Class<?> cls, String getterName) {
        for (Method method : cls.getDeclaredMethods()) {
            if (!method.getName().equals(getterName) || method.isSynthetic() || method.isBridge() || method.getReturnType() == Void.TYPE || method.getParameterTypes().length != 0) continue;
            method.setAccessible(true);
            return method;
        }
        return null;
    }

    public static Field getDeclaredField(Class<?> cls, String fieldName) {
        for (Field field : cls.getDeclaredFields()) {
            if (!field.getName().equals(fieldName) || field.isSynthetic()) continue;
            field.setAccessible(true);
            return field;
        }
        return null;
    }

    public static Method findClassAliasInstantiator(Class<?> javaClass, ClassAlias container) {
        Class<?> searchClass = javaClass.getEnclosingClass() != null ? javaClass.getEnclosingClass() : javaClass;
        String aliasName = NamingBase.getAliasInstantiatorMethodName(container);
        for (Method method : searchClass.getDeclaredMethods()) {
            if (!method.getName().equals(aliasName)) continue;
            return method;
        }
        return null;
    }

    public static Constructor<?> findConstructor(Class<?> javaClass) {
        Constructor<?> best = null;
        int numBestParams = -1;
        int numBest = 0;
        for (Constructor<?> meth : javaClass.getDeclaredConstructors()) {
            if (meth.isSynthetic() || meth.getAnnotation(Ignore.class) != null) continue;
            Class<?>[] parameterTypes = meth.getParameterTypes();
            if (parameterTypes.length > numBestParams) {
                best = meth;
                numBestParams = parameterTypes.length;
                numBest = 1;
                continue;
            }
            if (parameterTypes.length != numBestParams) continue;
            ++numBest;
        }
        if (best == null) {
            throw Metamodel.newModelError("Couldn't find method " + javaClass);
        }
        if (numBest > 1) {
            throw Metamodel.newModelError("Method arity ambiguity " + javaClass);
        }
        return best;
    }
}

