/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.runtime.metamodel.decl;

import ceylon.language.Exception;
import ceylon.language.Resource;
import ceylon.language.Sequential;
import ceylon.language.String;
import ceylon.language.meta.declaration.Import;
import com.redhat.ceylon.compiler.java.Util;
import com.redhat.ceylon.compiler.java.language.ByteArrayResource;
import com.redhat.ceylon.compiler.java.language.FileResource;
import com.redhat.ceylon.compiler.java.language.ObjectArrayIterable;
import com.redhat.ceylon.compiler.java.language.ZipResource;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.metadata.TypeParameter;
import com.redhat.ceylon.compiler.java.metadata.TypeParameters;
import com.redhat.ceylon.compiler.java.runtime.metamodel.AnnotationBearing;
import com.redhat.ceylon.compiler.java.runtime.metamodel.Metamodel;
import com.redhat.ceylon.compiler.java.runtime.metamodel.decl.ImportImpl;
import com.redhat.ceylon.compiler.java.runtime.model.ReifiedType;
import com.redhat.ceylon.compiler.java.runtime.model.RuntimeModelLoader;
import com.redhat.ceylon.compiler.java.runtime.model.RuntimeModuleManager;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.ModuleImport;
import com.redhat.ceylon.model.typechecker.model.Package;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ModuleImpl
implements ceylon.language.meta.declaration.Module,
AnnotationBearing,
ReifiedType {
    @Ignore
    public static final TypeDescriptor $TypeDescriptor$ = TypeDescriptor.klass(ModuleImpl.class, new TypeDescriptor[0]);
    private static final Annotation[] NO_ANNOTATION = new Annotation[0];
    protected Module declaration;
    private Sequential<? extends ceylon.language.meta.declaration.Package> packages;
    private Sequential<? extends Import> dependencies;

    public ModuleImpl(Module declaration) {
        this.declaration = declaration;
    }

    @Override
    @Ignore
    public Annotation[] $getJavaAnnotations$() {
        if (this.declaration.isDefault() || this.declaration.isJava()) {
            return NO_ANNOTATION;
        }
        return Metamodel.getJavaClass(this.declaration).getAnnotations();
    }

    @Override
    @Ignore
    public boolean $isAnnotated$(Class<? extends Annotation> annotationType) {
        if (this.declaration.isDefault() || this.declaration.isJava()) {
            return false;
        }
        Class<?> element = Metamodel.getJavaClass(this.declaration);
        return element != null ? element.isAnnotationPresent(annotationType) : false;
    }

    @Override
    public <AnnotationType extends Annotation> boolean annotated(TypeDescriptor reifed$AnnotationType) {
        return Metamodel.isAnnotated(reifed$AnnotationType, this);
    }

    @Override
    @TypeInfo(value="ceylon.language::Sequential<Annotation>")
    @TypeParameters(value={@TypeParameter(value="Annotation", satisfies={"ceylon.language::Annotation"})})
    public <Annotation extends Annotation> Sequential<? extends Annotation> annotations(@Ignore TypeDescriptor $reifiedAnnotation) {
        return Metamodel.annotations($reifiedAnnotation, this);
    }

    @Override
    @TypeInfo(value="ceylon.language::Sequential<ceylon.language.meta.declaration::Package>")
    public Sequential<? extends ceylon.language.meta.declaration.Package> getMembers() {
        if (this.packages == null) {
            List<Package> modelPackages = this.declaration.getPackages();
            ceylon.language.meta.declaration.Package[] packages = new ceylon.language.meta.declaration.Package[modelPackages.size()];
            for (int i = 0; i < packages.length; ++i) {
                packages[i] = Metamodel.getOrCreateMetamodel(modelPackages.get(i));
            }
            this.packages = Util.sequentialWrapper(ceylon.language.meta.declaration.Package.$TypeDescriptor$, packages);
        }
        return this.packages;
    }

    @Override
    @TypeInfo(value="ceylon.language::Null|ceylon.language.meta.declaration::Package")
    public ceylon.language.meta.declaration.Package findPackage(@Name(value="name") java.lang.String name) {
        Package pkg = this.declaration.getDirectPackage(name);
        return pkg == null ? null : Metamodel.getOrCreateMetamodel(pkg);
    }

    @Override
    @TypeInfo(value="ceylon.language::Null|ceylon.language.meta.declaration::Package")
    public ceylon.language.meta.declaration.Package findImportedPackage(@Name(value="name") java.lang.String name) {
        Package pkg = this.declaration.getPackage(name);
        return pkg == null ? null : Metamodel.getOrCreateMetamodel(pkg);
    }

    @Override
    @TypeInfo(value="ceylon.language::Sequential<ceylon.language.meta.declaration::Import>")
    public Sequential<? extends Import> getDependencies() {
        if (this.dependencies == null) {
            List<ModuleImport> modelImports = this.declaration.getImports();
            ArrayList<ImportImpl> sb = new ArrayList<ImportImpl>(modelImports.size());
            for (ModuleImport moduleImport : modelImports) {
                sb.add(new ImportImpl(this, moduleImport));
            }
            Object[] array = sb.toArray(new ImportImpl[0]);
            this.dependencies = new ObjectArrayIterable(Import.$TypeDescriptor$, array).sequence();
        }
        return this.dependencies;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @TypeInfo(value="ceylon.language::Resource")
    public Resource resourceByPath(@Name(value="path") java.lang.String path) {
        byte[] contents;
        RuntimeModelLoader modelLoader;
        java.lang.String fullPath = path;
        if (!fullPath.startsWith("/")) {
            java.lang.String modPath = "default".equals(this.getName()) ? "" : this.getName().replace('.', '/') + "/";
            fullPath = modPath + path;
        } else {
            fullPath = fullPath.substring(1);
        }
        RuntimeModuleManager moduleManager = Metamodel.getModuleManager();
        if (moduleManager != null && (modelLoader = moduleManager.getModelLoader()) != null && (contents = modelLoader.getContents(this.declaration, fullPath)) != null) {
            URI uri = modelLoader.getContentUri(this.declaration, fullPath);
            return new ByteArrayResource(contents, uri);
        }
        java.lang.String moduleUnitFullPath = this.declaration.getUnit().getFullPath();
        if (moduleUnitFullPath == null) return null;
        File car = new File(moduleUnitFullPath);
        try (ZipFile zip = new ZipFile(car);){
            ZipEntry e = zip.getEntry(fullPath);
            if (e != null && !e.isDirectory()) {
                ZipResource zipResource = new ZipResource(car, fullPath);
                return zipResource;
            }
        }
        catch (IOException ex) {
            throw new Exception(new String("Searching for resource " + path), (Throwable)ex);
        }
        File target = new File(new File(car.getParentFile(), "module-resources"), fullPath);
        if (!target.exists()) return null;
        if (!target.isFile()) return null;
        if (!target.canRead()) return null;
        return new FileResource(target);
    }

    @Override
    @TypeInfo(value="ceylon.language::String")
    public java.lang.String getName() {
        return this.declaration.getNameAsString();
    }

    @Override
    public java.lang.String getQualifiedName() {
        return this.getName();
    }

    @Override
    @TypeInfo(value="ceylon.language::String")
    public java.lang.String getVersion() {
        return this.declaration.getVersion();
    }

    public int hashCode() {
        int result = 1;
        result = 37 * result + this.getName().hashCode();
        java.lang.String version2 = this.getVersion();
        result = 37 * result + (version2 == null ? 0 : version2.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ceylon.language.meta.declaration.Module)) {
            return false;
        }
        ceylon.language.meta.declaration.Module other = (ceylon.language.meta.declaration.Module)obj;
        if (!Util.eq(other.getVersion(), this.getVersion())) {
            return false;
        }
        return this.getName().equals(other.getName());
    }

    public java.lang.String toString() {
        return "module " + this.getName() + "/" + this.getVersion();
    }

    @Override
    @Ignore
    public TypeDescriptor $getType$() {
        return $TypeDescriptor$;
    }
}

