/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.runtime.metamodel.decl;

import ceylon.language.Anything;
import ceylon.language.meta.declaration.ClassDeclaration;
import ceylon.language.meta.declaration.OpenClassType;
import ceylon.language.meta.declaration.OpenType;
import ceylon.language.meta.declaration.SetterDeclaration;
import ceylon.language.meta.declaration.ValueDeclaration;
import ceylon.language.meta.declaration.ValueDeclaration$impl;
import ceylon.language.meta.model.Attribute;
import ceylon.language.meta.model.Type;
import ceylon.language.meta.model.TypeApplicationException;
import ceylon.language.meta.model.Value;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Class;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.metadata.TypeParameter;
import com.redhat.ceylon.compiler.java.metadata.TypeParameters;
import com.redhat.ceylon.compiler.java.metadata.Variance;
import com.redhat.ceylon.compiler.java.runtime.metamodel.AnnotationBearing;
import com.redhat.ceylon.compiler.java.runtime.metamodel.Metamodel;
import com.redhat.ceylon.compiler.java.runtime.metamodel.Reflection;
import com.redhat.ceylon.compiler.java.runtime.metamodel.decl.FunctionOrValueDeclarationImpl;
import com.redhat.ceylon.compiler.java.runtime.metamodel.decl.SetterDeclarationImpl;
import com.redhat.ceylon.compiler.java.runtime.metamodel.meta.AttributeImpl;
import com.redhat.ceylon.compiler.java.runtime.metamodel.meta.ValueImpl;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;
import com.redhat.ceylon.model.loader.NamingBase;
import com.redhat.ceylon.model.typechecker.model.ClassAlias;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.Functional;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Setter;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypedReference;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@Ceylon(major=8)
@Class
public class ValueDeclarationImpl
extends FunctionOrValueDeclarationImpl
implements ValueDeclaration,
AnnotationBearing {
    @Ignore
    public static final TypeDescriptor $TypeDescriptor$ = TypeDescriptor.klass(ValueDeclarationImpl.class, new TypeDescriptor[0]);
    private OpenType type;
    private SetterDeclarationImpl setter;

    public ValueDeclarationImpl(com.redhat.ceylon.model.typechecker.model.Value declaration) {
        super(declaration);
        this.type = Metamodel.getMetamodel(declaration.getType());
    }

    @Override
    @Ignore
    public ValueDeclaration$impl $ceylon$language$meta$declaration$ValueDeclaration$impl() {
        return null;
    }

    @Override
    public boolean getLate() {
        return ((TypedDeclaration)this.declaration).isLate();
    }

    @Override
    public boolean getVariable() {
        return ((TypedDeclaration)this.declaration).isVariable();
    }

    @Override
    public boolean getObjectValue() {
        return this.type instanceof OpenClassType && ((OpenClassType)this.type).getDeclaration().getAnonymous();
    }

    @Override
    @TypeInfo(value="ceylon.language.meta.declaration::ClassDeclaration|ceylon.language::Null")
    public ClassDeclaration getObjectClass() {
        OpenClassType decl;
        if (this.type instanceof OpenClassType && (decl = (OpenClassType)this.type).getDeclaration().getAnonymous()) {
            return decl.getDeclaration();
        }
        return null;
    }

    @TypeInfo(value="ceylon.language.meta.model::Value<Get,Set>", erased=true)
    @TypeParameters(value={@TypeParameter(value="Get"), @TypeParameter(value="Set", defaultValue="ceylon.language::Nothing")})
    public <Get, Set> Value<Get, Set> apply(@Ignore TypeDescriptor $reifiedGet, @Ignore TypeDescriptor $reifiedSet) {
        if (!this.getToplevel()) {
            throw new TypeApplicationException("Cannot apply a member declaration with no container type: use memberApply");
        }
        com.redhat.ceylon.model.typechecker.model.Value modelDecl = (com.redhat.ceylon.model.typechecker.model.Value)this.declaration;
        TypedReference typedReference = modelDecl.appliedTypedReference(null, Collections.emptyList());
        com.redhat.ceylon.model.typechecker.model.Type getType = typedReference.getType();
        TypeDescriptor reifiedGet = Metamodel.getTypeDescriptorForProducedType(getType);
        com.redhat.ceylon.model.typechecker.model.Type setType = this.getVariable() ? getType : modelDecl.getUnit().getNothingType();
        TypeDescriptor reifiedSet = this.getVariable() ? reifiedGet : TypeDescriptor.NothingType;
        Metamodel.checkReifiedTypeArgument("apply", "Value<$1,$2>", Variance.OUT, getType, $reifiedGet, Variance.IN, setType, $reifiedSet);
        return new ValueImpl(reifiedGet, reifiedSet, this, typedReference, null, null);
    }

    @TypeInfo(value="ceylon.language.meta.model::Attribute<Container,Get,Set>")
    @TypeParameters(value={@TypeParameter(value="Container"), @TypeParameter(value="Get"), @TypeParameter(value="Set", defaultValue="ceylon.language::Nothing")})
    public <Container, Get, Set> Attribute<Container, Get, Set> memberApply(@Ignore TypeDescriptor $reifiedContainer, @Ignore TypeDescriptor $reifiedGet, @Ignore TypeDescriptor $reifiedSet, @Name(value="containerType") Type<? extends Object> containerType) {
        if (this.getToplevel()) {
            throw new TypeApplicationException("Cannot apply a toplevel declaration to a container type: use apply");
        }
        com.redhat.ceylon.model.typechecker.model.Type qualifyingType = Metamodel.getModel(containerType);
        Metamodel.checkQualifyingType(qualifyingType, this.declaration);
        com.redhat.ceylon.model.typechecker.model.Value modelDecl = (com.redhat.ceylon.model.typechecker.model.Value)this.declaration;
        com.redhat.ceylon.model.typechecker.model.Type memberQualifyingType = qualifyingType.getSupertype((TypeDeclaration)modelDecl.getContainer());
        TypedReference typedReference = modelDecl.appliedTypedReference(memberQualifyingType, Collections.emptyList());
        TypeDescriptor reifiedContainer = Metamodel.getTypeDescriptorForProducedType(qualifyingType);
        com.redhat.ceylon.model.typechecker.model.Type getType = typedReference.getType();
        TypeDescriptor reifiedGet = Metamodel.getTypeDescriptorForProducedType(getType);
        com.redhat.ceylon.model.typechecker.model.Type setType = this.getVariable() ? getType : modelDecl.getUnit().getNothingType();
        TypeDescriptor reifiedSet = this.getVariable() ? reifiedGet : TypeDescriptor.NothingType;
        Metamodel.checkReifiedTypeArgument("memberApply", "Attribute<$1,$2,$3>", Variance.IN, memberQualifyingType, $reifiedContainer, Variance.OUT, getType, $reifiedGet, Variance.IN, setType, $reifiedSet);
        return new AttributeImpl(reifiedContainer, reifiedGet, reifiedSet, this, typedReference, containerType);
    }

    @Override
    @TypeInfo(value="ceylon.language.meta.declaration::OpenType")
    public OpenType getOpenType() {
        return this.type;
    }

    @Override
    @TypeInfo(value="ceylon.language::Anything")
    public Object get() {
        return this.apply(Anything.$TypeDescriptor$, TypeDescriptor.NothingType).get();
    }

    @Override
    @TypeInfo(value="ceylon.language::Anything")
    public Object memberGet(@Name(value="container") @TypeInfo(value="ceylon.language::Object") Object container) {
        Type<?> containerType = Metamodel.getAppliedMetamodel(Metamodel.getTypeDescriptor(container));
        return this.memberApply(TypeDescriptor.NothingType, Anything.$TypeDescriptor$, TypeDescriptor.NothingType, containerType).bind(container).get();
    }

    public int hashCode() {
        return Metamodel.hashCode(this, "value");
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ValueDeclarationImpl)) {
            return false;
        }
        return Metamodel.equalsForSameType(this, (ValueDeclarationImpl)obj);
    }

    @Override
    @TypeInfo(value="ceylon.language::Anything")
    public Object set(@TypeInfo(value="ceylon.language::Anything") @Name(value="newValue") Object newValue) {
        return this.apply(Anything.$TypeDescriptor$, TypeDescriptor.NothingType).$setIfAssignable(newValue);
    }

    @Override
    @TypeInfo(value="ceylon.language::Anything")
    public Object memberSet(@Name(value="container") @TypeInfo(value="ceylon.language::Object") Object container, @TypeInfo(value="ceylon.language::Anything") @Name(value="newValue") Object newValue) {
        Type<?> containerType = Metamodel.getAppliedMetamodel(Metamodel.getTypeDescriptor(container));
        return this.memberApply(TypeDescriptor.NothingType, Anything.$TypeDescriptor$, TypeDescriptor.NothingType, containerType).bind(container).$setIfAssignable(newValue);
    }

    @Override
    public String toString() {
        return "value " + super.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TypeInfo(value="ceylon.language.meta.declaration::SetterDeclaration|ceylon.language::Null")
    public SetterDeclaration getSetter() {
        if (this.setter == null && ((com.redhat.ceylon.model.typechecker.model.Value)this.declaration).getSetter() != null) {
            Object object = Metamodel.getLock();
            synchronized (object) {
                Setter setterModel;
                if (this.setter == null && (setterModel = ((com.redhat.ceylon.model.typechecker.model.Value)this.declaration).getSetter()) != null) {
                    this.setter = (SetterDeclarationImpl)Metamodel.getOrCreateMetamodel(setterModel);
                }
            }
        }
        return this.setter;
    }

    @Override
    @Ignore
    public TypeDescriptor $getType$() {
        return $TypeDescriptor$;
    }

    @Override
    @Ignore
    public Annotation[] $getJavaAnnotations$() {
        java.lang.Class<?> javaClass = Metamodel.getJavaClass(this.declaration);
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        if (javaClass != null) {
            Method declaredGetter = Reflection.getDeclaredGetter(javaClass, NamingBase.getGetterName(this.declaration));
            if (declaredGetter != null) {
                result.addAll(Arrays.asList(declaredGetter.getAnnotations()));
            }
            if (!((com.redhat.ceylon.model.typechecker.model.Value)this.declaration).isTransient()) {
                Method setter;
                Field field = Reflection.getDeclaredField(javaClass, this.declaration.getName());
                if (field != null) {
                    Annotation[] fieldAnnos = field.getAnnotations();
                    result.addAll(Arrays.asList(fieldAnnos));
                }
                if ((setter = Reflection.getDeclaredSetter(javaClass, NamingBase.getSetterName(this.declaration.getName()))) != null) {
                    Annotation[] setterAnnos = setter.getAnnotations();
                    result.addAll(Arrays.asList(setterAnnos));
                }
            }
        }
        if (this.parameter != null && !this.parameter.getModel().isShared()) {
            Annotation[][] parameterAnnotations;
            Scope container = this.parameter.getModel().getContainer();
            if (container instanceof Function) {
                parameterAnnotations = Metamodel.getJavaMethod((Function)container).getParameterAnnotations();
            } else if (container instanceof ClassAlias) {
                parameterAnnotations = Reflection.findClassAliasInstantiator(Metamodel.getJavaClass((com.redhat.ceylon.model.typechecker.model.Class)container), (ClassAlias)container).getParameterAnnotations();
            } else if (container instanceof com.redhat.ceylon.model.typechecker.model.Class) {
                parameterAnnotations = Reflection.findConstructor(Metamodel.getJavaClass((com.redhat.ceylon.model.typechecker.model.Class)container)).getParameterAnnotations();
            } else {
                throw Metamodel.newModelError("Unsupported parameter container");
            }
            List<Parameter> parameters = ((Functional)((Object)container)).getFirstParameterList().getParameters();
            int index = parameters.indexOf(this.parameter);
            if (index == -1) {
                throw Metamodel.newModelError("Parameter " + this.parameter + " not found in container " + this.parameter.getModel().getContainer());
            }
            if (index >= parameterAnnotations.length) {
                throw Metamodel.newModelError("Parameter " + this.parameter + " index is greater than JVM parameters for " + this.parameter.getModel().getContainer());
            }
            result.addAll(Arrays.asList(parameterAnnotations[index]));
        }
        return result.toArray(new Annotation[result.size()]);
    }

    @Override
    @Ignore
    public boolean $isAnnotated$(java.lang.Class<? extends Annotation> annotationType) {
        Method declaredGetter;
        java.lang.Class<?> javaClass = Metamodel.getJavaClass(this.declaration);
        if (javaClass != null && (declaredGetter = Reflection.getDeclaredGetter(javaClass, NamingBase.getGetterName(this.declaration))) != null) {
            return declaredGetter.isAnnotationPresent(annotationType);
        }
        if (this.parameter != null && !this.parameter.getModel().isShared()) {
            for (Annotation a : this.$getJavaAnnotations$()) {
                if (!a.annotationType().equals(annotationType)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public <AnnotationType extends Annotation> boolean annotated(TypeDescriptor reifed$AnnotationType) {
        return Metamodel.isAnnotated(reifed$AnnotationType, this);
    }
}

