/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.runtime.model;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.Overrides;
import com.redhat.ceylon.compiler.java.runtime.model.RuntimeResolver;
import org.jboss.modules.ModuleIdentifier;

public class OverridesRuntimeResolver
implements RuntimeResolver {
    private static final ThreadLocal<RuntimeResolver> tl = new ThreadLocal();
    private Overrides overrides;

    public OverridesRuntimeResolver(Overrides overrides) {
        this.overrides = overrides;
    }

    protected ModuleIdentifier findOverride(ModuleIdentifier mi) {
        ArtifactContext context = new ArtifactContext(mi.getName(), mi.getSlot(), ".car", ".jar");
        ArtifactContext override = this.overrides.applyOverrides(context);
        return ModuleIdentifier.create(override.getName(), override.getVersion());
    }

    @Override
    public String resolveVersion(String moduleName, String moduleVersion) {
        if ("default".equals(moduleName)) {
            return null;
        }
        return this.findOverride(ModuleIdentifier.create(moduleName, moduleVersion)).getSlot();
    }

    public void installInThreadLocal() {
        tl.set(this);
    }

    public static RuntimeResolver getFromThreadLocal() {
        return tl.get();
    }
}

