/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.runtime.model;

import com.redhat.ceylon.common.runtime.CeylonModuleClassLoader;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.cmr.JDKUtils;
import com.redhat.ceylon.model.loader.LoaderJULLogger;
import com.redhat.ceylon.model.loader.ModelResolutionException;
import com.redhat.ceylon.model.loader.impl.reflect.CachedTOCJars;
import com.redhat.ceylon.model.loader.impl.reflect.ReflectionModelLoader;
import com.redhat.ceylon.model.loader.impl.reflect.mirror.ReflectionClass;
import com.redhat.ceylon.model.loader.impl.reflect.mirror.ReflectionUtils;
import com.redhat.ceylon.model.loader.mirror.ClassMirror;
import com.redhat.ceylon.model.loader.mirror.MethodMirror;
import com.redhat.ceylon.model.loader.model.AnnotationProxyClass;
import com.redhat.ceylon.model.loader.model.AnnotationProxyMethod;
import com.redhat.ceylon.model.loader.model.LazyFunction;
import com.redhat.ceylon.model.loader.model.LazyModule;
import com.redhat.ceylon.model.loader.model.LazyPackage;
import com.redhat.ceylon.model.typechecker.model.Modules;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.Unit;
import com.redhat.ceylon.model.typechecker.model.UnknownType;
import com.redhat.ceylon.model.typechecker.util.ModuleManager;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;

public class RuntimeModelLoader
extends ReflectionModelLoader {
    public static final int MAX_JBOSS_MODULES_WAITS = 4;
    public static final int JBOSS_MODULES_TIMEOUT = 5000;
    private Map<com.redhat.ceylon.model.typechecker.model.Module, ClassLoader> classLoaders = new HashMap<com.redhat.ceylon.model.typechecker.model.Module, ClassLoader>();
    private Map<String, com.redhat.ceylon.model.typechecker.model.Module> moduleCache = new HashMap<String, com.redhat.ceylon.model.typechecker.model.Module>();
    private CachedTOCJars jars = new CachedTOCJars();

    public RuntimeModelLoader(ModuleManager moduleManager, Modules modules) {
        super(moduleManager, modules, new LoaderJULLogger());
    }

    @Override
    public void loadStandardModules() {
        com.redhat.ceylon.model.typechecker.model.Module languageModule = this.findOrCreateModule("ceylon.language", null);
        this.addModuleToClassPath(languageModule, null);
        LazyPackage languagePackage = this.findOrCreatePackage(languageModule, "ceylon.language");
        this.typeFactory.setPackage(languagePackage);
        for (String jdkModule : JDKUtils.getJDKModuleNames()) {
            this.findOrCreateModule(jdkModule, JDKUtils.jdk.version);
        }
        for (String jdkOracleModule : JDKUtils.getOracleJDKModuleNames()) {
            this.findOrCreateModule(jdkOracleModule, JDKUtils.jdk.version);
        }
    }

    @Override
    protected List<String> getPackageList(com.redhat.ceylon.model.typechecker.model.Module module, String packageName) {
        return this.jars.getPackageList(module, packageName);
    }

    @Override
    protected boolean packageExists(com.redhat.ceylon.model.typechecker.model.Module module, String packageName) {
        return this.jars.packageExists(module, packageName);
    }

    public byte[] getContents(String path) {
        return this.jars.getContents(path);
    }

    public URI getContentUri(String path) {
        return this.jars.getContentUri(path);
    }

    public byte[] getContents(com.redhat.ceylon.model.typechecker.model.Module module, String path) {
        return this.jars.getContents(module, path);
    }

    public URI getContentUri(com.redhat.ceylon.model.typechecker.model.Module module, String path) {
        return this.jars.getContentUri(module, path);
    }

    @Override
    protected Class<?> loadClass(com.redhat.ceylon.model.typechecker.model.Module module, String name) {
        ClassLoader classLoader = this.classLoaders.get(module);
        if (classLoader == null) {
            if (JDKUtils.isJDKModule(module.getNameAsString()) || JDKUtils.isOracleJDKModule(module.getNameAsString())) {
                try {
                    return ClassLoader.getSystemClassLoader().loadClass(name);
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            }
            return null;
        }
        try {
            return classLoader.loadClass(name);
        }
        catch (ClassNotFoundException | NoClassDefFoundError x) {
            return null;
        }
    }

    @Override
    public void addModuleToClassPath(final com.redhat.ceylon.model.typechecker.model.Module module, ArtifactResult artifact) {
        String cacheKey = this.cacheKeyByModule(module.getNameAsString(), module.getVersion());
        this.moduleCache.put(cacheKey, module);
        if (artifact == null) {
            return;
        }
        this.jars.addJar(artifact, module);
        if (module instanceof LazyModule) {
            ((LazyModule)module).setPackagePathsProvider(new LazyModule.PackagePathsProvider(){

                @Override
                public Set<String> getPackagePaths() {
                    return RuntimeModelLoader.this.jars.getPackagePaths(module);
                }
            });
        }
    }

    public void addModuleClassLoader(com.redhat.ceylon.model.typechecker.model.Module module, ClassLoader classLoader) {
        this.classLoaders.put(module, classLoader);
    }

    @Override
    public com.redhat.ceylon.model.typechecker.model.Module findModuleForClassMirror(ClassMirror classMirror) {
        Class<?> klass = ((ReflectionClass)classMirror).klass;
        com.redhat.ceylon.model.typechecker.model.Module ret = this.findModuleForClass(klass);
        if (ret == null) {
            throw new ModelResolutionException("Could not find module for class " + klass);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public com.redhat.ceylon.model.typechecker.model.Module findModuleForClass(Class<?> klass) {
        ClassLoader cl = klass.getClassLoader();
        if (cl instanceof ModuleClassLoader) {
            String version2;
            ModuleClassLoader classLoader = (ModuleClassLoader)cl;
            Module jbossModule = classLoader.getModule();
            String name = jbossModule.getIdentifier().getName();
            String cacheKey = this.cacheKeyByModule(name, version2 = jbossModule.getIdentifier().getSlot());
            com.redhat.ceylon.model.typechecker.model.Module ret = this.moduleCache.get(cacheKey);
            if (ret == null) {
                Object lock;
                if (cl instanceof CeylonModuleClassLoader) {
                    ((CeylonModuleClassLoader)((Object)cl)).registerInMetaModel();
                }
                Object object = lock = this.getLock();
                synchronized (object) {
                    int tries = 4;
                    while (!this.classLoaders.containsValue(cl)) {
                        try {
                            lock.wait(5000L);
                        }
                        catch (InterruptedException e) {
                            throw new ModelResolutionException(e);
                        }
                        if (tries-- >= 0) continue;
                        throw new ModelResolutionException("Failed to find registered classloader for " + klass);
                    }
                    ret = this.moduleCache.get(cacheKey);
                }
            }
            return ret;
        }
        String pkgName = ReflectionUtils.getPackageName(klass);
        String jdkModuleName = JDKUtils.getJDKModuleNameForPackage(pkgName);
        if (jdkModuleName != null) {
            return this.findModule(jdkModuleName, JDKUtils.jdk.version);
        }
        return this.lookupModuleByPackageName(pkgName);
    }

    @Override
    protected String cacheKeyByModule(com.redhat.ceylon.model.typechecker.model.Module module, String name) {
        if (module == null) {
            throw new NullPointerException("No module found for " + name);
        }
        return super.cacheKeyByModule(module, name);
    }

    private String cacheKeyByModule(String name, String version2) {
        if (name.equals("default")) {
            return name + "/";
        }
        return name + "/" + version2;
    }

    public Unit getUnit() {
        return this.typeFactory;
    }

    @Override
    protected UnknownType.ErrorReporter makeModelErrorReporter(com.redhat.ceylon.model.typechecker.model.Module module, String message) {
        return this.makeModelErrorReporter(message);
    }

    @Override
    protected UnknownType.ErrorReporter makeModelErrorReporter(final String message) {
        return new UnknownType.ErrorReporter(message){

            @Override
            public void reportError() {
                throw new ModelResolutionException(message);
            }
        };
    }

    @Override
    protected void setAnnotationConstructor(LazyFunction method, MethodMirror meth) {
    }

    @Override
    protected void makeInteropAnnotationConstructorInvocation(AnnotationProxyMethod ctor, AnnotationProxyClass klass, List<Parameter> ctorParams) {
    }
}

