/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.runtime.model;

import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.compiler.java.runtime.metamodel.Metamodel;
import com.redhat.ceylon.compiler.java.runtime.model.OverridesRuntimeResolver;
import com.redhat.ceylon.compiler.java.runtime.model.RuntimeModelLoader;
import com.redhat.ceylon.compiler.java.runtime.model.RuntimeResolver;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.loader.AbstractModelLoader;
import com.redhat.ceylon.model.loader.impl.reflect.model.ReflectionModule;
import com.redhat.ceylon.model.loader.impl.reflect.model.ReflectionModuleManager;
import com.redhat.ceylon.model.loader.model.LazyModule;
import com.redhat.ceylon.model.loader.model.LazyPackage;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.ModuleImport;
import com.redhat.ceylon.model.typechecker.model.Modules;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.Unit;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.modules.ConcurrentClassLoader;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;

public class RuntimeModuleManager
extends ReflectionModuleManager {
    private RuntimeResolver runtimeResolver;
    private final LinkedHashMap<TypeDescriptor, Type> typeCache = new LinkedHashMap<TypeDescriptor, Type>(100, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<TypeDescriptor, Type> eldest) {
            return this.size() > 100;
        }
    };
    private final LinkedHashMap<String, Boolean> isCache = new LinkedHashMap<String, Boolean>(100, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Boolean> eldest) {
            return this.size() > 100;
        }
    };

    public RuntimeModuleManager(RuntimeResolver runtimeResolver) {
        this.runtimeResolver = runtimeResolver;
    }

    @Override
    public boolean isModuleLoadedFromSource(String moduleName) {
        return false;
    }

    @Override
    protected AbstractModelLoader createModelLoader(Modules modules) {
        return new RuntimeModelLoader(this, modules);
    }

    @Override
    public Package createPackage(String pkgName, com.redhat.ceylon.model.typechecker.model.Module module) {
        LazyPackage pkg = new LazyPackage(this.getModelLoader());
        List<String> name = pkgName.isEmpty() ? Collections.emptyList() : RuntimeModuleManager.splitModuleName(pkgName);
        pkg.setName(name);
        if (module != null) {
            module.getPackages().add(pkg);
            pkg.setModule(module);
        }
        return pkg;
    }

    @Override
    protected com.redhat.ceylon.model.typechecker.model.Module createModule(List<String> moduleName, String version2) {
        ReflectionModule module = new ReflectionModule(this);
        module.setName(moduleName);
        module.setVersion(version2);
        if (module instanceof ReflectionModule) {
            this.setupIfJDKModule(module);
        }
        return module;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadModule(String name, String version2, ArtifactResult artifact, ClassLoader classLoader) {
        RuntimeModelLoader modelLoader = this.getModelLoader();
        Object object = modelLoader.getLock();
        synchronized (object) {
            com.redhat.ceylon.model.typechecker.model.Module module = this.getOrCreateModule(RuntimeModuleManager.splitModuleName(name), version2);
            if (module.isDefault() ? module.getUnit() != null : module.isAvailable()) {
                return false;
            }
            modelLoader.addModuleToClassPath(module, artifact);
            modelLoader.addModuleClassLoader(module, classLoader);
            module.setAvailable(true);
            Unit u = new Unit();
            u.setFilename(artifact.name());
            if (artifact.artifact() != null) {
                u.setFullPath(artifact.artifact().getAbsolutePath());
            }
            module.setUnit(u);
            if (!module.isDefault() && !modelLoader.loadCompiledModule(module)) {
                ((LazyModule)module).setJava(true);
                module.setNativeBackends(Backend.Java.asSet());
                for (ArtifactResult dep : artifact.dependencies()) {
                    com.redhat.ceylon.model.typechecker.model.Module dependency = this.getOrCreateModule(RuntimeModuleManager.splitModuleName(dep.name()), dep.version());
                    ModuleImport depImport = this.findImport(module, dependency);
                    if (depImport != null) continue;
                    ModuleImport moduleImport = new ModuleImport(dependency, false, false, Backend.Java);
                    module.addImport(moduleImport);
                }
            }
            return true;
        }
    }

    @Override
    public com.redhat.ceylon.model.typechecker.model.Module getOrCreateModule(List<String> moduleName, String version2) {
        version2 = this.runtimeVersion(ModelUtil.formatPath(moduleName), version2);
        return super.getOrCreateModule(moduleName, version2);
    }

    protected String runtimeVersion(String moduleName, String version2) {
        RuntimeResolver runtimeResolver = this.runtimeResolver;
        if (runtimeResolver == null) {
            runtimeResolver = OverridesRuntimeResolver.getFromThreadLocal();
        }
        if (runtimeResolver == null && Thread.currentThread().getContextClassLoader() instanceof ConcurrentClassLoader) {
            ModuleLoader contextModuleLoader;
            try {
                contextModuleLoader = Module.getContextModuleLoader();
            }
            catch (NullPointerException e) {
                contextModuleLoader = null;
            }
            if (contextModuleLoader instanceof RuntimeResolver) {
                runtimeResolver = (RuntimeResolver)((Object)contextModuleLoader);
            }
        }
        if (runtimeResolver != null) {
            version2 = runtimeResolver.resolveVersion(moduleName, version2);
        }
        return version2;
    }

    @Override
    public com.redhat.ceylon.model.typechecker.model.Module findLoadedModule(String moduleName, String searchedVersion) {
        return super.findLoadedModule(moduleName, this.runtimeVersion(moduleName, searchedVersion));
    }

    @Override
    public RuntimeModelLoader getModelLoader() {
        return (RuntimeModelLoader)super.getModelLoader();
    }

    public com.redhat.ceylon.model.typechecker.model.Module findModuleForClass(Class<?> klass) {
        return this.getModelLoader().findModuleForClass(klass);
    }

    public Type getCachedType(TypeDescriptor td) {
        Type pt = this.typeCache.get(td);
        if (pt == null) {
            pt = td.toType(this);
            this.typeCache.put(td, pt);
        }
        return pt;
    }

    public boolean cachedIs(Object o, TypeDescriptor type) {
        TypeDescriptor instanceType = Metamodel.getTypeDescriptor(o);
        String key = instanceType + "<:" + type;
        Boolean cachedResult = this.isCache.get(key);
        if (cachedResult != null) {
            return cachedResult;
        }
        if (instanceType == null) {
            return false;
        }
        Type pt1 = this.getCachedType(instanceType);
        Type pt2 = this.getCachedType(type);
        boolean result = pt1.isSubtypeOf(pt2);
        this.isCache.put(key, result);
        return result;
    }
}

