/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.runtime.tools.impl;

import ceylon.language.AssertionError;
import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.MavenVersionComparator;
import com.redhat.ceylon.cmr.api.Overrides;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.cmr.ceylon.CeylonUtils;
import com.redhat.ceylon.cmr.impl.FlatRepository;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.compiler.java.runtime.metamodel.Metamodel;
import com.redhat.ceylon.compiler.java.runtime.model.OverridesRuntimeResolver;
import com.redhat.ceylon.compiler.java.runtime.tools.ModuleLoader;
import com.redhat.ceylon.compiler.java.runtime.tools.ModuleNotFoundException;
import com.redhat.ceylon.compiler.java.runtime.tools.impl.ModuleGraph;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.cmr.ImportType;
import com.redhat.ceylon.model.cmr.JDKUtils;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public abstract class BaseModuleLoaderImpl
implements ModuleLoader {
    final RepositoryManager repositoryManager;
    final ClassLoader delegateClassLoader;
    private Map<String, ModuleLoaderContext> contexts = new HashMap<String, ModuleLoaderContext>();
    protected boolean verbose;

    public BaseModuleLoaderImpl() {
        this(null);
    }

    public void log(String string) {
        System.err.println("[CMR:DEBUG] " + string);
    }

    public BaseModuleLoaderImpl(ClassLoader delegateClassLoader) {
        this(CeylonUtils.repoManager().buildManager(), delegateClassLoader, false);
    }

    public BaseModuleLoaderImpl(RepositoryManager repositoryManager, ClassLoader delegateClassLoader, boolean verbose) {
        this.repositoryManager = repositoryManager == null ? CeylonUtils.repoManager().buildManager() : repositoryManager;
        this.delegateClassLoader = delegateClassLoader == null ? BaseModuleLoaderImpl.class.getClassLoader() : delegateClassLoader;
        this.verbose = verbose;
    }

    @Override
    public ClassLoader loadModule(String name, String version2) {
        if (this.contexts == null) {
            throw new AssertionError("Cannot get load module after cleanup is called");
        }
        String key = name;
        ModuleLoaderContext ctx = this.contexts.get(key);
        if (ctx == null) {
            ctx = this.createModuleLoaderContext(name, version2);
            this.contexts.put(key, ctx);
        }
        return ctx.moduleClassLoader;
    }

    abstract ModuleLoaderContext createModuleLoaderContext(String var1, String var2);

    public void cleanup() {
        if (this.contexts != null) {
            for (ModuleLoaderContext ctx : this.contexts.values()) {
                ctx.cleanup();
            }
            this.contexts = null;
        }
    }

    public URL[] getClassLoaderURLs(String module) {
        ModuleLoaderContext ctx = this.contexts.get(module);
        return ctx.getClassLoaderURLs();
    }

    abstract class ModuleLoaderContext {
        final String module;
        final String modver;
        final ModuleGraph moduleGraph = new ModuleGraph();
        ClassLoader moduleClassLoader;

        ModuleLoaderContext(String module, String version2) {
            this.module = module;
            this.modver = version2;
            this.initialise();
        }

        abstract void initialise();

        /*
         * Enabled aggressive block sorting
         */
        void loadModule(String name, String version2, boolean optional, boolean inCurrentClassLoader, ModuleGraph.Module dependent) throws IOException {
            ArtifactContext artifactContext = new ArtifactContext(name, version2, ".car", ".jar");
            Overrides overrides = BaseModuleLoaderImpl.this.repositoryManager.getOverrides();
            if (overrides != null) {
                if (overrides.isRemoved(artifactContext)) {
                    return;
                }
                ArtifactContext replacement = overrides.replace(artifactContext);
                if (replacement != null) {
                    artifactContext = replacement;
                    name = replacement.getName();
                    version2 = replacement.getVersion();
                }
                if (overrides.isVersionOverridden(artifactContext)) {
                    version2 = overrides.getVersionOverride(artifactContext);
                    artifactContext.setVersion(version2);
                }
            }
            if (JDKUtils.isJDKModule(name)) return;
            if (JDKUtils.isOracleJDKModule(name)) {
                return;
            }
            ModuleGraph.Module loadedModule = this.moduleGraph.findModule(name);
            if (loadedModule != null) {
                String loadedVersion = loadedModule.version;
                if (!Objects.equals(version2, loadedVersion)) {
                    if (MavenVersionComparator.compareVersions(version2, loadedModule.version) <= 0) {
                        this.addDependency(dependent, loadedModule);
                        return;
                    }
                    if (BaseModuleLoaderImpl.this.verbose) {
                        BaseModuleLoaderImpl.this.log("Replacing " + loadedModule + " with newer version " + version2);
                    }
                } else {
                    if (loadedModule.artifact != null) {
                        this.addDependency(dependent, loadedModule);
                        return;
                    }
                    if (!optional) {
                        throw new ModuleNotFoundException("Could not find module: " + ModuleUtil.makeModuleName(name, version2));
                    }
                    this.addDependency(dependent, loadedModule);
                    return;
                }
            }
            if (BaseModuleLoaderImpl.this.verbose) {
                BaseModuleLoaderImpl.this.log("Resolving " + name + "/" + version2);
            }
            ArtifactResult result = BaseModuleLoaderImpl.this.repositoryManager.getArtifactResult(artifactContext);
            if (!optional) {
                if (result == null) throw new ModuleNotFoundException("Could not find module: " + ModuleUtil.makeModuleName(name, version2));
                if (result.artifact() == null) throw new ModuleNotFoundException("Could not find module: " + ModuleUtil.makeModuleName(name, version2));
                if (!result.artifact().exists()) {
                    throw new ModuleNotFoundException("Could not find module: " + ModuleUtil.makeModuleName(name, version2));
                }
            }
            ModuleGraph.Module mod = dependent == null ? this.moduleGraph.addRoot(name, version2) : dependent.addDependency(name, version2);
            if (loadedModule != null) {
                loadedModule.replace(mod);
            }
            mod.artifact = result;
            if (result == null) return;
            if (inCurrentClassLoader || result.repository() instanceof FlatRepository) {
                mod.inCurrentClassLoader = true;
            }
            Iterator<ArtifactResult> i$ = result.dependencies().iterator();
            while (i$.hasNext()) {
                ArtifactResult dep = i$.next();
                if (mod.replaced) {
                    return;
                }
                this.loadModule(dep.name(), dep.version(), dep.importType() == ImportType.OPTIONAL, inCurrentClassLoader, mod);
            }
        }

        private void addDependency(ModuleGraph.Module from, ModuleGraph.Module to) {
            if (from != null) {
                from.addDependency(to);
            } else {
                this.moduleGraph.addRoot(to);
            }
        }

        protected void initialiseMetamodel() {
            Overrides overrides = BaseModuleLoaderImpl.this.repositoryManager.getOverrides();
            Metamodel.resetModuleManager(new OverridesRuntimeResolver(overrides));
            this.moduleGraph.visit(new ModuleGraph.Visitor(){

                @Override
                public void visit(ModuleGraph.Module module) {
                    ModuleLoaderContext.this.registerInMetamodel(module);
                }
            });
        }

        private void registerInMetamodel(ModuleGraph.Module module) {
            if (JDKUtils.isJDKModule(module.name) || JDKUtils.isOracleJDKModule(module.name)) {
                return;
            }
            ArtifactResult dependencyArtifact = module.artifact;
            if (dependencyArtifact != null) {
                ClassLoader dependencyClassLoader = module.inCurrentClassLoader ? BaseModuleLoaderImpl.this.delegateClassLoader : this.moduleClassLoader;
                this.registerInMetamodel(dependencyArtifact, dependencyClassLoader);
            }
        }

        private void registerInMetamodel(ArtifactResult artifact, ClassLoader classLoader) {
            if (BaseModuleLoaderImpl.this.verbose) {
                BaseModuleLoaderImpl.this.log("Registering " + artifact.name() + "/" + artifact.version() + " in metamodel");
            }
            Metamodel.loadModule(artifact.name(), artifact.version(), artifact, classLoader);
        }

        public void cleanup() {
            if (this.moduleClassLoader != BaseModuleLoaderImpl.this.delegateClassLoader && this.moduleClassLoader instanceof URLClassLoader) {
                try {
                    ((URLClassLoader)this.moduleClassLoader).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.moduleGraph.clear();
            this.moduleClassLoader = null;
        }

        public URL[] getClassLoaderURLs() {
            if (this.moduleClassLoader != BaseModuleLoaderImpl.this.delegateClassLoader && this.moduleClassLoader instanceof URLClassLoader) {
                return ((URLClassLoader)this.moduleClassLoader).getURLs();
            }
            return null;
        }
    }
}

