/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.runtime.tools.impl;

import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.compiler.java.runtime.tools.impl.BaseModuleLoaderImpl;
import com.redhat.ceylon.compiler.java.runtime.tools.impl.ModuleGraph;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.cmr.RepositoryException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Map;

public class FlatpathModuleLoader
extends BaseModuleLoaderImpl {
    final Map<String, String> extraModules;

    public FlatpathModuleLoader() {
        this(null);
    }

    public FlatpathModuleLoader(ClassLoader delegateClassLoader) {
        this(null, delegateClassLoader, null, false);
    }

    public FlatpathModuleLoader(RepositoryManager repositoryManager, ClassLoader delegateClassLoader, Map<String, String> extraModules, boolean verbose) {
        super(repositoryManager, delegateClassLoader, verbose);
        this.extraModules = extraModules;
    }

    @Override
    BaseModuleLoaderImpl.ModuleLoaderContext createModuleLoaderContext(String name, String version2) {
        return new FlatpathModuleLoaderContext(name, version2);
    }

    class FlatpathModuleLoaderContext
    extends BaseModuleLoaderImpl.ModuleLoaderContext {
        FlatpathModuleLoaderContext(String module, String version2) {
            super(module, version2);
        }

        @Override
        void initialise() {
            this.preloadModules();
            this.moduleClassLoader = this.setupClassLoader();
            this.initialiseMetamodel();
        }

        private void preloadModules() {
            try {
                this.loadModule(this.module, this.modver, false, false, null);
                if (FlatpathModuleLoader.this.extraModules != null) {
                    for (Map.Entry<String, String> entry : FlatpathModuleLoader.this.extraModules.entrySet()) {
                        this.loadModule(entry.getKey(), entry.getValue(), false, false, null);
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private ClassLoader setupClassLoader() {
            ModuleGraph.Module loadedModule = this.moduleGraph.findModule(this.module);
            if (loadedModule.inCurrentClassLoader) {
                return FlatpathModuleLoader.this.delegateClassLoader;
            }
            return this.makeModuleClassLoader();
        }

        private ClassLoader makeModuleClassLoader() {
            final HashSet modulesNotInCurrentClassLoader = new HashSet();
            this.moduleGraph.visit(new ModuleGraph.Visitor(){

                @Override
                public void visit(ModuleGraph.Module module) {
                    if (!module.inCurrentClassLoader && module.artifact != null) {
                        modulesNotInCurrentClassLoader.add(module);
                    }
                }
            });
            URL[] urls = new URL[modulesNotInCurrentClassLoader.size()];
            if (FlatpathModuleLoader.this.verbose) {
                FlatpathModuleLoader.this.log("Making classpath with " + urls.length + " jars");
            }
            int i = 0;
            for (ModuleGraph.Module module : modulesNotInCurrentClassLoader) {
                ArtifactResult artifact = module.artifact;
                try {
                    URL url = artifact.artifact().toURL();
                    if (FlatpathModuleLoader.this.verbose) {
                        FlatpathModuleLoader.this.log(" cp[" + i + "] = " + url);
                    }
                    urls[i++] = url;
                }
                catch (RepositoryException | MalformedURLException e) {
                    throw new RuntimeException("Failed to get a URL for module file for " + module, e);
                }
            }
            return new URLClassLoader(urls, FlatpathModuleLoader.this.delegateClassLoader);
        }
    }
}

