/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.runtime.tools.impl;

import com.redhat.ceylon.compiler.java.launcher.Main;
import com.redhat.ceylon.compiler.java.runtime.tools.CompilationListener;
import com.redhat.ceylon.compiler.java.runtime.tools.Compiler;
import com.redhat.ceylon.compiler.java.runtime.tools.CompilerOptions;
import com.redhat.ceylon.compiler.java.runtime.tools.JavaCompilerOptions;
import com.redhat.ceylon.compiler.java.runtime.tools.impl.NullWriter;
import com.redhat.ceylon.compiler.java.tools.CeylonTaskListener;
import com.redhat.ceylon.compiler.java.tools.CeyloncTaskImpl;
import com.redhat.ceylon.compiler.java.tools.CeyloncTool;
import com.redhat.ceylon.javax.tools.Diagnostic;
import com.redhat.ceylon.javax.tools.DiagnosticListener;
import com.redhat.ceylon.javax.tools.JavaFileObject;
import com.redhat.ceylon.langtools.source.util.TaskEvent;
import com.redhat.ceylon.langtools.tools.javac.api.ClientCodeWrapper;
import com.redhat.ceylon.langtools.tools.javac.file.JavacFileManager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class JavaCompilerImpl
implements Compiler {
    @Override
    public boolean compile(CompilerOptions options, CompilationListener listener) {
        CeyloncTool compiler = new CeyloncTool();
        CompilationListenerAdapter diagnosticListener = new CompilationListenerAdapter(listener);
        NullWriter writer = null;
        if (!options.isVerbose()) {
            writer = new NullWriter();
        }
        JavacFileManager fileManager = compiler.getStandardFileManager(writer, diagnosticListener, null, null);
        Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(options.getFiles());
        CeyloncTaskImpl compilerTask = compiler.getTask(null, fileManager, diagnosticListener, this.translateOptions(options), options.getModules(), compilationUnits);
        compilerTask.setTaskListener(diagnosticListener);
        Main.ExitState state = compilerTask.call2();
        if (options.isVerbose() && state.abortingException != null) {
            state.abortingException.printStackTrace();
        }
        return state.ceylonState == Main.ExitState.CeylonState.OK;
    }

    private List<String> translateOptions(CompilerOptions options) {
        ArrayList<String> translatedOptions = new ArrayList<String>();
        if (options.isVerbose()) {
            translatedOptions.add("-verbose");
        }
        for (File sourcePath : options.getSourcePath()) {
            translatedOptions.add("-src");
            translatedOptions.add(sourcePath.getPath());
        }
        for (String rep : options.getUserRepositories()) {
            translatedOptions.add("-rep");
            translatedOptions.add(rep);
        }
        if (options.getOutputRepository() != null) {
            translatedOptions.add("-out");
            translatedOptions.add(options.getOutputRepository());
        }
        if (options.getSystemRepository() != null) {
            translatedOptions.add("-sysrep");
            translatedOptions.add(options.getSystemRepository());
        }
        if (options.getOverrides() != null) {
            translatedOptions.add("-overrides");
            translatedOptions.add(options.getOverrides());
        }
        if (options instanceof JavaCompilerOptions) {
            JavaCompilerOptions javaOptions = (JavaCompilerOptions)options;
            if (javaOptions.isFlatClasspath()) {
                translatedOptions.add("-flat-classpath");
            }
            if (javaOptions.isAutoExportMavenDependencies()) {
                translatedOptions.add("-auto-export-maven-dependencies");
            }
        }
        return translatedOptions;
    }

    @ClientCodeWrapper.Trusted
    public static class CompilationListenerAdapter
    implements DiagnosticListener<JavaFileObject>,
    CeylonTaskListener {
        private CompilationListener listener;

        public CompilationListenerAdapter(CompilationListener listener) {
            this.listener = listener;
        }

        @Override
        public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
            Diagnostic.Kind kind = diagnostic.getKind();
            String message = diagnostic.getMessage(Locale.getDefault());
            long line = diagnostic.getLineNumber();
            long column = diagnostic.getColumnNumber();
            JavaFileObject source = diagnostic.getSource();
            File file = null;
            if (source != null) {
                try {
                    file = new File(source.toUri());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            switch (kind) {
                case ERROR: {
                    this.listener.error(file, line, column, message);
                    break;
                }
                case WARNING: 
                case MANDATORY_WARNING: {
                    this.listener.warning(file, line, column, message);
                    break;
                }
            }
        }

        @Override
        public void started(TaskEvent e) {
        }

        @Override
        public void finished(TaskEvent e) {
        }

        @Override
        public void moduleCompiled(String name, String version2) {
            this.listener.moduleCompiled(name, version2);
        }
    }
}

