/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.runtime.tools.impl;

import ceylon.language.AssertionError;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.cmr.ceylon.CeylonUtils;
import com.redhat.ceylon.common.JVMModuleUtil;
import com.redhat.ceylon.compiler.java.runtime.model.OverridesRuntimeResolver;
import com.redhat.ceylon.compiler.java.runtime.tools.JavaRunner;
import com.redhat.ceylon.compiler.java.runtime.tools.JavaRunnerOptions;
import com.redhat.ceylon.compiler.java.runtime.tools.RunnerOptions;
import com.redhat.ceylon.compiler.java.runtime.tools.impl.BaseModuleLoaderImpl;
import com.redhat.ceylon.compiler.java.runtime.tools.impl.CmrLogger;
import com.redhat.ceylon.compiler.java.runtime.tools.impl.FlatpathModuleLoader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;

public class JavaRunnerImpl
implements JavaRunner {
    private String module;
    private BaseModuleLoaderImpl moduleLoader;
    private ClassLoader moduleClassLoader;
    private String run;

    public JavaRunnerImpl(RunnerOptions options, String module, String version2) {
        this.module = module;
        RepositoryManager repositoryManager = CeylonUtils.repoManager().userRepos(options.getUserRepositories()).systemRepo(options.getSystemRepository()).offline(options.isOffline()).noDefaultRepos(options.isNoDefaultRepositories()).overrides(options.getOverrides()).upgradeDist(!options.isDowngradeDist()).logger(new CmrLogger(options.isVerbose("cmr"))).buildManager();
        new OverridesRuntimeResolver(repositoryManager.getOverrides()).installInThreadLocal();
        ClassLoader delegateClassLoader = null;
        if (options instanceof JavaRunnerOptions) {
            delegateClassLoader = ((JavaRunnerOptions)options).getDelegateClassLoader();
        }
        this.moduleLoader = new FlatpathModuleLoader(repositoryManager, delegateClassLoader, options.getExtraModules(), options.isVerbose("cmr"));
        this.moduleClassLoader = this.moduleLoader.loadModule(module, version2);
        this.run = options.getRun();
    }

    @Override
    public void run(String ... arguments) {
        if (this.moduleClassLoader == null) {
            throw new AssertionError("Cannot call run method after cleanup is called");
        }
        this.invokeMain(this.module, arguments);
    }

    @Override
    public ClassLoader getModuleClassLoader() {
        if (this.moduleClassLoader == null) {
            throw new AssertionError("Cannot get class loader after cleanup is called");
        }
        return this.moduleClassLoader;
    }

    @Override
    public void cleanup() {
        this.moduleLoader.cleanup();
        this.moduleLoader = null;
        this.moduleClassLoader = null;
    }

    public URL[] getClassLoaderURLs() {
        return this.moduleLoader.getClassLoaderURLs(this.module);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeMain(String module, String[] arguments) {
        String className = JVMModuleUtil.javaClassNameFromCeylon(module, this.run);
        try {
            Class<?> runClass = this.moduleClassLoader.loadClass(className);
            Method main = runClass.getMethod("main", String[].class);
            Thread currentThread = Thread.currentThread();
            ClassLoader oldCcl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(this.moduleClassLoader);
                main.invoke(null, new Object[]{arguments});
            }
            finally {
                currentThread.setContextClassLoader(oldCcl);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Cannot find main class for module " + module + ": " + className, e);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException("Failed to invoke main method for module " + module + ": " + className, e);
        }
    }
}

