/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.runtime.tools.impl;

import com.redhat.ceylon.compiler.java.runtime.tools.CompilationListener;
import com.redhat.ceylon.compiler.java.runtime.tools.Compiler;
import com.redhat.ceylon.compiler.java.runtime.tools.CompilerOptions;
import com.redhat.ceylon.compiler.java.runtime.tools.impl.NullWriter;
import com.redhat.ceylon.compiler.js.CeylonCompileJsTool;
import com.redhat.ceylon.compiler.js.CompilerErrorException;
import com.redhat.ceylon.compiler.js.DiagnosticListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class JavaScriptCompilerImpl
implements Compiler {
    @Override
    public boolean compile(CompilerOptions options, CompilationListener listener) {
        CeylonCompileJsTool tool = new CeylonCompileJsTool();
        if (options.isVerbose()) {
            tool.setVerbose("");
        }
        tool.setOffline(options.isOffline());
        try {
            tool.setRepositoryAsStrings(options.getUserRepositories());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        tool.setSystemRepository(options.getSystemRepository());
        tool.setOut(options.getOutputRepository());
        tool.setSource(options.getSourcePath());
        ArrayList<String> moduleOrFile = new ArrayList<String>();
        moduleOrFile.addAll(options.getModules());
        moduleOrFile.addAll(this.fileToStringList(options.getFiles()));
        tool.setModule(moduleOrFile);
        tool.setDiagnosticListener(this.adapt(listener));
        tool.setThrowOnError(true);
        if (!options.isVerbose()) {
            tool.setOut((Appendable)new NullWriter());
        }
        try {
            tool.run();
        }
        catch (CompilerErrorException e) {
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    private DiagnosticListener adapt(final CompilationListener listener) {
        return new DiagnosticListener(){

            public void moduleCompiled(String module, String version2) {
                listener.moduleCompiled(module, version2);
            }

            public void error(File file, long line, long column, String message) {
                listener.error(file, line, column, message);
            }

            public void warning(File file, long line, long column, String message) {
                listener.warning(file, line, column, message);
            }
        };
    }

    private List<String> fileToStringList(List<File> files) {
        ArrayList<String> ret = new ArrayList<String>(files.size());
        for (File file : files) {
            ret.add(file.getPath());
        }
        return ret;
    }
}

