/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.runtime.tools.impl;

import com.redhat.ceylon.model.cmr.ArtifactResult;
import java.util.HashSet;
import java.util.Set;

public class ModuleGraph {
    Set<Module> roots = new HashSet<Module>();

    public Module addRoot(String module, String version2) {
        Module mod = new Module(module, version2);
        this.roots.add(mod);
        return mod;
    }

    public Module addRoot(Module mod) {
        this.roots.add(mod);
        return mod;
    }

    public Module findModule(String module) {
        HashSet<String> visited = new HashSet<String>();
        return this.findModule(module, visited, this.roots);
    }

    private Module findModule(String module, Set<String> visited, Set<Module> modules) {
        for (Module mod : modules) {
            if (!visited.add(mod.name)) continue;
            if (mod.name.equals(module)) {
                return mod;
            }
            Module found = this.findModule(module, visited, mod.dependencies);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public Module findModule(String module, String version2) {
        HashSet<Module> visited = new HashSet<Module>();
        return this.findModule(module, version2, visited, this.roots);
    }

    private Module findModule(String module, String version2, Set<Module> visited, Set<Module> modules) {
        for (Module mod : modules) {
            if (!visited.add(mod)) continue;
            if (mod.name.equals(module) && mod.version.equals(version2)) {
                return mod;
            }
            Module found = this.findModule(module, version2, visited, mod.dependencies);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public void visit(Visitor visitor) {
        HashSet<Module> visited = new HashSet<Module>();
        this.visit(visitor, visited, this.roots);
    }

    private void visit(Visitor visitor, Set<Module> visited, Set<Module> modules) {
        for (Module mod : modules) {
            if (!visited.add(mod)) continue;
            visitor.visit(mod);
            this.visit(visitor, visited, mod.dependencies);
        }
    }

    public void clear() {
        this.roots.clear();
    }

    class Module {
        String name;
        String version;
        Set<Module> dependencies = new HashSet<Module>();
        Set<Module> dependents = new HashSet<Module>();
        public ArtifactResult artifact;
        public boolean inCurrentClassLoader;
        boolean replaced;

        public Module(String name, String version2) {
            this.name = name;
            this.version = version2;
        }

        public Module replace(Module replacement) {
            if (this.replaced) {
                return replacement;
            }
            this.replaced = true;
            for (Module dependent : this.dependents) {
                dependent.replaceDependency(this, replacement);
            }
            this.dependents.clear();
            ModuleGraph.this.roots.remove(this);
            for (Module dependency : this.dependencies) {
                dependency.dependents.remove(this);
            }
            this.dependencies.clear();
            return replacement;
        }

        private void replaceDependency(Module from, Module to) {
            this.dependencies.remove(from);
            this.dependencies.add(to);
            to.dependents.add(this);
        }

        public String toString() {
            return this.name + "/" + this.version;
        }

        public int hashCode() {
            int hash = 17;
            hash = hash * 31 + this.name.hashCode();
            hash = hash * 31 + this.version.hashCode();
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof Module)) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            Module other = (Module)obj;
            return this.name.equals(other.name) && this.version.equals(other.version);
        }

        public Module addDependency(String name, String version2) {
            Module mod = new Module(name, version2);
            this.dependencies.add(mod);
            mod.dependents.add(this);
            return mod;
        }

        public Module addDependency(Module mod) {
            this.dependencies.add(mod);
            mod.dependents.add(this);
            return mod;
        }
    }

    static interface Visitor {
        public void visit(Module var1);
    }
}

