/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.tools;

import com.redhat.ceylon.cmr.util.JarUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;

public class JarCat
implements Closeable {
    private final HashSet<String> entries;
    private final JarOutputStream jout;

    public JarCat(File out) throws IOException {
        this.jout = new JarOutputStream(new FileOutputStream(out));
        this.entries = new HashSet();
    }

    public void cat(File file) throws IOException {
        this.cat(file, null);
    }

    public void cat(File file, JarUtils.JarEntryFilter filter) throws IOException {
        if (file != null) {
            try (JarFile j = new JarFile(file);){
                Enumeration<JarEntry> inEntries = j.entries();
                while (inEntries.hasMoreElements()) {
                    JarEntry entry = inEntries.nextElement();
                    String name = entry.getName();
                    if (filter != null && filter.avoid(name) || this.entries.contains(name)) continue;
                    this.makeParentDirs(name);
                    ZipEntry ze = new ZipEntry(name);
                    this.jout.putNextEntry(ze);
                    this.entries.add(name);
                    if (!entry.isDirectory()) {
                        try (InputStream in = j.getInputStream(entry);){
                            JarUtils.copy(in, this.jout);
                        }
                    }
                    this.jout.closeEntry();
                }
            }
        }
    }

    private void makeParentDirs(String name) throws IOException {
        String pname;
        int index = name.lastIndexOf(47, name.endsWith("/") ? name.length() - 2 : name.length() - 1);
        if (index != -1 && !this.entries.contains(pname = name.substring(0, index + 1))) {
            ZipEntry ze = new ZipEntry(pname);
            this.jout.putNextEntry(ze);
            this.entries.add(pname);
            this.jout.closeEntry();
        }
    }

    @Override
    public void close() throws IOException {
        this.jout.close();
    }
}

