/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.tools;

import com.redhat.ceylon.common.log.Logger;
import com.redhat.ceylon.javax.lang.model.element.Modifier;
import com.redhat.ceylon.javax.lang.model.element.NestingKind;
import com.redhat.ceylon.javax.tools.JavaFileObject;
import com.redhat.ceylon.model.loader.OsgiUtil;
import com.redhat.ceylon.model.typechecker.model.Module;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public class JarEntryManifestFileObject
implements JavaFileObject {
    private String jarFileName;
    private String fileName;
    private Module module;
    private String osgiProvidedBundles;
    private ByteArrayOutputStream baos;

    public JarEntryManifestFileObject(String jarFileName, String fileName, Module module, String osgiProvidedBundles) {
        this.jarFileName = jarFileName;
        this.fileName = fileName;
        this.module = module;
        this.osgiProvidedBundles = osgiProvidedBundles;
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        this.baos = new ByteArrayOutputStream();
        return new FilterOutputStream(this.baos){

            @Override
            public void close() throws IOException {
                super.write(10);
                super.close();
            }
        };
    }

    public void writeManifest(JarOutputStream jarFile, Logger log) throws IOException {
        if (this.baos != null) {
            this.writeManifestJarEntry(jarFile, this.readManifest(this.baos), log);
        }
    }

    private void writeManifestJarEntry(JarOutputStream jarFile, Manifest originalManifest, Logger log) throws IOException {
        Manifest manifest = this.module.isDefault() ? new OsgiUtil.DefaultModuleManifest().build() : new OsgiUtil.OsgiManifest(this.module, originalManifest, this.osgiProvidedBundles, log).build();
        jarFile.putNextEntry(new ZipEntry(this.fileName));
        manifest.write(jarFile);
    }

    private Manifest readManifest(ByteArrayOutputStream baos) throws IOException {
        return new Manifest(new ByteArrayInputStream(baos.toByteArray()));
    }

    public int hashCode() {
        return this.jarFileName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof JarEntryManifestFileObject) {
            JarEntryManifestFileObject r = (JarEntryManifestFileObject)obj;
            return this.jarFileName.equals(r.jarFileName);
        }
        return false;
    }

    public String toString() {
        return this.jarFileName + ":" + this.fileName;
    }

    @Override
    public URI toUri() {
        return null;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return null;
    }

    @Override
    public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
        return null;
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        return null;
    }

    @Override
    public Writer openWriter() throws IOException {
        return null;
    }

    @Override
    public long getLastModified() {
        return 0L;
    }

    @Override
    public boolean delete() {
        return false;
    }

    @Override
    public JavaFileObject.Kind getKind() {
        return null;
    }

    @Override
    public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
        return false;
    }

    @Override
    public NestingKind getNestingKind() {
        return null;
    }

    @Override
    public Modifier getAccessLevel() {
        return null;
    }
}

