/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.tools;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.ArtifactCreator;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.cmr.ceylon.CeylonUtils;
import com.redhat.ceylon.cmr.impl.ShaSigner;
import com.redhat.ceylon.cmr.util.JarUtils;
import com.redhat.ceylon.common.FileUtil;
import com.redhat.ceylon.common.log.Logger;
import com.redhat.ceylon.compiler.java.tools.CeylonLocation;
import com.redhat.ceylon.compiler.java.tools.CeylonTaskListener;
import com.redhat.ceylon.compiler.java.tools.CeyloncFileManager;
import com.redhat.ceylon.compiler.java.tools.JarCat;
import com.redhat.ceylon.compiler.java.tools.JarEntryFileObject;
import com.redhat.ceylon.compiler.java.tools.JarEntryManifestFileObject;
import com.redhat.ceylon.compiler.java.tools.Java9Util;
import com.redhat.ceylon.compiler.java.tools.JavacLogger;
import com.redhat.ceylon.compiler.java.tools.MavenPomUtil;
import com.redhat.ceylon.javax.tools.JavaFileObject;
import com.redhat.ceylon.javax.tools.StandardLocation;
import com.redhat.ceylon.langtools.source.util.TaskListener;
import com.redhat.ceylon.langtools.tools.javac.main.OptionName;
import com.redhat.ceylon.langtools.tools.javac.util.Log;
import com.redhat.ceylon.langtools.tools.javac.util.Options;
import com.redhat.ceylon.model.loader.OsgiUtil;
import com.redhat.ceylon.model.typechecker.model.Module;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public class JarOutputRepositoryManager {
    private Map<Module, ProgressiveJar> openJars = new HashMap<Module, ProgressiveJar>();
    private Log log;
    private Options options;
    private CeyloncFileManager ceyloncFileManager;
    private TaskListener taskListener;

    JarOutputRepositoryManager(Log log, Options options, CeyloncFileManager ceyloncFileManager, TaskListener taskListener) {
        this.log = log;
        this.options = options;
        this.ceyloncFileManager = ceyloncFileManager;
        this.taskListener = taskListener;
    }

    public JavaFileObject getFileObject(RepositoryManager repositoryManager, Module module, String fileName, File sourceFile) throws IOException {
        ProgressiveJar progressiveJar = this.getProgressiveJar(repositoryManager, module);
        return progressiveJar.getJavaFileObject(fileName, sourceFile);
    }

    private ProgressiveJar getProgressiveJar(RepositoryManager repositoryManager, Module module) throws IOException {
        ProgressiveJar jarFile = this.openJars.get(module);
        if (jarFile == null) {
            jarFile = new ProgressiveJar(repositoryManager, module, this.log, this.options, this.ceyloncFileManager, this.taskListener);
            this.openJars.put(module, jarFile);
        }
        return jarFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        Exception ex = null;
        try {
            for (ProgressiveJar jarFile : this.openJars.values()) {
                try {
                    jarFile.close();
                }
                catch (Exception e) {
                    ex = e;
                }
            }
        }
        finally {
            this.openJars.clear();
        }
        if (ex instanceof IOException) {
            throw (IOException)ex;
        }
    }

    static class ProgressiveJar {
        private static final String META_INF = "META-INF";
        private static final String MAPPING_FILE = "META-INF/mapping.txt";
        private File originalJarFile;
        private File outputJarFile;
        private JarOutputStream jarOutputStream;
        private final Set<String> modifiedSourceFiles = new HashSet<String>();
        private final Set<String> modifiedResourceFilesRel = new HashSet<String>();
        private final Set<String> modifiedResourceFilesFull = new HashSet<String>();
        private final Properties writtenClassesMapping = new Properties();
        private Logger cmrLog;
        private Options options;
        private RepositoryManager repoManager;
        private ArtifactContext carContext;
        private ArtifactCreator srcCreator;
        private ArtifactCreator resourceCreator;
        private final Set<String> foldersToAdd = new HashSet<String>();
        private Module module;
        private boolean writeOsgiManifest;
        private String osgiProvidedBundles;
        private final String resourceRootPath;
        private boolean writeMavenManifest;
        private boolean writeJava9Module;
        private TaskListener taskListener;
        private JarEntryManifestFileObject manifest;
        private Log log;

        public ProgressiveJar(RepositoryManager repoManager, Module module, Log log, Options options, CeyloncFileManager ceyloncFileManager, TaskListener taskListener) throws IOException {
            String rootName;
            this.options = options;
            this.repoManager = repoManager;
            this.carContext = new ArtifactContext(module.getNameAsString(), module.getVersion(), ".car");
            this.log = log;
            this.cmrLog = new JavacLogger(options, Log.instance(ceyloncFileManager.getContext()));
            this.srcCreator = CeylonUtils.makeSourceArtifactCreator(repoManager, ceyloncFileManager.getLocation(StandardLocation.SOURCE_PATH), module.getNameAsString(), module.getVersion(), options.get(OptionName.VERBOSE) != null, this.cmrLog);
            this.resourceCreator = CeylonUtils.makeResourceArtifactCreator(repoManager, ceyloncFileManager.getLocation(StandardLocation.SOURCE_PATH), ceyloncFileManager.getLocation(CeylonLocation.RESOURCE_PATH), options.get(OptionName.CEYLONRESOURCEROOT), module.getNameAsString(), module.getVersion(), options.get(OptionName.VERBOSE) != null, this.cmrLog);
            this.module = module;
            this.writeOsgiManifest = !options.isSet(OptionName.CEYLONNOOSGI);
            this.osgiProvidedBundles = options.get(OptionName.CEYLONOSGIPROVIDEDBUNDLES);
            this.writeMavenManifest = !options.isSet(OptionName.CEYLONNOPOM) && !module.isDefault();
            this.writeJava9Module = options.isSet(OptionName.CEYLONJIGSAW) && !module.isDefault();
            String rrp = module.getNameAsString().replace('.', '/');
            if (!rrp.isEmpty() && !rrp.endsWith("/")) {
                rrp = rrp + "/";
            }
            if ((rootName = options.get(OptionName.CEYLONRESOURCEROOT)) == null) {
                rootName = "ROOT";
            }
            this.resourceRootPath = rrp + rootName + "/";
            this.taskListener = taskListener;
            this.originalJarFile = repoManager.getArtifact(this.carContext);
            this.outputJarFile = File.createTempFile("ceylon-compiler-", ".car");
            this.jarOutputStream = new JarOutputStream(new FileOutputStream(this.outputJarFile));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Properties getPreviousMapping() throws IOException {
            if (this.originalJarFile != null) {
                JarFile jarFile = null;
                jarFile = new JarFile(this.originalJarFile);
                try {
                    JarEntry entry = jarFile.getJarEntry(MAPPING_FILE);
                    if (entry != null) {
                        Properties properties;
                        InputStream inputStream = jarFile.getInputStream(entry);
                        try {
                            Properties previousMapping = new Properties();
                            previousMapping.load(inputStream);
                            properties = previousMapping;
                        }
                        catch (Throwable throwable) {
                            inputStream.close();
                            throw throwable;
                        }
                        inputStream.close();
                        return properties;
                    }
                }
                finally {
                    jarFile.close();
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Manifest getPreviousManifest() throws IOException {
            if (this.originalJarFile != null) {
                JarFile jarFile = null;
                jarFile = new JarFile(this.originalJarFile);
                try {
                    Manifest manifest = jarFile.getManifest();
                    return manifest;
                }
                finally {
                    jarFile.close();
                }
            }
            return null;
        }

        public void close() throws IOException {
            try {
                Set<String> copiedSourceFiles = this.srcCreator.copy(this.modifiedSourceFiles);
                this.resourceCreator.copy(this.modifiedResourceFilesFull);
                this.jarOutputStream.flush();
                this.jarOutputStream.close();
                File metaFirstFile = File.createTempFile("compile", "car");
                JarOutputStream manifestFirst = new JarOutputStream(new FileOutputStream(metaFirstFile));
                HashSet<String> foldersAdded = new HashSet<String>();
                JarUtils.makeFolder(foldersAdded, manifestFirst, "META-INF/");
                if (this.writeOsgiManifest && this.manifest == null) {
                    Manifest manifest = (this.module.isDefault() ? new OsgiUtil.DefaultModuleManifest() : new OsgiUtil.OsgiManifest(this.module, this.getPreviousManifest(), this.osgiProvidedBundles, null)).build();
                    ProgressiveJar.writeManifestJarEntry(manifestFirst, manifest);
                } else if (this.manifest != null && !this.module.isDefault()) {
                    this.manifest.writeManifest(manifestFirst, new JavacLogger(this.options, this.log));
                }
                if (this.writeMavenManifest) {
                    this.writeMavenManifest(foldersAdded, manifestFirst, this.module);
                }
                if (this.writeJava9Module && !this.module.isDefault()) {
                    this.writeJava9Module(foldersAdded, manifestFirst, this.module);
                }
                Properties previousMapping = this.getPreviousMapping();
                JarUtils.JarEntryFilter jarFilter = this.getJarFilter(previousMapping, copiedSourceFiles);
                this.writeMappingJarEntry(manifestFirst, foldersAdded, previousMapping, jarFilter);
                manifestFirst.close();
                File finalCarFile = File.createTempFile("ceylon-compiler-", ".car");
                JarCat jc = new JarCat(finalCarFile);
                jc.cat(metaFirstFile);
                jc.cat(this.outputJarFile);
                jc.cat(this.originalJarFile, jarFilter);
                jc.close();
                FileUtil.deleteQuietly(metaFirstFile);
                if (this.options.isSet(OptionName.CEYLONPACK200)) {
                    JarUtils.repack(finalCarFile, this.cmrLog);
                }
                File sha1File = ShaSigner.sign(finalCarFile, this.cmrLog, this.options.get(OptionName.VERBOSE) != null);
                JarUtils.publish(finalCarFile, sha1File, this.carContext, this.repoManager, this.cmrLog);
                String info = this.module.isDefault() ? this.module.getNameAsString() : this.module.getNameAsString() + "/" + this.module.getVersion();
                this.cmrLog.info("Created module " + info);
                if (this.taskListener instanceof CeylonTaskListener) {
                    ((CeylonTaskListener)this.taskListener).moduleCompiled(this.module.getNameAsString(), this.module.getVersion());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (RuntimeException e) {
                throw e;
            }
            finally {
                FileUtil.deleteQuietly(this.outputJarFile);
            }
        }

        private JarUtils.JarEntryFilter getJarFilter(final Properties previousMapping, final Set<String> copiedSourceFiles) {
            return new JarUtils.JarEntryFilter(){

                @Override
                public boolean avoid(String entryFullName) {
                    if (entryFullName.endsWith(".class")) {
                        boolean classWasUpdated = ProgressiveJar.this.writtenClassesMapping.containsKey(entryFullName);
                        if (previousMapping != null) {
                            String sourceFileForClass = previousMapping.getProperty(entryFullName);
                            classWasUpdated = classWasUpdated || copiedSourceFiles.contains(sourceFileForClass);
                        }
                        return classWasUpdated;
                    }
                    return ProgressiveJar.this.modifiedResourceFilesRel.contains(entryFullName) || entryFullName.equals(ProgressiveJar.MAPPING_FILE) || ProgressiveJar.this.writeOsgiManifest && OsgiUtil.OsgiManifest.isManifestFileName(entryFullName) || ProgressiveJar.this.writeMavenManifest && MavenPomUtil.isMavenDescriptor(entryFullName, ProgressiveJar.this.module);
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void writeManifestJarEntry(JarOutputStream out, Manifest manifest) {
            try {
                out.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
                manifest.write(out);
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    out.closeEntry();
                }
                catch (IOException iOException) {}
            }
        }

        private void writeMavenManifest(Set<String> foldersAlreadyAdded, JarOutputStream manifestFirst, Module module) {
            MavenPomUtil.writeMavenManifest2(manifestFirst, module, foldersAlreadyAdded);
        }

        private void writeJava9Module(Set<String> foldersAlreadyAdded, JarOutputStream manifestFirst, Module module) {
            Java9Util.writeModuleDescriptor(manifestFirst, new Java9Util.Java9ModuleDescriptor(module));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeMappingJarEntry(JarOutputStream outputStream, Set<String> foldersAlreadyAdded, Properties previousMapping, JarUtils.JarEntryFilter filter) {
            Properties newMapping = new Properties();
            newMapping.putAll((Map<?, ?>)this.writtenClassesMapping);
            if (previousMapping != null) {
                for (String classFullName : previousMapping.stringPropertyNames()) {
                    if (filter.avoid(classFullName)) continue;
                    newMapping.setProperty(classFullName, previousMapping.getProperty(classFullName));
                }
            }
            try {
                JarUtils.makeFolder(foldersAlreadyAdded, outputStream, "META-INF/");
                outputStream.putNextEntry(new ZipEntry(MAPPING_FILE));
                newMapping.store(outputStream, "");
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    outputStream.closeEntry();
                }
                catch (IOException iOException) {}
            }
        }

        public JavaFileObject getJavaFileObject(String fileName, File sourceFile) {
            String folder;
            String entryName = fileName.replace(File.separatorChar, '/');
            if (!this.resourceRootPath.isEmpty() && entryName.startsWith(this.resourceRootPath)) {
                entryName = entryName.substring(this.resourceRootPath.length());
            }
            if ((folder = JarUtils.getFolder(entryName)) != null) {
                this.foldersToAdd.add(folder);
            }
            if (sourceFile != null) {
                this.modifiedSourceFiles.add(sourceFile.getPath());
                this.addMappingEntry(entryName, JarUtils.toPlatformIndependentPath(this.srcCreator.getPaths(), sourceFile.getPath()));
            } else {
                this.modifiedResourceFilesRel.add(entryName);
                this.modifiedResourceFilesFull.add(FileUtil.applyPath(this.resourceCreator.getPaths(), fileName).getPath());
                if (OsgiUtil.CeylonManifest.isManifestFileName(entryName) && (this.module.isDefault() || this.writeOsgiManifest)) {
                    this.manifest = new JarEntryManifestFileObject(this.outputJarFile.getPath(), entryName, this.module, this.osgiProvidedBundles);
                    return this.manifest;
                }
            }
            return new JarEntryFileObject(this.outputJarFile.getPath(), this.jarOutputStream, entryName);
        }

        private void addMappingEntry(String className, String sourcePath) {
            this.writtenClassesMapping.put(className, sourcePath);
        }
    }
}

