/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.tools;

import com.redhat.ceylon.cmr.util.JarUtils;
import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.model.cmr.JDKUtils;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.ModuleImport;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class MavenPomUtil {
    private static String[] getMavenCoordinates(String moduleName) {
        String artifactId;
        String groupId;
        int lastDot = moduleName.lastIndexOf(".");
        if (lastDot != -1) {
            groupId = moduleName.substring(0, lastDot);
            artifactId = moduleName.substring(lastDot + 1);
        } else {
            groupId = artifactId = moduleName;
        }
        return new String[]{groupId, artifactId};
    }

    public static void writeMavenManifest2(JarOutputStream jarOutputStream, Module module, Set<String> foldersAlreadyAdded) {
        String moduleName = module.getNameAsString();
        String[] mavenCoordinates = MavenPomUtil.getMavenCoordinates(moduleName);
        String groupId = mavenCoordinates[0];
        String artifactId = mavenCoordinates[1];
        try {
            JarUtils.makeFolder(foldersAlreadyAdded, jarOutputStream, "META-INF/");
            JarUtils.makeFolder(foldersAlreadyAdded, jarOutputStream, "META-INF/maven/");
            JarUtils.makeFolder(foldersAlreadyAdded, jarOutputStream, "META-INF/maven/" + groupId + "/");
            String path = "META-INF/maven/" + groupId + "/" + artifactId + "/";
            JarUtils.makeFolder(foldersAlreadyAdded, jarOutputStream, path);
            MavenPomUtil.writePomXml(jarOutputStream, path, groupId, artifactId, module);
            MavenPomUtil.writePomProperties(jarOutputStream, path, groupId, artifactId, module.getVersion());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void writePomXml(JarOutputStream jarOutputStream, String path, String groupId, String artifactId, Module module) {
        try {
            jarOutputStream.putNextEntry(new ZipEntry(path + "pom.xml"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            XMLStreamWriter out = XMLOutputFactory.newInstance().createXMLStreamWriter(new OutputStreamWriter((OutputStream)jarOutputStream, "utf-8"));
            out.writeStartDocument();
            out.writeCharacters("\n");
            out.writeStartElement("project");
            out.writeAttribute("xmlns", "http://maven.apache.org/POM/4.0.0");
            out.writeAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            out.writeAttribute("xsi:schemaLocation", "http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd");
            out.writeCharacters("\n ");
            out.writeStartElement("modelVersion");
            out.writeCharacters("4.0.0");
            out.writeEndElement();
            out.writeCharacters("\n ");
            out.writeStartElement("groupId");
            out.writeCharacters(groupId);
            out.writeEndElement();
            out.writeCharacters("\n ");
            out.writeStartElement("artifactId");
            out.writeCharacters(artifactId);
            out.writeEndElement();
            out.writeCharacters("\n ");
            out.writeStartElement("version");
            out.writeCharacters(module.getVersion());
            out.writeEndElement();
            out.writeCharacters("\n ");
            out.writeStartElement("name");
            out.writeCharacters(module.getNameAsString());
            out.writeEndElement();
            List<ModuleImport> imports = module.getImports();
            if (!imports.isEmpty()) {
                out.writeCharacters("\n ");
                out.writeStartElement("dependencies");
                for (ModuleImport dep : imports) {
                    Module moduleDependency;
                    String dependencyName;
                    if (!ModelUtil.isForBackend(dep.getNativeBackends(), Backend.Java) || (dependencyName = (moduleDependency = dep.getModule()).getNameAsString()).equals("ceylon.language") || JDKUtils.isJDKModule(dependencyName) || JDKUtils.isOracleJDKModule(dependencyName)) continue;
                    String[] mavenCoordinates = MavenPomUtil.getMavenCoordinates(moduleDependency.getNameAsString());
                    out.writeCharacters("\n  ");
                    out.writeStartElement("dependency");
                    out.writeCharacters("\n    ");
                    out.writeStartElement("groupId");
                    out.writeCharacters(mavenCoordinates[0]);
                    out.writeEndElement();
                    out.writeCharacters("\n    ");
                    out.writeStartElement("artifactId");
                    out.writeCharacters(mavenCoordinates[1]);
                    out.writeEndElement();
                    out.writeCharacters("\n    ");
                    out.writeStartElement("version");
                    out.writeCharacters(moduleDependency.getVersion());
                    out.writeEndElement();
                    if (dep.isOptional()) {
                        out.writeCharacters("\n    ");
                        out.writeStartElement("optional");
                        out.writeCharacters("true");
                        out.writeEndElement();
                    }
                    out.writeCharacters("\n  ");
                    out.writeEndElement();
                }
                out.writeCharacters("\n ");
                out.writeEndElement();
            }
            out.writeCharacters("\n");
            out.writeEndElement();
            out.writeEndDocument();
            out.flush();
        }
        catch (IOException | XMLStreamException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                jarOutputStream.closeEntry();
            }
            catch (IOException iOException) {}
        }
    }

    private static void writePomProperties(JarOutputStream jarOutputStream, String path, String groupId, String artifactId, String version2) {
        try {
            jarOutputStream.putNextEntry(new ZipEntry(path + "pom.properties"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            Properties properties = new Properties();
            properties.put("version", version2);
            properties.put("groupId", groupId);
            properties.put("artifactId", artifactId);
            properties.store(jarOutputStream, "Generated by Ceylon");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                jarOutputStream.closeEntry();
            }
            catch (IOException iOException) {}
        }
    }

    public static boolean isMavenDescriptor(String entryFullName, Module module) {
        String moduleName = module.getNameAsString();
        String[] mavenCoordinates = MavenPomUtil.getMavenCoordinates(moduleName);
        String groupId = mavenCoordinates[0];
        String artifactId = mavenCoordinates[1];
        String path = "META-INF/maven/" + groupId + "/" + artifactId + "/";
        return entryFullName.equals(path + "pom.xml") || entryFullName.equals(path + "pom.properties");
    }
}

