/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.tools;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.common.StatusPrinter;
import com.redhat.ceylon.compiler.java.tools.StatusPrinterArtifactCallback;
import com.redhat.ceylon.compiler.typechecker.analyzer.ModuleValidator;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.typechecker.model.Module;

public class StatusPrinterProgressListener
implements ModuleValidator.ProgressListener {
    private ModuleValidator validator;
    StatusPrinter sp;

    public StatusPrinterProgressListener(ModuleValidator validator, StatusPrinter sp) {
        this.validator = validator;
        this.sp = sp;
    }

    @Override
    public void retrievingModuleArtifact(Module module, ArtifactContext artifactContext) {
        long done = this.validator.numberOfModulesAlreadySearched();
        long todo = this.validator.numberOfModulesNotAlreadySearched();
        long total = done + todo;
        this.sp.clearLine();
        this.sp.log("[" + (done + 1L) + "/" + total + "]: ");
        int moduleSize = this.sp.remainingForPercentage(0.4);
        int versionSize = this.sp.remainingForPercentage(0.1);
        this.sp.log(module.getNameAsString(), moduleSize);
        this.sp.log("/");
        this.sp.log(module.getVersion(), versionSize);
        this.sp.captureLine();
        artifactContext.setCallback(new StatusPrinterArtifactCallback(this.sp));
    }

    @Override
    public void resolvingModuleArtifact(Module module, ArtifactResult artifactResult) {
    }

    @Override
    public void retrievingModuleArtifactFailed(Module module, ArtifactContext artifactContext) {
        this.sp.logCapturedLine();
        this.sp.log(" FAIL");
    }

    @Override
    public void retrievingModuleArtifactSuccess(Module module, ArtifactResult artifact) {
        this.sp.logCapturedLine();
        this.sp.log(" OK");
    }
}

