/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.typechecker;

import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.cmr.ceylon.CeylonUtils;
import com.redhat.ceylon.compiler.typechecker.TypeChecker;
import com.redhat.ceylon.compiler.typechecker.analyzer.UnsupportedError;
import com.redhat.ceylon.compiler.typechecker.io.VFS;
import com.redhat.ceylon.compiler.typechecker.io.VirtualFile;
import com.redhat.ceylon.compiler.typechecker.io.cmr.impl.LeakingLogger;
import com.redhat.ceylon.compiler.typechecker.tree.Message;
import com.redhat.ceylon.compiler.typechecker.util.AssertionVisitor;
import com.redhat.ceylon.compiler.typechecker.util.ModuleManagerFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class TypeCheckerBuilder {
    private boolean verbose = false;
    private boolean statistics = false;
    private String encoding;
    private List<VirtualFile> srcDirectories = new ArrayList<VirtualFile>();
    private List<VirtualFile> srcFiles = null;
    private final VFS vfs;
    private boolean verifyDependencies = true;
    private AssertionVisitor assertionVisitor = new AssertionVisitor(){

        @Override
        protected boolean includeError(Message err, int phase) {
            return phase != 3 || !(err instanceof UnsupportedError);
        }
    };
    private ModuleManagerFactory moduleManagerFactory;
    private RepositoryManager repositoryManager;
    private List<String> moduleFilters = new ArrayList<String>();

    public TypeCheckerBuilder(VFS vfs) {
        this.vfs = vfs != null ? vfs : new VFS();
    }

    public TypeCheckerBuilder() {
        this.vfs = new VFS();
    }

    public TypeCheckerBuilder addSrcDirectory(File srcDirectory) {
        return this.addSrcDirectory(this.vfs.getFromFile(srcDirectory));
    }

    public TypeCheckerBuilder addSrcDirectory(VirtualFile srcDirectory) {
        this.srcDirectories.add(srcDirectory);
        return this;
    }

    public TypeCheckerBuilder setRepositoryManager(RepositoryManager repositoryManager) {
        this.repositoryManager = repositoryManager;
        return this;
    }

    public TypeCheckerBuilder setModuleFilters(List<String> moduleFilters) {
        this.moduleFilters.clear();
        this.moduleFilters.addAll(moduleFilters);
        return this;
    }

    public TypeCheckerBuilder setSourceFiles(List<File> srcFiles) {
        if (srcFiles != null) {
            this.srcFiles = new ArrayList<VirtualFile>();
            for (File src : srcFiles) {
                this.srcFiles.add(this.vfs.getFromFile(src));
            }
        } else {
            this.srcFiles = null;
        }
        return this;
    }

    public TypeCheckerBuilder skipDependenciesVerification() {
        this.verifyDependencies = false;
        return this;
    }

    public TypeCheckerBuilder assertionVisitor(AssertionVisitor visitor) {
        this.assertionVisitor = visitor;
        return this;
    }

    public TypeCheckerBuilder verbose(boolean isVerbose) {
        this.verbose = isVerbose;
        return this;
    }

    public TypeCheckerBuilder statistics(boolean statistics) {
        this.statistics = statistics;
        return this;
    }

    public TypeCheckerBuilder usageWarnings(boolean usageWarnings) {
        this.assertionVisitor.includeUsageWarnings(usageWarnings);
        return this;
    }

    public TypeCheckerBuilder moduleManagerFactory(ModuleManagerFactory moduleManagerFactory) {
        this.moduleManagerFactory = moduleManagerFactory;
        return this;
    }

    public VFS getVFS() {
        return this.vfs;
    }

    public TypeCheckerBuilder encoding(String value) {
        this.encoding = value;
        return this;
    }

    public TypeChecker getTypeChecker() {
        if (this.repositoryManager == null) {
            this.repositoryManager = CeylonUtils.repoManager().logger(new LeakingLogger()).buildManager();
        }
        return new TypeChecker(this.vfs, this.srcDirectories, this.repositoryManager, this.verifyDependencies, this.assertionVisitor, this.moduleManagerFactory, this.verbose, this.statistics, this.moduleFilters, this.srcFiles, this.encoding);
    }
}

