/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.typechecker.analyzer;

import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import java.util.Collections;
import java.util.List;

public class AliasVisitor
extends Visitor {
    private void check(Node that, Type t, TypeDeclaration d) {
        List<TypeDeclaration> list;
        if (t != null && !(list = t.isRecursiveTypeAliasDefinition(Collections.singleton(d))).isEmpty()) {
            that.addError("type alias is circular: definition of '" + d.getName() + "' is recursive, involving " + AliasVisitor.typeList(list));
            d.setExtendedType(that.getUnit().getUnknownType());
            d.addBrokenSupertype(t);
        }
    }

    public static String typeList(List<TypeDeclaration> list) {
        StringBuffer sb = new StringBuffer();
        for (TypeDeclaration td : list) {
            sb.append("'").append(td.getName()).append("', ");
        }
        sb.setLength(sb.length() - 2);
        return sb.toString();
    }

    @Override
    public void visit(Tree.TypeAliasDeclaration that) {
        Tree.StaticType st;
        Tree.TypeSpecifier ts = that.getTypeSpecifier();
        if (ts != null && (st = ts.getType()) != null) {
            this.check(ts, st.getTypeModel(), that.getDeclarationModel());
        }
        super.visit(that);
    }

    @Override
    public void visit(Tree.ClassDeclaration that) {
        Tree.SimpleType st;
        Tree.ClassSpecifier ts = that.getClassSpecifier();
        if (ts != null && (st = ts.getType()) != null) {
            this.check(ts, st.getTypeModel(), that.getDeclarationModel());
        }
        super.visit(that);
    }

    @Override
    public void visit(Tree.InterfaceDeclaration that) {
        Tree.StaticType st;
        Tree.TypeSpecifier ts = that.getTypeSpecifier();
        if (ts != null && (st = ts.getType()) != null) {
            this.check(ts, st.getTypeModel(), that.getDeclarationModel());
        }
        super.visit(that);
    }

    @Override
    public void visit(Tree.TupleType that) {
        super.visit(that);
        that.setTypeModel(that.getTypeModel().resolveAliases());
    }

    @Override
    public void visit(Tree.FunctionType that) {
        super.visit(that);
        Type rt = that.getTypeModel();
        if (rt != null) {
            that.setTypeModel(rt.resolveAliases());
        }
    }
}

