/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.typechecker.analyzer;

import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.compiler.typechecker.context.TypecheckerUnit;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.TreeUtil;
import com.redhat.ceylon.compiler.typechecker.util.NormalizedLevenshtein;
import com.redhat.ceylon.model.cmr.JDKUtils;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.Constructor;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Generic;
import com.redhat.ceylon.model.typechecker.model.Interface;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.ModuleImport;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.ParameterList;
import com.redhat.ceylon.model.typechecker.model.Reference;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.SiteVariance;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeAlias;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.Unit;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AnalyzerUtil {
    static final NormalizedLevenshtein distance = new NormalizedLevenshtein();
    static final List<Type> NO_TYPE_ARGS = Collections.emptyList();

    static TypedDeclaration getTypedMember(TypeDeclaration td, String name, List<Type> signature, boolean ellipsis, Unit unit) {
        Declaration member = td.getMember(name, unit, signature, ellipsis);
        if (member instanceof TypedDeclaration) {
            return (TypedDeclaration)member;
        }
        return null;
    }

    static TypeDeclaration getTypeMember(TypeDeclaration td, String name, List<Type> signature, boolean ellipsis, Unit unit) {
        Declaration member = td.getMember(name, unit, signature, ellipsis);
        if (member instanceof TypeDeclaration) {
            return (TypeDeclaration)member;
        }
        if (member instanceof TypedDeclaration) {
            return AnalyzerUtil.anonymousType(name, (TypedDeclaration)member);
        }
        return null;
    }

    static TypedDeclaration getTypedDeclaration(Scope scope, String name, List<Type> signature, boolean ellipsis, Unit unit) {
        Declaration result = scope.getMemberOrParameter(unit, name, signature, ellipsis);
        if (result instanceof TypedDeclaration) {
            return (TypedDeclaration)result;
        }
        return null;
    }

    static TypeDeclaration getTypeDeclaration(Scope scope, String name, List<Type> signature, boolean ellipsis, Unit unit) {
        Declaration result = scope.getMemberOrParameter(unit, name, signature, ellipsis);
        if (result instanceof TypeDeclaration) {
            return (TypeDeclaration)result;
        }
        if (result instanceof TypedDeclaration) {
            return AnalyzerUtil.anonymousType(name, (TypedDeclaration)result);
        }
        return null;
    }

    static TypedDeclaration getPackageTypedDeclaration(String name, List<Type> signature, boolean ellipsis, Unit unit) {
        Declaration result = unit.getPackage().getMember(name, signature, ellipsis);
        if (result instanceof TypedDeclaration) {
            return (TypedDeclaration)result;
        }
        return null;
    }

    static TypeDeclaration getPackageTypeDeclaration(String name, List<Type> signature, boolean ellipsis, Unit unit) {
        Declaration result = unit.getPackage().getMember(name, signature, ellipsis);
        if (result instanceof TypeDeclaration) {
            return (TypeDeclaration)result;
        }
        if (result instanceof TypedDeclaration) {
            return AnalyzerUtil.anonymousType(name, (TypedDeclaration)result);
        }
        return null;
    }

    private static TypeDeclaration anonymousType(String name, TypedDeclaration result) {
        TypeDeclaration typeDeclaration;
        Type type = result.getType();
        if (type != null && ((typeDeclaration = type.getDeclaration()) instanceof Class || typeDeclaration instanceof Constructor) && typeDeclaration.isAnonymous() && ModelUtil.isNamed(name, typeDeclaration)) {
            return typeDeclaration;
        }
        return null;
    }

    private static String best(final String name, Collection<String> names) {
        if (names.isEmpty()) {
            return null;
        }
        final boolean ucase = Character.isUpperCase(name.charAt(0));
        String best = Collections.max(names, new Comparator<String>(){

            @Override
            public int compare(String x, String y) {
                boolean xucase = Character.isUpperCase(x.charAt(0));
                boolean yucase = Character.isUpperCase(y.charAt(0));
                if (ucase == xucase && ucase != yucase) {
                    return 1;
                }
                if (ucase == yucase && ucase != xucase) {
                    return -1;
                }
                return Double.compare(distance.similarity(name, x), distance.similarity(name, y));
            }
        });
        return distance.similarity(name, best) > 0.6 ? best : null;
    }

    public static String correct(Scope scope, Unit unit, String name) {
        return AnalyzerUtil.best(name, scope.getMatchingDeclarations(unit, "", 0, null).keySet());
    }

    public static String correct(TypeDeclaration type, Scope scope, Unit unit, String name) {
        return AnalyzerUtil.best(name, type.getMatchingMemberDeclarations(unit, scope, "", 0).keySet());
    }

    static List<Type> getTypeArguments(Tree.TypeArguments tas, Type qualifyingType, List<TypeParameter> typeParameters) {
        if (tas instanceof Tree.TypeArgumentList) {
            TypeParameter tp;
            Type dta;
            int i;
            HashMap<TypeParameter, Type> typeArgs = new HashMap<TypeParameter, Type>();
            HashMap<TypeParameter, SiteVariance> vars = new HashMap<TypeParameter, SiteVariance>();
            if (qualifyingType != null) {
                typeArgs.putAll(qualifyingType.getTypeArguments());
                vars.putAll(qualifyingType.getVarianceOverrides());
            }
            Tree.TypeArgumentList tal = (Tree.TypeArgumentList)tas;
            int size = typeParameters.size();
            ArrayList<Type> typeArguments = new ArrayList<Type>(size);
            List<Tree.Type> types = tal.getTypes();
            int count = types.size();
            for (i = 0; i < count; ++i) {
                Tree.StaticType st;
                Tree.TypeVariance tv;
                Tree.Type type = types.get(i);
                Type t = type.getTypeModel();
                if (t == null) {
                    typeArguments.add(null);
                    continue;
                }
                typeArguments.add(t);
                if (i >= size) continue;
                TypeParameter tp2 = typeParameters.get(i);
                if (tp2.isTypeConstructor()) {
                    AnalyzerUtil.setTypeConstructor(type, tp2);
                }
                typeArgs.put(tp2, t);
                if (!(type instanceof Tree.StaticType) || (tv = (st = (Tree.StaticType)type).getTypeVariance()) == null) continue;
                boolean contra = tv.getText().equals("in");
                vars.put(tp2, contra ? SiteVariance.IN : SiteVariance.OUT);
            }
            for (i = typeArguments.size(); i < size && (dta = (tp = typeParameters.get(i)).getDefaultTypeArgument()) != null; ++i) {
                Type da = dta.substitute(typeArgs, vars);
                typeArguments.add(da);
                typeArgs.put(tp, da);
            }
            return typeArguments;
        }
        return Collections.emptyList();
    }

    public static Tree.Statement getLastExecutableStatement(Tree.ClassBody that) {
        List<Tree.Statement> statements = that.getStatements();
        TypecheckerUnit unit = that.getUnit();
        for (int i = statements.size() - 1; i >= 0; --i) {
            Tree.Statement s = statements.get(i);
            if (!AnalyzerUtil.isExecutableStatement(unit, s) && !(s instanceof Tree.Constructor) && !(s instanceof Tree.Enumerated)) continue;
            return s;
        }
        return null;
    }

    static Tree.Declaration getLastConstructor(Tree.ClassBody that) {
        List<Tree.Statement> statements = that.getStatements();
        for (int i = statements.size() - 1; i >= 0; --i) {
            Tree.Statement s = statements.get(i);
            if (!(s instanceof Tree.Constructor) && !(s instanceof Tree.Enumerated)) continue;
            return (Tree.Declaration)s;
        }
        return null;
    }

    static boolean isExecutableStatement(Unit unit, Tree.Statement s) {
        if (s instanceof Tree.SpecifierStatement) {
            Tree.SpecifierStatement ss = (Tree.SpecifierStatement)s;
            Tree.SpecifierExpression se = ss.getSpecifierExpression();
            return !ss.getRefinement() || !(se instanceof Tree.LazySpecifierExpression);
        }
        if (s instanceof Tree.ExecutableStatement) {
            return true;
        }
        if (s instanceof Tree.AttributeDeclaration) {
            Tree.AttributeDeclaration ad = (Tree.AttributeDeclaration)s;
            Tree.SpecifierOrInitializerExpression sie = ad.getSpecifierOrInitializerExpression();
            return sie != null && !(sie instanceof Tree.LazySpecifierExpression);
        }
        if (s instanceof Tree.ObjectDefinition) {
            Type et;
            Tree.ObjectDefinition o = (Tree.ObjectDefinition)s;
            if (o.getExtendedType() != null && (et = o.getExtendedType().getType().getTypeModel()) != null && !et.isObject() && !et.isBasic()) {
                return true;
            }
            Tree.ClassBody body = o.getClassBody();
            return body != null && AnalyzerUtil.getLastExecutableStatement(body) != null;
        }
        return false;
    }

    static String typingMessage(Type type, String problem, Type otherType, Unit unit) {
        String expandedOtherTypeName;
        String expandedTypeName;
        String otherTypeName;
        String typeName;
        HashSet<TypeDeclaration> declarations = new HashSet<TypeDeclaration>();
        type.collectDeclarations(declarations);
        otherType.collectDeclarations(declarations);
        HashSet<String> names = new HashSet<String>();
        for (TypeDeclaration td : declarations) {
            names.add(td.getName(unit));
        }
        String unknownTypeError = type.getFirstUnknownTypeError(true);
        if (names.size() < declarations.size()) {
            typeName = type.asQualifiedString();
            otherTypeName = otherType.asQualifiedString();
            expandedTypeName = type.resolveAliases().asQualifiedString();
            expandedOtherTypeName = otherType.resolveAliases().asQualifiedString();
        } else {
            typeName = type.asString(unit);
            otherTypeName = otherType.asString(unit);
            expandedTypeName = type.resolveAliases().asString(unit);
            expandedOtherTypeName = otherType.resolveAliases().asString(unit);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(": '").append(typeName).append("'");
        if (!typeName.equals(expandedTypeName)) {
            sb.append(" ('").append(expandedTypeName).append("')");
        }
        sb.append(problem);
        sb.append("'").append(otherTypeName).append("'");
        if (!otherTypeName.equals(expandedOtherTypeName)) {
            sb.append(" ('").append(expandedOtherTypeName).append("')");
        }
        if (unknownTypeError != null) {
            sb.append(": ").append(unknownTypeError);
        }
        return sb.toString();
    }

    private static String message(Type type, String problem, Unit unit) {
        String typeName = type.asString(unit);
        String expandedTypeName = type.resolveAliases().asString(unit);
        StringBuilder sb = new StringBuilder();
        sb.append(": '").append(typeName).append("'");
        if (!typeName.equals(expandedTypeName)) {
            sb.append(" ('").append(expandedTypeName).append("')");
        }
        sb.append(problem);
        return sb.toString();
    }

    static boolean checkCallable(Type type, Node node, String message) {
        TypecheckerUnit unit = node.getUnit();
        if (ModelUtil.isTypeUnknown(type)) {
            AnalyzerUtil.addTypeUnknownError(node, type, message);
            return false;
        }
        if (!unit.isCallableType(type)) {
            if (!TreeUtil.hasError(node)) {
                String extra = AnalyzerUtil.message(type, " is not a subtype of 'Callable'", unit);
                if (node instanceof Tree.StaticMemberOrTypeExpression) {
                    Tree.StaticMemberOrTypeExpression smte = (Tree.StaticMemberOrTypeExpression)node;
                    Declaration d = smte.getDeclaration();
                    String name = d.getName();
                    if (d instanceof Interface) {
                        extra = ": '" + name + "' is an interface";
                    } else if (d instanceof TypeAlias) {
                        extra = ": '" + name + "' is a type alias";
                    } else if (d instanceof TypeParameter) {
                        extra = ": '" + name + "' is a type parameter";
                    } else if (d instanceof Value) {
                        extra = ": value '" + name + "' has type '" + type.asString(unit) + "' which is not a subtype of 'Callable'";
                    }
                }
                node.addError(message + extra);
            }
            return false;
        }
        return true;
    }

    static Type checkSupertype(Type type, TypeDeclaration td, Node node, String message) {
        return AnalyzerUtil.checkSupertype(type, false, td, node, message);
    }

    static Type checkSupertype(Type type, boolean unary, TypeDeclaration td, Node node, String message) {
        if (ModelUtil.isTypeUnknown(type)) {
            AnalyzerUtil.addTypeUnknownError(node, type, message);
            return null;
        }
        Type supertype = type.getSupertype(td);
        if (supertype == null) {
            node.addError(message + AnalyzerUtil.message(type, " is not a subtype of '" + td.getName() + "'", node.getUnit()));
        } else if (!unary && !supertype.getVarianceOverrides().isEmpty()) {
            node.addError(message + AnalyzerUtil.message(type, " does not have a principal instantiation for '" + td.getName() + "'", node.getUnit()));
        }
        return supertype;
    }

    static void checkAssignable(Type type, Type supertype, Node node, String message) {
        if (ModelUtil.isTypeUnknown(type)) {
            AnalyzerUtil.addTypeUnknownError(node, type, message);
        } else if (ModelUtil.isTypeUnknown(supertype)) {
            AnalyzerUtil.addTypeUnknownError(node, supertype, message);
        } else if (!type.isSubtypeOf(supertype)) {
            node.addError(message + AnalyzerUtil.notAssignableMessage(type, supertype, node));
        }
    }

    static void checkAssignableWithWarning(Type type, Type supertype, Node node, String message) {
        if (ModelUtil.isTypeUnknown(type)) {
            AnalyzerUtil.addTypeUnknownError(node, type, message);
        } else if (ModelUtil.isTypeUnknown(supertype)) {
            AnalyzerUtil.addTypeUnknownError(node, supertype, message);
        } else if (!type.isSubtypeOf(supertype)) {
            node.addUnsupportedError(message + AnalyzerUtil.notAssignableMessage(type, supertype, node));
        }
    }

    static void checkAssignableToOneOf(Type type, Type supertype1, Type supertype2, Node node, String message, int code) {
        if (ModelUtil.isTypeUnknown(type)) {
            AnalyzerUtil.addTypeUnknownError(node, type, message);
        } else if (ModelUtil.isTypeUnknown(supertype1)) {
            AnalyzerUtil.addTypeUnknownError(node, supertype1, message);
        } else if (ModelUtil.isTypeUnknown(supertype2)) {
            AnalyzerUtil.addTypeUnknownError(node, supertype2, message);
        } else if (!type.isSubtypeOf(supertype1) && !type.isSubtypeOf(supertype2)) {
            node.addError(message + AnalyzerUtil.notAssignableMessage(type, supertype1, node), code);
        }
    }

    static String notAssignableMessage(Type type, Type supertype, Node node) {
        return AnalyzerUtil.typingMessage(type, " is not assignable to ", supertype, node.getUnit());
    }

    static void checkAssignable(Type type, Type supertype, Node node, String message, int code) {
        if (ModelUtil.isTypeUnknown(type)) {
            AnalyzerUtil.addTypeUnknownError(node, type, message);
        } else if (ModelUtil.isTypeUnknown(supertype)) {
            AnalyzerUtil.addTypeUnknownError(node, supertype, message);
        } else if (!type.isSubtypeOf(supertype)) {
            node.addError(message + AnalyzerUtil.notAssignableMessage(type, supertype, node), code);
        }
    }

    static void checkIsExactly(Type type, Type supertype, Node node, String message) {
        if (ModelUtil.isTypeUnknown(type)) {
            AnalyzerUtil.addTypeUnknownError(node, type, message);
        } else if (ModelUtil.isTypeUnknown(supertype)) {
            AnalyzerUtil.addTypeUnknownError(node, supertype, message);
        } else if (!type.isExactly(supertype)) {
            node.addError(message + AnalyzerUtil.notExactlyMessage(type, supertype, node));
        }
    }

    static void checkIsExactly(Type type, Type supertype, Node node, String message, int code) {
        if (ModelUtil.isTypeUnknown(type)) {
            AnalyzerUtil.addTypeUnknownError(node, type, message);
        } else if (ModelUtil.isTypeUnknown(supertype)) {
            AnalyzerUtil.addTypeUnknownError(node, supertype, message);
        } else if (!type.isExactly(supertype)) {
            node.addError(message + AnalyzerUtil.notExactlyMessage(type, supertype, node), code);
        }
    }

    static void checkIsExactlyOneOf(Type type, Type supertype1, Type supertype2, Node node, String message) {
        if (ModelUtil.isTypeUnknown(type)) {
            AnalyzerUtil.addTypeUnknownError(node, type, message);
        } else if (ModelUtil.isTypeUnknown(supertype1)) {
            AnalyzerUtil.addTypeUnknownError(node, supertype1, message);
        } else if (ModelUtil.isTypeUnknown(supertype2)) {
            AnalyzerUtil.addTypeUnknownError(node, supertype2, message);
        } else if (!type.isExactly(supertype1) && !type.isExactly(supertype2)) {
            node.addError(message + AnalyzerUtil.notExactlyMessage(type, supertype1, node));
        }
    }

    static String notExactlyMessage(Type type, Type supertype, Node node) {
        return AnalyzerUtil.typingMessage(type, " is not exactly ", supertype, node.getUnit());
    }

    private static void addTypeUnknownError(Node node, Type type, String message) {
        if (!TreeUtil.hasError(node)) {
            node.addError(message + ": type cannot be determined" + AnalyzerUtil.getTypeUnknownError(type));
        }
    }

    static String getTypeUnknownError(Type type) {
        if (type == null) {
            return "";
        }
        String error = type.getFirstUnknownTypeError();
        if (error != null) {
            return ": " + error;
        }
        return "";
    }

    static boolean inLanguageModule(Unit unit) {
        return unit.getPackage().getQualifiedNameString().startsWith("ceylon.language");
    }

    static String typeDescription(TypeDeclaration td, Unit unit) {
        String name = td.getName();
        if (td instanceof TypeParameter) {
            Declaration container = (Declaration)((Object)td.getContainer());
            return "type parameter '" + name + "' of '" + container.getName(unit) + "'";
        }
        return "type '" + name + "'";
    }

    static String typeNamesAsIntersection(List<Type> upperBounds, Unit unit) {
        if (upperBounds.isEmpty()) {
            return "Anything";
        }
        StringBuilder sb = new StringBuilder();
        for (Type st : upperBounds) {
            sb.append(st.asString(unit)).append(" & ");
        }
        if (sb.toString().endsWith(" & ")) {
            sb.setLength(sb.length() - 3);
        }
        return sb.toString();
    }

    public static boolean isAlwaysSatisfied(Tree.ConditionList cl) {
        if (cl == null) {
            return false;
        }
        for (Tree.Condition c : cl.getConditions()) {
            Tree.BaseMemberExpression bme;
            Declaration d;
            Tree.Term term;
            Tree.BooleanCondition bc;
            Tree.Expression ex;
            if (c instanceof Tree.BooleanCondition && (ex = (bc = (Tree.BooleanCondition)c).getExpression()) != null && (term = TreeUtil.unwrapExpressionUntilTerm(ex)) instanceof Tree.BaseMemberExpression && ModelUtil.isBooleanTrue(d = (bme = (Tree.BaseMemberExpression)term).getDeclaration())) continue;
            return false;
        }
        return true;
    }

    public static boolean isNeverSatisfied(Tree.ConditionList cl) {
        if (cl == null) {
            return false;
        }
        for (Tree.Condition c : cl.getConditions()) {
            Tree.BaseMemberExpression bme;
            Declaration d;
            Tree.Term term;
            Tree.BooleanCondition bc;
            Tree.Expression ex;
            if (!(c instanceof Tree.BooleanCondition) || (ex = (bc = (Tree.BooleanCondition)c).getExpression()) == null || !((term = TreeUtil.unwrapExpressionUntilTerm(ex)) instanceof Tree.BaseMemberExpression) || !ModelUtil.isBooleanFalse(d = (bme = (Tree.BaseMemberExpression)term).getDeclaration())) continue;
            return true;
        }
        return false;
    }

    public static boolean isAtLeastOne(Tree.ForClause forClause) {
        Tree.Expression e;
        Tree.SpecifierExpression se;
        Tree.ForIterator fi = forClause.getForIterator();
        if (fi != null && (se = fi.getSpecifierExpression()) != null && (e = se.getExpression()) != null) {
            TypecheckerUnit unit = forClause.getUnit();
            Type at = unit.getAnythingType();
            Type neit = unit.getNonemptyIterableType(at);
            Type t = e.getTypeModel();
            return t != null && t.isSubtypeOf(neit);
        }
        return false;
    }

    static boolean declaredInPackage(Declaration dec, Unit unit) {
        return dec.getUnit().getPackage().equals(unit.getPackage());
    }

    public static boolean isIndirectInvocation(Tree.InvocationExpression that) {
        return AnalyzerUtil.isIndirectInvocation(that, false);
    }

    public static boolean isIndirectInvocation(Tree.InvocationExpression that, boolean unwrap) {
        return AnalyzerUtil.isIndirectInvocation(that.getPrimary(), unwrap);
    }

    private static boolean isIndirectInvocation(Tree.Primary primary, boolean unwrap) {
        Tree.Term term;
        Tree.Term term2 = term = unwrap ? TreeUtil.unwrapExpressionUntilTerm(primary) : primary;
        if (term instanceof Tree.MemberOrTypeExpression) {
            Tree.MemberOrTypeExpression mte = (Tree.MemberOrTypeExpression)term;
            return AnalyzerUtil.isIndirectInvocation(mte);
        }
        return true;
    }

    private static boolean isIndirectInvocation(Tree.MemberOrTypeExpression that) {
        Reference prf = that.getTarget();
        if (prf == null) {
            return true;
        }
        Declaration d = prf.getDeclaration();
        if (!prf.isFunctional() || d instanceof TypeParameter) {
            return true;
        }
        if (that.getStaticMethodReference()) {
            if (d.isStaticallyImportable() || ModelUtil.isConstructor(d)) {
                Tree.QualifiedMemberOrTypeExpression qmte = (Tree.QualifiedMemberOrTypeExpression)that;
                return AnalyzerUtil.isIndirectInvocation(qmte.getPrimary(), false);
            }
            return true;
        }
        return false;
    }

    static String message(Declaration dec) {
        String qualifier;
        Scope container = dec.getContainer();
        if (container instanceof Declaration) {
            Declaration cd = (Declaration)((Object)container);
            qualifier = " in '" + cd.getName() + "'";
        } else {
            qualifier = "";
        }
        return "'" + dec.getName() + "'" + qualifier;
    }

    static Node getParameterTypeErrorNode(Tree.Parameter p) {
        if (p instanceof Tree.ParameterDeclaration) {
            Tree.ParameterDeclaration pd = (Tree.ParameterDeclaration)p;
            return pd.getTypedDeclaration().getType();
        }
        return p;
    }

    public static Node getTypeErrorNode(Node that) {
        Tree.FunctionArgument fa;
        Tree.TypedArgument ta;
        Tree.TypedDeclaration td;
        Tree.Type type;
        if (that instanceof Tree.TypedDeclaration && (type = (td = (Tree.TypedDeclaration)that).getType()) != null) {
            return type;
        }
        if (that instanceof Tree.TypedArgument && (type = (ta = (Tree.TypedArgument)that).getType()) != null) {
            return type;
        }
        if (that instanceof Tree.FunctionArgument && (type = (fa = (Tree.FunctionArgument)that).getType()) != null && type.getToken() != null) {
            return type;
        }
        return that;
    }

    static void checkIsExactlyForInterop(Unit unit, boolean isCeylon, Type parameterType, Type refinedParameterType, Node node, String message) {
        if (isCeylon) {
            AnalyzerUtil.checkIsExactly(parameterType, refinedParameterType, node, message, 9200);
        } else {
            Type refinedDefiniteType = unit.getDefiniteType(refinedParameterType);
            AnalyzerUtil.checkIsExactlyOneOf(parameterType, refinedParameterType, refinedDefiniteType, node, message);
        }
    }

    public static Type getTupleType(List<Tree.PositionalArgument> es, Unit unit, boolean requireSequential) {
        Type result = unit.getEmptyType();
        Type ut = unit.getNothingType();
        Class td = unit.getTupleDeclaration();
        Interface id = unit.getIterableDeclaration();
        for (int i = es.size() - 1; i >= 0; --i) {
            Tree.PositionalArgument a = es.get(i);
            Type t = a.getTypeModel();
            if (t == null) continue;
            Type et = t;
            if (a instanceof Tree.SpreadArgument) {
                ut = unit.getIteratedType(et);
                result = AnalyzerUtil.spreadType(et, unit, requireSequential);
                continue;
            }
            if (a instanceof Tree.Comprehension) {
                ut = et;
                Tree.Comprehension c = (Tree.Comprehension)a;
                Tree.InitialComprehensionClause icc = c.getInitialComprehensionClause();
                Type type = result = icc.getPossiblyEmpty() ? unit.getSequentialType(et) : unit.getSequenceType(et);
                if (requireSequential) continue;
                Type it = ModelUtil.appliedType((TypeDeclaration)id, et, icc.getFirstTypeModel());
                result = ModelUtil.intersectionType(result, it, unit);
                continue;
            }
            ut = ModelUtil.unionType(ut, et, unit);
            result = ModelUtil.appliedType((TypeDeclaration)td, ut, et, result);
        }
        return result;
    }

    static Type spreadType(Type et, Unit unit, boolean requireSequential) {
        if (et == null) {
            return null;
        }
        if (requireSequential) {
            if (unit.isSequentialType(et)) {
                return et;
            }
            Type it = unit.getIteratedType(et);
            Type st = unit.isNonemptyIterableType(et) ? unit.getSequenceType(it) : unit.getSequentialType(it);
            return st;
        }
        return et;
    }

    static boolean setTypeConstructor(Tree.Type t, TypeParameter typeParam) {
        Tree.SimpleType s;
        Type pt = t.getTypeModel();
        if (pt == null) {
            return false;
        }
        if (t instanceof Tree.SimpleType && (s = (Tree.SimpleType)t).getTypeArgumentList() == null && (typeParam != null || AnalyzerUtil.isGeneric(s.getDeclarationModel()))) {
            pt.setTypeConstructor(true);
            pt.setTypeConstructorParameter(typeParam);
        }
        return pt.isTypeConstructor();
    }

    static boolean isGeneric(Declaration member) {
        if (member instanceof Generic) {
            Generic g = (Generic)((Object)member);
            return !g.getTypeParameters().isEmpty();
        }
        return false;
    }

    static boolean inSameModule(TypeDeclaration etd, Unit unit) {
        return etd.getUnit().getPackage().getModule().equals(unit.getPackage().getModule());
    }

    static void checkCasesDisjoint(Type type, Type other, Node node) {
        if (!ModelUtil.isTypeUnknown(type) && !ModelUtil.isTypeUnknown(other)) {
            TypecheckerUnit unit = node.getUnit();
            Type it = ModelUtil.intersectionType(type.resolveAliases(), other.resolveAliases(), unit);
            if (!it.isNothing()) {
                node.addError("cases are not disjoint: '" + type.asString(unit) + "' and '" + other.asString(unit) + "'");
            }
        }
    }

    static Parameter getMatchingParameter(ParameterList pl, Tree.NamedArgument na, Set<Parameter> foundParameters) {
        Tree.Identifier id = na.getIdentifier();
        if (id == null) {
            for (Parameter p : pl.getParameters()) {
                if (foundParameters.contains(p)) continue;
                return p;
            }
        } else {
            String name = TreeUtil.name(id);
            for (Parameter p : pl.getParameters()) {
                if (p.getName() == null || !p.getName().equals(name)) continue;
                return p;
            }
        }
        return null;
    }

    static Parameter getUnspecifiedParameter(Reference pr, ParameterList pl, Set<Parameter> foundParameters) {
        for (Parameter p : pl.getParameters()) {
            Type t = pr == null ? p.getType() : pr.getTypedParameter(p).getFullType();
            if (t == null) continue;
            t = t.resolveAliases();
            if (foundParameters.contains(p) || !p.getDeclaration().getUnit().isIterableParameterType(t)) continue;
            return p;
        }
        return null;
    }

    static boolean involvesTypeParams(Declaration dec, Type type) {
        if (AnalyzerUtil.isGeneric(dec)) {
            Generic g = (Generic)((Object)dec);
            return type.involvesTypeParameters(g);
        }
        return false;
    }

    static TypeDeclaration unwrapAliasedTypeConstructor(TypeDeclaration dec) {
        Type et;
        TypeDeclaration d = dec;
        while (!AnalyzerUtil.isGeneric(d) && d.isAlias() && (et = d.getExtendedType()) != null) {
            et = et.resolveAliases();
            d = et.getDeclaration();
            if (!et.isTypeConstructor() || !AnalyzerUtil.isGeneric(d)) continue;
            return d;
        }
        return dec;
    }

    static Type unwrapAliasedTypeConstructor(Type type) {
        Type et;
        TypeDeclaration d = type.getDeclaration();
        while (!AnalyzerUtil.isGeneric(d) && d.isAlias() && (et = d.getExtendedType()) != null) {
            d = et.getDeclaration();
            if (!(et = et.resolveAliases()).isTypeConstructor() || !AnalyzerUtil.isGeneric(d)) continue;
            return et;
        }
        return type;
    }

    static Package importedPackage(Tree.ImportPath path) {
        if (path != null && !path.getIdentifiers().isEmpty()) {
            String nameToImport = TreeUtil.formatPath(path.getIdentifiers());
            Module module = path.getUnit().getPackage().getModule();
            Package pkg = module.getPackage(nameToImport);
            if (pkg != null) {
                if (pkg.getModule().equals(module)) {
                    return pkg;
                }
                if (!pkg.isShared()) {
                    path.addError("imported package is not shared: '" + nameToImport + "'", 402);
                }
                HashSet<Module> visited = new HashSet<Module>();
                for (ModuleImport mi : module.getImports()) {
                    if (!AnalyzerUtil.findModuleInTransitiveImports(mi.getModule(), pkg.getModule(), visited)) continue;
                    return pkg;
                }
            } else {
                for (ModuleImport mi : module.getImports()) {
                    if (!mi.isNative()) continue;
                    String name = mi.getModule().getNameAsString();
                    if (!ModelUtil.isForBackend(mi.getNativeBackends(), path.getUnit()) && (nameToImport.equals(name) || nameToImport.startsWith(name + "."))) {
                        return null;
                    }
                    if (ModelUtil.isForBackend(Backend.Java.asSet(), path.getUnit()) || !JDKUtils.isJDKAnyPackage(nameToImport) && !JDKUtils.isOracleJDKAnyPackage(nameToImport)) continue;
                    return null;
                }
            }
            String help = module.isDefault() ? " (define a module and add module import to its module descriptor)" : " (add module import to module descriptor of '" + module.getNameAsString() + "')";
            path.addError("package not found in imported modules: '" + nameToImport + "'" + help, 7000);
        }
        return null;
    }

    static Module importedModule(Tree.ImportPath path) {
        if (path != null && !path.getIdentifiers().isEmpty()) {
            String nameToImport = TreeUtil.formatPath(path.getIdentifiers());
            Module module = path.getUnit().getPackage().getModule();
            Package pkg = module.getPackage(nameToImport);
            if (pkg != null) {
                Module mod = pkg.getModule();
                if (!pkg.getNameAsString().equals(mod.getNameAsString())) {
                    path.addError("not a module: '" + nameToImport + "'");
                    return null;
                }
                if (mod.equals(module)) {
                    return mod;
                }
                HashSet<Module> visited = new HashSet<Module>();
                for (ModuleImport mi : module.getImports()) {
                    Module m = mi.getModule();
                    if (!AnalyzerUtil.findModuleInTransitiveImports(m, mod, visited)) continue;
                    return mod;
                }
            }
            path.addError("module not found in imported modules: '" + nameToImport + "'", 7000);
        }
        return null;
    }

    private static boolean findModuleInTransitiveImports(Module moduleToVisit, Module moduleToFind, Set<Module> visited) {
        if (!visited.add(moduleToVisit)) {
            return false;
        }
        if (moduleToVisit.equals(moduleToFind)) {
            return true;
        }
        for (ModuleImport imp : moduleToVisit.getImports()) {
            if (!imp.isExport() || !AnalyzerUtil.findModuleInTransitiveImports(imp.getModule(), moduleToFind, visited)) continue;
            return true;
        }
        return false;
    }

    static boolean isVeryAbstractClass(Tree.ClassDefinition that, Unit unit) {
        String pname = unit.getPackage().getQualifiedNameString();
        String name = TreeUtil.name(that.getIdentifier());
        return "ceylon.language".equals(pname) && ("Anything".equalsIgnoreCase(name) || "Object".equalsIgnoreCase(name) || "Basic".equalsIgnoreCase(name) || "Null".equalsIgnoreCase(name));
    }
}

