/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.typechecker.analyzer;

import com.redhat.ceylon.common.Backends;
import com.redhat.ceylon.compiler.typechecker.analyzer.AnalyzerUtil;
import com.redhat.ceylon.compiler.typechecker.analyzer.TypeArgumentInference;
import com.redhat.ceylon.compiler.typechecker.analyzer.Warning;
import com.redhat.ceylon.compiler.typechecker.context.TypecheckerUnit;
import com.redhat.ceylon.compiler.typechecker.tree.CustomTree;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.TreeUtil;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.compiler.typechecker.util.NativeUtil;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.Constructor;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.Functional;
import com.redhat.ceylon.model.typechecker.model.Generic;
import com.redhat.ceylon.model.typechecker.model.Interface;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.ModuleImport;
import com.redhat.ceylon.model.typechecker.model.NothingType;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.ParameterList;
import com.redhat.ceylon.model.typechecker.model.Reference;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Setter;
import com.redhat.ceylon.model.typechecker.model.SiteVariance;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeAlias;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypedReference;
import com.redhat.ceylon.model.typechecker.model.Unit;
import com.redhat.ceylon.model.typechecker.model.UnknownType;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExpressionVisitor
extends Visitor {
    private Tree.Type returnType;
    private Declaration returnDeclaration;
    private boolean dynamic;
    private boolean inExtendsClause = false;
    private TypeDeclaration constructorClass;
    private Node ifStatementOrExpression;
    private Node switchStatementOrExpression;
    private TypecheckerUnit unit;
    private boolean declarationLiteral = false;
    private boolean modelLiteral = false;

    private Tree.IfClause ifClause() {
        if (this.ifStatementOrExpression instanceof Tree.IfStatement) {
            Tree.IfStatement is = (Tree.IfStatement)this.ifStatementOrExpression;
            return is.getIfClause();
        }
        if (this.ifStatementOrExpression instanceof Tree.IfExpression) {
            Tree.IfExpression ie = (Tree.IfExpression)this.ifStatementOrExpression;
            return ie.getIfClause();
        }
        return null;
    }

    private Tree.SwitchClause switchClause() {
        if (this.switchStatementOrExpression instanceof Tree.SwitchStatement) {
            Tree.SwitchStatement ss = (Tree.SwitchStatement)this.switchStatementOrExpression;
            return ss.getSwitchClause();
        }
        if (this.switchStatementOrExpression instanceof Tree.SwitchExpression) {
            Tree.SwitchExpression se = (Tree.SwitchExpression)this.switchStatementOrExpression;
            return se.getSwitchClause();
        }
        return null;
    }

    private Tree.SwitchCaseList switchCaseList() {
        if (this.switchStatementOrExpression instanceof Tree.SwitchStatement) {
            Tree.SwitchStatement ss = (Tree.SwitchStatement)this.switchStatementOrExpression;
            return ss.getSwitchCaseList();
        }
        if (this.switchStatementOrExpression instanceof Tree.SwitchExpression) {
            Tree.SwitchExpression se = (Tree.SwitchExpression)this.switchStatementOrExpression;
            return se.getSwitchCaseList();
        }
        return null;
    }

    public ExpressionVisitor() {
    }

    public ExpressionVisitor(TypecheckerUnit unit) {
        this.unit = unit;
    }

    @Override
    public void visit(Tree.CompilationUnit that) {
        this.unit = that.getUnit();
        super.visit(that);
    }

    private Declaration beginReturnDeclaration(Declaration d) {
        Declaration od = this.returnDeclaration;
        this.returnDeclaration = d;
        return od;
    }

    private void endReturnDeclaration(Declaration od) {
        this.returnDeclaration = od;
    }

    private Tree.Type beginReturnScope(Tree.Type t) {
        Tree.Type ort = this.returnType;
        this.returnType = t;
        if (this.returnType instanceof Tree.FunctionModifier || this.returnType instanceof Tree.ValueModifier) {
            this.returnType.setTypeModel(this.unit.getNothingType());
        }
        return ort;
    }

    private void endReturnScope(Tree.Type t, TypedDeclaration td) {
        if (this.returnType instanceof Tree.FunctionModifier || this.returnType instanceof Tree.ValueModifier) {
            td.setType(this.returnType.getTypeModel());
        }
        this.returnType = t;
    }

    @Override
    public void visit(Tree.FunctionArgument that) {
        Type fullType;
        Tree.Expression e = that.getExpression();
        Function fun = that.getDeclarationModel();
        Tree.Type type = that.getType();
        if (e == null) {
            Tree.Type ret = fun.isDeclaredVoid() && !(type instanceof Tree.VoidModifier) ? new Tree.VoidModifier(null) : type;
            Tree.Type rt = this.beginReturnScope(ret);
            Declaration od = this.beginReturnDeclaration(fun);
            super.visit(that);
            this.endReturnDeclaration(od);
            this.endReturnScope(rt, fun);
        } else {
            super.visit(that);
            Type returnType = this.unit.denotableType(e.getTypeModel());
            fun.setType(returnType);
            type.setTypeModel(returnType);
            if (type instanceof Tree.VoidModifier && !this.isSatementExpression(e)) {
                e.addError("anonymous function is declared void so specified expression must be a statement");
            }
        }
        if (fun.isDeclaredVoid()) {
            fun.setType(this.unit.getAnythingType());
        }
        TypedReference reference = fun.getTypedReference();
        if (AnalyzerUtil.isGeneric(fun)) {
            Scope scope = that.getScope();
            fullType = ModelUtil.genericFunctionType(fun, scope, fun, reference, this.unit);
        } else {
            fullType = reference.getFullType();
        }
        that.setTypeModel(fullType);
        Tree.TypeParameterList tpl = that.getTypeParameterList();
        if (tpl != null) {
            NativeUtil.checkNotJvm(tpl, "type functions are not supported on the JVM");
        }
    }

    @Override
    public void visit(Tree.IfExpression that) {
        Node ose = this.switchStatementOrExpression;
        Node oie = this.ifStatementOrExpression;
        this.switchStatementOrExpression = null;
        this.ifStatementOrExpression = that;
        super.visit(that);
        ArrayList<Type> list = new ArrayList<Type>();
        Tree.IfClause ifClause = that.getIfClause();
        if (ifClause != null && ifClause.getExpression() != null) {
            Type t = ifClause.getExpression().getTypeModel();
            if (t != null) {
                ModelUtil.addToUnion(list, t);
            }
        } else {
            that.addError("missing then expression");
        }
        Tree.ElseClause elseClause = that.getElseClause();
        if (elseClause != null && elseClause.getExpression() != null) {
            Type t = elseClause.getExpression().getTypeModel();
            if (t != null) {
                ModelUtil.addToUnion(list, t);
            }
        } else {
            that.addError("missing else expression");
        }
        that.setTypeModel(ModelUtil.union(list, this.unit));
        this.switchStatementOrExpression = ose;
        this.ifStatementOrExpression = oie;
    }

    @Override
    public void visit(Tree.Switched that) {
        Tree.Variable variable = that.getVariable();
        if (variable != null && variable.getSpecifierExpression() == null) {
            that.addError("missing specified expression");
        }
        super.visit(that);
    }

    @Override
    public void visit(Tree.SwitchExpression that) {
        Node ose = this.switchStatementOrExpression;
        Node oie = this.ifStatementOrExpression;
        this.switchStatementOrExpression = that;
        this.ifStatementOrExpression = null;
        super.visit(that);
        Tree.SwitchCaseList switchCaseList = that.getSwitchCaseList();
        Tree.SwitchClause switchClause = that.getSwitchClause();
        this.checkCasesExhaustive(switchClause, switchCaseList);
        if (switchCaseList != null) {
            Type t;
            Tree.Expression e;
            ArrayList<Type> list = new ArrayList<Type>();
            for (Tree.CaseClause cc : that.getSwitchCaseList().getCaseClauses()) {
                Type t2;
                Tree.Expression e2 = cc.getExpression();
                if (e2 == null || (t2 = e2.getTypeModel()) == null) continue;
                ModelUtil.addToUnion(list, t2);
            }
            Tree.ElseClause elseClause = that.getSwitchCaseList().getElseClause();
            if (elseClause != null && (e = elseClause.getExpression()) != null && (t = e.getTypeModel()) != null) {
                ModelUtil.addToUnion(list, t);
            }
            that.setTypeModel(ModelUtil.union(list, this.unit));
        }
        this.switchStatementOrExpression = ose;
        this.ifStatementOrExpression = oie;
    }

    @Override
    public void visit(Tree.ExpressionComprehensionClause that) {
        super.visit(that);
        that.setTypeModel(that.getExpression().getTypeModel());
        that.setFirstTypeModel(this.unit.getNothingType());
    }

    @Override
    public void visit(Tree.ForComprehensionClause that) {
        super.visit(that);
        that.setPossiblyEmpty(true);
        Tree.ComprehensionClause cc = that.getComprehensionClause();
        if (cc != null) {
            Type it;
            Tree.Expression e;
            Tree.SpecifierExpression se;
            that.setTypeModel(cc.getTypeModel());
            Tree.ForIterator fi = that.getForIterator();
            if (fi != null && (se = fi.getSpecifierExpression()) != null && (e = se.getExpression()) != null && (it = e.getTypeModel()) != null) {
                if (!(this.unit.isIterableType(it) || this.unit.isJavaIterableType(it) || this.unit.isJavaArrayType(it))) {
                    se.addError("expression is not iterable: '" + it.asString(this.unit) + "' is not a subtype of 'Iterable'");
                }
                that.setPossiblyEmpty(cc.getPossiblyEmpty() || !this.unit.isNonemptyIterableType(it));
                Type firstType = ModelUtil.unionType(this.unit.getAbsentType(it), cc.getFirstTypeModel(), this.unit);
                that.setFirstTypeModel(firstType);
            }
        }
    }

    @Override
    public void visit(Tree.IfComprehensionClause that) {
        super.visit(that);
        that.setPossiblyEmpty(true);
        that.setFirstTypeModel(this.unit.getNullType());
        Tree.ComprehensionClause cc = that.getComprehensionClause();
        if (cc != null) {
            that.setTypeModel(cc.getTypeModel());
        }
    }

    @Override
    public void visit(Tree.Destructure that) {
        Tree.Expression e;
        super.visit(that);
        Tree.Pattern pattern = that.getPattern();
        Tree.SpecifierExpression se = that.getSpecifierExpression();
        if (se != null && (e = se.getExpression()) != null) {
            this.destructure(pattern, se, e.getTypeModel());
        }
    }

    private void destructure(Tree.Pattern pattern, Tree.SpecifierExpression se, Type type) {
        if (type != null) {
            type = type.resolveAliases();
            if (pattern instanceof Tree.TuplePattern) {
                this.destructure(se, type, (Tree.TuplePattern)pattern);
            } else if (pattern instanceof Tree.KeyValuePattern) {
                this.destructure(se, type, (Tree.KeyValuePattern)pattern);
            } else {
                Tree.VariablePattern vp = (Tree.VariablePattern)pattern;
                Tree.Variable var = vp.getVariable();
                Tree.Type varType = var.getType();
                if (varType != null) {
                    if (varType instanceof Tree.SequencedType) {
                        this.inferSequencedValueType(type, var);
                    } else {
                        this.inferValueType(var, type);
                    }
                    Type declaredType = varType.getTypeModel();
                    AnalyzerUtil.checkAssignable(type, declaredType, var, "type of element of assigned value must be a subtype of declared type of pattern variable");
                }
            }
        }
    }

    private void inferSequencedValueType(Type type, Tree.Variable var) {
        Tree.SequencedType st = (Tree.SequencedType)var.getType();
        if (st.getType() instanceof Tree.ValueModifier && type != null) {
            Type set = this.unit.getSequentialElementType(type);
            st.getType().setTypeModel(set);
            this.setSequencedValueType(st, type, var);
        }
    }

    private void destructure(Tree.SpecifierExpression se, Type entryType, Tree.KeyValuePattern keyValuePattern) {
        Tree.Pattern key = keyValuePattern.getKey();
        Tree.Pattern value = keyValuePattern.getValue();
        if (entryType.isExactlyNothing()) {
            se.addError("assigned expression has bottom type 'Nothing', so may not be destructured");
        } else if (!this.unit.isEntryType(entryType)) {
            se.addError("assigned expression is not an entry type, so may not be destructured: '" + entryType.asString(this.unit) + "' is not an entry type");
        } else {
            this.destructure(key, se, this.unit.getKeyType(entryType));
            this.destructure(value, se, this.unit.getValueType(entryType));
        }
    }

    private void destructure(Tree.SpecifierExpression se, Type sequenceType, Tree.TuplePattern tuplePattern) {
        List<Tree.Pattern> patterns = tuplePattern.getPatterns();
        int length = patterns.size();
        if (length == 0) {
            tuplePattern.addError("tuple pattern must have at least one variable");
        } else if (sequenceType.isExactlyNothing()) {
            se.addError("assigned expression has bottom type 'Nothing', so may not be destructured");
        } else {
            for (int i = 0; i < length - 1; ++i) {
                Tree.VariablePattern vp;
                Tree.Type t;
                Tree.Pattern p = patterns.get(i);
                if (!(p instanceof Tree.VariablePattern) || !((t = (vp = (Tree.VariablePattern)p).getVariable().getType()) instanceof Tree.SequencedType)) continue;
                t.addError("variadic pattern element must occur as last element of tuple pattern");
            }
            Tree.Pattern lastPattern = patterns.get(length - 1);
            if (!this.unit.isSequentialType(sequenceType)) {
                se.addError("assigned expression is not a sequence type, so may not be destructured: '" + sequenceType.asString(this.unit) + "' is not a subtype of 'Sequential'");
            } else if (this.unit.isEmptyType(sequenceType)) {
                se.addError("assigned expression is an empty sequence type, so may not be destructured: '" + sequenceType.asString(this.unit) + "' is a subtype of 'Empty'");
            } else if (this.unit.isTupleType(sequenceType)) {
                this.destructureTuple(se, sequenceType, patterns, length, lastPattern);
            } else {
                this.destructureSequence(se, sequenceType, patterns, length, lastPattern);
            }
        }
    }

    private boolean isVariadicPattern(Tree.Pattern lastPattern) {
        Tree.VariablePattern variablePattern;
        Tree.Type type;
        boolean variadic = false;
        if (lastPattern instanceof Tree.VariablePattern && (type = (variablePattern = (Tree.VariablePattern)lastPattern).getVariable().getType()) instanceof Tree.SequencedType) {
            variadic = true;
        }
        return variadic;
    }

    private void destructureTuple(Tree.SpecifierExpression se, Type sequenceType, List<Tree.Pattern> patterns, int length, Tree.Pattern lastPattern) {
        int i;
        boolean variadic = this.isVariadicPattern(lastPattern);
        List<Type> types = this.unit.getTupleElementTypes(sequenceType);
        boolean tupleLengthUnbounded = this.unit.isTupleLengthUnbounded(sequenceType);
        int minimumLength = this.unit.getTupleMinimumLength(sequenceType);
        if (!variadic && types.size() > length) {
            se.addError("assigned tuple has too many elements");
        }
        if (!variadic && tupleLengthUnbounded) {
            se.addError("assigned tuple has unbounded length");
        }
        if (!variadic && minimumLength < types.size()) {
            se.addError("assigned tuple has variadic length");
        }
        int fixedLength = variadic ? length - 1 : length;
        for (i = 0; i < types.size() && i < fixedLength; ++i) {
            Type type = types.get(i);
            Tree.Pattern pattern = patterns.get(i);
            this.destructure(pattern, se, type);
        }
        if (variadic) {
            Type tail = this.unit.getTailType(sequenceType, fixedLength);
            this.destructure(lastPattern, se, tail);
        }
        for (i = types.size(); i < length; ++i) {
            Node errNode;
            Tree.Pattern pattern = patterns.get(i);
            if (pattern instanceof Tree.VariablePattern) {
                Tree.VariablePattern vp = (Tree.VariablePattern)pattern;
                errNode = vp.getVariable();
            } else {
                errNode = pattern;
            }
            errNode.addError("assigned tuple has too few elements");
        }
    }

    private void destructureSequence(Tree.SpecifierExpression se, Type sequenceType, List<Tree.Pattern> patterns, int length, Tree.Pattern lastPattern) {
        boolean variadic = this.isVariadicPattern(lastPattern);
        if (!variadic) {
            se.addError("assigned expression is not a tuple type, so pattern must end in a variadic element: '" + sequenceType.asString(this.unit) + "' is not a tuple type");
        } else if (length > 2) {
            se.addError("assigned expression is not a tuple type, so pattern must not have more than two elements: '" + sequenceType.asString(this.unit) + "' is not a tuple type");
        } else if (length > 1 && !this.unit.isSequenceType(sequenceType)) {
            se.addError("assigned expression is not a nonempty sequence type, so pattern must have exactly one element: '" + sequenceType.asString(this.unit) + "' is not a subtype of 'Sequence'");
        }
        if (length > 1) {
            Type elementType = this.unit.getSequentialElementType(sequenceType);
            this.destructure(patterns.get(0), se, elementType);
            this.destructure(lastPattern, se, this.unit.getSequentialType(elementType));
        } else {
            this.destructure(lastPattern, se, sequenceType);
        }
    }

    @Override
    public void visit(Tree.Variable that) {
        super.visit(that);
        if (that instanceof CustomTree.GuardedVariable) {
            CustomTree.GuardedVariable gv = (CustomTree.GuardedVariable)that;
            this.setTypeForElseVariable(that, gv.getConditionList());
            Tree.BaseMemberExpression bme = (Tree.BaseMemberExpression)that.getSpecifierExpression().getExpression().getTerm();
            Declaration original = bme.getDeclaration();
            if (original instanceof TypedDeclaration) {
                that.getDeclarationModel().setOriginalDeclaration((TypedDeclaration)original);
            }
        } else {
            Tree.SpecifierExpression se = that.getSpecifierExpression();
            if (se != null) {
                Type t;
                this.inferType(that, (Tree.SpecifierOrInitializerExpression)se);
                Tree.Type type = that.getType();
                if (type != null && !ModelUtil.isTypeUnknown(t = type.getTypeModel())) {
                    this.checkType(t, se);
                }
            }
        }
    }

    @Override
    public void visit(Tree.ConditionList that) {
        if (that.getConditions().isEmpty()) {
            that.addError("empty condition list");
        }
        super.visit(that);
    }

    @Override
    public void visit(Tree.ResourceList that) {
        if (that.getResources().isEmpty()) {
            that.addError("empty resource list");
        }
        super.visit(that);
    }

    private void initOriginalDeclaration(Tree.Variable that) {
        if (that.getType() instanceof Tree.SyntheticVariable) {
            Value td = that.getDeclarationModel();
            Tree.BaseMemberExpression bme = (Tree.BaseMemberExpression)that.getSpecifierExpression().getExpression().getTerm();
            TypedDeclaration d = (TypedDeclaration)bme.getDeclaration();
            td.setOriginalDeclaration(d);
        }
    }

    @Override
    public void visit(Tree.IsCondition that) {
        Type type;
        Tree.Type t = that.getType();
        if (t != null) {
            t.visit(this);
        }
        Tree.Variable v = that.getVariable();
        Type type2 = type = t == null ? null : t.getTypeModel();
        if (v != null) {
            Type it;
            Type knownType;
            Tree.SpecifierExpression se = v.getSpecifierExpression();
            if (se == null) {
                knownType = null;
            } else {
                se.visit(this);
                this.checkReferenceIsNonVariable(v, se);
                this.initOriginalDeclaration(v);
                Tree.Expression e = se.getExpression();
                Type type3 = knownType = e == null ? null : e.getTypeModel();
                if (knownType != null) {
                    if (TreeUtil.hasUncheckedNulls(e)) {
                        knownType = this.unit.getOptionalType(knownType);
                    }
                    String help = " (expression is already of the specified type)";
                    if (that.getNot()) {
                        if (ModelUtil.intersectionType(type, knownType, this.unit).isNothing()) {
                            that.addError("does not narrow type: intersection of '" + type.asString(this.unit) + "' and '" + knownType.asString(this.unit) + "' is empty" + help);
                        } else if (knownType.isSubtypeOf(type)) {
                            that.addError("tests assignability to bottom type 'Nothing': '" + knownType.asString(this.unit) + "' is a subtype of '" + type.asString(this.unit) + "'");
                        }
                    } else if (knownType.isSubtypeOf(type)) {
                        that.addError("does not narrow type: '" + knownType.asString(this.unit) + "' is a subtype of '" + type.asString(this.unit) + "'" + help);
                    }
                }
            }
            this.defaultTypeToAnything(v);
            if (knownType == null) {
                knownType = this.unit.getAnythingType();
            }
            if ((it = this.narrow(type, knownType, that.getNot())).isNothing() && !that.getNot()) {
                that.addError("tests assignability to bottom type 'Nothing': intersection of '" + knownType.asString(this.unit) + "' and '" + type.asString(this.unit) + "' is empty");
            }
            knownType = this.unit.denotableType(knownType);
            it = this.narrow(type, knownType, that.getNot());
            v.getType().setTypeModel(it);
            v.getDeclarationModel().setType(it);
        }
    }

    private Type narrow(Type type, Type knownType, boolean not) {
        Type it = not ? knownType.minus(type) : ModelUtil.intersectionType(type, knownType, this.unit);
        return it;
    }

    @Override
    public void visit(Tree.SatisfiesCondition that) {
        super.visit(that);
        that.addUnsupportedError("satisfies conditions not yet supported");
    }

    @Override
    public void visit(Tree.ExistsOrNonemptyCondition that) {
        Type t = null;
        Tree.Term term = null;
        Tree.Statement s = that.getVariable();
        if (s instanceof Tree.Variable) {
            Tree.Variable v = (Tree.Variable)s;
            this.defaultTypeToAnything(v);
            Tree.SpecifierExpression se = v.getSpecifierExpression();
            if (se == null) {
                v.addError("missing specifier");
            } else {
                Tree.Expression e = se.getExpression();
                if (e != null) {
                    se.visit(this);
                    boolean not = that.getNot();
                    if (that instanceof Tree.ExistsCondition) {
                        this.inferDefiniteType(v, se, not);
                        this.checkOptionalType(v, se, not);
                    } else if (that instanceof Tree.NonemptyCondition) {
                        this.inferNonemptyType(v, se, not);
                        this.checkEmptyOptionalType(v, se, not);
                    }
                    t = e.getTypeModel();
                    this.checkReferenceIsNonVariable(v, se);
                    this.initOriginalDeclaration(v);
                    term = e.getTerm();
                }
            }
        } else if (s instanceof Tree.Destructure) {
            Tree.Expression e;
            Tree.SpecifierExpression se;
            Tree.Destructure d = (Tree.Destructure)s;
            if (that.getNot()) {
                that.addError("negated conditions do not support destructuring");
            }
            if ((se = d.getSpecifierExpression()) != null && (e = se.getExpression()) != null) {
                se.visit(this);
                t = e.getTypeModel();
                if (!ModelUtil.isTypeUnknown(t)) {
                    Type type = null;
                    if (that instanceof Tree.ExistsCondition) {
                        type = this.unit.getDefiniteType(t);
                    } else if (that instanceof Tree.NonemptyCondition) {
                        type = this.unit.getNonemptyDefiniteType(t);
                    }
                    if (!ModelUtil.isTypeUnknown(type) && !type.isNothing()) {
                        Tree.Pattern pattern = d.getPattern();
                        this.destructure(pattern, se, type);
                    }
                }
                term = e.getTerm();
            }
        }
        if (that instanceof Tree.ExistsCondition) {
            this.checkOptional(t, term);
        } else if (that instanceof Tree.NonemptyCondition) {
            this.checkEmpty(t, term);
        }
    }

    private void defaultTypeToAnything(Tree.Variable v) {
        v.getType().visit(this);
        Value dec = v.getDeclarationModel();
        if (dec.getType() == null) {
            dec.setType(this.defaultType());
        }
    }

    private void checkReferenceIsNonVariable(Tree.Variable v, Tree.SpecifierExpression se) {
        if (v.getType() instanceof Tree.SyntheticVariable) {
            Tree.BaseMemberExpression term = (Tree.BaseMemberExpression)se.getExpression().getTerm();
            this.checkReferenceIsNonVariable(term, false);
        }
    }

    private void checkReferenceIsNonVariable(Tree.BaseMemberExpression ref, boolean isSwitch) {
        Declaration d = ref.getDeclaration();
        if (d != null) {
            int code = isSwitch ? 3101 : 3100;
            String help = " (assign to a new local value to narrow type)";
            if (!(d instanceof Value)) {
                ref.addError("referenced declaration is not a value: '" + d.getName(this.unit) + "'", code);
            } else if (this.isNonConstant(d)) {
                ref.addError("referenced value is non-constant: '" + d.getName(this.unit) + "'" + help, code);
            } else if (d.isDefault() || d.isFormal()) {
                ref.addError("referenced value may be refined by a non-constant value: '" + d.getName(this.unit) + "'" + help, code);
            }
        }
    }

    private boolean isNonConstant(Declaration d) {
        if (d instanceof Value) {
            Value v = (Value)d;
            return v.isVariable() || v.isTransient();
        }
        return false;
    }

    private void checkEmpty(Type t, Tree.Term term) {
        if (!ModelUtil.isTypeUnknown(t)) {
            if (!this.unit.isSequentialType(this.unit.getDefiniteType(t))) {
                term.addError("expression must be a possibly-empty sequential type: '" + t.asString(this.unit) + "' is not a subtype of 'Anything[]?'");
            } else if (!this.unit.isPossiblyEmptyType(t)) {
                term.addError("expression must be a possibly-empty sequential type: '" + t.asString(this.unit) + "' is not possibly-empty");
            }
        }
    }

    private void checkOptional(Type type, Tree.Term term) {
        if (!(ModelUtil.isTypeUnknown(type) || this.unit.isOptionalType(type) || TreeUtil.hasUncheckedNulls(term))) {
            term.addError("expression must be of optional type: '" + type.asString(this.unit) + "' is not optional");
        }
    }

    private void checkIterable(Type pt, Tree.Primary p) {
        if (!this.unit.isIterableType(pt)) {
            p.addError("expression must be of iterable type: '" + pt.asString(this.unit) + "' is not a subtype of 'Iterable'");
        }
    }

    @Override
    public void visit(Tree.BooleanCondition that) {
        Type t;
        super.visit(that);
        if (that.getExpression() != null && !ModelUtil.isTypeUnknown(t = that.getExpression().getTypeModel())) {
            AnalyzerUtil.checkAssignable(t, this.unit.getBooleanType(), that, "expression must be of boolean type");
        }
    }

    @Override
    public void visit(Tree.Resource that) {
        super.visit(that);
        Type t = null;
        Node typedNode = null;
        Tree.Expression e = that.getExpression();
        Tree.Variable v = that.getVariable();
        if (e != null) {
            t = e.getTypeModel();
            typedNode = e;
        } else if (v != null) {
            t = v.getType().getTypeModel();
            typedNode = v.getType();
            Tree.SpecifierExpression se = v.getSpecifierExpression();
            if (se == null) {
                v.addError("missing resource specifier");
            } else {
                e = se.getExpression();
                if (typedNode instanceof Tree.ValueModifier) {
                    typedNode = se.getExpression();
                }
            }
        } else {
            that.addError("missing resource expression");
        }
        if (typedNode != null && !ModelUtil.isTypeUnknown(t) && e != null) {
            Type ot = this.unit.getObtainableType();
            Type dt = this.unit.getDestroyableType();
            Type act = this.unit.getJavaAutoCloseableType();
            if (!t.isSubtypeOf(act)) {
                if (TreeUtil.isInstantiationExpression(e)) {
                    if (!t.isSubtypeOf(dt) && !t.isSubtypeOf(ot)) {
                        typedNode.addError("resource must be either obtainable or destroyable: '" + t.asString(this.unit) + "' is neither 'Obtainable' nor 'Destroyable'");
                    }
                } else {
                    AnalyzerUtil.checkAssignable(t, ot, typedNode, "resource must be obtainable");
                }
            }
        }
    }

    @Override
    public void visit(Tree.ForIterator that) {
        Type et;
        Tree.Expression e;
        super.visit(that);
        Tree.SpecifierExpression se = that.getSpecifierExpression();
        if (se != null && (e = se.getExpression()) != null && !ModelUtil.isTypeUnknown(et = e.getTypeModel())) {
            if (!(this.unit.isIterableType(et) || this.unit.isJavaIterableType(et) || this.unit.isJavaObjectArrayType(et) || this.unit.isJavaPrimitiveArrayType(et))) {
                se.addError("expression is not iterable: '" + et.asString(this.unit) + "' is not a subtype of 'Iterable'");
            } else if (et != null && this.unit.isEmptyType(et)) {
                se.addError("iterated expression is definitely empty: '" + et.asString(this.unit) + "' is a subtype of 'Empty'");
            }
        }
    }

    @Override
    public void visit(Tree.ValueIterator that) {
        super.visit(that);
        Tree.Variable v = that.getVariable();
        if (v != null) {
            this.inferContainedType(v, that.getSpecifierExpression());
            this.checkContainedType(v, that.getSpecifierExpression());
        }
    }

    @Override
    public void visit(Tree.PatternIterator that) {
        Type it;
        Type et;
        Tree.Expression e;
        super.visit(that);
        Tree.SpecifierExpression se = that.getSpecifierExpression();
        if (se != null && (e = se.getExpression()) != null && !ModelUtil.isTypeUnknown(et = e.getTypeModel()) && (it = this.unit.getIteratedType(et)) != null && !ModelUtil.isTypeUnknown(it)) {
            this.destructure(that.getPattern(), se, it);
        }
    }

    @Override
    public void visit(Tree.AttributeDeclaration that) {
        Setter setter;
        super.visit(that);
        Value dec = that.getDeclarationModel();
        Tree.SpecifierOrInitializerExpression sie = that.getSpecifierOrInitializerExpression();
        this.inferType(that, sie);
        Tree.Type type = that.getType();
        if (type != null) {
            Type t = type.getTypeModel();
            if (type instanceof Tree.LocalModifier && !this.isNativeForWrongBackend(dec.getScopedBackends())) {
                if (dec.isParameter()) {
                    type.addError("parameter may not have inferred type: '" + dec.getName() + "' must declare an explicit type");
                } else if (ModelUtil.isTypeUnknown(t)) {
                    if (sie == null) {
                        type.addError("value must specify an explicit type or definition", 200);
                    } else if (!TreeUtil.hasError(sie)) {
                        type.addError("value type could not be inferred" + AnalyzerUtil.getTypeUnknownError(t));
                    }
                }
            }
            if (!ModelUtil.isTypeUnknown(t)) {
                this.checkType(t, dec, sie, 2100);
            }
        }
        if ((setter = dec.getSetter()) != null) {
            setter.getParameter().getModel().setType(dec.getType());
        }
    }

    @Override
    public void visit(Tree.ParameterizedExpression that) {
        super.visit(that);
        Tree.Primary primary = that.getPrimary();
        if (!TreeUtil.hasError(that) && (primary instanceof Tree.QualifiedMemberExpression || primary instanceof Tree.BaseMemberExpression)) {
            Type pt;
            Tree.MemberOrTypeExpression mte = (Tree.MemberOrTypeExpression)primary;
            if (primary.getTypeModel() != null && mte.getDeclaration() != null && (pt = primary.getTypeModel()) != null) {
                List<Tree.ParameterList> pls = that.getParameterLists();
                for (int j = 0; j < pls.size(); ++j) {
                    pt = this.handleExpressionParameterList(that, mte, pt, pls.get(j));
                }
            }
        }
    }

    private Type handleExpressionParameterList(Tree.ParameterizedExpression that, Tree.MemberOrTypeExpression mte, Type pt, Tree.ParameterList pl) {
        Interface cd = this.unit.getCallableDeclaration();
        Type ct = pt.getSupertype(cd);
        String refName = mte.getDeclaration().getName();
        if (ct == null) {
            pl.addError("no matching parameter list in referenced declaration: '" + refName + "'");
        } else if (ct.getTypeArgumentList().size() >= 2) {
            Type tupleType = ct.getTypeArgumentList().get(1);
            List<Type> argTypes = this.unit.getTupleElementTypes(tupleType);
            boolean variadic = this.unit.isTupleLengthUnbounded(tupleType);
            boolean atLeastOne = this.unit.isTupleVariantAtLeastOne(tupleType);
            List<Tree.Parameter> params = pl.getParameters();
            if (argTypes.size() != params.size()) {
                pl.addError("wrong number of declared parameters: '" + refName + "' has " + argTypes.size() + " parameters");
            }
            for (int i = 0; i < argTypes.size() && i < params.size(); ++i) {
                Type at = argTypes.get(i);
                Tree.Parameter param = params.get(i);
                Parameter model = param.getParameterModel();
                Type paramType = model.getModel().getTypedReference().getFullType();
                if (ModelUtil.isTypeUnknown(paramType) || ModelUtil.isTypeUnknown(at) || at.isSubtypeOf(paramType)) continue;
                param.addError("type of parameter '" + model.getName() + "' must be a supertype of corresponding parameter type in declaration of '" + refName + "'");
            }
            if (!params.isEmpty()) {
                Tree.Parameter lastParam = params.get(params.size() - 1);
                Parameter model = lastParam.getParameterModel();
                boolean refSequenced = model.isSequenced();
                boolean refAtLeastOne = model.isAtLeastOne();
                if (refSequenced && !variadic) {
                    lastParam.addError("parameter list in declaration of '" + refName + "' does not have a variadic parameter");
                } else if (!refSequenced && variadic) {
                    lastParam.addError("parameter list in declaration of '" + refName + "' has a variadic parameter");
                } else if (refAtLeastOne && !atLeastOne) {
                    lastParam.addError("variadic parameter in declaration of '" + refName + "' is optional");
                } else if (!refAtLeastOne && atLeastOne) {
                    lastParam.addError("variadic parameter in declaration of '" + refName + "' is not optional");
                }
            }
            pt = ct.getTypeArgumentList().get(0);
            that.setTypeModel(pt);
        }
        return pt;
    }

    @Override
    public void visit(Tree.SpecifierStatement that) {
        super.visit(that);
        Tree.SpecifierExpression rhs = that.getSpecifierExpression();
        Tree.Term lhs = that.getBaseMemberExpression();
        boolean hasParams = false;
        Tree.Term me = lhs;
        while (me instanceof Tree.ParameterizedExpression) {
            hasParams = true;
            Tree.ParameterizedExpression pe = (Tree.ParameterizedExpression)me;
            me = pe.getPrimary();
        }
        if (!(me instanceof Tree.StaticMemberOrTypeExpression)) {
            me.addError("illegal specification statement: only a function or value may be specified");
            return;
        }
        this.assign(me);
        Declaration d = that.getDeclaration();
        if (d == null && me instanceof Tree.MemberOrTypeExpression) {
            Tree.MemberOrTypeExpression mte = (Tree.MemberOrTypeExpression)me;
            d = mte.getDeclaration();
        }
        if (d instanceof TypedDeclaration) {
            if (that.getRefinement()) {
                if (d instanceof Value) {
                    this.refineValue(that);
                } else if (d instanceof Function) {
                    this.refineMethod(that);
                }
                Tree.StaticMemberOrTypeExpression smte = (Tree.StaticMemberOrTypeExpression)me;
                smte.setDeclaration(d);
            } else if (d instanceof FunctionOrValue) {
                FunctionOrValue mv = (FunctionOrValue)d;
                if (mv.isShortcutRefinement()) {
                    String desc = d instanceof Value ? "value" : "function";
                    me.addError(desc + " already specified: '" + d.getName(this.unit) + "'");
                } else if (d instanceof Value && ((Value)d).isInferred()) {
                    me.addError("value is not a variable: '" + d.getName() + "'");
                } else if (!mv.isVariable() && !mv.isLate()) {
                    String desc = d instanceof Value ? "value is neither variable nor late and" : "function";
                    if (mv.isToplevel()) {
                        me.addError("toplevel " + desc + " may not be specified: '" + d.getName(this.unit) + "'", 803);
                    } else if (!mv.isDefinedInScope(that.getScope())) {
                        me.addError(desc + " may not be specified here: '" + d.getName(this.unit) + "'", 803);
                    }
                }
            }
            if (hasParams && d instanceof Function && ((Function)d).isDeclaredVoid() && !this.isSatementExpression(rhs.getExpression())) {
                rhs.addError("function is declared void so specified expression must be a statement: '" + d.getName(this.unit) + "' is declared 'void'");
            }
            if (d instanceof Value && rhs instanceof Tree.LazySpecifierExpression) {
                ((Value)d).setTransient(true);
            }
            Type t = lhs.getTypeModel();
            if (lhs == me && d instanceof Function && !t.isTypeConstructor()) {
                t = this.eraseDefaultedParameters(t);
            }
            if (!ModelUtil.isTypeUnknown(t)) {
                this.checkType(t, d, rhs, 2100);
            }
        }
        if (lhs instanceof Tree.ParameterizedExpression) {
            if (!(rhs instanceof Tree.LazySpecifierExpression)) {
                rhs.addError("functions with parameters must be specified using =>");
            }
        } else if (rhs instanceof Tree.LazySpecifierExpression && d instanceof Function) {
            rhs.addError("functions without parameters must be specified using =");
        }
    }

    boolean isSatementExpression(Tree.Expression e) {
        if (e == null) {
            return false;
        }
        Tree.Term t = e.getTerm();
        return t instanceof Tree.InvocationExpression || t instanceof Tree.PostfixOperatorExpression || t instanceof Tree.AssignmentOp || t instanceof Tree.PrefixOperatorExpression;
    }

    private Type eraseDefaultedParameters(Type type) {
        List<Type> typeArgs;
        Interface cd = this.unit.getCallableDeclaration();
        Type callableType = type.getSupertype(cd);
        if (callableType != null && (typeArgs = callableType.getTypeArgumentList()).size() >= 2) {
            Type rt = typeArgs.get(0);
            Type pts = typeArgs.get(1);
            List<Type> argTypes = this.unit.getTupleElementTypes(pts);
            boolean variadic = this.unit.isTupleLengthUnbounded(pts);
            boolean atLeastOne = this.unit.isTupleVariantAtLeastOne(pts);
            if (variadic) {
                Type spt = argTypes.get(argTypes.size() - 1);
                argTypes.set(argTypes.size() - 1, this.unit.getIteratedType(spt));
            }
            Type tt = this.unit.getTupleType(argTypes, variadic, atLeastOne, -1);
            return ModelUtil.appliedType((TypeDeclaration)cd, rt, tt);
        }
        return type;
    }

    static Reference getRefinedMember(FunctionOrValue d, ClassOrInterface classOrInterface) {
        TypeDeclaration td = (TypeDeclaration)d.getContainer();
        Type supertype = classOrInterface.getType().getSupertype(td);
        return d.appliedReference(supertype, AnalyzerUtil.NO_TYPE_ARGS);
    }

    private void refineValue(Tree.SpecifierStatement that) {
        Value refinedValue = (Value)that.getRefined();
        Value value = (Value)that.getDeclaration();
        ClassOrInterface ci = (ClassOrInterface)value.getContainer();
        Declaration root = refinedValue.getRefinedDeclaration();
        TypeDeclaration td = (TypeDeclaration)root.getContainer();
        List<Declaration> interveningRefinements = ModelUtil.getInterveningRefinements(value.getName(), null, root, ci, td);
        this.accountForIntermediateRefinements(that, refinedValue, value, ci, interveningRefinements);
    }

    private void refineMethod(Tree.SpecifierStatement that) {
        Function refinedMethod = (Function)that.getRefined();
        Function method = (Function)that.getDeclaration();
        ClassOrInterface ci = (ClassOrInterface)method.getContainer();
        Declaration root = method.getRefinedDeclaration();
        TypeDeclaration td = (TypeDeclaration)root.getContainer();
        List<Declaration> interveningRefinements = ModelUtil.getInterveningRefinements(method.getName(), ModelUtil.getSignature(method), root, ci, td);
        if (interveningRefinements.isEmpty()) {
            that.getBaseMemberExpression().addError("shortcut refinement does not exactly refine any overloaded inherited member");
        } else {
            List<Object> parameterLists;
            Reference refinedProducedReference = this.accountForIntermediateRefinements(that, refinedMethod, method, ci, interveningRefinements);
            Tree.Term me = that.getBaseMemberExpression();
            if (me instanceof Tree.ParameterizedExpression) {
                Tree.ParameterizedExpression pe = (Tree.ParameterizedExpression)me;
                parameterLists = pe.getParameterLists();
            } else {
                parameterLists = Collections.emptyList();
            }
            List<ParameterList> refinedParamLists = refinedMethod.getParameterLists();
            List<ParameterList> methodParamLists = method.getParameterLists();
            for (int i = 0; i < refinedParamLists.size() && i < methodParamLists.size(); ++i) {
                ParameterList refinedParameters = refinedParamLists.get(i);
                ParameterList parameters = methodParamLists.get(i);
                Tree.ParameterList parameterList = parameterLists.size() <= i ? null : (Tree.ParameterList)parameterLists.get(i);
                List<Parameter> rps = refinedParameters.getParameters();
                for (int j = 0; j < rps.size(); ++j) {
                    Tree.ParameterDeclaration pd;
                    Tree.Type type;
                    Parameter refinedParameter = rps.get(j);
                    Type refinedParameterType = refinedProducedReference.getTypedParameter(refinedParameter).getFullType();
                    if (parameterList == null || parameterList.getParameters().size() <= j) {
                        Parameter p = parameters.getParameters().get(j);
                        p.getModel().setType(refinedParameterType);
                        continue;
                    }
                    Tree.Parameter parameter = parameterList.getParameters().get(j);
                    Parameter p = parameter.getParameterModel();
                    Type parameterType = p.getModel().getTypedReference().getFullType();
                    Node typeNode = parameter;
                    if (parameter instanceof Tree.ParameterDeclaration && (type = (pd = (Tree.ParameterDeclaration)parameter).getTypedDeclaration().getType()) != null) {
                        typeNode = type;
                    }
                    AnalyzerUtil.checkIsExactlyForInterop(that.getUnit(), refinedParameters.isNamedParametersSupported(), parameterType, refinedParameterType, typeNode, "type of parameter '" + p.getName() + "' of '" + method.getName() + "' declared by '" + ci.getName() + "' is different to type of corresponding parameter '" + refinedParameter.getName() + "' of refined method '" + refinedMethod.getName() + "' of '" + ((Declaration)((Object)refinedMethod.getContainer())).getName() + "'");
                }
            }
        }
    }

    private Reference accountForIntermediateRefinements(Tree.SpecifierStatement that, FunctionOrValue refinedMethodOrValue, FunctionOrValue methodOrValue, ClassOrInterface ci, List<Declaration> interveningRefinements) {
        Tree.SpecifierExpression rhs = that.getSpecifierExpression();
        Reference refinedProducedReference = ExpressionVisitor.getRefinedMember(refinedMethodOrValue, ci);
        ArrayList<Type> refinedTypes = new ArrayList<Type>();
        ModelUtil.addToIntersection(refinedTypes, refinedProducedReference.getType(), this.unit);
        for (Declaration refinement : interveningRefinements) {
            if (!(refinement instanceof FunctionOrValue) || refinement.equals(refinedMethodOrValue)) continue;
            FunctionOrValue rmv = (FunctionOrValue)refinement;
            Reference refinedMember = ExpressionVisitor.getRefinedMember(rmv, ci);
            ModelUtil.addToIntersection(refinedTypes, refinedMember.getType(), this.unit);
            Type requiredType = this.getRequiredSpecifiedType(that, refinedMember);
            if (rhs != null && !ModelUtil.isTypeUnknown(requiredType)) {
                this.checkType(requiredType, refinement, rhs, 2100);
            }
            if (refinement.isDefault() || refinement.isFormal()) continue;
            Declaration container = (Declaration)((Object)refinement.getContainer());
            that.getBaseMemberExpression().addError("shortcut refinement refines non-formal, non-default member: '" + refinement.getName() + "' of '" + container.getName(this.unit));
        }
        Type it = ModelUtil.canonicalIntersection(refinedTypes, this.unit);
        methodOrValue.setType(it);
        return refinedProducedReference;
    }

    private Type getRequiredSpecifiedType(Tree.SpecifierStatement that, Reference refinedMember) {
        Type t = refinedMember.getFullType();
        Tree.Term term = that.getBaseMemberExpression();
        if (term instanceof Tree.ParameterizedExpression) {
            Tree.ParameterizedExpression pe = (Tree.ParameterizedExpression)term;
            int pls = pe.getParameterLists().size();
            for (int i = 0; !ModelUtil.isTypeUnknown(t) && i < pls; ++i) {
                t = this.unit.getCallableReturnType(t);
            }
        }
        return t;
    }

    @Override
    public void visit(Tree.TypeParameterDeclaration that) {
        TypeParameter tpd;
        Type dta;
        super.visit(that);
        Tree.TypeSpecifier ts = that.getTypeSpecifier();
        if (ts != null && (dta = (tpd = that.getDeclarationModel()).getDefaultTypeArgument()) != null) {
            for (Type st : tpd.getSatisfiedTypes()) {
                AnalyzerUtil.checkAssignable(dta, st, ts.getType(), "default type argument does not satisfy type constraint");
            }
        }
    }

    @Override
    public void visit(Tree.InitializerParameter that) {
        super.visit(that);
        Parameter p = that.getParameterModel();
        FunctionOrValue model = p.getModel();
        if (model != null) {
            Type type = model.getTypedReference().getFullType();
            if (type != null && !ModelUtil.isTypeUnknown(type)) {
                this.checkType(type, that.getSpecifierExpression());
            }
            if (AnalyzerUtil.isGeneric(model)) {
                NativeUtil.checkNotJvm(that, "type functions are not supported on the JVM");
            }
        } else {
            Declaration a = that.getScope().getDirectMember(p.getName(), null, false);
            if (a == null) {
                Declaration fun = p.getDeclaration();
                that.addError((fun != null && fun.isAnonymous() ? "parameter is not declared explicitly, and its type cannot be inferred" : "parameter is not declared") + ": '" + p.getName() + "' (specify the parameter type explicitly)");
            }
        }
    }

    private void checkType(Type declaredType, Tree.SpecifierOrInitializerExpression sie) {
        Type set;
        Tree.Expression e;
        if (sie != null && (e = sie.getExpression()) != null && !ModelUtil.isTypeUnknown(set = e.getTypeModel())) {
            AnalyzerUtil.checkAssignable(set, declaredType, sie, "specified expression must be assignable to declared type");
        }
    }

    private void checkType(Type declaredType, Declaration dec, Tree.SpecifierOrInitializerExpression sie, int code) {
        Type t;
        Tree.Expression e;
        if (sie != null && (e = sie.getExpression()) != null && !ModelUtil.isTypeUnknown(t = e.getTypeModel())) {
            String name = "'" + dec.getName(this.unit) + "'";
            if (dec.isClassOrInterfaceMember()) {
                Declaration c = (Declaration)((Object)dec.getContainer());
                name = name + " of '" + c.getName(this.unit) + "'";
            }
            AnalyzerUtil.checkAssignable(t, declaredType, sie, "specified expression must be assignable to declared type of " + name, code);
        }
    }

    private void checkFunctionType(Type et, Tree.Type that, Tree.SpecifierExpression se) {
        if (!ModelUtil.isTypeUnknown(et)) {
            AnalyzerUtil.checkAssignable(et, that.getTypeModel(), se, "specified expression type must be assignable to declared return type", 2100);
        }
    }

    private void checkOptionalType(Tree.Variable var, Tree.SpecifierExpression se, boolean not) {
        Tree.Type type = var.getType();
        if (type != null && !(type instanceof Tree.LocalModifier)) {
            Type set;
            Tree.Expression e;
            Type vt = type.getTypeModel();
            if (!ModelUtil.isTypeUnknown(vt)) {
                Type nt = not ? this.unit.getNullType() : this.unit.getObjectType();
                String message = not ? "specified type must be the null type" : "specified type may not be optional";
                AnalyzerUtil.checkAssignable(vt, nt, type, message);
            }
            if (se != null && (e = se.getExpression()) != null && (set = e.getTypeModel()) != null && !ModelUtil.isTypeUnknown(vt) && !ModelUtil.isTypeUnknown(set)) {
                Type net = not ? this.unit.getNullType() : this.unit.getDefiniteType(set);
                AnalyzerUtil.checkAssignable(net, vt, se, "specified expression must be assignable to declared type after narrowing");
            }
        }
    }

    private void checkEmptyOptionalType(Tree.Variable var, Tree.SpecifierExpression se, boolean not) {
        Tree.Type type = var.getType();
        if (type != null && !(type instanceof Tree.LocalModifier)) {
            Tree.Expression e;
            Type vt = type.getTypeModel();
            if (!ModelUtil.isTypeUnknown(vt)) {
                Type nt = not ? this.unit.getEmptyType() : this.unit.getSequenceType(this.unit.getAnythingType());
                String message = not ? "specified type must be the empty sequence type" : "specified type must be a nonempty sequence type";
                AnalyzerUtil.checkAssignable(vt, nt, type, message);
            }
            if (se != null && (e = se.getExpression()) != null) {
                Type set = e.getTypeModel();
                if (!ModelUtil.isTypeUnknown(vt) && !ModelUtil.isTypeUnknown(set)) {
                    Type net = not ? this.unit.getEmptyType() : this.unit.getNonemptyDefiniteType(set);
                    AnalyzerUtil.checkAssignable(net, vt, se, "specified expression must be assignable to declared type after narrowing");
                }
            }
        }
    }

    private void checkContainedType(Tree.Variable var, Tree.SpecifierExpression se) {
        Tree.Expression e;
        Tree.Type type = var.getType();
        if (type != null && se != null && (e = se.getExpression()) != null) {
            Type vt = type.getTypeModel();
            Type expressionType = e.getTypeModel();
            if (!ModelUtil.isTypeUnknown(vt) && !ModelUtil.isTypeUnknown(expressionType)) {
                Type it = this.unit.getIteratedType(expressionType);
                if (it == null) {
                    it = this.unit.getJavaIteratedType(expressionType);
                }
                if (it == null) {
                    it = this.unit.getJavaArrayElementType(expressionType);
                }
                AnalyzerUtil.checkAssignable(it, vt, var, "iterable element type must be assignable to iterator variable type");
            }
        }
    }

    @Override
    public void visit(Tree.AttributeGetterDefinition that) {
        Tree.Type type = that.getType();
        Tree.Type rt = this.beginReturnScope(type);
        Value v = that.getDeclarationModel();
        Declaration od = this.beginReturnDeclaration(v);
        super.visit(that);
        this.endReturnScope(rt, v);
        this.endReturnDeclaration(od);
        Setter setter = v.getSetter();
        if (setter != null) {
            setter.getParameter().getModel().setType(v.getType());
        }
        if (type instanceof Tree.LocalModifier && ModelUtil.isTypeUnknown(type.getTypeModel())) {
            type.addError("getter type could not be inferred");
        }
    }

    @Override
    public void visit(Tree.AttributeArgument that) {
        Tree.SpecifierExpression se = that.getSpecifierExpression();
        Tree.Type type = that.getType();
        Value v = that.getDeclarationModel();
        if (se == null) {
            Tree.Type rt = this.beginReturnScope(type);
            Declaration od = this.beginReturnDeclaration(v);
            super.visit(that);
            this.endReturnDeclaration(od);
            this.endReturnScope(rt, v);
        } else {
            Type t;
            super.visit(that);
            this.inferType(that, (Tree.SpecifierOrInitializerExpression)se);
            if (type != null && !ModelUtil.isTypeUnknown(t = type.getTypeModel())) {
                this.checkType(t, v, se, 2100);
            }
        }
        if (type instanceof Tree.LocalModifier && ModelUtil.isTypeUnknown(type.getTypeModel()) && (se == null || !TreeUtil.hasError(se))) {
            Node node = type.getToken() == null ? that : type;
            node.addError("argument type could not be inferred");
        }
    }

    @Override
    public void visit(Tree.AttributeSetterDefinition that) {
        Tree.Expression e;
        Tree.Type rt = this.beginReturnScope(that.getType());
        Setter sd = that.getDeclarationModel();
        Declaration od = this.beginReturnDeclaration(sd);
        super.visit(that);
        this.endReturnDeclaration(od);
        this.endReturnScope(rt, sd);
        Tree.SpecifierExpression se = that.getSpecifierExpression();
        if (se != null && (e = se.getExpression()) != null && !this.isSatementExpression(e)) {
            se.addError("specified expression must be a statement: '" + sd.getName() + "'");
        }
    }

    @Override
    public void visit(Tree.MethodDeclaration that) {
        Tree.Expression e;
        super.visit(that);
        Tree.Type type = that.getType();
        Function m = that.getDeclarationModel();
        Tree.SpecifierExpression se = that.getSpecifierExpression();
        if (se != null && (e = se.getExpression()) != null) {
            Type returnType = e.getTypeModel();
            this.inferFunctionType(that, returnType);
            if (type != null && !(type instanceof Tree.DynamicModifier)) {
                this.checkFunctionType(returnType, type, se);
            }
            if (type instanceof Tree.VoidModifier && !this.isSatementExpression(e)) {
                se.addError("function is declared void so specified expression must be a statement: '" + m.getName() + "' is declared 'void'");
            }
        }
        if (type instanceof Tree.LocalModifier) {
            if (m.isParameter()) {
                type.addError("parameter may not have inferred type: '" + m.getName() + "' must declare an explicit type");
            } else if (ModelUtil.isTypeUnknown(type.getTypeModel())) {
                if (se == null) {
                    type.addError("function must specify an explicit return type or definition", 200);
                } else if (!TreeUtil.hasError(se)) {
                    type.addError("function type could not be inferred");
                }
            }
        }
    }

    @Override
    public void visit(Tree.MethodDefinition that) {
        Tree.Type type = that.getType();
        Tree.Type rt = this.beginReturnScope(type);
        Function m = that.getDeclarationModel();
        Declaration od = this.beginReturnDeclaration(m);
        super.visit(that);
        this.endReturnDeclaration(od);
        this.endReturnScope(rt, m);
        if (type instanceof Tree.LocalModifier && ModelUtil.isTypeUnknown(type.getTypeModel())) {
            type.addError("function type could not be inferred");
        }
    }

    @Override
    public void visit(Tree.MethodArgument that) {
        Tree.SpecifierExpression se = that.getSpecifierExpression();
        Function m = that.getDeclarationModel();
        Tree.Type type = that.getType();
        if (se == null) {
            Tree.Type rt = this.beginReturnScope(type);
            Declaration od = this.beginReturnDeclaration(m);
            super.visit(that);
            this.endReturnDeclaration(od);
            this.endReturnScope(rt, m);
        } else {
            super.visit(that);
            Tree.Expression e = se.getExpression();
            if (e != null) {
                Type returnType = e.getTypeModel();
                this.inferFunctionType(that, returnType);
                if (type != null && !(type instanceof Tree.DynamicModifier)) {
                    this.checkFunctionType(returnType, type, se);
                }
                if (m.isDeclaredVoid() && !this.isSatementExpression(e)) {
                    se.addError("functional argument is declared void so specified expression must be a statement: '" + m.getName() + "' is declared 'void'");
                }
            }
        }
        if (type instanceof Tree.LocalModifier && ModelUtil.isTypeUnknown(type.getTypeModel()) && (se == null || TreeUtil.hasError(type))) {
            Node node = type.getToken() == null ? that : type;
            node.addError("argument type could not be inferred");
        }
    }

    @Override
    public void visit(Tree.Declaration that) {
        super.visit(that);
    }

    private static Tree.VoidModifier fakeVoid(Node that) {
        return new Tree.VoidModifier(that.getToken());
    }

    @Override
    public void visit(Tree.ClassDefinition that) {
        Tree.Type rt = this.beginReturnScope(ExpressionVisitor.fakeVoid(that));
        Class c = that.getDeclarationModel();
        Declaration od = this.beginReturnDeclaration(c);
        super.visit(that);
        this.endReturnDeclaration(od);
        this.endReturnScope(rt, null);
    }

    @Override
    public void visit(Tree.InterfaceDefinition that) {
        Tree.Type rt = this.beginReturnScope(null);
        Interface i = that.getDeclarationModel();
        Declaration od = this.beginReturnDeclaration(i);
        super.visit(that);
        this.endReturnDeclaration(od);
        this.endReturnScope(rt, null);
    }

    @Override
    public void visit(Tree.ObjectDefinition that) {
        Tree.Type rt = this.beginReturnScope(ExpressionVisitor.fakeVoid(that));
        Class ac = that.getAnonymousClass();
        Declaration od = this.beginReturnDeclaration(ac);
        super.visit(that);
        this.endReturnDeclaration(od);
        this.endReturnScope(rt, null);
    }

    @Override
    public void visit(Tree.ObjectArgument that) {
        Tree.Type rt = this.beginReturnScope(ExpressionVisitor.fakeVoid(that));
        Class ac = that.getAnonymousClass();
        Declaration od = this.beginReturnDeclaration(ac);
        super.visit(that);
        this.endReturnDeclaration(od);
        this.endReturnScope(rt, null);
    }

    @Override
    public void visit(Tree.ObjectExpression that) {
        Tree.Type rt = this.beginReturnScope(ExpressionVisitor.fakeVoid(that));
        Class ac = that.getAnonymousClass();
        Declaration od = this.beginReturnDeclaration(ac);
        super.visit(that);
        this.endReturnDeclaration(od);
        this.endReturnScope(rt, null);
        that.setTypeModel(this.unit.denotableType(ac.getType()));
    }

    @Override
    public void visit(Tree.ClassDeclaration that) {
        super.visit(that);
        Class alias = that.getDeclarationModel();
        Type et = alias.getExtendedType();
        Tree.ClassSpecifier cs = that.getClassSpecifier();
        if (cs != null && et != null) {
            TypeDeclaration etd = et.getDeclaration();
            if (etd instanceof Constructor) {
                etd = etd.getExtendedType().getDeclaration();
            }
            if (etd instanceof Class) {
                Class c = (Class)etd;
                if (c.isAbstract() && !alias.isFormal() && !alias.isAbstract()) {
                    that.addError("alias of abstract class must be annotated abstract", 310);
                }
                if (c.isAbstraction()) {
                    that.addError("class alias may not alias overloaded class");
                } else {
                    Tree.InvocationExpression ie = cs.getInvocationExpression();
                    if (ie != null) {
                        this.checkClassAliasParameters(alias, that, ie);
                    }
                }
            }
        }
    }

    private void checkClassAliasParameters(Class alias, Tree.ClassDeclaration that, Tree.InvocationExpression ie) {
        Tree.Primary primary = ie.getPrimary();
        Tree.ExtendedTypeExpression smte = (Tree.ExtendedTypeExpression)primary;
        Functional classOrConstructor = (Functional)((Object)smte.getDeclaration());
        ParameterList cpl = classOrConstructor.getFirstParameterList();
        ParameterList apl = alias.getParameterList();
        if (cpl != null && apl != null) {
            int aps;
            List<Parameter> cplps = cpl.getParameters();
            List<Parameter> aplps = apl.getParameters();
            int cps = cplps.size();
            if (cps != (aps = aplps.size())) {
                that.getParameterList().addUnsupportedError("wrong number of initializer parameters declared by class alias: '" + alias.getName() + "'");
            }
            for (int i = 0; i < cps && i < aps; ++i) {
                Parameter ap = aplps.get(i);
                Parameter cp = cplps.get(i);
                Reference target = smte.getTarget();
                FunctionOrValue apm = ap.getModel();
                if (apm == null || target == null) continue;
                Type pt = target.getTypedParameter(cp).getFullType();
                Type apt = apm.getReference().getFullType();
                if (ModelUtil.isTypeUnknown(pt) || ModelUtil.isTypeUnknown(apt) || apt.isSubtypeOf(pt)) continue;
                that.addUnsupportedError("alias parameter '" + ap.getName() + "' must be assignable to corresponding class parameter '" + cp.getName() + "'" + AnalyzerUtil.notAssignableMessage(apt, pt, that));
            }
            this.checkAliasedClass(that, cpl, apl);
        }
    }

    private void checkAliasedClass(Tree.ClassDeclaration that, ParameterList cpl, ParameterList apl) {
        Tree.InvocationExpression ie = that.getClassSpecifier().getInvocationExpression();
        Tree.PositionalArgumentList pal = ie.getPositionalArgumentList();
        if (pal != null) {
            List<Tree.PositionalArgument> pas = pal.getPositionalArguments();
            int cps = cpl.getParameters().size();
            int aps = apl.getParameters().size();
            int size = pas.size();
            if (cps != size) {
                pal.addUnsupportedError("wrong number of arguments for aliased class: '" + that.getDeclarationModel().getName() + "' has " + cps + " parameters");
            }
            for (int i = 0; i < size && i < cps && i < aps; ++i) {
                Tree.Expression e;
                Tree.PositionalArgument pa = pas.get(i);
                Parameter aparam = apl.getParameters().get(i);
                Parameter cparam = cpl.getParameters().get(i);
                if (pa instanceof Tree.ListedArgument) {
                    if (cparam.isSequenced()) {
                        pa.addUnsupportedError("argument to variadic parameter of aliased class must be spread");
                    }
                    Tree.ListedArgument la = (Tree.ListedArgument)pa;
                    e = la.getExpression();
                    this.checkAliasArg(aparam, e);
                    continue;
                }
                if (pa instanceof Tree.SpreadArgument) {
                    if (!cparam.isSequenced()) {
                        pa.addUnsupportedError("argument to non-variadic parameter of aliased class may not be spread");
                    }
                    Tree.SpreadArgument sa = (Tree.SpreadArgument)pa;
                    e = sa.getExpression();
                    this.checkAliasArg(aparam, e);
                    continue;
                }
                if (pa == null) continue;
                pa.addUnsupportedError("argument to parameter or aliased class must be listed or spread");
            }
        }
    }

    private void checkAliasArg(Parameter param, Tree.Expression e) {
        FunctionOrValue p;
        if (e != null && param != null && (p = param.getModel()) != null) {
            Tree.Term term = e.getTerm();
            if (term instanceof Tree.BaseMemberExpression) {
                Tree.BaseMemberExpression bme = (Tree.BaseMemberExpression)term;
                Declaration d = bme.getDeclaration();
                if (d != null && !d.equals(p)) {
                    e.addUnsupportedError("argument must be a parameter reference to " + this.paramdesc(param));
                }
            } else {
                e.addUnsupportedError("argument must be a parameter reference to " + this.paramdesc(param));
            }
        }
    }

    private void inferType(Tree.TypedDeclaration that, Tree.SpecifierOrInitializerExpression spec) {
        Tree.Type type = that.getType();
        if (type instanceof Tree.LocalModifier) {
            Tree.LocalModifier local = (Tree.LocalModifier)type;
            if (spec != null) {
                this.setType(local, spec, that);
            }
        }
    }

    private void inferType(Tree.AttributeArgument that, Tree.SpecifierOrInitializerExpression spec) {
        Tree.Type type = that.getType();
        if (type instanceof Tree.LocalModifier) {
            Tree.LocalModifier local = (Tree.LocalModifier)type;
            if (spec != null) {
                this.setType(local, spec, that);
            }
        }
    }

    private void inferFunctionType(Tree.TypedDeclaration that, Type et) {
        Tree.Type type = that.getType();
        if (type instanceof Tree.FunctionModifier) {
            Tree.FunctionModifier local = (Tree.FunctionModifier)type;
            if (et != null) {
                this.setFunctionType(local, et, that);
            }
        }
    }

    private void inferFunctionType(Tree.MethodArgument that, Type et) {
        Tree.Type type = that.getType();
        if (type instanceof Tree.FunctionModifier) {
            Tree.FunctionModifier local = (Tree.FunctionModifier)type;
            if (et != null) {
                this.setFunctionType(local, et, that);
            }
        }
    }

    private void inferDefiniteType(Tree.Variable that, Tree.SpecifierExpression se, boolean not) {
        Tree.Type type = that.getType();
        if (type instanceof Tree.LocalModifier) {
            Tree.LocalModifier local = (Tree.LocalModifier)type;
            if (not) {
                this.setNullTypeFromOptionalType(that, local, se);
            } else if (se != null) {
                this.setDefiniteTypeFromOptionalType(that, local, se);
            }
        }
    }

    private void inferNonemptyType(Tree.Variable that, Tree.SpecifierExpression se, boolean not) {
        Tree.Type type = that.getType();
        if (type instanceof Tree.LocalModifier) {
            Tree.LocalModifier local = (Tree.LocalModifier)type;
            if (not) {
                this.setEmptyTypeFromSequenceType(that, local, se);
            } else if (se != null) {
                this.setNonemptyTypeFromSequenceType(that, local, se);
            }
        }
    }

    private void inferContainedType(Tree.Variable that, Tree.SpecifierExpression se) {
        Tree.Type type = that.getType();
        if (type instanceof Tree.LocalModifier) {
            Tree.LocalModifier local = (Tree.LocalModifier)type;
            if (se != null) {
                this.setTypeFromIterableType(local, se, that);
            }
        }
    }

    private void inferValueType(Tree.Variable value, Type t) {
        Tree.Type type = value.getType();
        if (type instanceof Tree.LocalModifier) {
            Tree.ValueModifier local = (Tree.ValueModifier)type;
            if (t != null) {
                this.setValueType(local, t, value);
            }
        }
    }

    private void setDefiniteTypeFromOptionalType(Tree.Variable that, Tree.LocalModifier local, Tree.SpecifierExpression se) {
        Type expressionType;
        Tree.Expression e = se.getExpression();
        if (e != null && !ModelUtil.isTypeUnknown(expressionType = e.getTypeModel())) {
            if (this.unit.isOptionalType(expressionType)) {
                expressionType = this.unit.getDefiniteType(expressionType);
            }
            local.setTypeModel(expressionType);
            that.getDeclarationModel().setType(expressionType);
        }
    }

    private void setNullTypeFromOptionalType(Tree.Variable that, Tree.LocalModifier local, Tree.SpecifierExpression se) {
        Type et;
        Type nullType = this.unit.getNullType();
        Tree.Expression e = se.getExpression();
        if (e != null && !ModelUtil.isTypeUnknown(et = e.getTypeModel())) {
            nullType = ModelUtil.intersectionType(et, nullType, this.unit);
        }
        local.setTypeModel(nullType);
        that.getDeclarationModel().setType(nullType);
    }

    private void setNonemptyTypeFromSequenceType(Tree.Variable that, Tree.LocalModifier local, Tree.SpecifierExpression se) {
        Type expressionType;
        Tree.Expression e = se.getExpression();
        if (e != null && !ModelUtil.isTypeUnknown(expressionType = e.getTypeModel())) {
            if (this.unit.isPossiblyEmptyType(expressionType)) {
                expressionType = this.unit.getNonemptyDefiniteType(expressionType);
            }
            local.setTypeModel(expressionType);
            that.getDeclarationModel().setType(expressionType);
        }
    }

    private void setEmptyTypeFromSequenceType(Tree.Variable that, Tree.LocalModifier local, Tree.SpecifierExpression se) {
        Type expressionType;
        Type emptyType = this.unit.getEmptyType();
        Tree.Expression e = se.getExpression();
        if (e != null && !ModelUtil.isTypeUnknown(expressionType = e.getTypeModel())) {
            emptyType = ModelUtil.intersectionType(expressionType, emptyType, this.unit);
        }
        local.setTypeModel(emptyType);
        that.getDeclarationModel().setType(emptyType);
    }

    private void setTypeFromIterableType(Tree.LocalModifier local, Tree.SpecifierExpression se, Tree.Variable that) {
        Type expressionType;
        Tree.Expression e = se.getExpression();
        if (e != null && (expressionType = e.getTypeModel()) != null) {
            Type elementType = this.unit.getIteratedType(expressionType);
            if (elementType == null) {
                elementType = this.unit.getJavaIteratedType(expressionType);
            }
            if (elementType == null) {
                elementType = this.unit.getJavaArrayElementType(expressionType);
            }
            if (elementType != null) {
                local.setTypeModel(elementType);
                that.getDeclarationModel().setType(elementType);
            }
        }
    }

    private void setType(Tree.LocalModifier local, Tree.SpecifierOrInitializerExpression s, Tree.TypedDeclaration that) {
        Type type;
        Tree.Expression e = s.getExpression();
        if (e != null && (type = e.getTypeModel()) != null) {
            Type t = this.inferrableType(type);
            local.setTypeModel(t);
            that.getDeclarationModel().setType(t);
        }
    }

    private void setType(Tree.LocalModifier local, Tree.SpecifierOrInitializerExpression s, Tree.AttributeArgument that) {
        Type type;
        Tree.Expression e = s.getExpression();
        if (e != null && (type = e.getTypeModel()) != null) {
            Type t = this.inferrableType(type);
            local.setTypeModel(t);
            that.getDeclarationModel().setType(t);
        }
    }

    private void setSequencedValueType(Tree.SequencedType spread, Type et, Tree.TypedDeclaration that) {
        Type t = this.inferrableType(et);
        spread.setTypeModel(t);
        that.getDeclarationModel().setType(t);
    }

    private void setValueType(Tree.ValueModifier local, Type et, Tree.TypedDeclaration that) {
        Type t = this.inferrableType(et);
        local.setTypeModel(t);
        that.getDeclarationModel().setType(t);
    }

    private void setFunctionType(Tree.FunctionModifier local, Type et, Tree.TypedDeclaration that) {
        Type t = this.inferrableType(et);
        local.setTypeModel(t);
        that.getDeclarationModel().setType(t);
    }

    private void setFunctionType(Tree.FunctionModifier local, Type et, Tree.MethodArgument that) {
        Type t = this.inferrableType(et);
        local.setTypeModel(t);
        that.getDeclarationModel().setType(t);
    }

    private Type inferrableType(Type et) {
        return this.unit.denotableType(et).withoutUnderlyingType();
    }

    @Override
    public void visit(Tree.Throw that) {
        Type et;
        super.visit(that);
        Tree.Expression e = that.getExpression();
        if (e != null && !ModelUtil.isTypeUnknown(et = e.getTypeModel())) {
            Type tt = this.unit.getThrowableType();
            AnalyzerUtil.checkAssignable(et, tt, e, "thrown expression must be a throwable");
        }
    }

    @Override
    public void visit(Tree.Return that) {
        super.visit(that);
        if (this.returnType != null) {
            that.setDeclaration(this.returnDeclaration);
            Tree.Expression e = that.getExpression();
            String name = this.returnDeclaration.getName();
            name = name == null || this.returnDeclaration.isAnonymous() ? "anonymous function" : "'" + name + "'";
            if (e == null) {
                if (!(this.returnType instanceof Tree.VoidModifier)) {
                    if (this.returnDeclaration instanceof Function) {
                        that.addError("function must return a value: " + name + " is not a 'void' function", 12000);
                    } else {
                        that.addError("getter must return a value: " + name + " is a getter");
                    }
                }
            } else {
                Type et = this.returnType.getTypeModel();
                Type at = e.getTypeModel();
                if (this.returnType instanceof Tree.VoidModifier) {
                    if (this.returnDeclaration instanceof Function) {
                        that.addError("function may not return a value: " + name + " is a 'void' function", 13000);
                    } else if (this.returnDeclaration instanceof TypedDeclaration) {
                        that.addError("setter may not return a value: " + name + " is a setter");
                    } else {
                        that.addError("class initializer may not return a value");
                    }
                } else if (this.returnType instanceof Tree.LocalModifier) {
                    this.inferReturnType(et, at);
                } else if (!ModelUtil.isTypeUnknown(et) && !ModelUtil.isTypeUnknown(at)) {
                    AnalyzerUtil.checkAssignable(at, et, e, "returned expression must be assignable to return type of " + name, 2100);
                }
            }
        }
    }

    private void inferReturnType(Type et, Type at) {
        if (at != null) {
            at = this.unit.denotableType(at);
            if (et == null || et.isSubtypeOf(at)) {
                this.returnType.setTypeModel(at);
            } else if (!at.isSubtypeOf(et)) {
                Type rt = ModelUtil.unionType(at, et, this.unit);
                this.returnType.setTypeModel(rt);
            }
        }
    }

    private void checkMemberOperator(Type pt, Tree.QualifiedMemberOrTypeExpression qmte) {
        Tree.MemberOperator op = qmte.getMemberOperator();
        Tree.Primary p = qmte.getPrimary();
        if (op instanceof Tree.SafeMemberOp) {
            if (qmte.getStaticMethodReference()) {
                op.addError("static reference may not involve safe member operator");
            } else {
                this.checkOptional(pt, p);
            }
        } else if (op instanceof Tree.SpreadOp) {
            if (qmte.getStaticMethodReference()) {
                op.addError("static reference may not involve spread member operator");
            } else {
                this.checkIterable(pt, p);
            }
        }
    }

    private Type unwrap(Type type, Tree.QualifiedMemberOrTypeExpression qmte) {
        if (qmte.getStaticMethodReference()) {
            return type;
        }
        if (type == null) {
            return null;
        }
        Tree.MemberOperator op = qmte.getMemberOperator();
        if (op instanceof Tree.SafeMemberOp) {
            return this.unit.getDefiniteType(type);
        }
        if (op instanceof Tree.SpreadOp) {
            if (this.unit.isIterableType(type)) {
                Type it = this.unit.getIteratedType(type);
                return it == null ? this.unit.getUnknownType() : it;
            }
            return type;
        }
        return type;
    }

    Type wrap(Type type, Type receivingType, Tree.QualifiedMemberOrTypeExpression mte) {
        if (mte.getStaticMethodReference()) {
            return type;
        }
        Tree.MemberOperator op = mte.getMemberOperator();
        if (op instanceof Tree.SafeMemberOp) {
            return this.unit.getOptionalType(type);
        }
        if (op instanceof Tree.SpreadOp) {
            return this.unit.isNonemptyIterableType(receivingType) ? this.unit.getSequenceType(type) : this.unit.getSequentialType(type);
        }
        return type;
    }

    @Override
    public void visit(Tree.InvocationExpression that) {
        Tree.NamedArgumentList nal;
        Tree.Primary p = that.getPrimary();
        p.visit(this);
        Tree.PositionalArgumentList pal = that.getPositionalArgumentList();
        if (pal != null) {
            this.inferParameterTypes(p, pal);
            pal.visit(this);
        }
        if ((nal = that.getNamedArgumentList()) != null) {
            this.inferParameterTypes(p, nal);
            nal.visit(this);
        }
        if (p != null) {
            this.visitInvocationPositionalArgs(that);
            this.visitInvocationPrimary(that);
            if (AnalyzerUtil.isIndirectInvocation(that)) {
                this.visitIndirectInvocation(that);
            } else {
                this.visitDirectInvocation(that);
            }
        }
    }

    private void inferParameterTypes(Tree.Primary p, Tree.PositionalArgumentList pal) {
        Tree.Term term = TreeUtil.unwrapExpressionUntilTerm(p);
        if (term instanceof Tree.MemberOrTypeExpression) {
            Tree.MemberOrTypeExpression mte = (Tree.MemberOrTypeExpression)term;
            Declaration dec = mte.getDeclaration();
            if (dec instanceof Functional) {
                this.inferParameterTypesDirectly(dec, pal, mte);
            } else if (dec instanceof Value) {
                Value value = (Value)dec;
                this.inferParameterTypesIndirectly(pal, value.getType());
            }
        } else {
            this.inferParameterTypesIndirectly(pal, p.getTypeModel());
        }
    }

    private void inferParameterTypes(Tree.Primary p, Tree.NamedArgumentList nal) {
        Tree.MemberOrTypeExpression mte;
        Declaration dec;
        Tree.Term term = TreeUtil.unwrapExpressionUntilTerm(p);
        if (term instanceof Tree.MemberOrTypeExpression && (dec = (mte = (Tree.MemberOrTypeExpression)term).getDeclaration()) instanceof Functional) {
            this.inferParameterTypesDirectly(dec, nal, mte);
        }
    }

    private void inferParameterTypesIndirectly(Tree.PositionalArgumentList pal, Type pt) {
        if (this.unit.isCallableType(pt)) {
            List<Type> paramTypes = this.unit.getCallableArgumentTypes(pt);
            List<Tree.PositionalArgument> args = pal.getPositionalArguments();
            int argCount = args.size();
            int paramsSize = paramTypes.size();
            for (int i = 0; i < paramsSize && i < argCount; ++i) {
                Tree.ListedArgument la;
                Tree.Expression e;
                Type paramType = paramTypes.get(i);
                Tree.PositionalArgument arg = args.get(i);
                if (!(arg instanceof Tree.ListedArgument) || !this.unit.isCallableType(paramType) || (e = (la = (Tree.ListedArgument)arg).getExpression()) == null) continue;
                Tree.Term term = TreeUtil.unwrapExpressionUntilTerm(e.getTerm());
                if (term instanceof Tree.FunctionArgument) {
                    Tree.FunctionArgument fa = (Tree.FunctionArgument)term;
                    this.inferParameterTypesFromCallableType(paramType, null, fa);
                    continue;
                }
                if (!(term instanceof Tree.StaticMemberOrTypeExpression)) continue;
                Tree.StaticMemberOrTypeExpression smte = (Tree.StaticMemberOrTypeExpression)term;
                smte.setParameterType(paramType);
            }
        }
    }

    private void inferParameterTypesDirectly(Declaration dec, Tree.PositionalArgumentList pal, Tree.MemberOrTypeExpression mte) {
        Reference pr = this.getInvokedProducedReference(dec, mte);
        Functional fun = (Functional)((Object)dec);
        List<ParameterList> pls = fun.getParameterLists();
        if (!pls.isEmpty()) {
            ParameterList pl = pls.get(0);
            List<Parameter> params = pl.getParameters();
            List<Tree.PositionalArgument> args = pal.getPositionalArguments();
            int j = 0;
            int argCount = args.size();
            int paramsSize = params.size();
            for (int i = 0; i < argCount && j < paramsSize; ++i) {
                Parameter param = params.get(j);
                Tree.PositionalArgument arg = args.get(i);
                arg.setParameter(param);
                if (arg instanceof Tree.ListedArgument) {
                    Tree.ListedArgument la = (Tree.ListedArgument)arg;
                    this.inferParameterTypes(pr, param, la.getExpression(), param.isSequenced());
                }
                if (param.isSequenced()) continue;
                ++j;
            }
        }
    }

    private void inferParameterTypesDirectly(Declaration dec, Tree.NamedArgumentList nal, Tree.MemberOrTypeExpression mte) {
        Reference pr = this.getInvokedProducedReference(dec, mte);
        Functional fun = (Functional)((Object)dec);
        List<ParameterList> pls = fun.getParameterLists();
        if (!pls.isEmpty()) {
            Parameter param;
            HashSet<Parameter> foundParameters = new HashSet<Parameter>();
            ParameterList pl = pls.get(0);
            List<Tree.NamedArgument> args = nal.getNamedArguments();
            for (int i = 0; i < args.size(); ++i) {
                Tree.SpecifiedArgument sa;
                Tree.SpecifierExpression se;
                Tree.NamedArgument arg = args.get(i);
                Parameter param2 = AnalyzerUtil.getMatchingParameter(pl, arg, foundParameters);
                if (param2 == null) continue;
                foundParameters.add(param2);
                arg.setParameter(param2);
                if (!(arg instanceof Tree.SpecifiedArgument) || (se = (sa = (Tree.SpecifiedArgument)arg).getSpecifierExpression()) == null) continue;
                this.inferParameterTypes(pr, param2, se.getExpression(), false);
            }
            Tree.SequencedArgument sa = nal.getSequencedArgument();
            if (sa != null && (param = AnalyzerUtil.getUnspecifiedParameter(pr, pl, foundParameters)) != null) {
                sa.setParameter(param);
                for (Tree.PositionalArgument pa : sa.getPositionalArguments()) {
                    if (!(pa instanceof Tree.ListedArgument)) continue;
                    Tree.ListedArgument la = (Tree.ListedArgument)pa;
                    la.setParameter(param);
                    this.inferParameterTypes(pr, param, la.getExpression(), true);
                }
            }
        }
    }

    private Reference getInvokedProducedReference(Declaration dec, Tree.MemberOrTypeExpression mte) {
        Tree.TypeArguments tas;
        if (mte instanceof Tree.StaticMemberOrTypeExpression) {
            Tree.StaticMemberOrTypeExpression smte = (Tree.StaticMemberOrTypeExpression)mte;
            tas = smte.getTypeArguments();
        } else {
            tas = null;
        }
        Generic fun = (Generic)((Object)dec);
        List<TypeParameter> tps = fun.getTypeParameters();
        if (ExpressionVisitor.isPackageQualified(mte)) {
            Tree.QualifiedMemberOrTypeExpression qmte = (Tree.QualifiedMemberOrTypeExpression)mte;
            Type invokedType = qmte.getPrimary().getTypeModel().resolveAliases();
            Type receiverType = this.unwrap(invokedType, qmte);
            return receiverType.getTypedReference(dec, AnalyzerUtil.getTypeArguments(tas, receiverType, tps));
        }
        Type receiverType = mte.getScope().getDeclaringType(dec);
        return dec.appliedReference(receiverType, AnalyzerUtil.getTypeArguments(tas, receiverType, tps));
    }

    private static boolean isPackageQualified(Tree.MemberOrTypeExpression mte) {
        if (mte instanceof Tree.QualifiedMemberOrTypeExpression) {
            Tree.QualifiedMemberOrTypeExpression qmte = (Tree.QualifiedMemberOrTypeExpression)mte;
            Tree.Primary primary = qmte.getPrimary();
            return !(primary instanceof Tree.Package);
        }
        return false;
    }

    private void inferParameterTypes(Reference pr, Parameter param, Tree.Expression e, boolean variadic) {
        FunctionOrValue model = param.getModel();
        if (e != null && model != null) {
            Tree.Term term = TreeUtil.unwrapExpressionUntilTerm(e.getTerm());
            TypedReference tpr = pr.getTypedParameter(param);
            if (term instanceof Tree.FunctionArgument) {
                Tree.FunctionArgument anon = (Tree.FunctionArgument)term;
                if (model instanceof Functional) {
                    this.inferParameterTypesFromCallableParameter(pr, param, anon);
                } else {
                    Type paramType = tpr.getFullType();
                    if (variadic) {
                        paramType = this.unit.getIteratedType(paramType);
                    }
                    if (this.unit.isCallableType(paramType)) {
                        this.inferParameterTypesFromCallableType(paramType, param, anon);
                    }
                }
            } else if (term instanceof Tree.StaticMemberOrTypeExpression) {
                Tree.StaticMemberOrTypeExpression stme = (Tree.StaticMemberOrTypeExpression)term;
                if (stme instanceof Tree.QualifiedMemberOrTypeExpression && stme.getStaticMethodReference()) {
                    Tree.QualifiedMemberOrTypeExpression qmte = (Tree.QualifiedMemberOrTypeExpression)stme;
                    Tree.StaticMemberOrTypeExpression ote = (Tree.StaticMemberOrTypeExpression)qmte.getPrimary();
                    ote.setTargetParameter(tpr);
                    stme.setParameterType(tpr.getFullType());
                } else {
                    stme.setTargetParameter(tpr);
                    stme.setParameterType(tpr.getFullType());
                }
            }
        }
    }

    private void inferParameterTypesFromCallableType(Type paramType, Parameter param, Tree.FunctionArgument anon) {
        List<Tree.ParameterList> apls = anon.getParameterLists();
        if (!apls.isEmpty()) {
            List<Type> types = this.unit.getCallableArgumentTypes(paramType);
            List<Tree.Parameter> aps = apls.get(0).getParameters();
            Declaration declaration = param == null ? null : param.getDeclaration();
            for (int j = 0; j < types.size() && j < aps.size(); ++j) {
                Parameter parameter;
                Tree.Parameter ap = aps.get(j);
                if (!(ap instanceof Tree.InitializerParameter) || (parameter = ap.getParameterModel()).getModel() != null) continue;
                this.createInferredParameter(anon, declaration, ap, parameter, types.get(j));
            }
        }
    }

    private void inferParameterTypesFromCallableParameter(Reference pr, Parameter param, Tree.FunctionArgument anon) {
        Declaration declaration = param.getDeclaration();
        Functional fun = (Functional)((Object)param.getModel());
        List<ParameterList> fpls = fun.getParameterLists();
        List<Tree.ParameterList> apls = anon.getParameterLists();
        if (!fpls.isEmpty() && !apls.isEmpty()) {
            List<Parameter> fps = fpls.get(0).getParameters();
            List<Tree.Parameter> aps = apls.get(0).getParameters();
            for (int j = 0; j < fps.size() && j < aps.size(); ++j) {
                Parameter parameter;
                Parameter fp = fps.get(j);
                Tree.Parameter ap = aps.get(j);
                if (!(ap instanceof Tree.InitializerParameter) || (parameter = ap.getParameterModel()).getModel() != null) continue;
                this.createInferredParameter(anon, declaration, ap, parameter, pr.getTypedParameter(fp).getType());
            }
        }
    }

    private void createInferredParameter(Tree.FunctionArgument anon, Declaration declaration, Tree.Parameter ap, Parameter parameter, Type type) {
        if (ModelUtil.isTypeUnknown(type)) {
            type = this.unit.getUnknownType();
            if (!this.dynamic) {
                ap.addError("could not infer parameter type: '" + parameter.getName() + "' would have unknown type");
            }
        } else if (AnalyzerUtil.involvesTypeParams(declaration, type)) {
            ap.addError("could not infer parameter type: '" + parameter.getName() + "' would have type '" + type.asString(this.unit) + "' involving type parameters");
            type = this.unit.getUnknownType();
        }
        Value model = new Value();
        model.setUnit(this.unit);
        model.setType(type);
        model.setName(parameter.getName());
        model.setInferred(true);
        parameter.setModel(model);
        model.setInitializerParameter(parameter);
        Function m = anon.getDeclarationModel();
        model.setContainer(m);
        m.addMember(model);
    }

    private void visitInvocationPositionalArgs(Tree.InvocationExpression that) {
        Tree.Primary p = that.getPrimary();
        Tree.PositionalArgumentList pal = that.getPositionalArgumentList();
        if (pal != null && p instanceof Tree.MemberOrTypeExpression) {
            Tree.MemberOrTypeExpression mte = (Tree.MemberOrTypeExpression)p;
            List<Tree.PositionalArgument> args = pal.getPositionalArguments();
            ArrayList<Type> signature = new ArrayList<Type>(args.size());
            boolean spread = false;
            int s = args.size();
            for (int i = 0; i < s; ++i) {
                Tree.PositionalArgument pa = args.get(i);
                Type t = pa.getTypeModel();
                Type pat = this.unit.denotableType(t);
                if (pa instanceof Tree.SpreadArgument) {
                    if (this.unit.isTupleType(pat)) {
                        signature.addAll(this.unit.getTupleElementTypes(pat));
                        spread = this.unit.isTupleLengthUnbounded(pat);
                        continue;
                    }
                    signature.add(pat);
                    spread = true;
                    continue;
                }
                if (pa instanceof Tree.Comprehension) {
                    signature.add(this.unit.getSequentialType(pat));
                    spread = true;
                    continue;
                }
                signature.add(pat);
            }
            mte.setSignature(signature);
            mte.setEllipsis(spread);
        }
    }

    private void checkSuperInvocation(Tree.MemberOrTypeExpression qmte, List<Type> signature, boolean spread) {
        Declaration member = qmte.getDeclaration();
        if (member != null) {
            String name = member.getName();
            TypeDeclaration type = (TypeDeclaration)member.getContainer();
            if (member.isFormal() && !this.inExtendsClause) {
                qmte.addError("supertype member is declared formal: '" + name + "' of '" + type.getName() + "'");
            } else {
                Scope scope = qmte.getScope();
                ClassOrInterface ci = ModelUtil.getContainingClassOrInterface(scope);
                if (ci != null) {
                    Declaration etm;
                    Type et = ci.getExtendedType();
                    if (et != null && (etm = et.getDeclaration().getMember(name, signature, spread)) != null && !etm.getContainer().equals(type) && etm.refines(member)) {
                        TypeDeclaration container = (TypeDeclaration)etm.getContainer();
                        qmte.addError("inherited member is refined by intervening superclass: '" + container.getName() + "' refines '" + name + "' declared by '" + type.getName() + "'");
                    }
                    for (Type st : ci.getSatisfiedTypes()) {
                        Declaration stm = st.getDeclaration().getMember(name, signature, spread);
                        if (stm == null || stm.getContainer().equals(type) || !stm.refines(member)) continue;
                        TypeDeclaration container = (TypeDeclaration)stm.getContainer();
                        qmte.addError("inherited member is refined by intervening superinterface: '" + container.getName() + "' refines '" + name + "' declared by '" + type.getName() + "'");
                    }
                }
            }
        }
    }

    private void visitInvocationPrimary(Tree.InvocationExpression that) {
        Tree.Term primary = TreeUtil.unwrapExpressionUntilTerm(that.getPrimary());
        if (primary instanceof Tree.StaticMemberOrTypeExpression) {
            Tree.StaticMemberOrTypeExpression pmte = (Tree.StaticMemberOrTypeExpression)primary;
            this.visitInvocationPrimary(that, pmte);
        } else if (primary instanceof Tree.ExtendedTypeExpression) {
            Tree.ExtendedTypeExpression ete = (Tree.ExtendedTypeExpression)primary;
            this.visitExtendedTypePrimary(ete);
        } else {
            this.visitInvocationPrimary(that, primary);
        }
    }

    private void visitInvocationPrimary(Tree.InvocationExpression that, Tree.Term term) {
        Type type;
        if (term != null && (type = term.getTypeModel()) != null && (type = type.resolveAliases()).isTypeConstructor()) {
            List<Type> typeArgs = this.getOrInferTypeArgumentsForTypeConstructor(that, null, type, null);
            this.checkArgumentsAgainstTypeConstructor(typeArgs, null, type, term);
            Type fullType = ExpressionVisitor.accountForGenericFunctionRef(true, null, null, typeArgs, type);
            term.setTypeModel(fullType);
        }
    }

    private void visitInvocationPrimary(Tree.InvocationExpression that, Tree.StaticMemberOrTypeExpression reference) {
        Tree.QualifiedMemberExpression qme;
        TypedDeclaration member;
        TypeDeclaration type;
        Tree.QualifiedMemberOrTypeExpression qmte;
        Tree.Term term;
        if (reference instanceof Tree.QualifiedMemberOrTypeExpression && (term = TreeUtil.unwrapExpressionUntilTerm((qmte = (Tree.QualifiedMemberOrTypeExpression)reference).getPrimary())) instanceof Tree.StaticMemberOrTypeExpression) {
            Tree.StaticMemberOrTypeExpression pmte = (Tree.StaticMemberOrTypeExpression)term;
            this.visitInvocationPrimary(that, pmte);
        }
        Tree.TypeArguments tas = reference.getTypeArguments();
        if (reference instanceof Tree.BaseTypeExpression) {
            Tree.BaseTypeExpression bte = (Tree.BaseTypeExpression)reference;
            type = this.resolveBaseTypeExpression(bte, true);
            if (type != null) {
                this.setArgumentParameters(that, type);
                Type receivingType = this.getBaseReceivingType(that, type);
                List<Type> typeArgs = this.getOrInferTypeArguments(that, type, reference, receivingType);
                tas.setTypeModels(typeArgs);
                this.visitBaseTypeExpression(bte, type, typeArgs, tas, receivingType);
            }
        } else if (reference instanceof Tree.QualifiedTypeExpression) {
            Tree.QualifiedTypeExpression qte = (Tree.QualifiedTypeExpression)reference;
            type = this.resolveQualifiedTypeExpression(qte, true);
            if (type != null) {
                this.setArgumentParameters(that, type);
                Type receivingType = this.getReceivingType(qte);
                List<Type> typeArgs = this.getOrInferTypeArguments(that, type, reference, this.unwrap(receivingType, qte));
                tas.setTypeModels(typeArgs);
                Tree.Primary primary = qte.getPrimary();
                if (primary instanceof Tree.Package) {
                    this.visitBaseTypeExpression(qte, type, typeArgs, tas, null);
                } else {
                    this.visitQualifiedTypeExpression(qte, receivingType, type, typeArgs, tas);
                }
            }
        } else if (reference instanceof Tree.BaseMemberExpression) {
            Tree.BaseMemberExpression bme = (Tree.BaseMemberExpression)reference;
            TypedDeclaration base = this.resolveBaseMemberExpression(bme, true);
            if (base != null) {
                this.setArgumentParameters(that, base);
                Type receivingType = this.getBaseReceivingType(that, base);
                List<Type> typeArgs = this.getOrInferTypeArguments(that, base, reference, receivingType);
                tas.setTypeModels(typeArgs);
                this.visitBaseMemberExpression(bme, base, typeArgs, tas, receivingType);
            }
        } else if (reference instanceof Tree.QualifiedMemberExpression && (member = this.resolveQualifiedMemberExpression(qme = (Tree.QualifiedMemberExpression)reference, true)) != null) {
            this.setArgumentParameters(that, member);
            Type receivingType = this.getReceivingType(qme);
            List<Type> typeArgs = this.getOrInferTypeArguments(that, member, reference, this.unwrap(receivingType, qme));
            tas.setTypeModels(typeArgs);
            Tree.Primary primary = qme.getPrimary();
            if (primary instanceof Tree.Package) {
                this.visitBaseMemberExpression(qme, member, typeArgs, tas, null);
            } else {
                this.visitQualifiedMemberExpression(qme, receivingType, member, typeArgs, tas);
            }
        }
    }

    protected Type getBaseReceivingType(Tree.InvocationExpression that, Declaration dec) {
        Scope scope = that.getScope();
        if (dec.isClassOrInterfaceMember() && !dec.isStaticallyImportable() && !dec.isDefinedInScope(scope)) {
            ClassOrInterface ci = (ClassOrInterface)dec.getContainer();
            Type qualifyingType = scope.getDeclaringType(dec);
            List<Type> inferredArgs = new TypeArgumentInference(this.unit).getInferredTypeArgsForReference(that, dec, ci, qualifyingType);
            return ci.appliedType(null, inferredArgs);
        }
        return null;
    }

    private Type getReceivingType(Tree.QualifiedMemberOrTypeExpression reference) {
        Tree.Primary primary = reference.getPrimary();
        if (primary instanceof Tree.Package) {
            return null;
        }
        return primary.getTypeModel().resolveAliases();
    }

    private void setArgumentParameters(Tree.InvocationExpression that, Declaration invoked) {
        Functional fun;
        List<ParameterList> pls;
        if (invoked instanceof Functional && !(pls = (fun = (Functional)((Object)invoked)).getParameterLists()).isEmpty()) {
            ParameterList pl = pls.get(0);
            Tree.PositionalArgumentList pal = that.getPositionalArgumentList();
            if (pal != null) {
                List<Tree.PositionalArgument> args = pal.getPositionalArguments();
                List<Parameter> params = pl.getParameters();
                int j = 0;
                for (int i = 0; i < args.size() && j < params.size(); ++i) {
                    Tree.PositionalArgument arg = args.get(i);
                    Parameter param = params.get(j);
                    if (arg != null && param != null) {
                        arg.setParameter(param);
                    }
                    if (param != null && param.isSequenced()) continue;
                    ++j;
                }
            }
        }
    }

    private List<Type> getOrInferTypeArguments(Tree.InvocationExpression that, Declaration dec, Tree.StaticMemberOrTypeExpression reference, Type receiverType) {
        Tree.TypeArguments tas = reference.getTypeArguments();
        boolean explicit = tas instanceof Tree.TypeArgumentList;
        if (AnalyzerUtil.isGeneric(dec)) {
            if (explicit) {
                return AnalyzerUtil.getTypeArguments(tas, receiverType, ModelUtil.getTypeParameters(dec));
            }
            List<Type> typeArgs = this.getInferredTypeArguments(that, reference, (Generic)((Object)dec), receiverType);
            return typeArgs;
        }
        if (dec instanceof Value) {
            Value value = (Value)dec;
            Type type = value.getType();
            if (type != null && (type = type.resolveAliases()).isTypeConstructor()) {
                return this.getOrInferTypeArgumentsForTypeConstructor(that, receiverType, type, tas);
            }
            return AnalyzerUtil.NO_TYPE_ARGS;
        }
        return AnalyzerUtil.NO_TYPE_ARGS;
    }

    private List<Type> getOrInferTypeArgumentsForTypeConstructor(Tree.InvocationExpression that, Type receiverType, Type type, Tree.TypeArguments tas) {
        TypeDeclaration td = type.getDeclaration();
        List<TypeParameter> typeParameters = td.getTypeParameters();
        boolean explicit = tas instanceof Tree.TypeArgumentList;
        if (explicit) {
            return AnalyzerUtil.getTypeArguments(tas, receiverType, typeParameters);
        }
        return new TypeArgumentInference(this.unit).getInferredTypeArgsForTypeConstructor(that, receiverType, type, typeParameters);
    }

    private List<Type> getInferredTypeArguments(Tree.InvocationExpression that, Tree.StaticMemberOrTypeExpression reference, Generic generic, Type receiverType) {
        Tree.Term primary = TreeUtil.unwrapExpressionUntilTerm(that.getPrimary());
        if (primary instanceof Tree.StaticMemberOrTypeExpression) {
            Tree.StaticMemberOrTypeExpression pmte = (Tree.StaticMemberOrTypeExpression)primary;
            if (ExpressionVisitor.isStaticReference(pmte)) {
                if (reference == pmte) {
                    return null;
                }
                TypeDeclaration type = (TypeDeclaration)generic;
                return new TypeArgumentInference(this.unit).getInferredTypeArgsForStaticReference(that, type, receiverType);
            }
            Declaration declaration = pmte.getDeclaration();
            return new TypeArgumentInference(this.unit).getInferredTypeArgsForReference(that, declaration, generic, receiverType);
        }
        return null;
    }

    private static boolean isStaticReference(Tree.StaticMemberOrTypeExpression reference) {
        if (reference.getStaticMethodReference()) {
            Declaration declaration = reference.getDeclaration();
            if (declaration == null) {
                return true;
            }
            if (ModelUtil.isConstructor(declaration)) {
                return false;
            }
            return !declaration.isStaticallyImportable();
        }
        return false;
    }

    private void visitDirectInvocation(Tree.InvocationExpression that) {
        Tree.Term primary = TreeUtil.unwrapExpressionUntilTerm(that.getPrimary());
        if (primary == null) {
            return;
        }
        Tree.MemberOrTypeExpression mte = (Tree.MemberOrTypeExpression)primary;
        Reference prf = mte.getTarget();
        Declaration dec = mte.getDeclaration();
        Functional fun = (Functional)((Object)dec);
        if (dec != null) {
            List<ParameterList> parameterLists;
            List<Type> tal;
            Type ct;
            Tree.NamedArgumentList nal;
            Class c;
            if (!(primary instanceof Tree.ExtendedTypeExpression) && dec instanceof Class && (c = (Class)dec).isAbstract()) {
                that.addError("abstract class may not be instantiated: '" + dec.getName(this.unit) + "'");
            }
            if ((nal = that.getNamedArgumentList()) != null && dec.isAbstraction()) {
                that.addError("overloaded declarations may not be called using named arguments: '" + dec.getName(this.unit) + "'");
            }
            if ((ct = primary.getTypeModel()) != null && !(tal = ct.getTypeArgumentList()).isEmpty()) {
                that.setTypeModel(tal.get(0));
            }
            if (nal != null && !(parameterLists = fun.getParameterLists()).isEmpty() && !parameterLists.get(0).isNamedParametersSupported()) {
                that.addError("named invocations of Java methods not supported");
            }
            if (!dec.isAbstraction()) {
                this.checkInvocationArguments(that, prf, fun);
            }
        }
    }

    private void visitIndirectInvocation(Tree.InvocationExpression that) {
        Tree.Term primary = TreeUtil.unwrapExpressionUntilTerm(that.getPrimary());
        if (primary == null) {
            return;
        }
        Type pt = primary.getTypeModel();
        if (!ModelUtil.isTypeUnknown(pt)) {
            if (that.getNamedArgumentList() != null) {
                that.addError("named arguments not supported for indirect invocations");
                return;
            }
            Tree.PositionalArgumentList pal = that.getPositionalArgumentList();
            if (pal == null) {
                return;
            }
            if (pt.isNothing()) {
                that.setTypeModel(this.unit.getNothingType());
            } else if (AnalyzerUtil.checkCallable(pt, primary, "invoked expression must be callable")) {
                Type paramTypesAsTuple;
                Interface cd = this.unit.getCallableDeclaration();
                List<Type> typeArgs = pt.getSupertype(cd).getTypeArgumentList();
                if (!typeArgs.isEmpty()) {
                    that.setTypeModel(typeArgs.get(0));
                }
                if (typeArgs.size() >= 2 && (paramTypesAsTuple = typeArgs.get(1)) != null) {
                    TypeDeclaration pttd = paramTypesAsTuple.getDeclaration();
                    if (pttd instanceof ClassOrInterface && (pttd.isEmpty() || pttd.isTuple() || pttd.isSequence() || pttd.isSequential())) {
                        this.checkIndirectInvocationArguments(that, paramTypesAsTuple, this.unit.getTupleElementTypes(paramTypesAsTuple), this.unit.isTupleLengthUnbounded(paramTypesAsTuple), this.unit.isTupleVariantAtLeastOne(paramTypesAsTuple), this.unit.getTupleMinimumLength(paramTypesAsTuple));
                    } else {
                        Type tt = AnalyzerUtil.getTupleType(pal.getPositionalArguments(), this.unit, false);
                        AnalyzerUtil.checkAssignable(tt, paramTypesAsTuple, pal, "argument list type must be assignable to parameter list type");
                    }
                }
            }
        }
    }

    private void checkInvocationArguments(Tree.InvocationExpression that, Reference prf, Functional dec) {
        List<ParameterList> pls = dec.getParameterLists();
        if (!pls.isEmpty()) {
            Tree.NamedArgumentList namedArgs;
            ParameterList pl = pls.get(0);
            Tree.PositionalArgumentList args = that.getPositionalArgumentList();
            if (args != null) {
                this.checkPositionalArguments(pl, prf, args, that);
            }
            if ((namedArgs = that.getNamedArgumentList()) != null && pl.isNamedParametersSupported()) {
                namedArgs.getNamedArgumentList().setParameterList(pl);
                this.checkNamedArguments(pl, prf, namedArgs);
            }
        }
    }

    private void checkNamedArguments(ParameterList pl, Reference pr, Tree.NamedArgumentList nal) {
        HashSet<Parameter> foundParameters = new HashSet<Parameter>();
        List<Tree.NamedArgument> na = nal.getNamedArguments();
        for (Tree.NamedArgument a : na) {
            this.checkNamedArg(a, pl, pr, foundParameters);
        }
        Tree.SequencedArgument sa = nal.getSequencedArgument();
        if (sa != null) {
            this.checkSequencedArg(sa, pl, pr, foundParameters);
        } else {
            Parameter sp = AnalyzerUtil.getUnspecifiedParameter(pr, pl, foundParameters);
            if (sp != null && !this.unit.isNonemptyIterableType(sp.getType())) {
                foundParameters.add(sp);
            }
        }
        this.checkForMissingNamedParameters(pl, pr, nal, foundParameters);
    }

    private void checkForMissingNamedParameters(ParameterList pl, Reference pr, Tree.NamedArgumentList nal, Set<Parameter> foundParameters) {
        StringBuilder missing = null;
        int count = 0;
        for (Parameter p : pl.getParameters()) {
            if (foundParameters.contains(p) || p.isDefaulted() || p.isSequenced() && !p.isAtLeastOne()) continue;
            ++count;
            Type type = pr.getTypedParameter(p).getFullType();
            if (missing == null) {
                missing = new StringBuilder();
            } else {
                missing.append(", ");
            }
            if (type != null) {
                missing.append(type.asString(this.unit)).append(" ");
            }
            missing.append(p.getName());
        }
        if (count == 1) {
            nal.addError("missing named argument to required parameter '" + missing + "' of '" + pr.getDeclaration().getName(this.unit) + "'", 11000);
        } else if (count > 1) {
            nal.addError("missing named arguments to " + count + " required parameters '" + missing + "' of '" + pr.getDeclaration().getName(this.unit) + "'", 11000);
        }
    }

    private void checkSequencedArg(Tree.SequencedArgument sa, ParameterList pl, Reference pr, Set<Parameter> foundParameters) {
        Parameter sp = AnalyzerUtil.getUnspecifiedParameter(pr, pl, foundParameters);
        if (sp == null) {
            sa.addError("all iterable parameters specified by named argument list: '" + pr.getDeclaration().getName(this.unit) + "' does not declare any additional parameters of type 'Iterable'");
        } else {
            if (!foundParameters.add(sp)) {
                sa.addError("duplicate argument for parameter: '" + sp.getName() + "' of '" + pr.getDeclaration().getName(this.unit) + "'");
            } else if (!this.dynamic && ModelUtil.isTypeUnknown(sp.getType())) {
                sa.addError("parameter type could not be determined: " + this.paramdesc(sp) + AnalyzerUtil.getTypeUnknownError(sp.getType()));
            }
            this.checkSequencedArgument(sa, pr, sp);
        }
    }

    private void checkNamedArg(Tree.NamedArgument a, ParameterList pl, Reference pr, Set<Parameter> foundParameters) {
        Parameter param = AnalyzerUtil.getMatchingParameter(pl, a, foundParameters);
        if (param == null) {
            if (a.getIdentifier() == null) {
                a.addError("all parameters specified by named argument list: '" + pr.getDeclaration().getName(this.unit) + "' does not declare any additional parameters");
            } else {
                a.addError("no matching parameter for named argument '" + TreeUtil.name(a.getIdentifier()) + "' declared by '" + pr.getDeclaration().getName(this.unit) + "'", 101);
            }
        } else {
            if (!foundParameters.add(param)) {
                a.addError("duplicate argument for parameter: '" + param.getName() + "' of '" + pr.getDeclaration().getName(this.unit) + "'");
            } else if (!this.dynamic && ModelUtil.isTypeUnknown(param.getType())) {
                a.addError("parameter type could not be determined: " + this.paramdesc(param) + AnalyzerUtil.getTypeUnknownError(param.getType()));
            }
            this.checkNamedArgument(a, pr, param);
            if (a.getIdentifier() == null) {
                Tree.Identifier node = new Tree.Identifier(null);
                node.setScope(a.getScope());
                node.setUnit(a.getUnit());
                node.setText(param.getName());
                a.setIdentifier(node);
            }
        }
    }

    private String paramdesc(Parameter p) {
        Declaration dec = p.getDeclaration();
        String result = "'" + p.getName() + "' of '" + dec.getName(this.unit) + "'";
        if (dec.isClassOrInterfaceMember()) {
            ClassOrInterface ci = (ClassOrInterface)dec.getContainer();
            result = result + " in '" + ci.getName(this.unit) + "'";
        }
        return result;
    }

    private String argdesc(Parameter p, Reference pr) {
        Declaration dec = pr.getDeclaration();
        String result = "'" + p.getName() + "' of '" + dec.getName(this.unit) + "'";
        Type qt = pr.getQualifyingType();
        if (qt != null) {
            result = result + " in '" + qt.asString(this.unit) + "'";
        }
        return result;
    }

    private void checkNamedArgument(Tree.NamedArgument arg, Reference reference, Parameter param) {
        arg.setParameter(param);
        Type argType = null;
        if (arg instanceof Tree.SpecifiedArgument) {
            Tree.SpecifiedArgument sa = (Tree.SpecifiedArgument)arg;
            Tree.Expression e = sa.getSpecifierExpression().getExpression();
            if (e != null) {
                argType = e.getTypeModel();
            }
        } else if (arg instanceof Tree.TypedArgument) {
            Tree.TypedArgument typedArg = (Tree.TypedArgument)arg;
            TypedDeclaration argDec = typedArg.getDeclarationModel();
            TypedReference argRef = argDec.getTypedReference();
            argType = AnalyzerUtil.isGeneric(argDec) ? ModelUtil.genericFunctionType((Generic)((Object)argDec), arg.getScope(), argDec, argRef, this.unit) : argRef.getFullType();
            this.checkArgumentToVoidParameter(param, typedArg);
            if (!this.dynamic && ModelUtil.isTypeUnknown(argType)) {
                arg.addError("could not determine type of named argument: '" + param.getName() + "'");
            }
        }
        TypedReference paramRef = reference.getTypedParameter(param);
        FunctionOrValue paramModel = param.getModel();
        Type paramType = AnalyzerUtil.isGeneric(paramModel) ? ModelUtil.genericFunctionType((Generic)((Object)paramModel), arg.getScope(), paramModel, paramRef, this.unit) : paramRef.getFullType();
        if (!ModelUtil.isTypeUnknown(argType) && !ModelUtil.isTypeUnknown(paramType)) {
            Node node;
            if (arg instanceof Tree.SpecifiedArgument) {
                Tree.SpecifiedArgument specifiedArg = (Tree.SpecifiedArgument)arg;
                node = specifiedArg.getSpecifierExpression();
            } else {
                node = arg;
            }
            AnalyzerUtil.checkAssignable(argType, paramType, node, "named argument must be assignable to parameter " + this.argdesc(param, reference), 2100);
        }
    }

    private void checkArgumentToVoidParameter(Parameter p, Tree.TypedArgument ta) {
        Tree.Type t;
        Tree.Expression e;
        Tree.MethodArgument ma;
        Tree.SpecifierExpression se;
        if (ta instanceof Tree.MethodArgument && (se = (ma = (Tree.MethodArgument)ta).getSpecifierExpression()) != null && (e = se.getExpression()) != null && (t = ta.getType()) instanceof Tree.FunctionModifier && t.getToken() == null && p.isDeclaredVoid() && !this.isSatementExpression(e)) {
            ta.addError("functional parameter is declared void so argument may not evaluate to a value: '" + p.getName() + "' is declared 'void'");
        }
    }

    private void checkSequencedArgument(Tree.SequencedArgument sa, Reference pr, Parameter p) {
        sa.setParameter(p);
        List<Tree.PositionalArgument> args = sa.getPositionalArguments();
        Type paramType = pr.getTypedParameter(p).getFullType();
        Interface id = this.unit.getIterableDeclaration();
        Type att = AnalyzerUtil.getTupleType(args, this.unit, false).getSupertype(id);
        if (!ModelUtil.isTypeUnknown(att) && !ModelUtil.isTypeUnknown(paramType)) {
            AnalyzerUtil.checkAssignable(att, paramType, sa, "iterable arguments must be assignable to iterable parameter " + this.argdesc(p, pr));
        }
    }

    private void checkPositionalArguments(ParameterList pl, Reference pr, Tree.PositionalArgumentList pal, Tree.InvocationExpression that) {
        int i;
        List<Tree.PositionalArgument> args = pal.getPositionalArguments();
        List<Parameter> params = pl.getParameters();
        Declaration target = pr.getDeclaration();
        int argCount = args.size();
        int paramsSize = params.size();
        for (i = 0; i < paramsSize; ++i) {
            Parameter param = params.get(i);
            if (i >= argCount) {
                if (!ExpressionVisitor.isRequired(param)) continue;
                Tree.PositionalArgumentList errorNode = that instanceof Tree.Annotation && args.isEmpty() ? that : pal;
                StringBuilder message = new StringBuilder();
                if (i + 1 < paramsSize && ExpressionVisitor.isRequired(params.get(i + 1))) {
                    Parameter p;
                    message.append("missing arguments to required parameters '");
                    this.appendParam(pr, param, message);
                    int count = 1;
                    for (int j = i + 1; !(j >= paramsSize || (p = params.get(j)).isDefaulted() || p.isSequenced() && !p.isAtLeastOne()); ++j) {
                        message.append(", ");
                        this.appendParam(pr, p, message);
                        ++count;
                    }
                    message.append("'").insert(20, " " + count);
                } else {
                    message.append("missing argument to required parameter '");
                    this.appendParam(pr, param, message);
                    message.append("'");
                }
                message.append(" of '").append(target.getName(this.unit)).append("'");
                errorNode.addError(message.toString());
                break;
            }
            Tree.PositionalArgument arg = args.get(i);
            Type pt = param.getType();
            if (!this.dynamic && ModelUtil.isTypeUnknown(pt)) {
                arg.addError("parameter type could not be determined: " + this.paramdesc(param) + AnalyzerUtil.getTypeUnknownError(pt));
            }
            if (arg instanceof Tree.SpreadArgument) {
                this.checkSpreadArgument(pr, param, arg, (Tree.SpreadArgument)arg, params.subList(i, paramsSize));
                break;
            }
            if (arg instanceof Tree.Comprehension) {
                if (param.isSequenced()) {
                    this.checkComprehensionPositionalArgument(param, pr, (Tree.Comprehension)arg, param.isAtLeastOne());
                    break;
                }
                arg.addError("not a variadic parameter: parameter '" + param.getName() + "' of '" + target.getName() + "'");
                break;
            }
            if (param.isSequenced()) {
                this.checkSequencedPositionalArgument(param, pr, args.subList(i, argCount));
                return;
            }
            this.checkPositionalArgument(param, pr, (Tree.ListedArgument)arg);
        }
        for (i = paramsSize; i < argCount; ++i) {
            Tree.PositionalArgument arg = args.get(i);
            if (arg instanceof Tree.SpreadArgument && this.unit.isEmptyType(arg.getTypeModel())) continue;
            arg.addError("no matching parameter declared by '" + target.getName(this.unit) + "': '" + target.getName(this.unit) + "' has " + paramsSize + " parameters", 2000);
        }
        this.checkJavaAnnotationElements(args, params, target);
    }

    private static boolean isRequired(Parameter param) {
        return !param.isDefaulted() && (!param.isSequenced() || param.isAtLeastOne());
    }

    private void appendParam(Reference pr, Parameter param, StringBuilder missing) {
        Type pt = pr.getTypedParameter(param).getFullType();
        if (!ModelUtil.isTypeUnknown(pt)) {
            if (param.isSequenced()) {
                pt = this.unit.getSequentialElementType(pt);
            }
            missing.append(pt.asString(this.unit));
            if (param.isSequenced()) {
                missing.append(param.isAtLeastOne() ? "+" : "*");
            }
            missing.append(" ");
        }
        missing.append(param.getName());
    }

    private void checkJavaAnnotationElements(List<Tree.PositionalArgument> args, List<Parameter> params, Declaration target) {
        Function method;
        ParameterList parameterList;
        if (target instanceof Function && target.isAnnotation() && !(parameterList = (method = (Function)target).getFirstParameterList()).isPositionalParametersSupported()) {
            for (int i = 0; i < params.size() && i < args.size(); ++i) {
                Parameter parameter = parameterList.getParameters().get(i);
                Tree.PositionalArgument arg = args.get(i);
                boolean isJavaAnnotationValueParameter = "value".equals(parameter.getName());
                if (arg == null || isJavaAnnotationValueParameter) continue;
                arg.addUsageWarning(Warning.javaAnnotationElement, "positional argument to Java annotation element: '" + parameter.getName() + "' (use named arguments)");
            }
        }
    }

    private void checkSpreadArgument(Reference pr, Parameter p, Tree.PositionalArgument a, Tree.SpreadArgument arg, List<Parameter> params) {
        a.setParameter(p);
        Type rat = arg.getTypeModel();
        if (!ModelUtil.isTypeUnknown(rat) && this.unit.isIterableType(rat)) {
            Type at = AnalyzerUtil.spreadType(rat, this.unit, true);
            Type ptt = this.unit.getParameterTypesAsTupleType(params, pr);
            if (!ModelUtil.isTypeUnknown(at) && !ModelUtil.isTypeUnknown(ptt)) {
                AnalyzerUtil.checkAssignable(at, ptt, arg, "spread argument not assignable to parameter types");
            }
        }
    }

    private void appendParamType(Type pt, boolean sequenced, StringBuilder missing) {
        if (!ModelUtil.isTypeUnknown(pt)) {
            boolean atLeastOne;
            if (sequenced) {
                atLeastOne = this.unit.isSequenceType(pt);
                pt = this.unit.getSequentialElementType(pt);
            } else {
                atLeastOne = false;
            }
            missing.append(pt.asString(this.unit));
            if (sequenced) {
                missing.append(atLeastOne ? "+" : "*");
            }
        }
    }

    private void checkIndirectInvocationArguments(Tree.InvocationExpression that, Type paramTypesAsTuple, List<Type> paramTypes, boolean sequenced, boolean atLeastOne, int firstDefaulted) {
        int i;
        Tree.PositionalArgumentList pal = that.getPositionalArgumentList();
        List<Tree.PositionalArgument> args = pal.getPositionalArguments();
        int paramsSize = paramTypes.size();
        int argCount = args.size();
        for (int i2 = 0; i2 < paramsSize; ++i2) {
            if (!ModelUtil.isTypeUnknown(paramTypes.get(i2))) continue;
            that.addError("parameter types cannot be determined from function reference");
            return;
        }
        int lastRequired = ExpressionVisitor.lastRequired(paramsSize, firstDefaulted, sequenced, atLeastOne);
        for (i = 0; i < paramsSize; ++i) {
            Type paramType = paramTypes.get(i);
            if (i >= argCount) {
                StringBuilder missingTypes = new StringBuilder();
                this.appendParamType(paramType, sequenced && i == paramsSize - 1, missingTypes);
                if (i == lastRequired) {
                    pal.addError("missing argument to required parameter of type '" + missingTypes + "' in indirect invocation");
                    break;
                }
                if (i >= lastRequired) break;
                for (int j = i + 1; j <= lastRequired; ++j) {
                    missingTypes.append(", ");
                    this.appendParamType(paramTypes.get(j), sequenced && j == paramsSize - 1, missingTypes);
                }
                pal.addError("missing arguments to " + (lastRequired - i + 1) + " required parameters of types '" + missingTypes + "' in indirect invocation");
                break;
            }
            Tree.PositionalArgument arg = args.get(i);
            Type at = arg.getTypeModel();
            if (arg instanceof Tree.SpreadArgument) {
                Tree.SpreadArgument sa = (Tree.SpreadArgument)arg;
                Type tt = this.unit.getTailType(paramTypesAsTuple, i);
                this.checkSpreadIndirectArgument(sa, tt, at);
                break;
            }
            if (arg instanceof Tree.Comprehension) {
                if (sequenced && i == paramsSize - 1) {
                    Tree.Comprehension c = (Tree.Comprehension)arg;
                    this.checkComprehensionIndirectArgument(c, paramType, atLeastOne);
                    break;
                }
                arg.addError("not a variadic parameter: parameter " + i);
                break;
            }
            if (sequenced && i == paramsSize - 1) {
                List<Tree.PositionalArgument> sublist = args.subList(i, argCount);
                this.checkSequencedIndirectArgument(sublist, paramType);
                return;
            }
            if (at == null || paramType == null || ModelUtil.isTypeUnknown(at) || ModelUtil.isTypeUnknown(paramType)) continue;
            AnalyzerUtil.checkAssignable(at, paramType, arg, "argument must be assignable to parameter type");
        }
        for (i = paramsSize; i < argCount; ++i) {
            Tree.PositionalArgument arg = args.get(i);
            if (arg instanceof Tree.SpreadArgument && this.unit.isEmptyType(arg.getTypeModel())) continue;
            arg.addError("no matching parameter: function reference has " + paramsSize + " parameters", 2000);
        }
    }

    private static int lastRequired(int paramsSize, int firstDefaulted, boolean sequenced, boolean atLeastOne) {
        if (firstDefaulted < paramsSize) {
            return firstDefaulted - 1;
        }
        return sequenced && !atLeastOne ? paramsSize - 2 : paramsSize - 1;
    }

    private void checkSpreadIndirectArgument(Tree.SpreadArgument sa, Type tailType, Type at) {
        Type sat;
        if (!ModelUtil.isTypeUnknown(at) && this.unit.isIterableType(at) && !ModelUtil.isTypeUnknown(sat = AnalyzerUtil.spreadType(at, this.unit, true)) && !ModelUtil.isTypeUnknown(tailType)) {
            AnalyzerUtil.checkAssignable(sat, tailType, sa, "spread argument not assignable to parameter types");
        }
    }

    private void checkSequencedIndirectArgument(List<Tree.PositionalArgument> args, Type paramType) {
        Type set = paramType == null ? null : this.unit.getIteratedType(paramType);
        for (int j = 0; j < args.size(); ++j) {
            Tree.PositionalArgument a = args.get(j);
            Type at = a.getTypeModel();
            if (ModelUtil.isTypeUnknown(at) || ModelUtil.isTypeUnknown(paramType)) continue;
            if (a instanceof Tree.SpreadArgument) {
                at = AnalyzerUtil.spreadType(at, this.unit, true);
                AnalyzerUtil.checkAssignable(at, paramType, a, "spread argument must be assignable to variadic parameter", 2101);
                continue;
            }
            AnalyzerUtil.checkAssignable(at, set, a, "argument must be assignable to variadic parameter", 2101);
            Interface sd = this.unit.getSequentialDeclaration();
            paramType = paramType.getSupertype(sd);
        }
    }

    private void checkComprehensionIndirectArgument(Tree.Comprehension c, Type paramType, boolean atLeastOne) {
        Type set;
        Tree.InitialComprehensionClause icc = c.getInitialComprehensionClause();
        if (icc.getPossiblyEmpty() && atLeastOne) {
            c.addError("variadic parameter is required but comprehension is possibly empty");
        }
        Type at = c.getTypeModel();
        Type type = set = paramType == null ? null : this.unit.getIteratedType(paramType);
        if (!ModelUtil.isTypeUnknown(at) && !ModelUtil.isTypeUnknown(set)) {
            AnalyzerUtil.checkAssignable(at, set, c, "argument must be assignable to variadic parameter");
        }
    }

    private void checkSequencedPositionalArgument(Parameter p, Reference pr, List<Tree.PositionalArgument> args) {
        Type paramType = pr.getTypedParameter(p).getFullType();
        Type set = paramType == null ? null : this.unit.getIteratedType(paramType);
        for (int j = 0; j < args.size(); ++j) {
            Tree.PositionalArgument a = args.get(j);
            a.setParameter(p);
            Type at = a.getTypeModel();
            if (ModelUtil.isTypeUnknown(at) || ModelUtil.isTypeUnknown(paramType)) continue;
            if (a instanceof Tree.SpreadArgument) {
                at = AnalyzerUtil.spreadType(at, this.unit, true);
                AnalyzerUtil.checkAssignable(at, paramType, a, "spread argument must be assignable to variadic parameter " + this.argdesc(p, pr), 2101);
                continue;
            }
            AnalyzerUtil.checkAssignable(at, set, a, "argument must be assignable to variadic parameter " + this.argdesc(p, pr), 2101);
            Interface sd = this.unit.getSequentialDeclaration();
            paramType = paramType.getSupertype(sd);
        }
    }

    private void checkComprehensionPositionalArgument(Parameter p, Reference pr, Tree.Comprehension c, boolean atLeastOne) {
        c.setParameter(p);
        Tree.InitialComprehensionClause icc = c.getInitialComprehensionClause();
        if (icc.getPossiblyEmpty() && atLeastOne) {
            c.addError("variadic parameter is required but comprehension is possibly empty");
        }
        Type paramType = pr.getTypedParameter(p).getFullType();
        c.setParameter(p);
        Type at = c.getTypeModel();
        if (!ModelUtil.isTypeUnknown(at) && !ModelUtil.isTypeUnknown(paramType)) {
            Type set = paramType == null ? null : this.unit.getIteratedType(paramType);
            AnalyzerUtil.checkAssignable(at, set, c, "argument must be assignable to variadic parameter " + this.argdesc(p, pr), 2101);
        }
    }

    private void checkPositionalArgument(Parameter p, Reference pr, Tree.ListedArgument a) {
        FunctionOrValue model = p.getModel();
        if (model != null) {
            TypedReference paramRef = pr.getTypedParameter(p);
            a.setParameter(p);
            Type paramType = AnalyzerUtil.isGeneric(model) ? ModelUtil.genericFunctionType((Generic)((Object)model), a.getScope(), model, paramRef, this.unit) : paramRef.getFullType();
            Type at = a.getTypeModel();
            if (!ModelUtil.isTypeUnknown(at) && !ModelUtil.isTypeUnknown(paramType)) {
                AnalyzerUtil.checkAssignable(at, paramType, a, "argument must be assignable to parameter " + this.argdesc(p, pr), 2100);
            }
        }
    }

    @Override
    public void visit(Tree.Comprehension that) {
        super.visit(that);
        Tree.InitialComprehensionClause icc = that.getInitialComprehensionClause();
        that.setTypeModel(icc.getTypeModel());
    }

    @Override
    public void visit(Tree.SpreadType that) {
        super.visit(that);
        Tree.Type type = that.getType();
        if (type != null) {
            Type at = this.unit.getAnythingType();
            AnalyzerUtil.checkAssignable(that.getTypeModel(), this.unit.getSequentialType(at), type, "spread type must be a sequence type");
        }
    }

    @Override
    public void visit(Tree.SpreadArgument that) {
        super.visit(that);
        Tree.Expression e = that.getExpression();
        if (e != null) {
            Type t = e.getTypeModel();
            if (!ModelUtil.isTypeUnknown(t) && !this.unit.isIterableType(t)) {
                e.addError("spread argument is not iterable: '" + t.asString(this.unit) + "' is not a subtype of 'Iterable'");
            }
            that.setTypeModel(t);
        }
    }

    @Override
    public void visit(Tree.ListedArgument that) {
        super.visit(that);
        Tree.Expression e = that.getExpression();
        if (e != null) {
            that.setTypeModel(e.getTypeModel());
        }
    }

    private boolean involvesUnknownTypes(Tree.ElementOrRange eor) {
        if (eor instanceof Tree.Element) {
            Tree.Element el = (Tree.Element)eor;
            Tree.Expression expression = el.getExpression();
            return ModelUtil.isTypeUnknown(expression.getTypeModel());
        }
        Tree.ElementRange er = (Tree.ElementRange)eor;
        Tree.Expression lb = er.getLowerBound();
        Tree.Expression ub = er.getUpperBound();
        return lb != null && ModelUtil.isTypeUnknown(lb.getTypeModel()) || ub != null && ModelUtil.isTypeUnknown(ub.getTypeModel());
    }

    @Override
    public void visit(Tree.IndexExpression that) {
        super.visit(that);
        Type pt = this.type(that);
        if (pt == null) {
            that.addError("could not determine type of receiver");
        } else {
            Tree.ElementOrRange eor = that.getElementOrRange();
            if (eor == null) {
                that.addError("malformed index expression");
            } else if (!ModelUtil.isTypeUnknown(pt) && !this.involvesUnknownTypes(eor)) {
                if (eor instanceof Tree.Element) {
                    Interface md;
                    List<Type> args;
                    Interface ld;
                    Type kt = null;
                    Type vt = null;
                    Interface cd = this.unit.getCorrespondenceDeclaration();
                    Type cst = pt.getSupertype(cd);
                    if (cst != null) {
                        List<Type> args2 = cst.getTypeArgumentList();
                        kt = args2.get(0);
                        vt = this.unit.getOptionalType(args2.get(1));
                    }
                    if (cst == null && (cst = pt.getSupertype(ld = this.unit.getJavaListDeclaration())) != null) {
                        args = cst.getTypeArgumentList();
                        kt = this.unit.getIntegerType();
                        vt = this.unit.getOptionalType(args.get(0));
                    }
                    if (cst == null && (cst = pt.getSupertype(md = this.unit.getJavaMapDeclaration())) != null) {
                        args = cst.getTypeArgumentList();
                        kt = args.get(0);
                        vt = this.unit.getOptionalType(args.get(1));
                    }
                    if (cst == null) {
                        boolean objectArray = this.unit.isJavaObjectArrayType(pt);
                        boolean primitiveArray = this.unit.isJavaPrimitiveArrayType(pt);
                        if (objectArray || primitiveArray) {
                            cst = pt;
                            kt = this.unit.getIntegerType();
                            Type et = this.unit.getJavaArrayElementType(pt);
                            Type type = vt = primitiveArray ? et : this.unit.getOptionalType(et);
                        }
                    }
                    if (cst == null) {
                        that.getPrimary().addError("illegal receiving type for index expression: '" + pt.getDeclaration().getName(this.unit) + "' is not a subtype of 'Correspondence'");
                    } else {
                        Tree.Element e = (Tree.Element)eor;
                        Tree.Expression ee = e.getExpression();
                        AnalyzerUtil.checkAssignable(ee.getTypeModel(), kt, ee, "index must be assignable to key type");
                        that.setTypeModel(vt);
                        Tree.Term t = ee.getTerm();
                        this.refineTypeForTupleElement(that, pt, t);
                    }
                } else {
                    Interface rd = this.unit.getRangedDeclaration();
                    Type rst = pt.getSupertype(rd);
                    if (rst == null) {
                        that.getPrimary().addError("illegal receiving type for index range expression: '" + pt.getDeclaration().getName(this.unit) + "' is not a subtype of 'Ranged'");
                    } else {
                        List<Type> args = rst.getTypeArgumentList();
                        Type kt = args.get(0);
                        Type rt = args.get(2);
                        Tree.ElementRange er = (Tree.ElementRange)eor;
                        Tree.Expression lb = er.getLowerBound();
                        Tree.Expression ub = er.getUpperBound();
                        Tree.Expression l = er.getLength();
                        if (lb != null) {
                            AnalyzerUtil.checkAssignable(lb.getTypeModel(), kt, lb, "lower bound must be assignable to index type");
                        }
                        if (ub != null) {
                            AnalyzerUtil.checkAssignable(ub.getTypeModel(), kt, ub, "upper bound must be assignable to index type");
                        }
                        if (l != null) {
                            AnalyzerUtil.checkAssignable(l.getTypeModel(), this.unit.getIntegerType(), l, "length must be an integer");
                        }
                        that.setTypeModel(rt);
                        if (lb != null && ub == null && l == null) {
                            this.refineTypeForTupleOpenRange(that, pt, lb.getTerm());
                        }
                    }
                }
            }
        }
    }

    private void refineTypeForTupleElement(Tree.IndexExpression that, Type pt, Tree.Term t) {
        boolean negated = false;
        if (t instanceof Tree.NegativeOp) {
            t = ((Tree.NegativeOp)t).getTerm();
            negated = true;
        } else if (t instanceof Tree.PositiveOp) {
            t = ((Tree.PositiveOp)t).getTerm();
        }
        Type tt = pt;
        if (this.unit.isSequentialType(tt) && t instanceof Tree.NaturalLiteral) {
            int index = Integer.parseInt(t.getText());
            if (negated) {
                index = -index;
            }
            List<Type> elementTypes = this.unit.getTupleElementTypes(tt);
            boolean variadic = this.unit.isTupleLengthUnbounded(tt);
            int minimumLength = this.unit.getTupleMinimumLength(tt);
            boolean atLeastOne = this.unit.isTupleVariantAtLeastOne(tt);
            if (elementTypes != null) {
                int size = elementTypes.size();
                Type nt = this.unit.getNullType();
                if (size == 0) {
                    that.setTypeModel(nt);
                } else if (index < 0) {
                    that.setTypeModel(nt);
                } else if (index < size - (variadic ? 1 : 0)) {
                    Type iet = elementTypes.get(index);
                    if (iet == null) {
                        return;
                    }
                    if (index >= minimumLength) {
                        iet = ModelUtil.unionType(iet, nt, this.unit);
                    }
                    that.setTypeModel(iet);
                } else if (variadic) {
                    Type iet = elementTypes.get(size - 1);
                    if (iet == null) {
                        return;
                    }
                    Type it = this.unit.getIteratedType(iet);
                    if (it == null) {
                        return;
                    }
                    if (!atLeastOne || index >= size) {
                        it = ModelUtil.unionType(it, nt, this.unit);
                    }
                    that.setTypeModel(it);
                } else {
                    that.setTypeModel(nt);
                }
            }
        }
    }

    private void refineTypeForTupleOpenRange(Tree.IndexExpression that, Type pt, Tree.Term l) {
        boolean lnegated = false;
        if (l instanceof Tree.NegativeOp) {
            l = ((Tree.NegativeOp)l).getTerm();
            lnegated = true;
        } else if (l instanceof Tree.PositiveOp) {
            l = ((Tree.PositiveOp)l).getTerm();
        }
        Type tt = pt;
        if (this.unit.isSequentialType(tt) && l instanceof Tree.NaturalLiteral) {
            int lindex = Integer.parseInt(l.getText());
            if (lnegated) {
                lindex = -lindex;
            }
            List<Type> elementTypes = this.unit.getTupleElementTypes(tt);
            boolean variadic = this.unit.isTupleLengthUnbounded(tt);
            boolean atLeastOne = this.unit.isTupleVariantAtLeastOne(tt);
            int minimumLength = this.unit.getTupleMinimumLength(tt);
            ArrayList<Type> list = new ArrayList<Type>();
            if (elementTypes != null) {
                int size = elementTypes.size();
                if (lindex < 0) {
                    lindex = 0;
                }
                for (int index = lindex; index < size - (variadic ? 1 : 0); ++index) {
                    Type et = elementTypes.get(index);
                    if (et == null) {
                        return;
                    }
                    list.add(et);
                }
                if (variadic) {
                    Type it = elementTypes.get(size - 1);
                    if (it == null) {
                        return;
                    }
                    Type rt = this.unit.getIteratedType(it);
                    if (rt == null) {
                        return;
                    }
                    list.add(rt);
                }
                Type rt = this.unit.getTupleType(list, variadic, atLeastOne && lindex < size, minimumLength - lindex);
                that.setTypeModel(ModelUtil.intersectionType(rt, that.getTypeModel(), this.unit));
            }
        }
    }

    private Type type(Tree.PostfixExpression that) {
        Tree.Primary p = that.getPrimary();
        return p == null ? null : p.getTypeModel();
    }

    private void assign(Tree.Term term) {
        if (term instanceof Tree.MemberOrTypeExpression) {
            Tree.MemberOrTypeExpression m = (Tree.MemberOrTypeExpression)term;
            m.setAssigned(true);
        }
    }

    @Override
    public void visit(Tree.PostfixOperatorExpression that) {
        this.assign(that.getTerm());
        super.visit(that);
        Type type = this.type(that);
        this.visitIncrementDecrement(that, type, that.getTerm());
        this.checkAssignability(that.getTerm(), that);
    }

    @Override
    public void visit(Tree.PrefixOperatorExpression that) {
        this.assign(that.getTerm());
        super.visit(that);
        Type type = this.type(that);
        if (that.getTerm() != null) {
            this.visitIncrementDecrement(that, type, that.getTerm());
            this.checkAssignability(that.getTerm(), that);
        }
    }

    private void visitIncrementDecrement(Tree.Term that, Type pt, Tree.Term term) {
        if (!ModelUtil.isTypeUnknown(pt)) {
            Type ot = AnalyzerUtil.checkSupertype(pt, this.unit.getOrdinalDeclaration(), term, "operand expression must be of enumerable type");
            if (ot != null) {
                Type ta = ot.getTypeArgumentList().get(0);
                AnalyzerUtil.checkAssignable(ta, pt, that, "result type must be assignable to declared type");
            }
            that.setTypeModel(pt);
        }
    }

    private void visitScaleOperator(Tree.ScaleOp that) {
        Interface sd;
        Type st;
        Type lhst = this.leftType(that);
        Type rhst = this.rightType(that);
        if (!ModelUtil.isTypeUnknown(rhst) && !ModelUtil.isTypeUnknown(lhst) && (st = AnalyzerUtil.checkSupertype(rhst, sd = this.unit.getScalableDeclaration(), that, "right operand must be of scalable type")) != null) {
            Type ta = st.getTypeArgumentList().get(0);
            Type rt = st.getTypeArgumentList().get(1);
            TypeDeclaration fd = this.unit.getFloatDeclaration();
            TypeDeclaration id = this.unit.getIntegerDeclaration();
            if (lhst.getDeclaration().inherits(id) && ta.getDeclaration().inherits(fd)) {
                lhst = fd.getType();
            }
            AnalyzerUtil.checkAssignable(lhst, ta, that, "scale factor must be assignable to scale type");
            that.setTypeModel(rt);
        }
    }

    private void checkComparable(Tree.BinaryOperatorExpression that) {
        Type lhst = this.leftType(that);
        Type rhst = this.rightType(that);
        if (!ModelUtil.isTypeUnknown(rhst) && !ModelUtil.isTypeUnknown(lhst)) {
            this.checkOperandTypes(lhst, rhst, this.unit.getComparableDeclaration(), that, "operand expressions must be comparable");
        }
    }

    private void visitComparisonOperator(Tree.BinaryOperatorExpression that) {
        this.checkComparable(that);
        that.setTypeModel(this.unit.getBooleanType());
    }

    private void visitCompareOperator(Tree.CompareOp that) {
        this.checkComparable(that);
        that.setTypeModel(this.unit.getComparisonType());
    }

    private void visitWithinOperator(Tree.WithinOp that) {
        Tree.Term lbt = that.getLowerBound().getTerm();
        Tree.Term ubt = that.getUpperBound().getTerm();
        Type lhst = lbt == null ? null : lbt.getTypeModel();
        Type rhst = ubt == null ? null : ubt.getTypeModel();
        Type t = that.getTerm().getTypeModel();
        if (!(ModelUtil.isTypeUnknown(t) || ModelUtil.isTypeUnknown(lhst) || ModelUtil.isTypeUnknown(rhst))) {
            this.checkOperandTypes(t, lhst, rhst, this.unit.getComparableDeclaration(), that, "operand expressions must be comparable");
        }
        that.setTypeModel(this.unit.getBooleanType());
    }

    private void visitSpanOperator(Tree.RangeOp that) {
        Interface ed;
        Type rhst;
        Type lhst = this.leftType(that);
        Type ot = this.checkOperandTypes(lhst, rhst = this.rightType(that), ed = this.unit.getEnumerableDeclaration(), that, "operand expressions must be of compatible enumerable type");
        if (ot != null) {
            that.setTypeModel(this.unit.getSpanType(ot));
        }
    }

    private void visitMeasureOperator(Tree.SegmentOp that) {
        Type lhst = this.leftType(that);
        Type rhst = this.rightType(that);
        Interface ed = this.unit.getEnumerableDeclaration();
        Type ot = AnalyzerUtil.checkSupertype(lhst, ed, that.getLeftTerm(), "left operand must be of enumerable type");
        if (!ModelUtil.isTypeUnknown(rhst)) {
            AnalyzerUtil.checkAssignable(rhst, this.unit.getIntegerType(), that.getRightTerm(), "right operand must be an integer");
        }
        if (ot != null) {
            Type ta = ot.getTypeArgumentList().get(0);
            that.setTypeModel(this.unit.getMeasureType(ta));
        }
    }

    private void visitEntryOperator(Tree.EntryOp that) {
        Type lhst = this.leftType(that);
        Type rhst = this.rightType(that);
        AnalyzerUtil.checkAssignable(lhst, this.unit.getObjectType(), that.getLeftTerm(), "operand expression must not be an optional type");
        that.setTypeModel(this.unit.getEntryType(lhst, rhst));
    }

    private void visitIdentityOperator(Tree.BinaryOperatorExpression that) {
        Type lhst = this.leftType(that);
        Type rhst = this.rightType(that);
        if (!ModelUtil.isTypeUnknown(rhst) && !ModelUtil.isTypeUnknown(lhst)) {
            Type idt = this.unit.getIdentifiableType();
            AnalyzerUtil.checkAssignable(lhst, idt, that.getLeftTerm(), "operand expression must be of type 'Identifiable'");
            AnalyzerUtil.checkAssignable(rhst, idt, that.getRightTerm(), "operand expression must be of type 'Identifiable'");
            if (ModelUtil.intersectionType(lhst, rhst, this.unit).isNothing()) {
                that.addError("values of disjoint types are never identical: '" + lhst.asString(this.unit) + "' has empty intersection with '" + rhst.asString(this.unit) + "'");
            }
        }
        that.setTypeModel(this.unit.getBooleanType());
    }

    private void visitEqualityOperator(Tree.BinaryOperatorExpression that) {
        Type lhst = this.leftType(that);
        Type rhst = this.rightType(that);
        if (!ModelUtil.isTypeUnknown(rhst) && !ModelUtil.isTypeUnknown(lhst)) {
            Type obt = this.unit.getObjectType();
            AnalyzerUtil.checkAssignable(lhst, obt, that.getLeftTerm(), "operand expression must be of type Object");
            AnalyzerUtil.checkAssignable(rhst, obt, that.getRightTerm(), "operand expression must be of type Object");
        }
        that.setTypeModel(this.unit.getBooleanType());
    }

    private void visitAssignOperator(Tree.AssignOp that) {
        Type rhst = this.rightType(that);
        Type lhst = this.leftType(that);
        if (!ModelUtil.isTypeUnknown(rhst) && !ModelUtil.isTypeUnknown(lhst)) {
            Type leftHandType = lhst;
            if (TreeUtil.hasUncheckedNulls(that.getLeftTerm())) {
                leftHandType = this.unit.getOptionalType(leftHandType);
            }
            AnalyzerUtil.checkAssignable(rhst, leftHandType, that.getRightTerm(), "assigned expression must be assignable to declared type", 2100);
        }
        that.setTypeModel(rhst);
    }

    private Type checkOperandTypes(Type lhst, Type rhst, TypeDeclaration td, Node node, String message) {
        Type lhsst = AnalyzerUtil.checkSupertype(lhst, td, node, message);
        if (lhsst != null) {
            Type at = lhsst.getTypeArgumentList().get(0);
            AnalyzerUtil.checkAssignable(rhst, at, node, message);
            return at;
        }
        return null;
    }

    private Type checkOperandTypes(Type t, Type lhst, Type rhst, TypeDeclaration td, Node node, String message) {
        Type st = AnalyzerUtil.checkSupertype(t, td, node, message);
        if (st != null) {
            Type at = st.getTypeArgumentList().get(0);
            AnalyzerUtil.checkAssignable(lhst, at, node, message);
            AnalyzerUtil.checkAssignable(rhst, at, node, message);
            return at;
        }
        return null;
    }

    private void visitArithmeticOperator(Tree.BinaryOperatorExpression that, TypeDeclaration type) {
        Type lhst = this.leftType(that);
        Type rhst = this.rightType(that);
        if (!ModelUtil.isTypeUnknown(rhst) && !ModelUtil.isTypeUnknown(lhst)) {
            Type nt;
            TypeDeclaration fd = this.unit.getFloatDeclaration();
            TypeDeclaration id = this.unit.getIntegerDeclaration();
            if (!rhst.isNothing() && !lhst.isNothing()) {
                if (rhst.getDeclaration().inherits(fd) && lhst.getDeclaration().inherits(id)) {
                    lhst = fd.getType();
                } else if (rhst.getDeclaration().inherits(id) && lhst.getDeclaration().inherits(fd)) {
                    rhst = fd.getType();
                }
            }
            if ((nt = AnalyzerUtil.checkSupertype(lhst, type, that.getLeftTerm(), that instanceof Tree.SumOp ? "left operand must be of summable type" : "left operand must be of numeric type")) != null) {
                Type ot;
                List<Type> tal = nt.getTypeArgumentList();
                if (tal.isEmpty()) {
                    return;
                }
                Type tt = tal.get(0);
                that.setTypeModel(tt);
                if (that instanceof Tree.PowerOp) {
                    if (tal.size() < 2) {
                        return;
                    }
                    ot = tal.get(1);
                } else {
                    ot = tt;
                }
                AnalyzerUtil.checkAssignable(rhst, ot, that, that instanceof Tree.SumOp ? "right operand must be of compatible summable type" : "right operand must be of compatible numeric type");
            }
        }
    }

    private void visitArithmeticAssignOperator(Tree.BinaryOperatorExpression that, TypeDeclaration type) {
        Type lhst = this.leftType(that);
        Type rhst = this.rightType(that);
        if (!ModelUtil.isTypeUnknown(rhst) && !ModelUtil.isTypeUnknown(lhst)) {
            TypeDeclaration fd = this.unit.getFloatDeclaration();
            TypeDeclaration id = this.unit.getIntegerDeclaration();
            if (!rhst.isNothing() && rhst.getDeclaration().inherits(id) && !lhst.isNothing() && lhst.getDeclaration().inherits(fd)) {
                rhst = fd.getType();
            }
            Type nt = AnalyzerUtil.checkSupertype(lhst, type, that.getLeftTerm(), that instanceof Tree.AddAssignOp ? "operand expression must be of summable type" : "operand expression must be of numeric type");
            that.setTypeModel(lhst);
            if (nt != null) {
                Type t = nt.getTypeArgumentList().get(0);
                AnalyzerUtil.checkAssignable(rhst, t, that, that instanceof Tree.AddAssignOp ? "right operand must be of compatible summable type" : "right operand must be of compatible numeric type");
                AnalyzerUtil.checkAssignable(t, lhst, that, "result type must be assignable to declared type");
            }
        }
    }

    private void visitSetOperator(Tree.BitwiseOp that) {
        Type lhst = this.leftType(that);
        Type rhst = this.rightType(that);
        if (!ModelUtil.isTypeUnknown(rhst) && !ModelUtil.isTypeUnknown(lhst)) {
            Type ot = this.unit.getObjectType();
            AnalyzerUtil.checkAssignable(lhst, this.unit.getSetType(ot), that.getLeftTerm(), "set operand expression must be a set");
            AnalyzerUtil.checkAssignable(rhst, this.unit.getSetType(ot), that.getRightTerm(), "set operand expression must be a set");
            Type lhset = this.unit.getSetElementType(lhst);
            Type rhset = this.unit.getSetElementType(rhst);
            Type et = that instanceof Tree.IntersectionOp ? ModelUtil.intersectionType(rhset, lhset, this.unit) : (that instanceof Tree.ComplementOp ? lhset : ModelUtil.unionType(rhset, lhset, this.unit));
            that.setTypeModel(this.unit.getSetType(et));
        }
    }

    private void visitSetAssignmentOperator(Tree.BitwiseAssignmentOp that) {
        Type lhst = this.leftType(that);
        Type rhst = this.rightType(that);
        if (!ModelUtil.isTypeUnknown(rhst) && !ModelUtil.isTypeUnknown(lhst)) {
            Type sot = this.unit.getSetType(this.unit.getObjectType());
            Type snt = this.unit.getSetType(this.unit.getNothingType());
            AnalyzerUtil.checkAssignable(lhst, sot, that.getLeftTerm(), "set operand expression must be a set");
            AnalyzerUtil.checkAssignable(rhst, sot, that.getRightTerm(), "set operand expression must be a set");
            AnalyzerUtil.checkAssignable(snt, lhst, that.getLeftTerm(), "assigned expression type must be an instantiation of 'Set'");
            Type lhset = this.unit.getSetElementType(lhst);
            Type rhset = this.unit.getSetElementType(rhst);
            if (that instanceof Tree.UnionAssignOp) {
                AnalyzerUtil.checkAssignable(rhset, lhset, that.getRightTerm(), "resulting set element type must be assignable to to declared set element type");
            }
            that.setTypeModel(this.unit.getSetType(lhset));
        }
    }

    private void visitLogicalOperator(Tree.BinaryOperatorExpression that) {
        Type bt = this.unit.getBooleanType();
        Type lt = this.leftType(that);
        Type rt = this.rightType(that);
        if (!ModelUtil.isTypeUnknown(rt) && !ModelUtil.isTypeUnknown(lt)) {
            AnalyzerUtil.checkAssignable(lt, bt, that, "logical operand expression must be a boolean value");
            AnalyzerUtil.checkAssignable(rt, bt, that, "logical operand expression must be a boolean value");
        }
        that.setTypeModel(bt);
    }

    private void visitDefaultOperator(Tree.DefaultOp that) {
        Type lhst = this.leftType(that);
        Type rhst = this.rightType(that);
        if (!ModelUtil.isTypeUnknown(rhst) && !ModelUtil.isTypeUnknown(lhst)) {
            this.checkOptional(lhst, that.getLeftTerm());
            Type dt = this.unit.getDefiniteType(lhst);
            Type rt = ModelUtil.unionType(dt, rhst, this.unit);
            that.setTypeModel(rt);
        }
    }

    private void visitThenOperator(Tree.ThenOp that) {
        Type lhst = this.leftType(that);
        Type rhst = this.rightType(that);
        if (!ModelUtil.isTypeUnknown(lhst)) {
            AnalyzerUtil.checkAssignable(lhst, this.unit.getBooleanType(), that.getLeftTerm(), "operand expression must be a boolean value");
        }
        if (rhst != null && !ModelUtil.isTypeUnknown(rhst)) {
            AnalyzerUtil.checkAssignable(rhst, this.unit.getObjectType(), that.getRightTerm(), "operand expression may not be an optional type");
            that.setTypeModel(this.unit.getOptionalType(rhst));
        }
    }

    private void visitInOperator(Tree.InOp that) {
        Type lhst = this.leftType(that);
        Type rhst = this.rightType(that);
        if (!ModelUtil.isTypeUnknown(rhst) && !ModelUtil.isTypeUnknown(lhst)) {
            Type ct = rhst.getSupertype(this.unit.getJavaCollectionDeclaration());
            if (ct == null) {
                ct = AnalyzerUtil.checkSupertype(rhst, this.unit.getCategoryDeclaration(), that.getRightTerm(), "operand expression must be a category");
            }
            if (ct != null) {
                Type at = ct.getTypeArguments().isEmpty() ? null : ct.getTypeArgumentList().get(0);
                AnalyzerUtil.checkAssignable(lhst, at, that.getLeftTerm(), "operand expression must be assignable to category type");
            }
        }
        that.setTypeModel(this.unit.getBooleanType());
    }

    private void visitUnaryOperator(Tree.UnaryOperatorExpression that, TypeDeclaration type) {
        Type nt;
        Type t = this.type(that);
        if (!ModelUtil.isTypeUnknown(t) && (nt = AnalyzerUtil.checkSupertype(t, true, type, that.getTerm(), "operand expression must be of correct type")) != null) {
            Type at = nt.getTypeArguments().isEmpty() ? nt : nt.getTypeArgumentList().get(0);
            that.setTypeModel(at);
        }
    }

    private void visitExistsOperator(Tree.Exists that) {
        this.checkOptional(this.type(that), that.getTerm());
        that.setTypeModel(this.unit.getBooleanType());
    }

    private void visitNonemptyOperator(Tree.Nonempty that) {
        this.checkEmpty(this.type(that), that.getTerm());
        that.setTypeModel(this.unit.getBooleanType());
    }

    private void visitOfOperator(Tree.OfOp that) {
        Type t;
        Tree.Type rt = that.getType();
        if (rt != null && !ModelUtil.isTypeUnknown(t = rt.getTypeModel())) {
            that.setTypeModel(t);
            Tree.Term tt = that.getTerm();
            if (tt != null) {
                Type pt = tt.getTypeModel();
                if (!ModelUtil.isTypeUnknown(pt) && !t.covers(pt)) {
                    that.addError("specified type does not cover the cases of the operand expression: '" + t.asString(this.unit) + "' does not cover '" + pt.asString(this.unit) + "'");
                }
                if (tt instanceof Tree.Super) {
                    Tree.Super s = (Tree.Super)tt;
                    s.setDeclarationModel(t.getDeclaration());
                }
            }
        }
    }

    private void visitIsOperator(Tree.IsOp that) {
        Type knownType;
        Tree.Term term;
        Type type;
        Tree.Type rt = that.getType();
        if (rt != null && !ModelUtil.isTypeUnknown(type = rt.getTypeModel()) && (term = that.getTerm()) != null && !ModelUtil.isTypeUnknown(knownType = term.getTypeModel())) {
            if (knownType.isSubtypeOf(type)) {
                that.addError("expression type is a subtype of the type: '" + knownType.asString(this.unit) + "' is assignable to '" + type.asString(this.unit) + "'");
            } else if (ModelUtil.intersectionType(type, knownType, this.unit).isNothing()) {
                that.addError("tests assignability to bottom type 'Nothing': intersection of '" + knownType.asString(this.unit) + "' and '" + type.asString(this.unit) + "' is empty");
            }
        }
        that.setTypeModel(this.unit.getBooleanType());
    }

    private void checkAssignability(Tree.Term that, Node node) {
        if (that instanceof Tree.QualifiedMemberOrTypeExpression || that instanceof Tree.BaseMemberOrTypeExpression) {
            Tree.QualifiedMemberOrTypeExpression qmte;
            Tree.MemberOperator mo;
            Tree.StaticMemberOrTypeExpression smte = (Tree.StaticMemberOrTypeExpression)that;
            Declaration dec = smte.getDeclaration();
            if (dec != null && (!TreeUtil.isEffectivelyBaseMemberExpression(smte) || dec instanceof Value && ((Value)dec).isInferred() || !this.unit.equals(dec.getUnit()))) {
                if (dec instanceof Value) {
                    Value value = (Value)dec;
                    if (!value.isVariable() && !value.isLate()) {
                        that.addError("value is not a variable: '" + dec.getName(this.unit) + "'", 800);
                    }
                } else {
                    that.addError("not a variable value: '" + dec.getName(this.unit) + "'");
                }
            }
            if (that instanceof Tree.QualifiedMemberOrTypeExpression && !((mo = (qmte = (Tree.QualifiedMemberOrTypeExpression)that).getMemberOperator()) instanceof Tree.MemberOp)) {
                that.addUnsupportedError("assignment to expression involving ?. or *. not supported");
            }
        } else {
            that.addError("expression cannot be assigned");
        }
    }

    private Type rightType(Tree.BinaryOperatorExpression that) {
        Tree.Term rt = that.getRightTerm();
        return rt == null ? null : rt.getTypeModel();
    }

    private Type leftType(Tree.BinaryOperatorExpression that) {
        Tree.Term lt = that.getLeftTerm();
        return lt == null ? null : lt.getTypeModel();
    }

    private Type type(Tree.UnaryOperatorExpression that) {
        Tree.Term t = that.getTerm();
        return t == null ? null : t.getTypeModel();
    }

    private Interface getArithmeticDeclaration(Tree.ArithmeticOp that) {
        if (that instanceof Tree.PowerOp) {
            return this.unit.getExponentiableDeclaration();
        }
        if (that instanceof Tree.SumOp) {
            return this.unit.getSummableDeclaration();
        }
        if (that instanceof Tree.DifferenceOp) {
            return this.unit.getInvertableDeclaration();
        }
        if (that instanceof Tree.RemainderOp) {
            return this.unit.getIntegralDeclaration();
        }
        return this.unit.getNumericDeclaration();
    }

    private Interface getArithmeticDeclaration(Tree.ArithmeticAssignmentOp that) {
        if (that instanceof Tree.AddAssignOp) {
            return this.unit.getSummableDeclaration();
        }
        if (that instanceof Tree.SubtractAssignOp) {
            return this.unit.getInvertableDeclaration();
        }
        if (that instanceof Tree.RemainderAssignOp) {
            return this.unit.getIntegralDeclaration();
        }
        return this.unit.getNumericDeclaration();
    }

    @Override
    public void visit(Tree.ArithmeticOp that) {
        super.visit(that);
        this.visitArithmeticOperator(that, this.getArithmeticDeclaration(that));
    }

    @Override
    public void visit(Tree.BitwiseOp that) {
        super.visit(that);
        this.visitSetOperator(that);
    }

    @Override
    public void visit(Tree.ScaleOp that) {
        super.visit(that);
        this.visitScaleOperator(that);
    }

    @Override
    public void visit(Tree.LogicalOp that) {
        super.visit(that);
        this.visitLogicalOperator(that);
    }

    @Override
    public void visit(Tree.EqualityOp that) {
        super.visit(that);
        this.visitEqualityOperator(that);
    }

    @Override
    public void visit(Tree.ComparisonOp that) {
        super.visit(that);
        this.visitComparisonOperator(that);
    }

    @Override
    public void visit(Tree.WithinOp that) {
        super.visit(that);
        this.visitWithinOperator(that);
    }

    @Override
    public void visit(Tree.IdenticalOp that) {
        super.visit(that);
        this.visitIdentityOperator(that);
    }

    @Override
    public void visit(Tree.CompareOp that) {
        super.visit(that);
        this.visitCompareOperator(that);
    }

    @Override
    public void visit(Tree.DefaultOp that) {
        super.visit(that);
        this.visitDefaultOperator(that);
    }

    @Override
    public void visit(Tree.ThenOp that) {
        super.visit(that);
        this.visitThenOperator(that);
    }

    @Override
    public void visit(Tree.NegativeOp that) {
        super.visit(that);
        this.visitUnaryOperator(that, this.unit.getInvertableDeclaration());
    }

    @Override
    public void visit(Tree.PositiveOp that) {
        super.visit(that);
        this.visitUnaryOperator(that, this.unit.getInvertableDeclaration());
    }

    @Override
    public void visit(Tree.NotOp that) {
        super.visit(that);
        this.visitUnaryOperator(that, this.unit.getBooleanDeclaration());
    }

    @Override
    public void visit(Tree.AssignOp that) {
        this.assign(that.getLeftTerm());
        super.visit(that);
        this.visitAssignOperator(that);
        this.checkAssignability(that.getLeftTerm(), that);
    }

    @Override
    public void visit(Tree.ArithmeticAssignmentOp that) {
        this.assign(that.getLeftTerm());
        super.visit(that);
        this.visitArithmeticAssignOperator(that, this.getArithmeticDeclaration(that));
        this.checkAssignability(that.getLeftTerm(), that);
    }

    @Override
    public void visit(Tree.LogicalAssignmentOp that) {
        this.assign(that.getLeftTerm());
        super.visit(that);
        this.visitLogicalOperator(that);
        this.checkAssignability(that.getLeftTerm(), that);
    }

    @Override
    public void visit(Tree.BitwiseAssignmentOp that) {
        this.assign(that.getLeftTerm());
        super.visit(that);
        this.visitSetAssignmentOperator(that);
        this.checkAssignability(that.getLeftTerm(), that);
    }

    @Override
    public void visit(Tree.RangeOp that) {
        super.visit(that);
        this.visitSpanOperator(that);
    }

    @Override
    public void visit(Tree.SegmentOp that) {
        super.visit(that);
        this.visitMeasureOperator(that);
    }

    @Override
    public void visit(Tree.EntryOp that) {
        super.visit(that);
        this.visitEntryOperator(that);
    }

    @Override
    public void visit(Tree.Exists that) {
        super.visit(that);
        this.visitExistsOperator(that);
    }

    @Override
    public void visit(Tree.Nonempty that) {
        super.visit(that);
        this.visitNonemptyOperator(that);
    }

    @Override
    public void visit(Tree.IsOp that) {
        super.visit(that);
        this.visitIsOperator(that);
    }

    @Override
    public void visit(Tree.OfOp that) {
        super.visit(that);
        this.visitOfOperator(that);
    }

    @Override
    public void visit(Tree.Extends that) {
        super.visit(that);
        that.addUnsupportedError("extends operator not yet supported");
    }

    @Override
    public void visit(Tree.Satisfies that) {
        super.visit(that);
        that.addUnsupportedError("satisfies operator not yet supported");
    }

    @Override
    public void visit(Tree.InOp that) {
        super.visit(that);
        this.visitInOperator(that);
    }

    @Override
    public void visit(Tree.LetExpression that) {
        Tree.Expression e;
        super.visit(that);
        Tree.LetClause lc = that.getLetClause();
        if (lc.getVariables().isEmpty()) {
            lc.addError("let clause must declare at least one variable or pattern");
        }
        if ((e = lc.getExpression()) != null) {
            that.setTypeModel(e.getTypeModel());
        }
    }

    @Override
    public void visit(Tree.BaseType that) {
        super.visit(that);
        TypeDeclaration type = that.getDeclarationModel();
        if (type != null) {
            if (!(type = (TypeDeclaration)this.handleNativeHeader(type, that, true)).isVisible(that.getScope())) {
                that.addError("type is not visible: " + ExpressionVisitor.baseDescription(that), 400);
            } else if (type.isPackageVisibility() && !AnalyzerUtil.declaredInPackage(type, this.unit)) {
                that.addError("package private type is not visible: " + ExpressionVisitor.baseDescription(that));
            }
        }
    }

    @Override
    public void visit(Tree.QualifiedType that) {
        super.visit(that);
        TypeDeclaration type = that.getDeclarationModel();
        if (type != null) {
            Tree.SimpleType st;
            if (!(type = (TypeDeclaration)this.handleNativeHeader(type, that, true)).isVisible(that.getScope())) {
                if (type instanceof Constructor) {
                    that.addError("constructor is not visible: " + ExpressionVisitor.qualifiedDescription(that), 400);
                } else {
                    that.addError("member type is not visible: " + ExpressionVisitor.qualifiedDescription(that), 400);
                }
            } else if (type.isPackageVisibility() && !AnalyzerUtil.declaredInPackage(type, this.unit)) {
                that.addError("package private member type is not visible: " + ExpressionVisitor.qualifiedDescription(that));
            } else if (type.isProtectedVisibility() && !AnalyzerUtil.declaredInPackage(type, this.unit)) {
                that.addError("protected member type is not visible: " + ExpressionVisitor.qualifiedDescription(that));
            }
            Tree.StaticType outerType = that.getOuterType();
            if (outerType instanceof Tree.SimpleType && (st = (Tree.SimpleType)outerType).getDeclarationModel() instanceof TypeParameter) {
                outerType.addError("type parameter should not occur as qualifying type: " + ExpressionVisitor.qualifiedDescription(that));
            }
        }
    }

    private void checkBaseVisibility(Node that, TypedDeclaration member, String name) {
        if (!member.isVisible(that.getScope())) {
            that.addError("function or value is not visible: '" + name + "'", 400);
        } else if (member.isPackageVisibility() && !AnalyzerUtil.declaredInPackage(member, this.unit)) {
            that.addError("package private function or value is not visible: '" + name + "'");
        }
    }

    private void checkQualifiedVisibility(Node that, TypedDeclaration member, String name, String container, boolean selfReference) {
        if (!member.isVisible(that.getScope())) {
            that.addError("method or attribute is not visible: '" + name + "' of " + container, 400);
        } else if (member.isPackageVisibility() && !AnalyzerUtil.declaredInPackage(member, this.unit)) {
            that.addError("package private method or attribute is not visible: '" + name + "' of " + container);
        } else if (member.isProtectedVisibility() && !selfReference && !AnalyzerUtil.declaredInPackage(member, this.unit)) {
            that.addError("protected method or attribute is not visible: '" + name + "' of " + container);
        }
    }

    private void checkBaseTypeAndConstructorVisibility(Tree.BaseTypeExpression that, String name, TypeDeclaration type) {
        if (ModelUtil.isOverloadedVersion(type)) {
            TypeDeclaration at = type.getExtendedType().getDeclaration();
            if (!at.isVisible(that.getScope())) {
                that.addError("type is not visible: '" + name + "'");
            } else if (at.isPackageVisibility() && !AnalyzerUtil.declaredInPackage(type, this.unit)) {
                that.addError("package private type is not visible: '" + name + "'");
            } else if (at.isProtectedVisibility() && !AnalyzerUtil.declaredInPackage(type, this.unit)) {
                that.addError("protected type is not visible: '" + name + "'");
            } else if (!type.isVisible(that.getScope())) {
                that.addError("type constructor is not visible: '" + name + "'");
            } else if (type.isPackageVisibility() && !AnalyzerUtil.declaredInPackage(type, this.unit)) {
                that.addError("package private constructor is not visible: '" + name + "'");
            } else if (type.isProtectedVisibility() && !AnalyzerUtil.declaredInPackage(type, this.unit)) {
                that.addError("protected constructor is not visible: '" + name + "'");
            }
        } else if (!type.isVisible(that.getScope())) {
            that.addError("type is not visible: '" + name + "'", 400);
        } else if (type.isPackageVisibility() && !AnalyzerUtil.declaredInPackage(type, this.unit)) {
            that.addError("package private type is not visible: '" + name + "'");
        } else if (type.isProtectedVisibility() && !AnalyzerUtil.declaredInPackage(type, this.unit)) {
            that.addError("protected type is not visible: '" + name + "'");
        }
    }

    private void checkQualifiedTypeAndConstructorVisibility(Tree.QualifiedTypeExpression that, TypeDeclaration type, String name, String container) {
        if (ModelUtil.isOverloadedVersion(type)) {
            TypeDeclaration at = type.getExtendedType().getDeclaration();
            if (!at.isVisible(that.getScope())) {
                that.addError("member type is not visible: '" + name + "' of '" + container);
            } else if (at.isPackageVisibility() && !AnalyzerUtil.declaredInPackage(type, this.unit)) {
                that.addError("package private member type is not visible: '" + name + "' of type " + container);
            } else if (at.isProtectedVisibility() && !AnalyzerUtil.declaredInPackage(type, this.unit)) {
                that.addError("protected member type is not visible: '" + name + "' of type " + container);
            } else if (!type.isVisible(that.getScope())) {
                that.addError("member type constructor is not visible: '" + name + "' of " + container);
            } else if (type.isPackageVisibility() && !AnalyzerUtil.declaredInPackage(type, this.unit)) {
                that.addError("package private member type constructor is not visible: '" + name + "' of " + container);
            } else if (type.isProtectedVisibility() && !AnalyzerUtil.declaredInPackage(type, this.unit)) {
                that.addError("protected member type constructor is not visible: '" + name + "' of " + container);
            }
        } else if (!type.isVisible(that.getScope())) {
            if (type instanceof Constructor) {
                that.addError("constructor is not visible: '" + name + "' of " + container, 400);
            } else {
                that.addError("member type is not visible: '" + name + "' of " + container, 400);
            }
        } else if (type.isPackageVisibility() && !AnalyzerUtil.declaredInPackage(type, this.unit)) {
            that.addError("package private member type is not visible: '" + name + "' of " + container);
        } else if (type.isProtectedVisibility() && !AnalyzerUtil.declaredInPackage(type, this.unit)) {
            that.addError("protected member type is not visible: '" + name + "' of " + container);
        }
    }

    private static String baseDescription(Tree.BaseType that) {
        return "'" + TreeUtil.name(that.getIdentifier()) + "'";
    }

    private static String qualifiedDescription(Tree.QualifiedType that) {
        String name = TreeUtil.name(that.getIdentifier());
        Type ot = that.getOuterType().getTypeModel();
        return "'" + name + "' of type '" + ot.getDeclaration().getName() + "'";
    }

    @Override
    public void visit(Tree.BaseMemberExpression that) {
        super.visit(that);
        boolean notIndirectlyInvoked = !that.getIndirectlyInvoked();
        boolean notDirectlyInvoked = !that.getDirectlyInvoked();
        TypedDeclaration member = this.resolveBaseMemberExpression(that, notIndirectlyInvoked);
        this.checkExtendsClauseReference(that, member);
        if (member != null && notDirectlyInvoked) {
            Tree.TypeArguments tal = that.getTypeArguments();
            List<Type> typeArgs = this.typeConstructorArgumentsInferrable(member, that) ? new TypeArgumentInference(this.unit).getInferredTypeArgsForFunctionRef(that, null) : (this.explicitTypeArguments(member, tal) ? AnalyzerUtil.getTypeArguments(tal, null, ModelUtil.getTypeParameters(member)) : new TypeArgumentInference(this.unit).getInferredTypeArgsForFunctionRef(that, null));
            if (typeArgs != null) {
                tal.setTypeModels(typeArgs);
                this.visitBaseMemberExpression(that, member, typeArgs, tal, null);
            } else {
                this.visitGenericBaseMemberReference(that, member);
            }
        }
    }

    private void checkExtendsClauseReference(Tree.BaseMemberOrTypeExpression that, Declaration member) {
        if (this.inExtendsClause && this.constructorClass != null && member != null && member.getContainer().equals(this.constructorClass) && !member.isStaticallyImportable() && !ModelUtil.isConstructor(member)) {
            that.addError("reference to class member from constructor extends clause");
        }
    }

    private void visitGenericBaseMemberReference(Tree.StaticMemberOrTypeExpression that, TypedDeclaration member) {
        if (AnalyzerUtil.isGeneric(member) && member instanceof Function) {
            Generic generic = (Generic)((Object)member);
            Scope scope = that.getScope();
            Type outerType = scope.getDeclaringType(member);
            TypedReference target = member.appliedTypedReference(outerType, AnalyzerUtil.NO_TYPE_ARGS);
            that.setTarget(target);
            Type functionType = ModelUtil.genericFunctionType(generic, scope, member, target, this.unit);
            that.setTypeModel(functionType);
            NativeUtil.checkNotJvm(that, "type functions are not supported on the JVM");
        }
    }

    private TypedDeclaration resolveBaseMemberExpression(Tree.BaseMemberExpression that, boolean error) {
        Tree.Identifier id = that.getIdentifier();
        String name = TreeUtil.name(id);
        Scope scope = that.getScope();
        TypedDeclaration member = AnalyzerUtil.getTypedDeclaration(scope, name, that.getSignature(), that.getEllipsis(), that.getUnit());
        if (member == null) {
            if (!this.dynamic && !this.isNativeForWrongBackend(scope.getScopedBackends()) && error) {
                String correction = AnalyzerUtil.correct(scope, this.unit, name);
                String message = correction == null ? "" : " (did you mean '" + correction + "'?)";
                that.addError("function or value does not exist: '" + name + "'" + message, 100);
                this.unit.getUnresolvedReferences().add(id);
            }
        } else {
            member = (TypedDeclaration)this.handleAbstractionOrHeader(member, that, error);
            that.setDeclaration(member);
            if (error && this.checkConcreteConstructor(member, that)) {
                this.checkBaseVisibility(that, member, name);
            }
        }
        return member;
    }

    @Override
    public void visit(Tree.QualifiedMemberExpression that) {
        super.visit(that);
        boolean notIndirectlyInvoked = !that.getIndirectlyInvoked();
        boolean notDirectlyInvoked = !that.getDirectlyInvoked();
        TypedDeclaration member = this.resolveQualifiedMemberExpression(that, notIndirectlyInvoked);
        if (member != null && notDirectlyInvoked) {
            List<Type> typeArgs;
            Tree.Primary primary = that.getPrimary();
            Tree.TypeArguments tal = that.getTypeArguments();
            Type receiverType = primary.getTypeModel().resolveAliases();
            if (receiverType.isTypeConstructor()) {
                that.addError("missing type arguments in reference to member of generic type: the type '" + receiverType.asString(this.unit) + "' is a type constructor (specify explicit type arguments)");
            }
            if ((typeArgs = this.typeConstructorArgumentsInferrable(member, that) ? new TypeArgumentInference(this.unit).getInferredTypeArgsForFunctionRef(that, receiverType) : (this.explicitTypeArguments(member, tal) ? AnalyzerUtil.getTypeArguments(tal, receiverType, ModelUtil.getTypeParameters(member)) : new TypeArgumentInference(this.unit).getInferredTypeArgsForFunctionRef(that, receiverType))) != null) {
                tal.setTypeModels(typeArgs);
                if (primary instanceof Tree.Package) {
                    this.visitBaseMemberExpression(that, member, typeArgs, tal, null);
                } else {
                    this.visitQualifiedMemberExpression(that, receiverType, member, typeArgs, tal);
                }
                if (that.getStaticMethodReference()) {
                    this.handleStaticReferenceImplicitTypeArguments(that);
                }
            } else if (that.getStaticMethodReference()) {
                this.handleStaticReferenceImplicitTypeArguments(that);
            } else if (primary instanceof Tree.Package) {
                this.visitGenericBaseMemberReference(that, member);
            } else {
                this.visitGenericQualifiedMemberReference(that, receiverType, member);
            }
        }
    }

    private void visitGenericQualifiedMemberReference(Tree.QualifiedMemberExpression that, Type receiverType, TypedDeclaration member) {
        if (AnalyzerUtil.isGeneric(member) && member instanceof Function) {
            Generic generic = (Generic)((Object)member);
            Scope scope = that.getScope();
            TypedReference target = receiverType.getTypedMember(member, AnalyzerUtil.NO_TYPE_ARGS);
            that.setTarget(target);
            Type functionType = ModelUtil.genericFunctionType(generic, scope, member, target, this.unit);
            that.setTypeModel(functionType);
            NativeUtil.checkNotJvm(that, "type functions are not supported on the JVM");
        }
    }

    private void handleStaticReferenceImplicitTypeArguments(Tree.QualifiedMemberOrTypeExpression that) {
        if (ExpressionVisitor.isStaticReference(that)) {
            Declaration member = that.getDeclaration();
            Tree.TypeArguments tas = that.getTypeArguments();
            if (member != null && !this.explicitTypeArguments(member, tas)) {
                that.addError("type arguments could not be inferred: '" + member.getName(this.unit) + "' is generic");
            }
            Tree.StaticMemberOrTypeExpression smte = (Tree.StaticMemberOrTypeExpression)that.getPrimary();
            Tree.TypeArguments typeArgs = smte.getTypeArguments();
            TypeDeclaration type = (TypeDeclaration)smte.getDeclaration();
            if (type != null && !this.explicitTypeArguments(type, typeArgs) && typeArgs.getTypeModels() == null) {
                Declaration declaration = smte.getDeclaration();
                Generic dec = (Generic)((Object)declaration);
                StringBuilder paramList = new StringBuilder();
                for (TypeParameter tp : dec.getTypeParameters()) {
                    if (paramList.length() > 0) {
                        paramList.append(", ");
                    }
                    paramList.append("'").append(tp.getName()).append("'");
                }
                smte.addError("missing type arguments to generic type qualifying static reference: '" + declaration.getName(this.unit) + "' declares type parameters " + paramList);
            }
        }
    }

    private TypedDeclaration resolveQualifiedMemberExpression(Tree.QualifiedMemberExpression that, boolean error) {
        boolean nameNonempty;
        Tree.Identifier id = that.getIdentifier();
        boolean bl = nameNonempty = id != null && !id.getText().equals("");
        if (nameNonempty && ExpressionVisitor.checkMember(that)) {
            boolean ambiguous;
            TypedDeclaration member;
            String container;
            Tree.Primary primary = that.getPrimary();
            String name = TreeUtil.name(id);
            List<Type> signature = that.getSignature();
            boolean spread = that.getEllipsis();
            if (primary instanceof Tree.Package) {
                Package pack = this.unit.getPackage();
                container = "package '" + pack.getNameAsString() + "'";
                member = AnalyzerUtil.getPackageTypedDeclaration(name, signature, spread, this.unit);
                ambiguous = false;
            } else {
                Declaration direct;
                Type pt = primary.getTypeModel().resolveAliases();
                TypeDeclaration d = this.getDeclaration(that, pt);
                container = "type '" + d.getName(this.unit) + "'";
                Scope scope = that.getScope();
                ClassOrInterface ci = ModelUtil.getContainingClassOrInterface(scope);
                member = ci != null && d.inherits(ci) && !(d instanceof NothingType) ? ((direct = ci.getDirectMember(name, signature, spread)) instanceof TypedDeclaration && !direct.isShared() ? (TypedDeclaration)direct : AnalyzerUtil.getTypedMember(d, name, signature, spread, this.unit)) : AnalyzerUtil.getTypedMember(d, name, signature, spread, this.unit);
                boolean bl2 = ambiguous = member == null && d.isMemberAmbiguous(name, this.unit, signature, spread);
                if (member == null) {
                    String correction = AnalyzerUtil.correct(d, scope, this.unit, name);
                    container = container + (correction == null ? "" : " (did you mean '" + correction + "'?)");
                }
            }
            if (member == null) {
                if (error) {
                    if (ambiguous) {
                        that.addError("method or attribute is ambiguous: '" + name + "' for " + container);
                    } else {
                        that.addError("method or attribute does not exist: '" + name + "' in " + container, 100);
                        this.unit.getUnresolvedReferences().add(id);
                    }
                }
            } else {
                member = (TypedDeclaration)this.handleAbstractionOrHeader(member, that, error);
                that.setDeclaration(member);
                this.resetSuperReference(that);
                boolean selfReference = this.isSelfReference(primary);
                if (!selfReference && !member.isShared()) {
                    member.setOtherInstanceAccess(true);
                }
                if (error) {
                    if (this.checkConcreteConstructor(member, that)) {
                        this.checkQualifiedVisibility(that, member, name, container, selfReference);
                    }
                    this.checkSuperMember(that, signature, spread);
                }
            }
            return member;
        }
        return null;
    }

    private boolean isSelfReference(Tree.Primary p) {
        return p instanceof Tree.This || p instanceof Tree.Outer || p instanceof Tree.Super;
    }

    private void checkSuperMember(Tree.QualifiedMemberOrTypeExpression that, List<Type> signature, boolean spread) {
        Tree.Term term = TreeUtil.eliminateParensAndWidening(that.getPrimary());
        if (term instanceof Tree.Super) {
            this.checkSuperInvocation(that, signature, spread);
        }
    }

    private void visitQualifiedMemberExpression(Tree.QualifiedMemberExpression that, Type receivingType, TypedDeclaration member, List<Type> typeArgs, Tree.TypeArguments tal) {
        Type receiverType;
        this.checkMemberOperator(receivingType, that);
        Tree.Primary primary = that.getPrimary();
        if (ModelUtil.isConstructor(member) && !(primary instanceof Tree.BaseTypeExpression) && !(primary instanceof Tree.QualifiedTypeExpression)) {
            primary.addError("constructor reference must be qualified by a type expression");
        }
        if (this.acceptsTypeArguments(member, receiverType = this.accountForStaticReferenceReceiverType(that, this.unwrap(receivingType, that)), typeArgs, tal, that)) {
            TypedReference ptr = receiverType.getTypedMember(member, typeArgs, that.getAssigned());
            that.setTarget(ptr);
            this.checkSpread(member, that);
            boolean direct = that.getDirectlyInvoked();
            Type fullType = ExpressionVisitor.accountForGenericFunctionRef(direct, tal, receivingType, typeArgs, ptr.getFullType(this.wrap(ptr.getType(), receivingType, that)));
            Scope scope = that.getScope();
            if (!this.dynamic && !this.isNativeForWrongBackend(scope.getScopedBackends()) && !ModelUtil.isAbstraction(member) && ModelUtil.isTypeUnknown(fullType)) {
                String rtname = receiverType.getDeclaration().getName(this.unit);
                that.addError("could not determine type of method or attribute reference: '" + member.getName(this.unit) + "' of '" + rtname + "'" + AnalyzerUtil.getTypeUnknownError(fullType));
            }
            that.setTypeModel(this.accountForStaticReferenceType(that, member, fullType));
        }
        if (that.getStaticMethodReference()) {
            this.handleStaticReferenceImplicitTypeArguments(that);
        }
    }

    private static Type accountForGenericFunctionRef(boolean directlyInvoked, Tree.TypeArguments tas, Type receivingType, List<Type> typeArgs, Type fullType) {
        if (fullType == null) {
            return null;
        }
        boolean explicit = tas instanceof Tree.TypeArgumentList;
        if (explicit || directlyInvoked || typeArgs != null && !typeArgs.isEmpty()) {
            Type realType = fullType.resolveAliases();
            if (realType.isTypeConstructor()) {
                return realType.getDeclaration().appliedType(receivingType, typeArgs);
            }
            return fullType;
        }
        return fullType;
    }

    private void checkSpread(TypedDeclaration member, Tree.QualifiedMemberExpression that) {
        Functional f;
        if (!(that.getMemberOperator() instanceof Tree.MemberOp) && member instanceof Functional && (f = (Functional)((Object)member)).getParameterLists().size() != 1) {
            that.addError("spread method must have exactly one parameter list");
        }
    }

    private Type accountForStaticReferenceReceiverType(Tree.QualifiedMemberOrTypeExpression that, Type receivingType) {
        if (that.getStaticMethodReference()) {
            Tree.MemberOrTypeExpression primary = (Tree.MemberOrTypeExpression)that.getPrimary();
            Reference target = primary.getTarget();
            return target == null ? this.unit.getUnknownType() : target.getType();
        }
        return receivingType;
    }

    private Type accountForStaticReferenceType(Tree.QualifiedMemberOrTypeExpression that, Declaration member, Type type) {
        if (that.getStaticMethodReference()) {
            Tree.QualifiedMemberOrTypeExpression qmte;
            Tree.Primary pp;
            Tree.MemberOrTypeExpression primary = (Tree.MemberOrTypeExpression)that.getPrimary();
            if (ModelUtil.isConstructor(member)) {
                Tree.QualifiedMemberOrTypeExpression qmte2;
                Tree.MemberOperator mo;
                if (primary instanceof Tree.QualifiedMemberOrTypeExpression && !((mo = (qmte2 = (Tree.QualifiedMemberOrTypeExpression)primary).getMemberOperator()) instanceof Tree.MemberOp)) {
                    mo.addError("illegal operator qualifying constructor reference");
                    return null;
                }
                if (primary.getStaticMethodReference()) {
                    qmte2 = (Tree.QualifiedMemberOrTypeExpression)primary;
                    if (qmte2.getDeclaration().isStaticallyImportable()) {
                        return type;
                    }
                    Tree.MemberOrTypeExpression pp2 = (Tree.MemberOrTypeExpression)qmte2.getPrimary();
                    return this.accountForStaticReferenceType(qmte2, pp2.getDeclaration(), type);
                }
                return type;
            }
            if (primary instanceof Tree.QualifiedMemberOrTypeExpression && !((pp = (qmte = (Tree.QualifiedMemberOrTypeExpression)primary).getPrimary()) instanceof Tree.BaseTypeExpression) && !(pp instanceof Tree.QualifiedTypeExpression) && !(pp instanceof Tree.Package)) {
                pp.addError("non-static type expression qualifies static member reference");
            }
            if (member.isStaticallyImportable()) {
                if (primary.getStaticMethodReference()) {
                    qmte = (Tree.QualifiedMemberOrTypeExpression)primary;
                    if (qmte.getDeclaration().isStaticallyImportable()) {
                        return type;
                    }
                    pp = (Tree.MemberOrTypeExpression)qmte.getPrimary();
                    return this.accountForStaticReferenceType(qmte, ((Tree.MemberOrTypeExpression)pp).getDeclaration(), type);
                }
                return type;
            }
            Reference target = primary.getTarget();
            if (target == null) {
                return this.unit.getUnknownType();
            }
            return this.getStaticReferenceType(type, target.getType());
        }
        return type;
    }

    private Type getStaticReferenceType(Type type, Type rt) {
        return ModelUtil.appliedType((TypeDeclaration)this.unit.getCallableDeclaration(), type, ModelUtil.appliedType((TypeDeclaration)this.unit.getTupleDeclaration(), rt, rt, this.unit.getEmptyType()));
    }

    private void visitBaseMemberExpression(Tree.StaticMemberOrTypeExpression that, TypedDeclaration member, List<Type> typeArgs, Tree.TypeArguments tal, Type receivingType) {
        if (this.acceptsTypeArguments(member, null, typeArgs, tal, that)) {
            Scope scope = that.getScope();
            Type outerType = scope.getDeclaringType(member);
            if (outerType == null) {
                outerType = receivingType;
            }
            TypedReference pr = member.appliedTypedReference(outerType, typeArgs, that.getAssigned());
            that.setTarget(pr);
            boolean direct = that.getDirectlyInvoked();
            Type fullType = ExpressionVisitor.accountForGenericFunctionRef(direct, tal, outerType, typeArgs, pr.getFullType());
            if (!this.dynamic && !this.isNativeForWrongBackend(scope.getScopedBackends()) && !ModelUtil.isAbstraction(member) && ModelUtil.isTypeUnknown(fullType)) {
                that.addError("could not determine type of function or value reference: '" + member.getName(this.unit) + "'" + AnalyzerUtil.getTypeUnknownError(fullType));
            }
            if (this.dynamic && ModelUtil.isTypeUnknown(fullType)) {
                return;
            }
            that.setTypeModel(fullType);
        }
    }

    @Override
    public void visit(Tree.BaseTypeExpression that) {
        super.visit(that);
        boolean notIndirectlyInvoked = !that.getIndirectlyInvoked();
        boolean notDirectlyInvoked = !that.getDirectlyInvoked();
        TypeDeclaration type = this.resolveBaseTypeExpression(that, notIndirectlyInvoked);
        this.checkExtendsClauseReference(that, type);
        if (type != null && notDirectlyInvoked) {
            Tree.TypeArguments tal = that.getTypeArguments();
            List<Type> typeArgs = this.explicitTypeArguments(type, tal) ? AnalyzerUtil.getTypeArguments(tal, null, type.getTypeParameters()) : new TypeArgumentInference(this.unit).getInferredTypeArgsForFunctionRef(that, null);
            if (typeArgs != null) {
                tal.setTypeModels(typeArgs);
                this.visitBaseTypeExpression(that, type, typeArgs, tal, null);
            } else if (!that.getStaticMethodReferencePrimary()) {
                this.visitGenericBaseTypeReference(that, type);
            }
        }
    }

    private void visitGenericBaseTypeReference(Tree.StaticMemberOrTypeExpression that, TypeDeclaration type) {
        if (AnalyzerUtil.isGeneric(type) && type instanceof Class) {
            TypeDeclaration generic = type;
            Scope scope = that.getScope();
            Type outerType = scope.getDeclaringType(type);
            Type target = type.appliedType(outerType, ModelUtil.typeParametersAsArgList(generic));
            that.setTarget(target);
            Type functionType = ModelUtil.genericFunctionType(generic, scope, type, target, this.unit);
            that.setTypeModel(functionType);
            NativeUtil.checkNotJvm(that, "type functions are not supported on the JVM");
        }
    }

    private TypeDeclaration resolveBaseTypeExpression(Tree.BaseTypeExpression that, boolean error) {
        Tree.Identifier id = that.getIdentifier();
        String name = TreeUtil.name(id);
        Scope scope = that.getScope();
        TypeDeclaration type = AnalyzerUtil.getTypeDeclaration(scope, name, that.getSignature(), that.getEllipsis(), that.getUnit());
        if (type == null) {
            if (error && !this.dynamic && !this.isNativeForWrongBackend(scope.getScopedBackends())) {
                String correction = AnalyzerUtil.correct(scope, this.unit, name);
                String message = correction == null ? "" : " (did you mean '" + correction + "'?)";
                that.addError("type does not exist: '" + name + "'" + message, 102);
                this.unit.getUnresolvedReferences().add(id);
            }
        } else {
            type = (TypeDeclaration)this.handleAbstractionOrHeader(type, that, error);
            that.setDeclaration(type);
            if (error && this.checkConcreteClass(type, that) && this.checkSealedReference(type, that)) {
                this.checkBaseTypeAndConstructorVisibility(that, name, type);
            }
        }
        return type;
    }

    private boolean checkConcreteConstructor(TypedDeclaration member, Tree.StaticMemberOrTypeExpression that) {
        if (ModelUtil.isConstructor(member)) {
            Scope container = member.getContainer();
            Constructor cons = (Constructor)member.getTypeDeclaration();
            if (cons.isAbstract()) {
                that.addError("partial constructor cannot be invoked: '" + member.getName(this.unit) + "' is abstract");
                return false;
            }
            if (container instanceof Class) {
                Class c = (Class)container;
                if (c.isAbstract()) {
                    that.addError("class cannot be instantiated: '" + member.getName(this.unit) + "' is a constructor for the abstract class '" + c.getName(this.unit));
                    return false;
                }
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean checkConcreteClass(TypeDeclaration type, Tree.MemberOrTypeExpression that) {
        if (that.getStaticMethodReferencePrimary()) {
            return true;
        }
        if (type instanceof Class) {
            Class c = (Class)type;
            if (c.isAbstract()) {
                that.addError("class cannot be instantiated: '" + type.getName(this.unit) + "' is abstract");
                return false;
            }
            if (c.getParameterList() == null) {
                that.addError("class cannot be instantiated: '" + type.getName(this.unit) + "' does not have a default constructor");
                return false;
            }
            return true;
        }
        if (type instanceof Constructor) {
            Scope container = type.getContainer();
            if (type.isAbstract()) {
                that.addError("partial constructor cannot be invoked: '" + type.getName(this.unit) + "' is abstract");
                return false;
            }
            if (container instanceof Class) {
                Class c = (Class)container;
                if (c.isAbstract()) {
                    that.addError("class cannot be instantiated: '" + type.getName(this.unit) + "' is a constructor for the abstract class '" + c.getName(this.unit));
                    return false;
                }
                return true;
            }
            return false;
        }
        that.addError("type cannot be instantiated: '" + type.getName(this.unit) + "' is not a class");
        return false;
    }

    private boolean checkSealedReference(TypeDeclaration type, Tree.MemberOrTypeExpression that) {
        if (type.isSealed() && !AnalyzerUtil.inSameModule(type, this.unit) && !that.getStaticMethodReferencePrimary()) {
            String moduleName = type.getUnit().getPackage().getModule().getNameAsString();
            if (type instanceof Constructor) {
                String cname = type.getExtendedType().getDeclaration().getName(this.unit);
                that.addError("invokes or references a sealed constructor in a different module: '" + type.getName(this.unit) + "' of '" + cname + "' in '" + moduleName + "'");
            } else {
                that.addError("instantiates or references a sealed class in a different module: '" + type.getName(this.unit) + "' in '" + moduleName + "'");
            }
            return false;
        }
        return true;
    }

    void visitExtendedTypePrimary(Tree.ExtendedTypeExpression that) {
        Declaration dec = that.getDeclaration();
        if (dec instanceof Class) {
            Declaration result;
            Class c = (Class)dec;
            if (c.isAbstraction() && (result = ModelUtil.findMatchingOverloadedClass(c, that.getSignature(), that.getEllipsis())) != null && result != dec) {
                TypeDeclaration td = (TypeDeclaration)result;
                that.setDeclaration(td);
                c = (Class)td;
                if (ModelUtil.isOverloadedVersion(result) && result.isPackageVisibility() && !AnalyzerUtil.declaredInPackage(result, this.unit)) {
                    that.addError("package private constructor is not visible: '" + result.getName() + "'");
                }
            }
            if (!c.isAbstraction() && c.getParameterList() == null) {
                that.addError("class cannot be instantiated: '" + c.getName(this.unit) + "' does not have a parameter list or default constructor");
            }
        }
    }

    @Override
    public void visit(Tree.QualifiedMemberOrTypeExpression that) {
        super.visit(that);
        Tree.Term p = that.getPrimary();
        while (p instanceof Tree.Expression && p.getMainToken() == null) {
            Tree.Expression e = (Tree.Expression)p;
            p = e.getTerm();
        }
        if (p instanceof Tree.MemberOrTypeExpression) {
            Tree.MemberOrTypeExpression mte = (Tree.MemberOrTypeExpression)p;
            Declaration pd = mte.getDeclaration();
            if (!that.getStaticMethodReference() && pd instanceof Functional) {
                that.addError("direct function references do not have members");
            }
        }
    }

    void resetSuperReference(Tree.QualifiedMemberOrTypeExpression that) {
        Declaration dec;
        Tree.Primary p = that.getPrimary();
        if (p instanceof Tree.Super && (dec = that.getDeclaration()) != null) {
            Tree.Super s = (Tree.Super)p;
            TypeDeclaration td = (TypeDeclaration)dec.getContainer();
            s.setDeclarationModel(td);
        }
    }

    @Override
    public void visit(Tree.QualifiedTypeExpression that) {
        super.visit(that);
        boolean notIndirectlyInvoked = !that.getIndirectlyInvoked();
        boolean notDirectlyInvoked = !that.getDirectlyInvoked();
        TypeDeclaration type = this.resolveQualifiedTypeExpression(that, notIndirectlyInvoked);
        if (type != null && notDirectlyInvoked) {
            Tree.Primary primary = that.getPrimary();
            Tree.TypeArguments tal = that.getTypeArguments();
            Type receiverType = primary.getTypeModel().resolveAliases();
            List<Type> typeArgs = this.explicitTypeArguments(type, tal) ? AnalyzerUtil.getTypeArguments(tal, receiverType, type.getTypeParameters()) : new TypeArgumentInference(this.unit).getInferredTypeArgsForFunctionRef(that, receiverType);
            if (typeArgs != null) {
                tal.setTypeModels(typeArgs);
                if (primary instanceof Tree.Package) {
                    this.visitBaseTypeExpression(that, type, typeArgs, tal, null);
                } else {
                    this.visitQualifiedTypeExpression(that, receiverType, type, typeArgs, tal);
                }
                if (that.getStaticMethodReference()) {
                    this.handleStaticReferenceImplicitTypeArguments(that);
                }
            } else if (that.getStaticMethodReference()) {
                this.handleStaticReferenceImplicitTypeArguments(that);
            } else if (!that.getStaticMethodReferencePrimary()) {
                if (primary instanceof Tree.Package) {
                    this.visitGenericBaseTypeReference(that, type);
                } else {
                    this.visitGenericQualifiedTypeReference(that, receiverType, type);
                }
            }
        }
    }

    private void visitGenericQualifiedTypeReference(Tree.QualifiedTypeExpression that, Type outerType, TypeDeclaration type) {
        if (AnalyzerUtil.isGeneric(type) && type instanceof Class) {
            TypeDeclaration generic = type;
            Scope scope = that.getScope();
            Type target = outerType.getTypeMember(type, ModelUtil.typeParametersAsArgList(generic));
            that.setTarget(target);
            Type functionType = ModelUtil.genericFunctionType(generic, scope, type, target, this.unit);
            that.setTypeModel(functionType);
            NativeUtil.checkNotJvm(that, "type functions are not supported on the JVM");
        }
    }

    private TypeDeclaration resolveQualifiedTypeExpression(Tree.QualifiedTypeExpression that, boolean error) {
        if (ExpressionVisitor.checkMember(that)) {
            boolean ambiguous;
            TypeDeclaration type;
            String container;
            Tree.Primary primary = that.getPrimary();
            Tree.Identifier id = that.getIdentifier();
            List<Type> signature = that.getSignature();
            boolean spread = that.getEllipsis();
            String name = TreeUtil.name(id);
            if (primary instanceof Tree.Package) {
                Package pack = this.unit.getPackage();
                container = "package '" + pack.getNameAsString() + "'";
                type = AnalyzerUtil.getPackageTypeDeclaration(name, signature, spread, this.unit);
                ambiguous = false;
            } else {
                Declaration direct;
                Type pt = primary.getTypeModel().resolveAliases();
                TypeDeclaration d = this.getDeclaration(that, pt);
                container = "type '" + d.getName(this.unit) + "'";
                Scope scope = that.getScope();
                ClassOrInterface ci = ModelUtil.getContainingClassOrInterface(scope);
                type = ci != null && !(d instanceof NothingType) && d.inherits(ci) ? ((direct = ci.getDirectMember(name, signature, spread)) instanceof TypeDeclaration ? (TypeDeclaration)direct : AnalyzerUtil.getTypeMember(d, name, signature, spread, this.unit)) : AnalyzerUtil.getTypeMember(d, name, signature, spread, this.unit);
                boolean bl = ambiguous = type == null && d.isMemberAmbiguous(name, this.unit, signature, spread);
                if (type == null) {
                    String correction = AnalyzerUtil.correct(d, scope, this.unit, name);
                    container = container + (correction == null ? "" : " (did you mean '" + correction + "'?)");
                }
            }
            if (type == null) {
                if (error) {
                    if (ambiguous) {
                        that.addError("member type is ambiguous: '" + name + "' for " + container);
                    } else {
                        that.addError("member type does not exist: '" + name + "' in " + container, 100);
                        this.unit.getUnresolvedReferences().add(id);
                    }
                }
            } else {
                type = (TypeDeclaration)this.handleAbstractionOrHeader(type, that, error);
                that.setDeclaration(type);
                this.resetSuperReference(that);
                if (!this.isSelfReference(primary) && !type.isShared()) {
                    type.setOtherInstanceAccess(true);
                }
                if (error) {
                    if (this.checkConcreteClass(type, that) && this.checkSealedReference(type, that)) {
                        this.checkQualifiedTypeAndConstructorVisibility(that, type, name, container);
                    }
                    if (!this.inExtendsClause) {
                        this.checkSuperMember(that, signature, spread);
                    }
                }
            }
            return type;
        }
        return null;
    }

    private static boolean checkMember(Tree.QualifiedMemberOrTypeExpression qmte) {
        Tree.Primary p = qmte.getPrimary();
        Type pt = p.getTypeModel();
        boolean packageQualified = p instanceof Tree.Package;
        return packageQualified || ExpressionVisitor.isResolvedStaticMethodRef(qmte) || pt != null && (!pt.isUnknown() || qmte.getMemberOperator() instanceof Tree.SpreadOp);
    }

    private static boolean isResolvedStaticMethodRef(Tree.QualifiedMemberOrTypeExpression qmte) {
        Tree.Primary p = qmte.getPrimary();
        if (qmte.getStaticMethodReference() && p instanceof Tree.StaticMemberOrTypeExpression) {
            Tree.StaticMemberOrTypeExpression smte = (Tree.StaticMemberOrTypeExpression)p;
            return smte.getDeclaration() != null;
        }
        return false;
    }

    private TypeDeclaration getDeclaration(Tree.QualifiedMemberOrTypeExpression that, Type pt) {
        TypeDeclaration _td;
        Tree.MemberOrTypeExpression primary;
        TypeDeclaration td;
        td = that.getStaticMethodReference() ? ((td = (TypeDeclaration)(primary = (Tree.MemberOrTypeExpression)that.getPrimary()).getDeclaration()) == null ? new UnknownType(this.unit) : td) : this.unwrap(pt, that).getDeclaration();
        if (td != null && td.isNativeImplementation() && (_td = (TypeDeclaration)ModelUtil.getNativeHeader(td)) != null) {
            td = _td;
        }
        return td;
    }

    private boolean explicitTypeArguments(Declaration dec, Tree.TypeArguments tal) {
        return tal instanceof Tree.TypeArgumentList || !dec.isParameterized();
    }

    private boolean typeConstructorArgumentsInferrable(Declaration dec, Tree.StaticMemberOrTypeExpression smte) {
        if (smte.getTypeArguments() instanceof Tree.TypeArgumentList) {
            return false;
        }
        if (dec instanceof Value) {
            Type type;
            Value value = (Value)dec;
            TypedReference param = smte.getTargetParameter();
            Type paramType = smte.getParameterType();
            if (param != null && paramType == null) {
                paramType = param.getType();
            }
            return (type = value.getType()) != null && type.resolveAliases().isTypeConstructor() && paramType != null && !paramType.resolveAliases().isTypeConstructor();
        }
        return false;
    }

    @Override
    public void visit(Tree.SimpleType that) {
        super.visit(that);
        Type pt = that.getTypeModel();
        if (pt != null) {
            TypeDeclaration type = that.getDeclarationModel();
            Tree.TypeArgumentList tal = that.getTypeArgumentList();
            if (type != null) {
                List<TypeParameter> params = type.getTypeParameters();
                List<Type> typeArgs = AnalyzerUtil.getTypeArguments(tal, pt.getQualifyingType(), params);
                this.acceptsTypeArguments(type, null, typeArgs, tal, that);
            }
            if (pt.isTypeConstructor() && !that.getMetamodel()) {
                NativeUtil.checkNotJvm(that, "type functions are not supported on the JVM");
            }
        }
    }

    @Override
    public void visit(Tree.EntryType that) {
        super.visit(that);
        Tree.StaticType keyType = that.getKeyType();
        AnalyzerUtil.checkAssignable(keyType.getTypeModel(), this.unit.getObjectType(), keyType, "entry key type must not be an optional type");
    }

    private void visitQualifiedTypeExpression(Tree.QualifiedTypeExpression that, Type receivingType, TypeDeclaration memberType, List<Type> typeArgs, Tree.TypeArguments tal) {
        this.checkMemberOperator(receivingType, that);
        Type receiverType = this.accountForStaticReferenceReceiverType(that, this.unwrap(receivingType, that));
        if (this.acceptsTypeArguments(memberType, receiverType, typeArgs, tal, that)) {
            Type type = receiverType.getTypeMember(memberType, typeArgs);
            that.setTarget(type);
            Type fullType = type.getFullType(this.wrap(type, receivingType, that));
            if (!this.dynamic && !that.getStaticMethodReference() && memberType instanceof Class && !ModelUtil.isAbstraction(memberType) && ModelUtil.isTypeUnknown(fullType)) {
                String rtname = receiverType.getDeclaration().getName(this.unit);
                that.addError("could not determine type of member class reference: '" + memberType.getName(this.unit) + "' of '" + rtname + "'");
            }
            that.setTypeModel(this.accountForStaticReferenceType(that, memberType, fullType));
        }
        if (that.getStaticMethodReference()) {
            this.handleStaticReferenceImplicitTypeArguments(that);
        }
    }

    private void visitBaseTypeExpression(Tree.StaticMemberOrTypeExpression that, TypeDeclaration baseType, List<Type> typeArgs, Tree.TypeArguments tal, Type receivingType) {
        if (this.acceptsTypeArguments(baseType, null, typeArgs, tal, that)) {
            Type outerType = that.getScope().getDeclaringType(baseType);
            if (outerType == null) {
                outerType = receivingType;
            }
            Type type = baseType.appliedType(outerType, typeArgs);
            Type fullType = type.getFullType();
            that.setTypeModel(fullType);
            that.setTarget(type);
        }
    }

    @Override
    public void visit(Tree.Expression that) {
        super.visit(that);
        Tree.Term term = that.getTerm();
        if (term == null) {
            that.addError("expression not well formed");
        } else {
            Type t = term.getTypeModel();
            if (t != null) {
                that.setTypeModel(t);
            }
        }
    }

    @Override
    public void visit(Tree.Outer that) {
        Type oci = ModelUtil.getOuterClassOrInterface(that.getScope());
        if (oci == null) {
            that.addError("outer appears outside a nested class or interface definition");
        } else {
            that.setTypeModel(oci);
            that.setDeclarationModel(oci.getDeclaration());
        }
    }

    @Override
    public void visit(Tree.Super that) {
        ClassOrInterface ci = ModelUtil.getContainingClassOrInterface(that.getScope());
        if (this.inExtendsClause) {
            if (ci != null && ci.isClassOrInterfaceMember()) {
                ClassOrInterface cci = (ClassOrInterface)ci.getContainer();
                that.setDeclarationModel(cci);
                that.setTypeModel(ModelUtil.intersectionOfSupertypes(cci));
            }
        } else if (ci == null) {
            that.addError("super occurs outside any type definition");
        } else {
            that.setDeclarationModel(ci);
            that.setTypeModel(ModelUtil.intersectionOfSupertypes(ci));
        }
    }

    @Override
    public void visit(Tree.This that) {
        ClassOrInterface ci = ModelUtil.getContainingClassOrInterface(that.getScope());
        if (this.inExtendsClause) {
            if (ci != null && ci.isClassOrInterfaceMember()) {
                ClassOrInterface cci = (ClassOrInterface)ci.getContainer();
                that.setDeclarationModel(cci);
                that.setTypeModel(cci.getType());
            }
        } else if (ci == null) {
            that.addError("this appears outside a class or interface definition");
        } else {
            that.setDeclarationModel(ci);
            that.setTypeModel(ci.getType());
        }
    }

    @Override
    public void visit(Tree.Package that) {
        if (!that.getQualifier()) {
            that.addError("package must qualify a reference to a toplevel declaration");
        }
        super.visit(that);
    }

    @Override
    public void visit(Tree.Dynamic that) {
        super.visit(that);
        if (this.dynamic) {
            Tree.NamedArgumentList nal = that.getNamedArgumentList();
            if (nal != null) {
                for (Tree.NamedArgument na : nal.getNamedArguments()) {
                    if (!(na instanceof Tree.SpecifiedArgument) || na.getIdentifier() != null) continue;
                    na.addError("missing argument name in dynamic instantiation expression");
                }
            }
        } else {
            that.addError("dynamic instantiation expression occurs outside dynamic block");
        }
    }

    @Override
    public void visit(Tree.Tuple that) {
        super.visit(that);
        Type tt = null;
        Tree.SequencedArgument sa = that.getSequencedArgument();
        if (sa != null) {
            List<Tree.PositionalArgument> pas = sa.getPositionalArguments();
            tt = AnalyzerUtil.getTupleType(pas, this.unit, true);
        } else {
            tt = this.unit.getEmptyType();
        }
        if (tt != null) {
            that.setTypeModel(tt);
            if (tt.containsUnknowns()) {
                that.addError("tuple element type could not be inferred");
            }
        }
    }

    @Override
    public void visit(Tree.SequenceEnumeration that) {
        super.visit(that);
        for (Tree.Statement st : that.getStatements()) {
            st.addError("enumeration expression may not contain statements");
        }
        Type st = null;
        Tree.SequencedArgument sa = that.getSequencedArgument();
        if (sa != null) {
            Interface id;
            List<Tree.PositionalArgument> pas = sa.getPositionalArguments();
            Type tt = AnalyzerUtil.getTupleType(pas, this.unit, false);
            if (tt != null && (st = tt.getSupertype(id = this.unit.getIterableDeclaration())) == null) {
                st = this.unit.getIterableType(this.unit.getUnknownType());
            }
        } else {
            st = this.unit.getIterableType(this.unit.getNothingType());
        }
        if (st != null) {
            that.setTypeModel(st);
            if (st.containsUnknowns()) {
                that.addError("iterable element type could not be inferred");
            }
        }
    }

    @Override
    public void visit(Tree.CatchVariable that) {
        super.visit(that);
        Tree.Variable var = that.getVariable();
        if (var != null) {
            Tree.Type vt = var.getType();
            if (vt instanceof Tree.LocalModifier) {
                Type et = this.unit.getExceptionType();
                vt.setTypeModel(et);
                var.getDeclarationModel().setType(et);
            } else {
                AnalyzerUtil.checkAssignable(vt.getTypeModel(), this.unit.getThrowableType(), vt, "catch type must be a throwable type");
            }
        }
    }

    @Override
    public void visit(Tree.StringTemplate that) {
        super.visit(that);
        for (Tree.Expression e : that.getExpressions()) {
            Type et = e.getTypeModel();
            if (ModelUtil.isTypeUnknown(et)) continue;
            AnalyzerUtil.checkAssignable(et, this.unit.getObjectType(), e, "interpolated expression must not be an optional type");
        }
        that.setTypeModel(this.unit.getStringType());
    }

    @Override
    public void visit(Tree.StringLiteral that) {
        that.setTypeModel(this.unit.getStringType());
    }

    @Override
    public void visit(Tree.NaturalLiteral that) {
        that.setTypeModel(this.unit.getIntegerType());
    }

    @Override
    public void visit(Tree.FloatLiteral that) {
        that.setTypeModel(this.unit.getFloatType());
    }

    @Override
    public void visit(Tree.CharLiteral that) {
        String result = that.getText();
        if (result.codePointCount(1, result.length() - 1) != 1) {
            that.addError("character literal must contain exactly one character");
        }
        that.setTypeModel(this.unit.getCharacterType());
    }

    @Override
    public void visit(Tree.QuotedLiteral that) {
        that.setTypeModel(this.unit.getStringType());
    }

    @Override
    public void visit(Tree.CompilerAnnotation that) {
    }

    @Override
    public void visit(Tree.MatchCase that) {
        super.visit(that);
        for (Tree.Expression e : that.getExpressionList().getExpressions()) {
            Type it;
            Tree.Variable switchVariable;
            Tree.Expression switchExpression;
            Type st;
            Tree.Switched switched;
            Type t;
            if (e == null || ModelUtil.isTypeUnknown(t = e.getTypeModel())) continue;
            if (this.switchStatementOrExpression != null && (switched = this.switchClause().getSwitched()) != null && (st = ExpressionVisitor.getSwitchType(switchExpression = switched.getExpression(), switchVariable = switched.getVariable())) != null && (it = ModelUtil.intersectionType(t, st, this.unit)).isNothing() && ExpressionVisitor.mayNotBeNothing(switchExpression, switchVariable, t)) {
                e.addError("value is not a case of the switched type: '" + t.asString(this.unit) + "' is not a case of the type '" + st.asString(this.unit) + "'");
            }
            this.checkValueCase(e);
        }
    }

    private void checkValueCase(Tree.Expression e) {
        Tree.Term term = e.getTerm();
        Type type = e.getTypeModel();
        if (term instanceof Tree.NegativeOp) {
            Tree.NegativeOp no = (Tree.NegativeOp)term;
            term = no.getTerm();
        }
        if (term instanceof Tree.Literal) {
            if (term instanceof Tree.FloatLiteral) {
                e.addError("literal case may not be a 'Float' literal");
            }
        } else if (term instanceof Tree.MemberOrTypeExpression) {
            boolean isToplevelClassInstance;
            TypeDeclaration dec = type.getDeclaration();
            boolean isToplevelInstance = dec.isObjectClass() && dec.isToplevel();
            boolean bl = isToplevelClassInstance = dec.isValueConstructor() && (dec.getContainer().isToplevel() || dec.isStaticallyImportable());
            if (!isToplevelInstance && !isToplevelClassInstance) {
                e.addError("case must refer to a toplevel object declaration, value constructor for a toplevel class, or literal value");
            } else {
                Type ut = ModelUtil.unionType(this.unit.getNullType(), this.unit.getIdentifiableType(), this.unit);
                AnalyzerUtil.checkAssignable(type, ut, e, "case must be identifiable or null");
            }
        } else if (term != null) {
            e.addError("case must be a literal value or refer to a toplevel object declaration or value constructor for a toplevel class");
        }
    }

    @Override
    public void visit(Tree.IsCase that) {
        Tree.Switched switched;
        Tree.Type t = that.getType();
        if (t != null) {
            t.visit(this);
        }
        if (this.switchStatementOrExpression != null && (switched = this.switchClause().getSwitched()) != null) {
            Tree.Expression switchExpression = switched.getExpression();
            Tree.Variable switchVariable = switched.getVariable();
            Tree.Variable v = that.getVariable();
            Type st = ExpressionVisitor.getSwitchType(switchExpression, switchVariable);
            if (st != null) {
                if (v != null) {
                    if (this.dynamic || !ModelUtil.isTypeUnknown(st)) {
                        v.visit(this);
                    }
                    this.initOriginalDeclaration(v);
                }
                if (t != null) {
                    Type pt = t.getTypeModel();
                    Type it = ModelUtil.intersectionType(pt, st, this.unit);
                    if (it.isNothing() && ExpressionVisitor.mayNotBeNothing(switchExpression, switchVariable, pt)) {
                        that.addError("narrows to bottom type 'Nothing': '" + pt.asString(this.unit) + "' has empty intersection with '" + st.asString(this.unit) + "'");
                    }
                    if (v != null) {
                        v.getType().setTypeModel(it);
                        v.getDeclarationModel().setType(it);
                    }
                }
            }
        }
    }

    private static boolean mayNotBeNothing(Tree.Expression switchExpression, Tree.Variable switchVariable, Type pt) {
        return switchVariable != null || switchExpression != null && (!TreeUtil.hasUncheckedNulls(switchExpression.getTerm()) || !pt.isNull());
    }

    @Override
    public void visit(Tree.SatisfiesCase that) {
        super.visit(that);
        that.addUnsupportedError("satisfies cases are not yet supported");
    }

    private static Type getSwitchType(Tree.Expression switchExpression, Tree.Variable switchVariable) {
        if (switchVariable != null) {
            return switchVariable.getType().getTypeModel();
        }
        if (switchExpression != null) {
            return switchExpression.getTypeModel();
        }
        return null;
    }

    @Override
    public void visit(Tree.SwitchStatement that) {
        Node oss = this.switchStatementOrExpression;
        Node ois = this.ifStatementOrExpression;
        this.ifStatementOrExpression = null;
        this.switchStatementOrExpression = that;
        super.visit(that);
        this.checkCasesExhaustive(that.getSwitchClause(), that.getSwitchCaseList());
        this.switchStatementOrExpression = oss;
        this.ifStatementOrExpression = ois;
    }

    private void checkCasesExhaustive(Tree.SwitchClause switchClause, Tree.SwitchCaseList switchCaseList) {
        Tree.Switched switched = switchClause.getSwitched();
        if (switched != null) {
            Type switchExpressionType = ExpressionVisitor.getSwitchedExpressionType(switched);
            if (switchCaseList != null && switchExpressionType != null) {
                Type caseUnionType;
                this.checkCases(switchCaseList);
                Tree.ElseClause elseClause = switchCaseList.getElseClause();
                if (!ModelUtil.isTypeUnknown(switchExpressionType) && elseClause == null && (caseUnionType = this.caseUnionType(switchCaseList)) != null && !caseUnionType.covers(switchExpressionType)) {
                    switchClause.addError("case types must cover all cases of the switch type or an else clause must appear: '" + caseUnionType.asString(this.unit) + "' does not cover '" + switchExpressionType.asString(this.unit) + "'", 10000);
                }
            }
        }
    }

    private static Type getSwitchedExpressionType(Tree.Switched switched) {
        if (switched != null) {
            Tree.Type t;
            Tree.Expression e = switched.getExpression();
            Tree.Variable v = switched.getVariable();
            if (e != null) {
                return e.getTypeModel();
            }
            if (v != null && (t = v.getType()) != null) {
                return t.getTypeModel();
            }
        }
        return null;
    }

    @Override
    public void visit(Tree.IfStatement that) {
        Node ois = this.ifStatementOrExpression;
        Node oss = this.switchStatementOrExpression;
        this.ifStatementOrExpression = that;
        this.switchStatementOrExpression = null;
        super.visit(that);
        this.ifStatementOrExpression = ois;
        this.switchStatementOrExpression = oss;
    }

    @Override
    public void visit(Tree.ElseClause that) {
        Tree.Expression expression;
        Tree.Block block;
        Tree.Variable var = that.getVariable();
        if (var != null) {
            Tree.ConditionList conditionList;
            Tree.Switched switched;
            var.visit(this);
            this.initOriginalDeclaration(var);
            if (this.switchStatementOrExpression != null && (switched = this.switchClause().getSwitched()) != null) {
                this.setTypeForElseVariable(var, switched);
            }
            if (this.ifStatementOrExpression != null && (conditionList = this.ifClause().getConditionList()) != null) {
                this.setTypeForElseVariable(var, conditionList);
            }
        }
        if ((block = that.getBlock()) != null) {
            block.visit(this);
        }
        if ((expression = that.getExpression()) != null) {
            expression.visit(this);
        }
    }

    private void setTypeForElseVariable(Tree.Variable var, Tree.Switched switched) {
        Type caseUnionType;
        Type switchExpressionType = ExpressionVisitor.getSwitchedExpressionType(switched);
        Tree.SwitchCaseList switchCaseList = this.switchCaseList();
        if (switchExpressionType != null && switchCaseList != null && !ModelUtil.isTypeUnknown(switchExpressionType) && (caseUnionType = this.caseUnionType(switchCaseList)) != null) {
            Type complementType = switchExpressionType.minus(caseUnionType);
            complementType = this.unit.denotableType(complementType);
            Value dec = var.getDeclarationModel();
            if (!ModelUtil.isCompletelyVisible(dec, complementType)) {
                complementType = switchExpressionType;
            }
            var.getType().setTypeModel(complementType);
            dec.setType(complementType);
        }
    }

    private void setTypeForElseVariable(Tree.Variable var, Tree.ConditionList conditionList) {
        Tree.Condition c = conditionList.getConditions().get(0);
        Tree.SpecifierExpression se = var.getSpecifierExpression();
        if (c instanceof Tree.ExistsCondition) {
            Tree.ExistsCondition ec = (Tree.ExistsCondition)c;
            this.inferDefiniteType(var, se, !ec.getNot());
        } else if (c instanceof Tree.NonemptyCondition) {
            Tree.NonemptyCondition ec = (Tree.NonemptyCondition)c;
            this.inferNonemptyType(var, se, !ec.getNot());
        } else if (c instanceof Tree.IsCondition) {
            Tree.IsCondition ic = (Tree.IsCondition)c;
            Tree.Expression e = se.getExpression();
            Type expressionType = e.getTypeModel();
            Type complementType = this.narrow(ic.getType().getTypeModel(), expressionType, !ic.getNot());
            Value dec = var.getDeclarationModel();
            if (!ModelUtil.isCompletelyVisible(dec, complementType)) {
                complementType = expressionType;
            }
            var.getType().setTypeModel(complementType);
            dec.setType(complementType);
        }
    }

    private void checkCases(Tree.SwitchCaseList switchCaseList) {
        Tree.Expression switchExpression;
        Tree.Switched switched;
        List<Tree.CaseClause> cases = switchCaseList.getCaseClauses();
        boolean hasIsCase = false;
        for (Tree.CaseClause cc : cases) {
            if (cc.getCaseItem() instanceof Tree.IsCase) {
                hasIsCase = true;
            }
            for (Tree.CaseClause occ : cases) {
                if (occ == cc) break;
                this.checkCasesClausesDisjoint(cc, occ);
            }
        }
        if (hasIsCase && this.switchStatementOrExpression != null && (switched = this.switchClause().getSwitched()) != null && (switchExpression = switched.getExpression()) != null) {
            Tree.Term st = switchExpression.getTerm();
            if (st instanceof Tree.BaseMemberExpression) {
                Tree.BaseMemberExpression bme = (Tree.BaseMemberExpression)st;
                this.checkReferenceIsNonVariable(bme, true);
            } else if (st != null) {
                st.addError("switch expression must be a value reference in switch with type cases", 3102);
            }
        }
    }

    private Type caseUnionType(Tree.SwitchCaseList switchCaseList) {
        List<Tree.CaseClause> caseClauses = switchCaseList.getCaseClauses();
        ArrayList<Type> list = new ArrayList<Type>(caseClauses.size());
        for (Tree.CaseClause cc : caseClauses) {
            Type ct = this.getTypeIgnoringLiterals(cc);
            if (ModelUtil.isTypeUnknown(ct)) {
                return null;
            }
            ModelUtil.addToUnion(list, ct);
        }
        return ModelUtil.union(list, this.unit);
    }

    private void checkCasesClausesDisjoint(Tree.CaseClause cc, Tree.CaseClause occ) {
        Tree.CaseItem cci = cc.getCaseItem();
        Tree.CaseItem occi = occ.getCaseItem();
        if (cci instanceof Tree.IsCase || occi instanceof Tree.IsCase) {
            AnalyzerUtil.checkCasesDisjoint(this.getType(cc), this.getType(occ), cci);
        } else {
            AnalyzerUtil.checkCasesDisjoint(this.getTypeIgnoringLiterals(cc), this.getTypeIgnoringLiterals(occ), cci);
        }
        if (cci instanceof Tree.MatchCase && occi instanceof Tree.MatchCase) {
            this.checkLiteralsDisjoint((Tree.MatchCase)cci, (Tree.MatchCase)occi);
        }
    }

    private void checkLiteralsDisjoint(Tree.MatchCase cci, Tree.MatchCase occi) {
        for (Tree.Expression e : cci.getExpressionList().getExpressions()) {
            for (Tree.Expression f : occi.getExpressionList().getExpressions()) {
                Tree.Term et = e.getTerm();
                Tree.Term ft = f.getTerm();
                boolean eneg = et instanceof Tree.NegativeOp;
                boolean fneg = ft instanceof Tree.NegativeOp;
                if (eneg) {
                    et = ((Tree.NegativeOp)et).getTerm();
                }
                if (fneg) {
                    ft = ((Tree.NegativeOp)ft).getTerm();
                }
                if (!(et instanceof Tree.Literal) || !(ft instanceof Tree.Literal)) continue;
                String ftv = ExpressionVisitor.getLiteralText(ft);
                String etv = ExpressionVisitor.getLiteralText(et);
                if (et instanceof Tree.NaturalLiteral && ft instanceof Tree.NaturalLiteral && (ftv.startsWith("#") && !etv.startsWith("#") || !ftv.startsWith("#") && etv.startsWith("#") || ftv.startsWith("$") && !etv.startsWith("$") || !ftv.startsWith("$") && etv.startsWith("$"))) {
                    cci.addUnsupportedError("literal cases with mixed bases not yet supported");
                    continue;
                }
                if (!etv.equals(ftv) || eneg != fneg) continue;
                cci.addError("literal cases must be disjoint: " + (eneg ? "-" : "") + etv.replaceAll("\\p{Cntrl}", "?") + " occurs in multiple cases");
            }
        }
    }

    private static String getLiteralText(Tree.Term et) {
        String etv = et.getText();
        if (et instanceof Tree.CharLiteral) {
            return "'" + etv + "'";
        }
        if (et instanceof Tree.StringLiteral) {
            return "\"" + etv + "\"";
        }
        return etv;
    }

    private Type getType(Tree.CaseItem ci) {
        Tree.IsCase ic = (Tree.IsCase)ci;
        Tree.Type t = ic.getType();
        if (t != null) {
            Type type = t.getTypeModel();
            return type == null ? null : type.getUnionOfCases();
        }
        return null;
    }

    private Type getType(Tree.CaseClause cc) {
        Tree.CaseItem ci = cc.getCaseItem();
        if (ci instanceof Tree.IsCase) {
            return this.getType(ci);
        }
        if (ci instanceof Tree.MatchCase) {
            Tree.MatchCase mc = (Tree.MatchCase)ci;
            List<Tree.Expression> es = mc.getExpressionList().getExpressions();
            ArrayList<Type> list = new ArrayList<Type>(es.size());
            for (Tree.Expression e : es) {
                if (e.getTypeModel() == null) continue;
                ModelUtil.addToUnion(list, e.getTypeModel());
            }
            return ModelUtil.union(list, this.unit);
        }
        return null;
    }

    private Type getTypeIgnoringLiterals(Tree.CaseClause cc) {
        Tree.CaseItem ci = cc.getCaseItem();
        if (ci instanceof Tree.IsCase) {
            return this.getType(ci);
        }
        if (ci instanceof Tree.MatchCase) {
            Tree.MatchCase mc = (Tree.MatchCase)ci;
            List<Tree.Expression> es = mc.getExpressionList().getExpressions();
            ArrayList<Type> list = new ArrayList<Type>(es.size());
            for (Tree.Expression e : es) {
                if (e.getTypeModel() == null || e.getTerm() instanceof Tree.Literal || e.getTerm() instanceof Tree.NegativeOp) continue;
                ModelUtil.addToUnion(list, e.getTypeModel());
            }
            return ModelUtil.union(list, this.unit);
        }
        return null;
    }

    @Override
    public void visit(Tree.TryCatchStatement that) {
        super.visit(that);
        block0: for (Tree.CatchClause cc : that.getCatchClauses()) {
            Type ct;
            Tree.CatchVariable ccv = cc.getCatchVariable();
            if (ccv == null || ccv.getVariable() == null || (ct = ccv.getVariable().getType().getTypeModel()) == null) continue;
            for (Tree.CatchClause ecc : that.getCatchClauses()) {
                Tree.CatchVariable eccv = ecc.getCatchVariable();
                if (eccv == null || eccv.getVariable() == null) continue;
                if (cc == ecc) continue block0;
                Type ect = eccv.getVariable().getType().getTypeModel();
                if (ect == null) continue;
                if (ct.isSubtypeOf(ect)) {
                    ccv.getVariable().getType().addError("exception type is already handled by earlier catch clause: '" + ct.asString(this.unit) + "'");
                }
                if (!ct.isUnion()) continue;
                for (Type ut : ct.getCaseTypes()) {
                    if (!ut.isSubtypeOf(ect)) continue;
                    ccv.getVariable().getType().addError("exception type is already handled by earlier catch clause: '" + ut.asString(this.unit) + "'");
                }
            }
        }
    }

    @Override
    public void visit(Tree.DynamicStatement that) {
        boolean od = this.dynamic;
        this.dynamic = true;
        super.visit(that);
        this.dynamic = od;
    }

    private boolean acceptsTypeArguments(Declaration dec, Type receiverType, List<Type> typeArguments, Tree.TypeArguments tas, Node parent) {
        Value td;
        Type type;
        boolean empty;
        boolean explicit = tas instanceof Tree.TypeArgumentList;
        boolean typeExpression = parent instanceof Tree.SimpleType;
        if (explicit && !typeExpression) {
            Tree.TypeArgumentList tal = (Tree.TypeArgumentList)tas;
            for (Tree.Type t : tal.getTypes()) {
                Tree.StaticType st;
                Tree.TypeVariance var;
                if (!(t instanceof Tree.StaticType) || (var = (st = (Tree.StaticType)t).getTypeVariance()) == null) continue;
                var.addError("use-site variance annotation may not occur in value expression");
            }
        }
        if (dec == null) {
            return false;
        }
        if (AnalyzerUtil.isGeneric(dec)) {
            if (typeArguments == null) {
                return false;
            }
            return this.checkTypeArgumentAgainstDeclaration(receiverType, dec, typeArguments, tas, parent);
        }
        boolean bl = empty = typeArguments == null || typeArguments.isEmpty();
        if (dec instanceof TypeAlias && !empty) {
            TypeAlias alias = (TypeAlias)dec;
            dec = AnalyzerUtil.unwrapAliasedTypeConstructor(alias);
            return this.checkTypeArgumentAgainstDeclaration(receiverType, dec, typeArguments, tas, parent);
        }
        if (dec instanceof Value && !empty && (type = (td = (Value)dec).getType()) != null && (type = type.resolveAliases()).isTypeConstructor()) {
            this.checkArgumentsAgainstTypeConstructor(typeArguments, tas, type, parent);
            return true;
        }
        if (!empty || explicit) {
            tas.addError("does not accept type arguments: '" + dec.getName(this.unit) + "' is not a generic declaration");
        }
        return empty;
    }

    private boolean checkTypeArgumentAgainstDeclaration(Type receiver, Declaration dec, List<Type> typeArguments, Tree.TypeArguments tas, Node parent) {
        Generic g = (Generic)((Object)dec);
        List<TypeParameter> params = g.getTypeParameters();
        boolean explicit = tas instanceof Tree.TypeArgumentList;
        int min = 0;
        for (TypeParameter tp : params) {
            if (tp.isDefaulted()) continue;
            ++min;
        }
        if (receiver == null && dec.isClassOrInterfaceMember()) {
            receiver = parent.getScope().getDeclaringType(dec);
        }
        int max = params.size();
        int args = typeArguments.size();
        if (args <= max && args >= min) {
            for (int i = 0; i < args; ++i) {
                boolean enforceConstraints;
                List<Type> sts;
                boolean argTypeMeaningful;
                TypeParameter param = params.get(i);
                Type argType = typeArguments.get(i);
                boolean bl = argTypeMeaningful = argType != null && !argType.isUnknown();
                if (argTypeMeaningful) {
                    if (!argType.isTypeConstructor() && param.isTypeConstructor()) {
                        ExpressionVisitor.typeArgNode(tas, i, parent).addError("type argument must be a type constructor: parameter '" + param.getName() + "' is a type constructor parameter but '" + argType.asString(this.unit) + "' is a regular type");
                    } else if (param.isTypeConstructor()) {
                        Node argNode;
                        if (explicit) {
                            Tree.TypeArgumentList tl = (Tree.TypeArgumentList)tas;
                            argNode = tl.getTypes().get(i);
                        } else {
                            argNode = parent;
                        }
                        this.checkTypeConstructorParam(param, argType, argNode);
                    }
                }
                boolean hasConstraints = !(sts = param.getSatisfiedTypes()).isEmpty() || param.getCaseTypes() != null;
                boolean bl2 = enforceConstraints = this.modelLiteral || !(parent instanceof Tree.SimpleType) || ((Tree.SimpleType)parent).getInherited();
                if (!hasConstraints || !enforceConstraints) continue;
                Type assignedType = ExpressionVisitor.argumentTypeForBoundsCheck(param, argType);
                for (Type st : sts) {
                    Type bound = st.appliedType(receiver, dec, typeArguments, null);
                    if (assignedType.isSubtypeOf(bound)) continue;
                    if (argTypeMeaningful) {
                        if (explicit) {
                            ExpressionVisitor.typeArgNode(tas, i, parent).addError("type parameter '" + param.getName() + "' of declaration '" + dec.getName(this.unit) + "' has argument '" + assignedType.asString(this.unit) + "' which is not assignable to upper bound '" + bound.asString(this.unit) + "' of '" + param.getName() + "'", 2102);
                        } else {
                            parent.addError("inferred type argument '" + assignedType.asString(this.unit) + "' to type parameter '" + param.getName() + "' of declaration '" + dec.getName(this.unit) + "' is not assignable to upper bound '" + bound.asString(this.unit) + "' of '" + param.getName() + "'");
                        }
                    }
                    return false;
                }
                if (ModelUtil.argumentSatisfiesEnumeratedConstraint(receiver, dec, typeArguments, assignedType, param)) continue;
                if (argTypeMeaningful) {
                    if (explicit) {
                        ExpressionVisitor.typeArgNode(tas, i, parent).addError("type parameter '" + param.getName() + "' of declaration '" + dec.getName(this.unit) + "' has argument '" + assignedType.asString(this.unit) + "' which is not one of the enumerated cases of '" + param.getName() + "'");
                    } else {
                        parent.addError("inferred type argument '" + assignedType.asString(this.unit) + "' to type parameter '" + param.getName() + "' of declaration '" + dec.getName(this.unit) + "' is not one of the enumerated cases of '" + param.getName() + "'");
                    }
                }
                return false;
            }
            return true;
        }
        if (explicit) {
            StringBuilder paramList = new StringBuilder();
            for (TypeParameter tp : g.getTypeParameters()) {
                if (paramList.length() > 0) {
                    paramList.append(", ");
                }
                paramList.append("'").append(tp.getName()).append("'");
            }
            String help = args < min ? " requires at least " + min + " type arguments to " + paramList : (args > max ? " allows at most " + max + " type arguments to " + paramList : "");
            tas.addError("wrong number of type arguments: '" + dec.getName(this.unit) + "'" + help);
        }
        return false;
    }

    private static Type argumentTypeForBoundsCheck(TypeParameter param, Type argType) {
        if (argType == null) {
            return null;
        }
        if (argType.isTypeConstructor()) {
            return argType.getDeclaration().appliedType(null, param.getType().getTypeArgumentList());
        }
        return argType;
    }

    private static Node typeArgNode(Tree.TypeArguments tas, int i, Node parent) {
        if (tas instanceof Tree.TypeArgumentList) {
            Tree.TypeArgumentList tal = (Tree.TypeArgumentList)tas;
            return tal.getTypes().get(i);
        }
        return parent;
    }

    private void checkArgumentsAgainstTypeConstructor(List<Type> typeArguments, Tree.TypeArguments tas, Type type, Node parent) {
        boolean explicit = tas instanceof Tree.TypeArgumentList;
        TypeDeclaration tcd = type.getDeclaration();
        List<TypeParameter> typeParameters = tcd.getTypeParameters();
        int size = typeArguments.size();
        if (size != typeParameters.size()) {
            tas.addError("wrong number of type arguments: type constructor requires " + size + " type arguments");
        } else {
            Map<TypeParameter, Type> args = ModelUtil.getTypeArgumentMap(tcd, null, typeArguments);
            Map<TypeParameter, SiteVariance> variances = Collections.emptyMap();
            for (int i = 0; i < size; ++i) {
                TypeParameter param = typeParameters.get(i);
                Type arg = typeArguments.get(i);
                if (!ModelUtil.isTypeUnknown(arg)) {
                    List<Type> sts = param.getSatisfiedTypes();
                    for (Type st : sts) {
                        Type bound = st.substitute(args, variances);
                        if (ModelUtil.isTypeUnknown(bound) || arg.isSubtypeOf(bound)) continue;
                        String message = "type argument '" + arg.asString(this.unit) + "' is not assignable to upper bound '" + bound.asString(this.unit) + "' of type parameter '" + param.getName() + "' of '" + param.getDeclaration().getName(this.unit) + "'";
                        if (explicit) {
                            ExpressionVisitor.typeArgNode(tas, i, parent).addError(message);
                            continue;
                        }
                        parent.addError("inferred " + message);
                    }
                }
                if (this.satisfiesEnumeratedConstraint(param, arg, args, variances)) continue;
                String message = "type argument '" + arg.asString(this.unit) + "' is not one of the enumerated cases of the type parameter '" + param.getName() + "' of '" + param.getDeclaration().getName(this.unit) + "'";
                if (explicit) {
                    ExpressionVisitor.typeArgNode(tas, i, parent).addError(message);
                    continue;
                }
                parent.addError("inferred " + message);
            }
        }
    }

    boolean satisfiesEnumeratedConstraint(TypeParameter param, Type arg, Map<TypeParameter, Type> args, Map<TypeParameter, SiteVariance> variances) {
        List<Type> cts = param.getCaseTypes();
        if (cts != null) {
            for (Type ct : cts) {
                Type bound = ct.substitute(args, variances);
                if (!arg.isSubtypeOf(bound)) continue;
                return true;
            }
            if (arg.isTypeParameter()) {
                for (Type act : arg.getCaseTypes()) {
                    boolean foundCase = false;
                    for (Type ct : cts) {
                        Type bound = ct.substitute(args, variances);
                        if (!act.isSubtypeOf(bound)) continue;
                        foundCase = true;
                    }
                    if (foundCase) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return true;
    }

    private void checkTypeConstructorParam(TypeParameter param, Type argType, Node argNode) {
        block10: {
            block12: {
                block11: {
                    block9: {
                        if (argType.isTypeConstructor()) break block9;
                        argNode.addError("not a type constructor: '" + argType.asString(this.unit) + "'");
                        break block10;
                    }
                    if (!(argType = AnalyzerUtil.unwrapAliasedTypeConstructor(argType)).isUnion()) break block11;
                    for (Type ct : argType.getCaseTypes()) {
                        this.checkTypeConstructorParam(param, ct, argNode);
                    }
                    break block10;
                }
                if (!argType.isIntersection()) break block12;
                for (Type st : argType.getSatisfiedTypes()) {
                    this.checkTypeConstructorParam(param, st, argNode);
                }
                break block10;
            }
            if (argType.isNothing()) break block10;
            TypeDeclaration argTypeDec = argType.getDeclaration();
            List<TypeParameter> argTypeParams = argTypeDec.getTypeParameters();
            int allowed = argTypeParams.size();
            int required = 0;
            for (TypeParameter tp : argTypeParams) {
                if (tp.isDefaulted()) break;
                ++required;
            }
            List<TypeParameter> paramTypeParams = param.getTypeParameters();
            int size = paramTypeParams.size();
            if (allowed < size || required > size) {
                argNode.addError("argument type constructor has wrong number of type parameters: argument '" + argTypeDec.getName(this.unit) + "' has " + allowed + " type parameters " + "but parameter '" + param.getName(this.unit) + "' has " + size + " type parameters");
            }
            for (int j = 0; j < size && j < allowed; ++j) {
                TypeParameter paramParam = paramTypeParams.get(j);
                TypeParameter argParam = argTypeParams.get(j);
                if (paramParam.isCovariant() && !argParam.isCovariant()) {
                    argNode.addError("argument type constructor is not covariant: '" + argParam.getName() + "' of '" + argTypeDec.getName(this.unit) + "' must have the same variance as '" + paramParam.getName() + "' of '" + param.getName(this.unit) + "'");
                } else if (paramParam.isContravariant() && !argParam.isContravariant()) {
                    argNode.addError("argument type constructor is not contravariant: '" + argParam.getName() + "' of '" + argTypeDec.getName(this.unit) + "' must have the same variance as '" + paramParam.getName() + "' of '" + param.getName(this.unit) + "'");
                }
                if (!ModelUtil.intersectionOfSupertypes(paramParam).isSubtypeOf(ModelUtil.intersectionOfSupertypes(argParam))) {
                    argNode.addError("upper bound on type parameter of argument type constructor is not a supertype of upper bound on corresponding type parameter of parameter: '" + argParam.getName() + "' of '" + argTypeDec.getName(this.unit) + "' does accept all type arguments accepted by '" + paramParam.getName() + "' of '" + param.getName(this.unit) + "'");
                }
                if (ModelUtil.unionOfCaseTypes(paramParam).isSubtypeOf(ModelUtil.unionOfCaseTypes(argParam))) continue;
                argNode.addError("enumerated bound on type parameter of argument type constructor is not a supertype of enumerated bound on corresponding type parameter of parameter: '" + argParam.getName() + "' of '" + argTypeDec.getName(this.unit) + "' does accept all type arguments accepted by '" + paramParam.getName() + "' of '" + param.getName(this.unit) + "'");
            }
        }
    }

    private void visitExtendedOrAliasedType(Tree.SimpleType et, Tree.InvocationExpression ie) {
        Type type;
        if (et != null && ie != null && (type = et.getTypeModel()) != null) {
            Tree.Primary primary = ie.getPrimary();
            if (primary instanceof Tree.InvocationExpression) {
                Tree.InvocationExpression iie = (Tree.InvocationExpression)primary;
                primary = iie.getPrimary();
            }
            if (primary instanceof Tree.ExtendedTypeExpression) {
                Tree.ExtendedTypeExpression ete = (Tree.ExtendedTypeExpression)primary;
                ete.setDeclaration(et.getDeclarationModel());
                ete.setTarget(type);
                Type qt = type.getQualifyingType();
                Type ft = type.getFullType();
                if (ete.getStaticMethodReference()) {
                    ft = this.getStaticReferenceType(ft, qt);
                }
                primary.setTypeModel(ft);
            }
        }
    }

    @Override
    public void visit(Tree.ClassSpecifier that) {
        this.visitExtendedOrAliasedType(that.getType(), that.getInvocationExpression());
        this.inExtendsClause = true;
        super.visit(that);
        this.inExtendsClause = false;
    }

    @Override
    public void visit(Tree.Enumerated that) {
        Constructor e = that.getEnumerated();
        this.checkDelegatedConstructor(that.getDelegatedConstructor(), e, that);
        TypeDeclaration occ = this.enterConstructorDelegation(e);
        Tree.Type rt = this.beginReturnScope(ExpressionVisitor.fakeVoid(that));
        Declaration od = this.beginReturnDeclaration(e);
        super.visit(that);
        this.endReturnDeclaration(od);
        this.endReturnScope(rt, null);
        this.endConstructorDelegation(occ);
    }

    @Override
    public void visit(Tree.Constructor that) {
        Constructor c = that.getConstructor();
        this.checkDelegatedConstructor(that.getDelegatedConstructor(), c, that);
        TypeDeclaration occ = this.enterConstructorDelegation(c);
        Tree.Type rt = this.beginReturnScope(ExpressionVisitor.fakeVoid(that));
        Declaration od = this.beginReturnDeclaration(c);
        super.visit(that);
        this.endReturnDeclaration(od);
        this.endReturnScope(rt, null);
        this.endConstructorDelegation(occ);
    }

    private void endConstructorDelegation(TypeDeclaration occ) {
        this.constructorClass = occ;
    }

    private TypeDeclaration enterConstructorDelegation(Constructor c) {
        TypeDeclaration occ = this.constructorClass;
        Type et = c.getExtendedType();
        this.constructorClass = et == null ? null : et.getDeclaration();
        return occ;
    }

    protected void checkDelegatedConstructor(Tree.DelegatedConstructor dc, Constructor c, Node node) {
        TypeDeclaration superclass;
        Class clazz;
        Type et;
        if (dc == null && c.isClassMember() && (et = (clazz = (Class)c.getContainer()).getExtendedType()) != null && !et.isBasic() && (superclass = et.getDeclaration()) != null) {
            node.addError("constructor must explicitly delegate to some superclass constructor: '" + clazz.getName() + "' extends '" + superclass.getName() + "'");
        }
    }

    @Override
    public void visit(Tree.DelegatedConstructor that) {
        this.visitExtendedOrAliasedType(that.getType(), that.getInvocationExpression());
        this.inExtendsClause = true;
        super.visit(that);
        this.inExtendsClause = false;
    }

    @Override
    public void visit(Tree.ExtendedType that) {
        this.visitExtendedOrAliasedType(that.getType(), that.getInvocationExpression());
        this.inExtendsClause = true;
        super.visit(that);
        this.inExtendsClause = false;
    }

    @Override
    public void visit(Tree.Term that) {
        super.visit(that);
        if (that.getTypeModel() == null) {
            that.setTypeModel(this.defaultType());
        }
    }

    @Override
    public void visit(Tree.Type that) {
        super.visit(that);
        if (that.getTypeModel() == null) {
            that.setTypeModel(this.defaultType());
        }
    }

    @Override
    public void visit(Tree.TypeConstructor that) {
        super.visit(that);
        NativeUtil.checkNotJvm(that, "type functions are not supported on the JVM");
    }

    @Override
    public void visit(Tree.TypeConstraint that) {
        super.visit(that);
        Tree.TypeParameterList typeParams = that.getTypeParameterList();
        if (typeParams != null) {
            NativeUtil.checkNotJvm(typeParams, "type functions are not supported on the JVM");
        }
    }

    @Override
    public void visit(Tree.FunctionalParameterDeclaration that) {
        super.visit(that);
        Tree.MethodDeclaration md = (Tree.MethodDeclaration)that.getTypedDeclaration();
        Tree.TypeParameterList tpl = md.getTypeParameterList();
        if (tpl != null) {
            NativeUtil.checkNotJvm(tpl, "type functions are not supported on the JVM");
        }
    }

    private Type defaultType() {
        UnknownType ut = new UnknownType(this.unit);
        Class ad = this.unit.getAnythingDeclaration();
        if (ad != null) {
            ut.setExtendedType(ad.getType());
        }
        return ut.getType();
    }

    @Override
    public void visit(Tree.PackageLiteral that) {
        Package pack;
        super.visit(that);
        Tree.ImportPath path = that.getImportPath();
        if (path == null) {
            path = new Tree.ImportPath(null);
            that.setImportPath(path);
            pack = this.unit.getPackage();
        } else {
            pack = AnalyzerUtil.importedPackage(path);
        }
        path.setModel(pack);
        that.setTypeModel(this.unit.getPackageDeclarationType());
    }

    @Override
    public void visit(Tree.ModuleLiteral that) {
        Module m;
        super.visit(that);
        if (that.getImportPath() == null) {
            that.setImportPath(new Tree.ImportPath(null));
            m = this.unit.getPackage().getModule();
        } else {
            m = AnalyzerUtil.importedModule(that.getImportPath());
        }
        that.getImportPath().setModel(m);
        that.setTypeModel(this.unit.getModuleDeclarationType());
    }

    @Override
    public void visit(Tree.TypeArgumentList that) {
        if (this.declarationLiteral) {
            that.addError("declaration reference may not specify type arguments");
        }
        super.visit(that);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(Tree.TypeLiteral that) {
        Node errorNode;
        TypeDeclaration d;
        Type t;
        if (that instanceof Tree.InterfaceLiteral || that instanceof Tree.ClassLiteral || that instanceof Tree.NewLiteral || that instanceof Tree.AliasLiteral || that instanceof Tree.TypeParameterLiteral) {
            this.declarationLiteral = true;
        } else {
            this.modelLiteral = true;
        }
        try {
            super.visit(that);
        }
        finally {
            this.declarationLiteral = false;
            this.modelLiteral = false;
        }
        Tree.StaticType type = that.getType();
        if (type != null) {
            t = type.getTypeModel();
            d = t.getDeclaration();
            errorNode = type;
        } else {
            errorNode = that;
            ClassOrInterface classOrInterface = ModelUtil.getContainingClassOrInterface(that.getScope());
            if (that instanceof Tree.ClassLiteral || that instanceof Tree.InterfaceLiteral) {
                d = classOrInterface;
                if (d == null) {
                    errorNode.addError("no containing type");
                    return;
                }
                t = classOrInterface.getType();
            } else {
                errorNode.addError("missing type reference");
                return;
            }
        }
        if (t != null) {
            that.setDeclaration(d);
            that.setWantsDeclaration(true);
            if (that instanceof Tree.ClassLiteral) {
                if (!(d instanceof Class)) {
                    if (d != null) {
                        errorNode.addError("referenced declaration is not a class" + this.getDeclarationReferenceSuggestion(d));
                    }
                    that.setTypeModel(this.unit.getClassDeclarationType());
                } else {
                    that.setTypeModel(this.unit.getClassDeclarationType((Class)d));
                }
            } else if (that instanceof Tree.NewLiteral) {
                TypeDeclaration c;
                Constructor defaultConstructor;
                if (d instanceof Class && (defaultConstructor = ((Class)(c = (Class)d)).getDefaultConstructor()) != null) {
                    d = defaultConstructor;
                }
                if (d instanceof Constructor) {
                    c = (Constructor)d;
                    if (((Constructor)c).getParameterList() == null) {
                        that.setTypeModel(this.unit.getValueConstructorDeclarationType());
                    } else {
                        that.setTypeModel(this.unit.getCallableConstructorDeclarationType());
                    }
                } else if (d != null) {
                    errorNode.addError("referenced declaration is not a constructor" + this.getDeclarationReferenceSuggestion(d));
                }
            } else if (that instanceof Tree.InterfaceLiteral) {
                if (!(d instanceof Interface) && d != null) {
                    errorNode.addError("referenced declaration is not an interface" + this.getDeclarationReferenceSuggestion(d));
                }
                that.setTypeModel(this.unit.getInterfaceDeclarationType());
            } else if (that instanceof Tree.AliasLiteral) {
                if (!(d instanceof TypeAlias)) {
                    errorNode.addError("referenced declaration is not a type alias" + this.getDeclarationReferenceSuggestion(d));
                }
                that.setTypeModel(this.unit.getAliasDeclarationType());
            } else if (that instanceof Tree.TypeParameterLiteral) {
                if (!(d instanceof TypeParameter)) {
                    errorNode.addError("referenced declaration is not a type parameter" + this.getDeclarationReferenceSuggestion(d));
                }
                that.setTypeModel(this.unit.getTypeParameterDeclarationType());
            } else if (d != null) {
                that.setWantsDeclaration(false);
                t = t.resolveAliases();
                if (t == null || t.isUnknown()) {
                    return;
                }
                if (d instanceof Constructor) {
                    if (((Constructor)d).isAbstraction()) {
                        errorNode.addError("constructor is overloaded");
                    } else {
                        that.setTypeModel(this.unit.getConstructorMetatype(t));
                    }
                } else if (d instanceof Class) {
                    if (((Class)d).isAbstraction()) {
                        errorNode.addError("class constructor is overloaded");
                    } else {
                        that.setTypeModel(this.unit.getClassMetatype(t));
                    }
                } else if (d instanceof Interface) {
                    that.setTypeModel(this.unit.getInterfaceMetatype(t));
                } else {
                    that.setTypeModel(this.unit.getTypeMetaType(t));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(Tree.MemberLiteral that) {
        if (that instanceof Tree.FunctionLiteral || that instanceof Tree.ValueLiteral) {
            this.declarationLiteral = true;
        } else {
            this.modelLiteral = true;
        }
        try {
            super.visit(that);
        }
        finally {
            this.declarationLiteral = false;
            this.modelLiteral = false;
        }
        Tree.Identifier id = that.getIdentifier();
        if (id != null) {
            String name = TreeUtil.name(id);
            Tree.StaticType type = that.getType();
            if (type == null) {
                TypedDeclaration result = that.getPackageQualified() ? AnalyzerUtil.getPackageTypedDeclaration(name, null, false, this.unit) : AnalyzerUtil.getTypedDeclaration(that.getScope(), name, null, false, this.unit);
                if (result != null) {
                    this.checkBaseVisibility(that, result, name);
                    this.setMemberMetatype(that, result);
                } else {
                    that.addError("function or value does not exist: '" + TreeUtil.name(id) + "'", 100);
                    this.unit.getUnresolvedReferences().add(id);
                }
            } else {
                TypeDeclaration qtd = type.getTypeModel().getDeclaration();
                String container = "type '" + qtd.getName(this.unit) + "'";
                TypedDeclaration member = AnalyzerUtil.getTypedMember(qtd, name, null, false, this.unit);
                if (member == null) {
                    if (qtd.isMemberAmbiguous(name, this.unit, null, false)) {
                        that.addError("method or attribute is ambiguous: '" + name + "' for " + container);
                    } else {
                        that.addError("method or attribute does not exist: '" + name + "' in " + container);
                    }
                } else {
                    this.checkQualifiedVisibility(that, member, name, container, false);
                    this.setMemberMetatype(that, member);
                }
            }
        }
    }

    private void setMemberMetatype(Tree.MemberLiteral that, TypedDeclaration result) {
        that.setDeclaration(result);
        if (that instanceof Tree.ValueLiteral) {
            if (result instanceof Value) {
                this.checkNonlocal(that, result);
            } else {
                that.getIdentifier().addError("referenced declaration is not a value" + this.getDeclarationReferenceSuggestion(result));
            }
            if (that.getBroken()) {
                that.addError("keyword object may not appear here: use the value keyword to refer to anonymous class declarations");
            }
            that.setWantsDeclaration(true);
            that.setTypeModel(this.unit.getValueDeclarationType());
        } else if (that instanceof Tree.FunctionLiteral) {
            if (result instanceof Function) {
                this.checkNonlocal(that, result);
            } else {
                that.getIdentifier().addError("referenced declaration is not a function" + this.getDeclarationReferenceSuggestion(result));
            }
            that.setWantsDeclaration(true);
            that.setTypeModel(this.unit.getFunctionDeclarationType());
        } else {
            if (!ModelUtil.isConstructor(result)) {
                this.checkNonlocal(that, result);
            }
            this.setMetamodelType(that, result);
        }
    }

    private String getDeclarationReferenceSuggestion(Declaration result) {
        String name = ": " + result.getName(this.unit);
        if (result instanceof Function) {
            return name + " is a function";
        }
        if (result instanceof Value) {
            return name + " is a value";
        }
        if (result instanceof Constructor) {
            return name + " is a constructor";
        }
        if (result instanceof Class) {
            return name + " is a class";
        }
        if (result instanceof Interface) {
            return name + " is an interface";
        }
        if (result instanceof TypeAlias) {
            return name + " is a type alias";
        }
        if (result instanceof TypeParameter) {
            return name + " is a type parameter";
        }
        return "";
    }

    private void setMetamodelType(Tree.MemberLiteral that, Declaration result) {
        Tree.StaticType type;
        Type outerType = result.isClassOrInterfaceMember() ? ((type = that.getType()) == null ? that.getScope().getDeclaringType(result) : type.getTypeModel()) : null;
        boolean constructor = ModelUtil.isConstructor(result);
        if (result instanceof Function) {
            Function method = (Function)result;
            if (method.isAbstraction()) {
                that.addError("method is overloaded");
            } else {
                Tree.TypeArgumentList tal = that.getTypeArgumentList();
                if (this.explicitTypeArguments(method, tal)) {
                    List<Type> typeArgs = AnalyzerUtil.getTypeArguments(tal, outerType, ModelUtil.getTypeParameters(method));
                    if (tal != null) {
                        tal.setTypeModels(typeArgs);
                    }
                    if (this.acceptsTypeArguments(method, outerType, typeArgs, tal, that)) {
                        TypedReference pr = outerType == null ? method.appliedTypedReference(null, typeArgs) : outerType.getTypedMember(method, typeArgs);
                        that.setTarget(pr);
                        Type metatype = constructor ? this.unit.getConstructorMetatype(pr) : this.unit.getFunctionMetatype(pr);
                        that.setTypeModel(metatype);
                    }
                } else {
                    that.addError("missing type arguments to generic declaration: '" + method.getName(this.unit) + "'");
                }
            }
        } else if (result instanceof Value) {
            Value value = (Value)result;
            if (that.getTypeArgumentList() != null) {
                that.addError("does not accept type arguments: '" + result.getName(this.unit) + "' is a value");
            } else {
                TypedReference reference = value.appliedTypedReference(outerType, AnalyzerUtil.NO_TYPE_ARGS);
                that.setTarget(reference);
                Type metatype = constructor ? this.unit.getValueConstructorMetatype(reference) : this.unit.getValueMetatype(reference);
                that.setTypeModel(metatype);
            }
        }
    }

    private void checkNonlocal(Node that, Declaration declaration) {
        if (!(declaration.isClassOrInterfaceMember() && declaration.isShared() || declaration.isToplevel())) {
            that.addError("metamodel reference to local declaration");
        }
    }

    private Declaration handleAbstractionOrHeader(Declaration dec, Tree.MemberOrTypeExpression that, boolean error) {
        dec = this.handleNativeHeader(dec, that, error);
        dec = this.handleAbstraction(dec, that);
        return dec;
    }

    private Declaration handleNativeHeader(Declaration dec, Node that, boolean error) {
        Declaration impl2 = dec;
        Declaration hdr = null;
        Module ctxModule = that.getUnit().getPackage().getModule();
        Module decModule = dec.getUnit().getPackage().getModule();
        Backends decModuleBackends = this.getModuleBackends(decModule, that.getUnit());
        Backends inBackends = that.getScope().getScopedBackends();
        if (dec.isNative()) {
            Backends backends;
            Backends backends2 = backends = inBackends.none() ? this.unit.getSupportedBackends() : inBackends;
            if (dec.isNativeHeader()) {
                hdr = dec;
                impl2 = ModelUtil.getNativeDeclaration(hdr, backends);
            } else {
                Declaration tmp = ModelUtil.getNativeHeader(dec);
                if (tmp != dec && (hdr = tmp) != null && (backends.none() || !backends.supports(dec.getNativeBackends()))) {
                    impl2 = ModelUtil.getNativeDeclaration(hdr, backends);
                }
            }
        }
        if (error && impl2 != null && (dec.isToplevel() || dec.isMember()) && NativeUtil.declarationScope(that.getScope()) != null && (hdr == null || !ModelUtil.isImplemented(hdr)) && (ctxModule != decModule && !decModuleBackends.none() || ctxModule == decModule && dec.isNative() && hdr == null) && (inBackends.none() || impl2.isNative() && !ModelUtil.isForBackend(impl2.getNativeBackends(), inBackends) || !decModuleBackends.none() && !ModelUtil.isForBackend(decModuleBackends, inBackends))) {
            Declaration d = NativeUtil.declarationScope(that.getScope());
            if (!inBackends.none()) {
                that.addError("illlegal reference to native declaration '" + dec.getName(this.unit) + "': native declaration '" + d.getName(this.unit) + "' has a different backend");
            } else {
                that.addError("illlegal reference to native declaration '" + dec.getName(this.unit) + "': declaration '" + d.getName(this.unit) + "' is not native (mark it or the module native)");
            }
        }
        if (dec.isNative()) {
            return inBackends.none() || impl2 == null ? dec : impl2;
        }
        return dec;
    }

    private Backends getModuleBackends(Module decModule, Unit unit) {
        Backends bs = decModule.getNativeBackends();
        List<ModuleImport> imports = unit.getPackage().getModule().getImports();
        for (ModuleImport imp : imports) {
            if (!imp.getModule().equals(decModule)) continue;
            if (imp.getNativeBackends().none()) break;
            bs = bs.none() ? imp.getNativeBackends() : bs.supported(imp.getNativeBackends());
            break;
        }
        return bs;
    }

    private Declaration handleAbstraction(Declaration dec, Tree.MemberOrTypeExpression that) {
        List<Declaration> overloads;
        if (!dec.isNative() && !that.getStaticMethodReferencePrimary() && ModelUtil.isAbstraction(dec) && (overloads = dec.getOverloads()).size() == 1) {
            return overloads.get(0);
        }
        return dec;
    }

    private boolean isNativeForWrongBackend(Backends backends) {
        return !backends.none() && !backends.header() && !ModelUtil.isForBackend(backends, this.unit);
    }
}

