/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.typechecker.analyzer;

import com.redhat.ceylon.compiler.typechecker.analyzer.AnalyzerUtil;
import com.redhat.ceylon.compiler.typechecker.context.TypecheckerUnit;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.TreeUtil;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Import;
import com.redhat.ceylon.model.typechecker.model.ImportList;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ImportVisitor
extends Visitor {
    private TypecheckerUnit unit;

    public ImportVisitor() {
    }

    public ImportVisitor(TypecheckerUnit unit) {
        this.unit = unit;
    }

    @Override
    public void visit(Tree.CompilationUnit that) {
        this.unit = that.getUnit();
        super.visit(that);
        HashSet<String> set = new HashSet<String>();
        for (Tree.Import im : that.getImportList().getImports()) {
            String mp;
            Tree.ImportPath ip = im.getImportPath();
            if (ip == null || set.add(mp = TreeUtil.formatPath(ip.getIdentifiers()))) continue;
            ip.addError("duplicate import: '" + mp + "'");
        }
    }

    @Override
    public void visit(Tree.Import that) {
        Package importedPackage = AnalyzerUtil.importedPackage(that.getImportPath());
        if (importedPackage != null) {
            that.getImportPath().setModel(importedPackage);
            Tree.ImportMemberOrTypeList imtl = that.getImportMemberOrTypeList();
            if (imtl != null) {
                ImportList il = imtl.getImportList();
                il.setImportedScope(importedPackage);
                HashSet<String> names = new HashSet<String>();
                for (Tree.ImportMemberOrType member : imtl.getImportMemberOrTypes()) {
                    names.add(this.importMember(member, importedPackage, il));
                }
                if (imtl.getImportWildcard() != null) {
                    this.importAllMembers(importedPackage, names, il);
                } else if (imtl.getImportMemberOrTypes().isEmpty()) {
                    imtl.addError("empty import list", 1020);
                }
            }
        }
    }

    private void importAllMembers(Package importedPackage, Set<String> ignoredMembers, ImportList il) {
        for (Declaration dec : importedPackage.getMembers()) {
            if (!dec.isShared() || !ModelUtil.isResolvable(dec) || ignoredMembers.contains(dec.getName()) || this.isNonimportable(importedPackage, dec.getName())) continue;
            this.addWildcardImport(il, dec);
        }
    }

    private void importAllMembers(TypeDeclaration importedType, Set<String> ignoredMembers, ImportList til) {
        for (Declaration dec : importedType.getMembers()) {
            if (!dec.isShared() || !dec.isStaticallyImportable() && !ModelUtil.isConstructor(dec) || !ModelUtil.isResolvable(dec) || ignoredMembers.contains(dec.getName())) continue;
            this.addWildcardImport(til, dec, importedType);
        }
    }

    private void addWildcardImport(ImportList il, Declaration dec) {
        if (!this.hidesToplevel(dec)) {
            Import i = new Import();
            i.setAlias(dec.getName());
            i.setDeclaration(dec);
            i.setWildcardImport(true);
            this.addWildcardImport(il, dec, i);
        }
    }

    private void addWildcardImport(ImportList il, Declaration dec, TypeDeclaration td) {
        if (!this.hidesToplevel(dec)) {
            Import i = new Import();
            i.setAlias(dec.getName());
            i.setDeclaration(dec);
            i.setWildcardImport(true);
            i.setTypeDeclaration(td);
            this.addWildcardImport(il, dec, i);
        }
    }

    private void addWildcardImport(ImportList il, Declaration dec, Import i) {
        String alias;
        if (ModelUtil.notOverloaded(dec) && (alias = i.getAlias()) != null) {
            Import o = this.unit.getImport(dec.getName());
            if (o != null && o.isWildcardImport()) {
                if (o.getDeclaration().equals(dec) || dec.isNativeHeader()) {
                    this.unit.getImports().remove(o);
                    il.getImports().remove(o);
                } else if (!dec.isNative()) {
                    i.setAmbiguous(true);
                    o.setAmbiguous(true);
                }
            }
            this.unit.getImports().add(i);
            il.getImports().add(i);
        }
    }

    private boolean hidesToplevel(Declaration dec) {
        for (Declaration d : this.unit.getDeclarations()) {
            String n = d.getName();
            if (!d.isToplevel() || n == null || !dec.getName().equals(n)) continue;
            return true;
        }
        return false;
    }

    private boolean checkForHiddenToplevel(Tree.Identifier id, Import i, Tree.Alias alias) {
        for (Declaration d : this.unit.getDeclarations()) {
            String n = d.getName();
            Declaration idec = i.getDeclaration();
            if (!d.isToplevel() || n == null || !i.getAlias().equals(n) || idec.equals(d) || ImportVisitor.isLegalAliasFreeImport(d, idec)) continue;
            if (alias == null) {
                id.addError("toplevel declaration with this name declared in this unit: '" + n + "'");
            } else {
                alias.addError("toplevel declaration with this name declared in this unit: '" + n + "'");
            }
            return true;
        }
        return false;
    }

    private static boolean isLegalAliasFreeImport(Declaration dec, Declaration importedDec) {
        if (importedDec instanceof Value) {
            Value value = (Value)importedDec;
            TypeDeclaration td = value.getTypeDeclaration();
            return td.isObjectClass() && td.equals(dec);
        }
        return false;
    }

    private void importMembers(Tree.ImportMemberOrType member, Declaration d) {
        Tree.ImportMemberOrTypeList imtl = member.getImportMemberOrTypeList();
        if (imtl != null) {
            Value v;
            TypeDeclaration td;
            if (d instanceof Value && (td = (v = (Value)d).getTypeDeclaration()).isObjectClass()) {
                d = td;
            }
            if (d instanceof TypeDeclaration) {
                HashSet<String> names = new HashSet<String>();
                ImportList til = imtl.getImportList();
                TypeDeclaration td2 = (TypeDeclaration)d;
                til.setImportedScope(td2);
                List<Tree.ImportMemberOrType> imts = imtl.getImportMemberOrTypes();
                for (Tree.ImportMemberOrType imt : imts) {
                    names.add(this.importMember(imt, td2, til));
                }
                if (imtl.getImportWildcard() != null) {
                    this.importAllMembers(td2, names, til);
                } else if (imts.isEmpty()) {
                    imtl.addError("empty import list", 1020);
                }
            } else {
                imtl.addError("member alias list must follow a type");
            }
        }
    }

    private void checkAliasCase(Tree.Alias alias, Declaration d) {
        if (alias != null) {
            Tree.Identifier id = alias.getIdentifier();
            int tt = id.getToken().getType();
            if (d instanceof TypeDeclaration && tt != 125) {
                id.addError("imported type should have uppercase alias: '" + d.getName() + "'");
            } else if (d instanceof TypedDeclaration && tt != 69) {
                id.addError("imported member should have lowercase alias: '" + d.getName() + "'");
            }
        }
    }

    private String importMember(Tree.ImportMemberOrType member, Package importedPackage, ImportList il) {
        Tree.Identifier id = member.getIdentifier();
        if (id == null) {
            return null;
        }
        Import i = new Import();
        member.setImportModel(i);
        Tree.Alias alias = member.getAlias();
        String name = TreeUtil.name(id);
        if (alias == null) {
            i.setAlias(name);
        } else {
            i.setAlias(TreeUtil.name(alias.getIdentifier()));
        }
        if (this.isNonimportable(importedPackage, name)) {
            id.addError("root type may not be imported");
            return name;
        }
        Declaration d = importedPackage.getMember(name, null, false);
        if (d == null) {
            String correction = AnalyzerUtil.correct(importedPackage, this.unit, name);
            String message = correction == null ? "" : " (did you mean '" + correction + "'?)";
            id.addError("imported declaration not found: '" + name + "'" + message, 100);
            this.unit.getUnresolvedReferences().add(id);
        } else {
            if (!AnalyzerUtil.declaredInPackage(d, this.unit)) {
                if (!d.isShared()) {
                    id.addError("imported declaration is not shared: '" + name + "'", 400);
                } else if (d.isPackageVisibility()) {
                    id.addError("imported package private declaration is not visible: '" + name + "'");
                } else if (d.isProtectedVisibility()) {
                    id.addError("imported protected declaration is not visible: '" + name + "'");
                }
            }
            i.setDeclaration(d);
            member.setDeclarationModel(d);
            if (il.hasImport(d)) {
                id.addError("already imported: '" + name + "'");
            } else if (!this.checkForHiddenToplevel(id, i, alias)) {
                this.addImport(member, il, i);
            }
            this.checkAliasCase(alias, d);
        }
        if (d != null) {
            this.importMembers(member, d);
        }
        return name;
    }

    private String importMember(Tree.ImportMemberOrType member, TypeDeclaration td, ImportList il) {
        Tree.Identifier id = member.getIdentifier();
        if (id == null) {
            return null;
        }
        Import i = new Import();
        member.setImportModel(i);
        Tree.Alias alias = member.getAlias();
        String name = TreeUtil.name(id);
        if (alias == null) {
            i.setAlias(name);
        } else {
            i.setAlias(TreeUtil.name(alias.getIdentifier()));
        }
        Declaration m = td.getMember(name, null, false);
        if (m == null) {
            String correction = AnalyzerUtil.correct(td, null, this.unit, name);
            String message = correction == null ? "" : " (did you mean '" + correction + "'?)";
            id.addError("imported declaration not found: '" + name + "' of '" + td.getName() + "'" + message, 100);
            this.unit.getUnresolvedReferences().add(id);
        } else {
            List<Declaration> members = m.getContainer().getMembers();
            for (Declaration d : members) {
                String dn = d.getName();
                if (dn == null || !dn.equals(name) || d.sameKind(m) || d.isAnonymous()) continue;
                id.addError("ambiguous member declaration: '" + name + "' of '" + td.getName() + "'");
                return null;
            }
            if (!m.isShared()) {
                id.addError("imported declaration is not shared: '" + name + "' of '" + td.getName() + "'", 400);
            } else if (!AnalyzerUtil.declaredInPackage(m, this.unit)) {
                if (m.isPackageVisibility()) {
                    id.addError("imported package private declaration is not visible: '" + name + "' of '" + td.getName() + "'");
                } else if (m.isProtectedVisibility()) {
                    id.addError("imported protected declaration is not visible: '" + name + "' of '" + td.getName() + "'");
                }
            }
            i.setTypeDeclaration(td);
            if (!(m.isStaticallyImportable() || ModelUtil.isToplevelClassConstructor(td, m) || ModelUtil.isToplevelAnonymousClass(m.getContainer()) || alias != null)) {
                member.addError("does not specify an alias");
            }
            i.setDeclaration(m);
            member.setDeclarationModel(m);
            if (il.hasImport(m)) {
                id.addError("already imported: '" + name + "' of '" + td.getName() + "'");
            } else if (m.isStaticallyImportable() || ModelUtil.isToplevelClassConstructor(td, m) || ModelUtil.isToplevelAnonymousClass(m.getContainer())) {
                if (!this.checkForHiddenToplevel(id, i, alias)) {
                    this.addImport(member, il, i);
                }
            } else {
                this.addMemberImport(member, il, i);
            }
            this.checkAliasCase(alias, m);
        }
        if (m != null) {
            this.importMembers(member, m);
        }
        return name;
    }

    private void addImport(Tree.ImportMemberOrType member, ImportList il, Import i) {
        String alias = i.getAlias();
        if (alias != null) {
            Map<String, String> mods = this.unit.getModifiers();
            if (mods.containsKey(alias) && mods.get(alias).equals(alias)) {
                member.addError("import hides a language modifier: '" + alias + "'");
            } else {
                Import o = this.unit.getImport(alias);
                if (o == null) {
                    this.unit.getImports().add(i);
                    il.getImports().add(i);
                } else if (o.isWildcardImport()) {
                    this.unit.getImports().remove(o);
                    il.getImports().remove(o);
                    this.unit.getImports().add(i);
                    il.getImports().add(i);
                } else {
                    member.addError("duplicate import alias: '" + alias + "'");
                }
            }
        }
    }

    private void addMemberImport(Tree.ImportMemberOrType member, ImportList il, Import i) {
        String alias = i.getAlias();
        if (alias != null) {
            if (il.getImport(alias) == null) {
                this.unit.getImports().add(i);
                il.getImports().add(i);
            } else {
                member.addError("duplicate member import alias: '" + alias + "'");
            }
        }
    }

    private boolean isNonimportable(Package pkg, String name) {
        String pname = pkg.getQualifiedNameString();
        return pname.equals("java.lang") && ("Object".equals(name) || "Throwable".equals(name) || "Exception".equals(name)) || pname.equals("java.lang.annotation") && "Annotation".equals(name);
    }
}

