/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.typechecker.analyzer;

import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.model.Setter;
import com.redhat.ceylon.model.typechecker.model.Type;

public class MissingNativeVisitor
extends Visitor {
    private final Backend forBackend;

    public MissingNativeVisitor(Backend forBackend) {
        this.forBackend = forBackend;
    }

    @Override
    public void visit(Tree.MemberOrTypeExpression expr) {
        this.checkNativeReference(expr, expr.getDeclaration());
        super.visit(expr);
    }

    @Override
    public void visit(Tree.SimpleType expr) {
        Type model = expr.getTypeModel();
        if (model != null) {
            this.checkNativeReference(expr, model.getDeclaration());
        }
        super.visit(expr);
    }

    @Override
    public void visit(Tree.ClassOrInterface decl) {
        if (this.checkNativeDeclaration(decl)) {
            super.visit(decl);
        }
    }

    @Override
    public void visit(Tree.ObjectDefinition decl) {
        if (this.checkNativeDeclaration(decl)) {
            super.visit(decl);
        }
    }

    @Override
    public void visit(Tree.AttributeDeclaration decl) {
        if (this.checkNativeDeclaration(decl)) {
            super.visit(decl);
        }
    }

    @Override
    public void visit(Tree.AttributeGetterDefinition decl) {
        if (this.checkNativeDeclaration(decl)) {
            super.visit(decl);
        }
    }

    @Override
    public void visit(Tree.AttributeSetterDefinition decl) {
        Setter model = decl.getDeclarationModel();
        if (!model.isToplevel() || !model.isNative()) {
            return;
        }
        if (this.checkNativeExistence(decl, model.getGetter(), true)) {
            super.visit(decl);
        }
    }

    @Override
    public void visit(Tree.AnyMethod decl) {
        if (this.checkNativeDeclaration(decl)) {
            super.visit(decl);
        }
    }

    private void checkNativeReference(Node node, Declaration model) {
        this.checkNativeExistence(node, model, false);
    }

    private boolean checkNativeDeclaration(Tree.Declaration decl) {
        Declaration model = decl.getDeclarationModel();
        return this.checkNativeExistence(decl, model, true);
    }

    private boolean checkNativeExistence(Node node, Declaration model, boolean nodeIsDecl) {
        if (model == null) {
            return true;
        }
        if (!model.isToplevel() || !model.isNative()) {
            return true;
        }
        Package pkg = ModelUtil.getPackage(model);
        if (pkg == null) {
            return true;
        }
        if (nodeIsDecl && !model.isNativeHeader() && !ModelUtil.isForBackend(model.getNativeBackends(), this.forBackend)) {
            return false;
        }
        if (ModelUtil.isForBackend(model.getNativeBackends(), this.forBackend)) {
            return true;
        }
        Declaration hdr = model.isNativeHeader() ? model : ModelUtil.getNativeHeader(model);
        if (hdr != null) {
            if (ModelUtil.isImplemented(hdr)) {
                return true;
            }
            Declaration impl2 = ModelUtil.getNativeDeclaration(hdr, this.forBackend);
            if (impl2 != null) {
                return true;
            }
        } else {
            return true;
        }
        boolean ok = this.checkNative(node, model);
        if (!ok) {
            node.addError("no native implementation for backend: native '" + model.getName() + "' is not implemented for the '" + this.forBackend.nativeAnnotation + "' backend", this.forBackend);
        }
        return true;
    }

    protected boolean checkNative(Node node, Declaration model) {
        return false;
    }
}

