/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.typechecker.analyzer;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.cmr.api.VersionComparator;
import com.redhat.ceylon.common.Backends;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.compiler.typechecker.analyzer.ModuleHelper;
import com.redhat.ceylon.compiler.typechecker.analyzer.ModuleSourceMapper;
import com.redhat.ceylon.compiler.typechecker.analyzer.Warning;
import com.redhat.ceylon.compiler.typechecker.context.Context;
import com.redhat.ceylon.compiler.typechecker.context.PhasedUnit;
import com.redhat.ceylon.compiler.typechecker.context.PhasedUnits;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.TreeUtil;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.typechecker.context.TypeCache;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.ModuleImport;
import com.redhat.ceylon.model.typechecker.util.ModuleManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ModuleValidator {
    private final Context context;
    private List<PhasedUnits> phasedUnitsOfDependencies;
    private final ModuleManager moduleManager;
    private final ModuleSourceMapper moduleManagerUtil;
    private Map<Module, ArtifactResult> searchedArtifacts = new HashMap<Module, ArtifactResult>();
    private ProgressListener listener = new ProgressListener(){

        @Override
        public void resolvingModuleArtifact(Module module, ArtifactResult artifactResult) {
        }

        @Override
        public void retrievingModuleArtifact(Module module, ArtifactContext artifactContext) {
        }

        @Override
        public void retrievingModuleArtifactFailed(Module module, ArtifactContext artifactContext) {
        }

        @Override
        public void retrievingModuleArtifactSuccess(Module module, ArtifactResult artifact) {
        }
    };

    public ModuleValidator(Context context, PhasedUnits phasedUnits) {
        this.context = context;
        this.moduleManager = phasedUnits.getModuleManager();
        this.moduleManagerUtil = phasedUnits.getModuleSourceMapper();
    }

    public void setListener(ProgressListener listener) {
        this.listener = listener;
    }

    public List<PhasedUnits> getPhasedUnitsOfDependencies() {
        return this.phasedUnitsOfDependencies;
    }

    public void verifyModuleDependencyTree() {
        TypeCache.doWithoutCaching(new Runnable(){

            @Override
            public void run() {
                ModuleValidator.this.phasedUnitsOfDependencies = new ArrayList();
                LinkedList<Module> dependencyTree = new LinkedList<Module>();
                Set<Module> compiledModules = ModuleValidator.this.moduleManagerUtil.getCompiledModules();
                ArrayList<Module> modules = new ArrayList<Module>(compiledModules.size() + 2);
                modules.add(ModuleValidator.this.context.getModules().getLanguageModule());
                modules.add(ModuleValidator.this.context.getModules().getDefaultModule());
                modules.addAll(compiledModules);
                for (Module module : modules) {
                    dependencyTree.addLast(module);
                    ModuleValidator.this.verifyModuleDependencyTree(module.getImports(), dependencyTree, new ArrayList(), ImportDepth.First, ModuleValidator.this.searchedArtifacts);
                    dependencyTree.pollLast();
                }
                for (Module module : compiledModules) {
                    ModuleValidator.this.verifyNative(module);
                }
                ModuleValidator.this.moduleManager.addImplicitImports();
            }
        });
        this.executeExternalModulePhases();
    }

    public final long numberOfModulesNotAlreadySearched() {
        long result = 0L;
        for (Module m : this.context.getModules().getListOfModules()) {
            if (m.isAvailable() || this.searchedArtifacts.containsKey(m)) continue;
            ++result;
        }
        return result;
    }

    public final long numberOfModulesAlreadySearched() {
        return this.searchedArtifacts.size();
    }

    private void verifyModuleDependencyTree(Collection<ModuleImport> moduleImports, LinkedList<Module> dependencyTree, List<Module> propagatedDependencies, ImportDepth importDepth, Map<Module, ArtifactResult> alreadySearchedArtifacts) {
        ArrayList<Module> visibleDependencies = new ArrayList<Module>();
        visibleDependencies.add(dependencyTree.getLast());
        for (ModuleImport moduleImport : moduleImports) {
            if (moduleImport.isNative() && !ModelUtil.isForBackend(moduleImport.getNativeBackends(), this.moduleManager)) continue;
            Module module = moduleImport.getModule();
            if (this.moduleManager.findModule(module, dependencyTree, true) != null) {
                return;
            }
            Iterable<String> searchedArtifactExtensions = this.moduleManager.getSearchedArtifactExtensions();
            ImportDepth newImportDepth = importDepth.forModuleImport(moduleImport);
            boolean forCompiledModule = newImportDepth.isVisibleToCompiledModules();
            if (!module.isAvailable()) {
                boolean firstTime;
                ArtifactResult artifact = null;
                if (alreadySearchedArtifacts.containsKey(module)) {
                    artifact = alreadySearchedArtifacts.get(module);
                    firstTime = false;
                } else {
                    RepositoryManager repositoryManager = this.context.getRepositoryManager();
                    Exception exceptionOnGetArtifact = null;
                    ArtifactContext artifactContext = new ArtifactContext(module.getNameAsString(), module.getVersion(), this.getArtifactSuffixes(searchedArtifactExtensions));
                    this.listener.retrievingModuleArtifact(module, artifactContext);
                    try {
                        artifact = repositoryManager.getArtifactResult(artifactContext);
                    }
                    catch (Exception e) {
                        exceptionOnGetArtifact = this.catchIfPossible(e);
                    }
                    if (artifact == null) {
                        ModuleHelper.buildErrorOnMissingArtifact(artifactContext, module, moduleImport, dependencyTree, exceptionOnGetArtifact, this.moduleManagerUtil);
                        this.listener.retrievingModuleArtifactFailed(module, artifactContext);
                    } else {
                        this.listener.retrievingModuleArtifactSuccess(module, artifact);
                    }
                    alreadySearchedArtifacts.put(module, artifact);
                    firstTime = true;
                }
                if (artifact != null && (firstTime || forCompiledModule)) {
                    this.listener.resolvingModuleArtifact(module, artifact);
                    Module moduleOverride = this.moduleManager.overridesModule(artifact, module, moduleImport);
                    if (moduleOverride != null) {
                        module = moduleOverride;
                        if (importDepth.equals((Object)ImportDepth.First)) {
                            this.moduleManagerUtil.attachErrorToDependencyDeclaration(moduleImport, dependencyTree, "the module import should not be overridden, since it is explicitly imported by a project source module");
                        }
                    }
                    this.moduleManagerUtil.resolveModule(artifact, module, moduleImport, dependencyTree, this.phasedUnitsOfDependencies, forCompiledModule);
                }
            }
            this.moduleManager.visitedModule(module, forCompiledModule);
            dependencyTree.addLast(module);
            ArrayList<Module> subModulePropagatedDependencies = new ArrayList<Module>();
            this.verifyModuleDependencyTree(module.getImports(), dependencyTree, subModulePropagatedDependencies, newImportDepth, alreadySearchedArtifacts);
            this.checkAndAddDependency(visibleDependencies, module, dependencyTree);
            for (Module submodule : subModulePropagatedDependencies) {
                this.checkAndAddDependency(visibleDependencies, submodule, dependencyTree);
            }
            if (moduleImport.isExport()) {
                this.checkAndAddDependency(propagatedDependencies, module, dependencyTree);
                for (Module submodule : subModulePropagatedDependencies) {
                    this.checkAndAddDependency(propagatedDependencies, submodule, dependencyTree);
                }
            }
            dependencyTree.pollLast();
        }
    }

    protected Exception catchIfPossible(Exception e) {
        return e;
    }

    private String[] getArtifactSuffixes(Iterable<String> extensions) {
        ArrayList<String> suffixes = new ArrayList<String>();
        for (String ext : extensions) {
            suffixes.add("." + ext);
        }
        return suffixes.toArray(new String[suffixes.size()]);
    }

    private void checkAndAddDependency(List<Module> dependencies, Module module, LinkedList<Module> dependencyTree) {
        boolean isDupe;
        Module dupe = this.moduleManager.findModule(module, dependencies, false);
        boolean bl = isDupe = dupe != null;
        if (dupe == null) {
            dupe = this.moduleManager.findSimilarModule(module, dependencies);
        }
        if (dupe != null && !this.isSameVersion(module, dupe)) {
            if (isDupe) {
                StringBuilder error = new StringBuilder("module (transitively) imports conflicting versions of dependency '");
                error.append(module.getNameAsString()).append("': ");
                String[] versions = VersionComparator.orderVersions(module.getVersion(), dupe.getVersion());
                error.append("version '").append(versions[0]).append("' and version '").append(versions[1]).append("'");
                this.moduleManagerUtil.addErrorToModule(dependencyTree.getFirst(), error.toString());
            } else {
                String moduleB;
                String moduleA;
                String moduleName = module.getNameAsString();
                String duplicateModuleName = dupe.getNameAsString();
                if (duplicateModuleName.compareTo(moduleName) < 0) {
                    moduleA = ModuleUtil.makeModuleName(duplicateModuleName, dupe.getVersion());
                    moduleB = ModuleUtil.makeModuleName(moduleName, module.getVersion());
                } else {
                    moduleA = ModuleUtil.makeModuleName(moduleName, module.getVersion());
                    moduleB = ModuleUtil.makeModuleName(duplicateModuleName, dupe.getVersion());
                }
                String error = "module (transitively) imports conflicting versions of similar dependencies '" + moduleA + "' and '" + moduleB + "'";
                this.moduleManagerUtil.addWarningToModule(dependencyTree.getFirst(), Warning.similarModule, error);
            }
        } else {
            dependencies.add(module);
        }
    }

    private boolean isSameVersion(Module module, Module dupe) {
        if (module == null || dupe == null) {
            return false;
        }
        if (dupe.getVersion() == null) {
            System.err.println("TypeChecker assertion failure: version should not be null in ModuleValidator.isSameVersion. Please report the issue with a test case");
            return false;
        }
        return dupe.getVersion().equals(module.getVersion());
    }

    private void verifyNative(Module module) {
        for (Tree.ImportModule imp : this.moduleManagerUtil.retrieveModuleImportNodes(module)) {
            Module importedModule;
            Node node;
            if (imp.getImportPath() != null) {
                node = imp.getImportPath();
                importedModule = (Module)imp.getImportPath().getModel();
            } else {
                node = imp.getQuotedLiteral();
                importedModule = this.moduleManagerUtil.getModuleForNode(node);
                if (importedModule == null) continue;
            }
            Backends bs = TreeUtil.getNativeBackend(imp.getAnnotationList(), imp.getUnit());
            if (bs.none()) {
                if (!importedModule.isNative() || module.isNative()) continue;
                node.addError(new ModuleSourceMapper.ModuleDependencyAnalysisError(node, "native import for cross-platform module (mark either the module or the import as native)", 20000));
                continue;
            }
            if (!importedModule.isNative() || bs.supports(importedModule.getNativeBackends())) continue;
            node.addError(new ModuleSourceMapper.ModuleDependencyAnalysisError(node, "native backend name conflicts with imported module: '\"" + bs + "\"' is not '\"" + importedModule.getNativeBackends().names() + "\"'"));
        }
    }

    protected void executeExternalModulePhases() {
        for (PhasedUnits units : this.phasedUnitsOfDependencies) {
            for (PhasedUnit pu : units.getPhasedUnits()) {
                pu.scanDeclarations();
            }
        }
        for (PhasedUnits units : this.phasedUnitsOfDependencies) {
            for (PhasedUnit pu : units.getPhasedUnits()) {
                pu.scanTypeDeclarations();
            }
        }
        for (PhasedUnits units : this.phasedUnitsOfDependencies) {
            for (PhasedUnit pu : units.getPhasedUnits()) {
                pu.validateRefinement();
            }
        }
    }

    private static enum ImportDepth {
        First{

            @Override
            public ImportDepth forModuleImport(ModuleImport moduleImport) {
                return Required;
            }

            @Override
            public boolean isVisibleToCompiledModules() {
                return true;
            }
        }
        ,
        Required{

            @Override
            public ImportDepth forModuleImport(ModuleImport moduleImport) {
                return moduleImport.isExport() ? Required : Transitive;
            }

            @Override
            public boolean isVisibleToCompiledModules() {
                return true;
            }
        }
        ,
        Transitive{

            @Override
            public ImportDepth forModuleImport(ModuleImport moduleImport) {
                return Transitive;
            }

            @Override
            public boolean isVisibleToCompiledModules() {
                return false;
            }
        };


        public abstract ImportDepth forModuleImport(ModuleImport var1);

        public abstract boolean isVisibleToCompiledModules();
    }

    public static interface ProgressListener {
        public void retrievingModuleArtifact(Module var1, ArtifactContext var2);

        public void retrievingModuleArtifactFailed(Module var1, ArtifactContext var2);

        public void retrievingModuleArtifactSuccess(Module var1, ArtifactResult var2);

        public void resolvingModuleArtifact(Module var1, ArtifactResult var2);
    }
}

