/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.typechecker.analyzer;

import com.redhat.ceylon.compiler.typechecker.analyzer.AnalyzerUtil;
import com.redhat.ceylon.compiler.typechecker.analyzer.DeclarationVisitor;
import com.redhat.ceylon.compiler.typechecker.analyzer.ExpressionVisitor;
import com.redhat.ceylon.compiler.typechecker.context.TypecheckerUnit;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.TreeUtil;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.model.typechecker.model.Annotation;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.Functional;
import com.redhat.ceylon.model.typechecker.model.Generic;
import com.redhat.ceylon.model.typechecker.model.Interface;
import com.redhat.ceylon.model.typechecker.model.LazyType;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.ParameterList;
import com.redhat.ceylon.model.typechecker.model.Reference;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Setter;
import com.redhat.ceylon.model.typechecker.model.SiteVariance;
import com.redhat.ceylon.model.typechecker.model.Specification;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.Unit;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RefinementVisitor
extends Visitor {
    private static final Comparator<Declaration> declarationCmp = new Comparator<Declaration>(){

        @Override
        public int compare(Declaration o1, Declaration o2) {
            if (o1.getName() == null && o2.getName() == null) {
                return 0;
            }
            if (o1.getName() == null) {
                return -1;
            }
            if (o2.getName() == null) {
                return 1;
            }
            return o1.getName().compareTo(o2.getName());
        }
    };

    @Override
    public void visit(Tree.AnyMethod that) {
        super.visit(that);
        this.inheritDefaultedArguments(that.getDeclarationModel());
    }

    @Override
    public void visit(Tree.AnyClass that) {
        super.visit(that);
        this.inheritDefaultedArguments(that.getDeclarationModel());
    }

    private void inheritDefaultedArguments(Declaration d) {
        Declaration rd = d.getRefinedDeclaration();
        if (rd != d && rd instanceof Functional && d instanceof Functional) {
            List<ParameterList> tdpls = ((Functional)((Object)d)).getParameterLists();
            List<ParameterList> rdpls = ((Functional)((Object)rd)).getParameterLists();
            if (!tdpls.isEmpty() && !rdpls.isEmpty()) {
                List<Parameter> tdps = tdpls.get(0).getParameters();
                List<Parameter> rdps = rdpls.get(0).getParameters();
                for (int i = 0; i < tdps.size() && i < rdps.size(); ++i) {
                    Parameter tdp = tdps.get(i);
                    Parameter rdp = rdps.get(i);
                    if (tdp == null || rdp == null) continue;
                    tdp.setDefaulted(rdp.isDefaulted());
                }
            }
        }
    }

    @Override
    public void visit(Tree.Declaration that) {
        super.visit(that);
        Declaration dec = that.getDeclarationModel();
        if (dec != null) {
            boolean member;
            boolean mayBeRefined;
            boolean mayBeShared;
            boolean bl = mayBeShared = dec.isToplevel() || dec.isClassOrInterfaceMember();
            if (dec.isShared() && !mayBeShared) {
                that.addError("shared declaration is not a member of a class, interface, or package: " + AnalyzerUtil.message(dec), 1200);
            }
            boolean bl2 = mayBeRefined = dec instanceof Value || dec instanceof Function || dec instanceof Class;
            if (!mayBeRefined) {
                this.checkNonrefinableDeclaration(that, dec);
            }
            boolean bl3 = member = dec.isClassOrInterfaceMember() && dec.isShared() && !ModelUtil.isConstructor(dec) && !(dec instanceof TypeParameter);
            if (member) {
                this.checkMember(that, dec);
            } else {
                this.checkNonMember(that, dec);
                if (ModelUtil.isOverloadedVersion(dec)) {
                    that.addError("name is not unique in scope: '" + dec.getName() + "'");
                }
            }
            if (dec.isNativeImplementation() || RefinementVisitor.isNativeMember(dec)) {
                this.checkNative(that, dec);
            }
        }
    }

    private static boolean isNativeMember(Declaration dec) {
        if (dec.isMember()) {
            Declaration container = (Declaration)((Object)dec.getContainer());
            return container.isNativeImplementation();
        }
        return false;
    }

    private void checkNative(Tree.Declaration that, Declaration dec) {
        List<Declaration> decls;
        if (dec instanceof Setter) {
            return;
        }
        Declaration header = ModelUtil.getNativeHeader(dec);
        if (header == null && (decls = this.getNativeMembers(dec.getContainer(), dec.getName())).size() > 1) {
            for (Declaration d : decls) {
                if (d == dec || d.getNativeBackends().supports(dec.getNativeBackends())) continue;
                header = dec;
                break;
            }
        }
        if (dec != header) {
            this.checkNativeDeclaration(that, dec, header);
        }
    }

    private List<Declaration> getNativeMembers(Scope container, String name) {
        ArrayList<Declaration> lst = new ArrayList<Declaration>();
        ArrayList<Scope> containers = new ArrayList<Scope>();
        if (container instanceof Declaration) {
            Declaration cd = (Declaration)((Object)container);
            if (cd.isNativeImplementation()) {
                Declaration header = ModelUtil.getNativeHeader(cd);
                if (header == null) {
                    List<Declaration> cs = this.getNativeMembers(cd.getContainer(), cd.getName());
                    for (Declaration c : cs) {
                        Value v;
                        if (c instanceof Value && ModelUtil.isObject(v = (Value)c)) {
                            c = v.getType().getDeclaration();
                        }
                        containers.add((Scope)((Object)c));
                    }
                }
            } else {
                containers.add(container);
            }
        } else {
            containers.add(container);
        }
        for (Scope s : containers) {
            for (Declaration dec : s.getMembers()) {
                if (!ModelUtil.isResolvable(dec) || !ModelUtil.isNamed(name, dec) || !dec.isNative()) continue;
                lst.add(dec);
            }
        }
        return lst;
    }

    private void checkNativeDeclaration(Tree.Declaration that, Declaration dec, Declaration header) {
        if (header == null && dec.isMember()) {
            if (((Declaration)((Object)dec.getContainer())).isNative() && dec.isNative() && dec.isShared() && !dec.isFormal() && !dec.isActual() && !dec.isDefault()) {
                that.addError("native member does not implement any header member: " + AnalyzerUtil.message(dec));
            }
            if (!dec.isNative() && dec.isShared()) {
                that.addError("non-native shared members not allowed in native implementations: " + AnalyzerUtil.message(dec));
            }
            return;
        }
        if (header != null && dec.isMember() && !dec.isParameter() && !dec.isNative()) {
            that.addError("member implementing a native header member must be marked native: " + AnalyzerUtil.message(dec));
            return;
        }
        if (dec instanceof Function && (header == null || header instanceof Function)) {
            this.checkNativeMethod(that, (Function)dec, (Function)header);
        } else if (dec instanceof Value && (header == null || header instanceof Value)) {
            this.checkNativeValue(that, (Value)dec, (Value)header);
        } else if (dec instanceof Class && (header == null || header instanceof Class)) {
            this.checkNativeClass(that, (Class)dec, (Class)header);
        } else if (dec instanceof Interface && (header == null || header instanceof Interface)) {
            this.checkNativeInterface(that, (Interface)dec, (Interface)header);
        } else if (header != null) {
            that.addError("native declarations not of same type: " + AnalyzerUtil.message(dec));
        }
    }

    private void checkNativeClass(Tree.Declaration that, Class dec, Class header) {
        if (header == null) {
            return;
        }
        if (dec.isAlias() || header.isAlias()) {
            return;
        }
        if (dec.isShared() && !header.isShared()) {
            that.addError("native header is not shared: " + AnalyzerUtil.message(dec));
        }
        if (!dec.isShared() && header.isShared()) {
            that.addError("native header is shared: " + AnalyzerUtil.message(dec));
        }
        if (dec.isAbstract() && !header.isAbstract()) {
            that.addError("native header is not abstract: " + AnalyzerUtil.message(dec));
        }
        if (!dec.isAbstract() && header.isAbstract()) {
            that.addError("native header is abstract: " + AnalyzerUtil.message(dec));
        }
        if (dec.isFinal() && !header.isFinal()) {
            that.addError("native header is not final: " + AnalyzerUtil.message(dec));
        }
        if (!dec.isFinal() && header.isFinal()) {
            that.addError("native header is final: " + AnalyzerUtil.message(dec));
        }
        if (dec.isSealed() && !header.isSealed()) {
            that.addError("native header is not sealed: " + AnalyzerUtil.message(dec));
        }
        if (!dec.isSealed() && header.isSealed()) {
            that.addError("native header is sealed: " + AnalyzerUtil.message(dec));
        }
        if (dec.isAnnotation() && !header.isAnnotation()) {
            that.addError("native header is not an annotation type: " + AnalyzerUtil.message(dec));
        }
        if (!dec.isAnnotation() && header.isAnnotation()) {
            that.addError("native header is an annotation type: " + AnalyzerUtil.message(dec));
        }
        Type dext = dec.getExtendedType();
        Type aext = header.getExtendedType();
        if (dext != null && aext == null || dext == null && aext != null || !dext.isExactly(aext)) {
            that.addError("native classes do not extend the same type: " + AnalyzerUtil.message(dec));
        }
        List<Type> dst = dec.getSatisfiedTypes();
        List<Type> ast = header.getSatisfiedTypes();
        if (dst.size() != ast.size() || !dst.containsAll(ast)) {
            that.addError("native classes do not satisfy the same interfaces: " + AnalyzerUtil.message(dec));
        }
        this.checkNativeClassParameters(that, dec, header, dec.getReference(), header.getReference());
        this.checkNativeTypeParameters(that, dec, header, dec.getTypeParameters(), header.getTypeParameters());
        this.checkMissingMemberImpl(that, dec, header);
    }

    private void checkMissingMemberImpl(Tree.Declaration that, Class dec, Class header) {
        List<Declaration> hdrMembers = this.getNativeClassMembers(header);
        List<Declaration> implMembers = this.getNativeClassMembers(dec);
        Iterator<Declaration> hdrIter = hdrMembers.iterator();
        Iterator<Declaration> implIter = implMembers.iterator();
        boolean hdrNext = true;
        boolean implNext = true;
        Declaration hdr = null;
        Declaration impl2 = null;
        while (!(!hdrIter.hasNext() && hdrNext || !implIter.hasNext() && implNext)) {
            int cmp;
            if (hdrNext) {
                hdr = hdrIter.next();
            }
            if (implNext) {
                impl2 = implIter.next();
            }
            if ((cmp = declarationCmp.compare(hdr, impl2)) < 0) {
                if (!ModelUtil.isImplemented(hdr)) {
                    that.addError("native header '" + hdr.getName() + "' of '" + RefinementVisitor.containerName(hdr) + "' has no native implementation");
                }
                hdrNext = true;
                implNext = false;
                continue;
            }
            if (cmp > 0) {
                hdrNext = false;
                implNext = true;
                continue;
            }
            hdrNext = true;
            implNext = true;
        }
        while (hdrIter.hasNext()) {
            hdr = hdrIter.next();
            if (ModelUtil.isImplemented(hdr)) continue;
            that.addError("native header '" + hdr.getName() + "' of '" + RefinementVisitor.containerName(hdr) + "' has no native implementation");
        }
    }

    private List<Declaration> getNativeClassMembers(Class dec) {
        List<Declaration> members = dec.getMembers();
        ArrayList<Declaration> nats = new ArrayList<Declaration>(members.size());
        for (Declaration m : members) {
            if (!m.isNative() || m.isFormal() || m.isActual() || m.isDefault()) continue;
            nats.add(m);
        }
        Collections.sort(nats, declarationCmp);
        return nats;
    }

    private void checkNativeInterface(Tree.Declaration that, Interface dec, Interface header) {
        if (header == null) {
            return;
        }
        if (dec.isAlias() || header.isAlias()) {
            return;
        }
        if (dec.isShared() && !header.isShared()) {
            that.addError("native header is not shared: " + AnalyzerUtil.message(dec));
        }
        if (!dec.isShared() && header.isShared()) {
            that.addError("native header is shared: " + AnalyzerUtil.message(dec));
        }
        if (dec.isFinal() && !header.isFinal()) {
            that.addError("native header is not final: " + AnalyzerUtil.message(dec));
        }
        if (!dec.isFinal() && header.isFinal()) {
            that.addError("native header is final: " + AnalyzerUtil.message(dec));
        }
        if (dec.isSealed() && !header.isSealed()) {
            that.addError("native header is not sealed: " + AnalyzerUtil.message(dec));
        }
        if (!dec.isSealed() && header.isSealed()) {
            that.addError("native header is sealed: " + AnalyzerUtil.message(dec));
        }
        if (dec.isAnnotation() && !header.isAnnotation()) {
            that.addError("native header is not an annotation type: " + AnalyzerUtil.message(dec));
        }
        if (!dec.isAnnotation() && header.isAnnotation()) {
            that.addError("native header is an annotation type: " + AnalyzerUtil.message(dec));
        }
        Type dext = dec.getExtendedType();
        Type aext = header.getExtendedType();
        if (dext != null && aext == null || dext == null && aext != null || !dext.isExactly(aext)) {
            that.addError("native classes do not extend the same type: " + AnalyzerUtil.message(dec));
        }
        List<Type> dst = dec.getSatisfiedTypes();
        List<Type> ast = header.getSatisfiedTypes();
        if (dst.size() != ast.size() || !dst.containsAll(ast)) {
            that.addError("native classes do not satisfy the same interfaces: " + AnalyzerUtil.message(dec));
        }
        this.checkNativeTypeParameters(that, dec, header, dec.getTypeParameters(), header.getTypeParameters());
    }

    private void checkNativeMethod(Tree.Declaration that, Function dec, Function header) {
        if (header == null) {
            return;
        }
        Type at = header.getType();
        Type dt = dec.getType();
        if (dt != null && !dt.isExactly(at)) {
            that.addError("native implementation must have the same return type as native header: " + AnalyzerUtil.message(dec) + " must have the type '" + at.asString(that.getUnit()) + "'");
        }
        if (dec.isShared() && !header.isShared()) {
            that.addError("native header is not shared: " + AnalyzerUtil.message(dec));
        }
        if (!dec.isShared() && header.isShared()) {
            that.addError("native header is shared: " + AnalyzerUtil.message(dec));
        }
        if (dec.isAnnotation() && !header.isAnnotation()) {
            that.addError("native header is not an annotation constructor: " + AnalyzerUtil.message(dec));
        }
        if (!dec.isAnnotation() && header.isAnnotation()) {
            that.addError("native header is an annotation constructor: " + AnalyzerUtil.message(dec));
        }
        this.checkRefiningMemberParameters(that, dec, header, dec.getReference(), header.getReference(), true);
        this.checkNativeTypeParameters(that, dec, header, dec.getTypeParameters(), header.getTypeParameters());
    }

    private void checkNativeValue(Tree.Declaration that, Value dec, Value header) {
        if (header == null) {
            return;
        }
        Type at = header.getType();
        Type dt = dec.getType();
        if (dt != null && !dt.isExactly(at) && !this.sameObjects(dec, header)) {
            that.addError("native implementation must have the same type as native header: " + AnalyzerUtil.message(dec) + " must have the type '" + at.asString(that.getUnit()) + "'");
        }
        if (dec.isShared() && !header.isShared()) {
            that.addError("native header is not shared: " + AnalyzerUtil.message(dec));
        }
        if (!dec.isShared() && header.isShared()) {
            that.addError("native header is shared: " + AnalyzerUtil.message(dec));
        }
        if (dec.isVariable() && !header.isVariable()) {
            that.addError("native header is not variable: " + AnalyzerUtil.message(dec));
        }
        if (!dec.isVariable() && header.isVariable()) {
            that.addError("native header is variable: " + AnalyzerUtil.message(dec));
        }
    }

    private boolean sameObjects(Value dec, Value header) {
        return ModelUtil.isObject(dec) && ModelUtil.isObject(header) && dec.getQualifiedNameString().equals(header.getQualifiedNameString());
    }

    private void checkNativeClassParameters(Tree.Declaration that, Class dec, Class header, Reference decRef, Reference hdrRef) {
        boolean checkok;
        boolean bl = checkok = (header.hasConstructors() || header.hasEnumerated()) && !dec.hasConstructors() && !dec.hasEnumerated() && dec.getParameterLists().isEmpty();
        if (!checkok) {
            if (dec.hasConstructors() != header.hasConstructors() || dec.hasEnumerated() != header.hasEnumerated()) {
                that.addError("native classes must all have parameters or all have constructors: " + AnalyzerUtil.message(dec));
            } else if (!dec.hasConstructors() && !dec.hasEnumerated()) {
                List<ParameterList> refiningParamLists = dec.getParameterLists();
                List<ParameterList> refinedParamLists = header.getParameterLists();
                if (refinedParamLists.size() != refiningParamLists.size()) {
                    that.addError("native classes must have the same number of parameter lists: " + AnalyzerUtil.message(dec));
                }
                for (int i = 0; i < refinedParamLists.size() && i < refiningParamLists.size(); ++i) {
                    this.checkParameterTypes(that, RefinementVisitor.getParameterList(that, i), hdrRef, decRef, refiningParamLists.get(i), refinedParamLists.get(i), true);
                }
            }
        }
    }

    private void checkNativeTypeParameters(Tree.Declaration that, Declaration impl2, Declaration header, List<TypeParameter> implTypeParams, List<TypeParameter> headerTypeParams) {
        int implSize;
        int headerSize = headerTypeParams.size();
        if (headerSize != (implSize = implTypeParams.size())) {
            that.addError("native header does not have the same number of type parameters as native implementation: " + AnalyzerUtil.message(impl2));
        } else {
            for (int i = 0; i < headerSize; ++i) {
                Type implIntersect;
                Type headerIntersect;
                TypeParameter headerTP = headerTypeParams.get(i);
                TypeParameter implTP = implTypeParams.get(i);
                if (!headerTP.getName().equals(implTP.getName())) {
                    that.addError("type parameter does not have the same name as its header: '" + implTP.getName() + "' is not '" + headerTP.getName() + "' for " + AnalyzerUtil.message(impl2));
                }
                if ((headerIntersect = ModelUtil.intersectionOfSupertypes(headerTP)).isExactly(implIntersect = ModelUtil.intersectionOfSupertypes(implTP))) continue;
                that.addError("type parameter does not have the same bounds as its header: '" + implTP.getName() + "' for " + AnalyzerUtil.message(impl2));
            }
        }
    }

    private void checkMember(Tree.Declaration that, Declaration member) {
        boolean legallyOverloaded;
        Class c;
        String name = member.getName();
        if (name == null) {
            return;
        }
        if (member instanceof Setter) {
            Setter setter = (Setter)member;
            Value getter = setter.getGetter();
            Declaration rd = getter.getRefinedDeclaration();
            member.setRefinedDeclaration(rd);
            return;
        }
        ClassOrInterface type = (ClassOrInterface)member.getContainer();
        if (member.isFormal() && type instanceof Class && !(c = (Class)type).isAbstract() && !c.isFormal()) {
            that.addError("formal member belongs to non-abstract, non-formal class: " + AnalyzerUtil.message(member), 1100);
        }
        if (type.isDynamic()) {
            if (member instanceof Class) {
                that.addError("member class belongs to dynamic interface");
            } else if (!member.isFormal()) {
                that.addError("non-formal member belongs to dynamic interface");
            }
        }
        List<Type> signature = ModelUtil.getSignature(member);
        Declaration root = type.getRefinedMember(name, signature, false);
        boolean bl = legallyOverloaded = !ModelUtil.isOverloadedVersion(member) || ModelUtil.isOverloadedVersion(root) || member.isNative();
        if (root == null || root.equals(member) || root.isNative() && member.isNative()) {
            member.setRefinedDeclaration(member);
            if (member.isActual()) {
                that.addError("actual member does not refine any inherited member: " + AnalyzerUtil.message(member), 1300);
            } else if (!legallyOverloaded) {
                if (member.isActual()) {
                    that.addError("overloaded member does not refine an inherited overloaded member: " + AnalyzerUtil.message(member));
                } else {
                    that.addError("duplicate or overloaded member name: " + AnalyzerUtil.message(member));
                }
            } else if (!ModelUtil.getInheritedDeclarations(name, type).isEmpty()) {
                that.addError("duplicate or overloaded member name in type hierarchy: " + AnalyzerUtil.message(member));
            }
        } else {
            member.setRefinedDeclaration(root);
            if (root.isPackageVisibility() && !AnalyzerUtil.declaredInPackage(root, that.getUnit())) {
                that.addError("refined declaration is not visible: " + AnalyzerUtil.message(member) + " refines " + AnalyzerUtil.message(root));
            }
            boolean found = false;
            TypeDeclaration rootType = (TypeDeclaration)root.getContainer();
            List<Declaration> interveningRefinements = ModelUtil.getInterveningRefinements(name, signature, root, type, rootType);
            for (Declaration refined : interveningRefinements) {
                if (ModelUtil.isOverloadedVersion(refined)) {
                    legallyOverloaded = true;
                }
                found = true;
                if (member instanceof Function) {
                    if (!(refined instanceof Function)) {
                        that.addError("refined declaration is not a method: " + AnalyzerUtil.message(member) + " refines " + AnalyzerUtil.message(refined));
                    }
                } else if (member instanceof Class) {
                    if (!(refined instanceof Class)) {
                        that.addError("refined declaration is not a class: " + AnalyzerUtil.message(member) + " refines " + AnalyzerUtil.message(refined));
                    }
                } else if (member instanceof TypedDeclaration) {
                    if (refined instanceof Class || refined instanceof Function) {
                        that.addError("refined declaration is not an attribute: " + AnalyzerUtil.message(member) + " refines " + AnalyzerUtil.message(refined));
                    } else if (refined instanceof TypedDeclaration && ((TypedDeclaration)refined).isVariable() && !((TypedDeclaration)member).isVariable()) {
                        if (member instanceof Value) {
                            that.addError("non-variable attribute refines a variable attribute: " + AnalyzerUtil.message(member) + " refines " + AnalyzerUtil.message(refined), 804);
                        } else {
                            that.addError("non-variable attribute refines a variable attribute: " + AnalyzerUtil.message(member) + " refines " + AnalyzerUtil.message(refined));
                        }
                    }
                }
                if (!member.isActual()) {
                    that.addError("non-actual member collides with an inherited member: " + AnalyzerUtil.message(member) + " refines " + AnalyzerUtil.message(refined), 600);
                } else if (!refined.isDefault() && !refined.isFormal()) {
                    that.addError("member refines a non-default, non-formal member: " + AnalyzerUtil.message(member) + " refines " + AnalyzerUtil.message(refined), 500);
                }
                if (type.isInconsistentType()) continue;
                this.checkRefinedTypeAndParameterTypes(that, member, type, refined);
            }
            if (!found) {
                if (member instanceof Function && root instanceof Function) {
                    that.addError("overloaded member does not refine any inherited member: " + AnalyzerUtil.message(member));
                }
            } else if (!legallyOverloaded) {
                that.addError("overloaded member does not exactly refine an inherited overloaded member: " + AnalyzerUtil.message(member));
            }
        }
    }

    private void checkRefinedTypeAndParameterTypes(Tree.Declaration that, Declaration refining, ClassOrInterface ci, Declaration refined) {
        List<Type> typeArgs;
        if (refined instanceof Generic && refining instanceof Generic) {
            List<TypeParameter> refinedTypeParams = ((Generic)((Object)refined)).getTypeParameters();
            List<TypeParameter> refiningTypeParams = ((Generic)((Object)refining)).getTypeParameters();
            this.checkRefiningMemberTypeParameters(that, refining, refined, refinedTypeParams, refiningTypeParams);
            typeArgs = this.checkRefiningMemberUpperBounds(that, ci, refined, refinedTypeParams, refiningTypeParams);
        } else {
            typeArgs = AnalyzerUtil.NO_TYPE_ARGS;
        }
        Type cit = ci.getType();
        Reference refinedMember = cit.getTypedReference(refined, typeArgs);
        Reference refiningMember = cit.getTypedReference(refining, typeArgs);
        Declaration refinedMemberDec = refinedMember.getDeclaration();
        Declaration refiningMemberDec = refiningMember.getDeclaration();
        Node typeNode = AnalyzerUtil.getTypeErrorNode(that);
        if (this.refinedMemberIsDynamicallyTyped(refinedMemberDec, refiningMemberDec)) {
            this.checkRefiningMemberDynamicallyTyped(refined, refiningMemberDec, typeNode);
        } else if (this.refiningMemberIsDynamicallyTyped(refinedMemberDec, refiningMemberDec)) {
            this.checkRefinedMemberDynamicallyTyped(refined, refinedMemberDec, typeNode);
        } else if (this.refinedMemberIsVariable(refinedMemberDec)) {
            this.checkRefinedMemberTypeExactly(refiningMember, refinedMember, typeNode, refined);
        } else {
            this.checkRefinedMemberTypeAssignable(refiningMember, refinedMember, typeNode, refined);
        }
        if (refining instanceof Functional && refined instanceof Functional) {
            this.checkRefiningMemberParameters(that, refining, refined, refinedMember, refiningMember, false);
        }
    }

    private void checkRefiningMemberParameters(Tree.Declaration that, Declaration refining, Declaration refined, Reference refinedMember, Reference refiningMember, boolean forNative) {
        List<ParameterList> refiningParamLists = ((Functional)((Object)refining)).getParameterLists();
        List<ParameterList> refinedParamLists = ((Functional)((Object)refined)).getParameterLists();
        if (refinedParamLists.size() != refiningParamLists.size()) {
            String subject = forNative ? "native header" : "refined member";
            String current = forNative ? "native implementation" : "refining member";
            StringBuilder message = new StringBuilder();
            message.append(current).append(" must have the same number of parameter lists as ").append(subject).append(": ").append(AnalyzerUtil.message(refining));
            if (!forNative) {
                message.append(" refines ").append(AnalyzerUtil.message(refined));
            }
            that.addError(message.toString());
        }
        for (int i = 0; i < refinedParamLists.size() && i < refiningParamLists.size(); ++i) {
            this.checkParameterTypes(that, RefinementVisitor.getParameterList(that, i), refiningMember, refinedMember, refiningParamLists.get(i), refinedParamLists.get(i), forNative);
        }
    }

    private boolean refinedMemberIsVariable(Declaration refinedMemberDec) {
        return refinedMemberDec instanceof TypedDeclaration && ((TypedDeclaration)refinedMemberDec).isVariable();
    }

    private void checkRefinedMemberDynamicallyTyped(Declaration refined, Declaration refinedMemberDec, Node typeNode) {
        TypedDeclaration td = (TypedDeclaration)refinedMemberDec;
        if (!td.isDynamicallyTyped()) {
            typeNode.addError("member which refines statically typed refined member must also be statically typed: " + AnalyzerUtil.message(refined));
        }
    }

    private void checkRefiningMemberDynamicallyTyped(Declaration refined, Declaration refiningMemberDec, Node typeNode) {
        TypedDeclaration td = (TypedDeclaration)refiningMemberDec;
        if (!td.isDynamicallyTyped()) {
            typeNode.addError("member which refines dynamically typed refined member must also be dynamically typed: " + AnalyzerUtil.message(refined));
        }
    }

    private boolean refiningMemberIsDynamicallyTyped(Declaration refinedMemberDec, Declaration refiningMemberDec) {
        return refinedMemberDec instanceof TypedDeclaration && refiningMemberDec instanceof TypedDeclaration && ((TypedDeclaration)refiningMemberDec).isDynamicallyTyped();
    }

    private boolean refinedMemberIsDynamicallyTyped(Declaration refinedMemberDec, Declaration refiningMemberDec) {
        return refinedMemberDec instanceof TypedDeclaration && refiningMemberDec instanceof TypedDeclaration && ((TypedDeclaration)refinedMemberDec).isDynamicallyTyped();
    }

    private void checkRefiningMemberTypeParameters(Tree.Declaration that, Declaration dec, Declaration refined, List<TypeParameter> refinedTypeParams, List<TypeParameter> refiningTypeParams) {
        int refinedSize;
        int refiningSize = refiningTypeParams.size();
        if (refiningSize != (refinedSize = refinedTypeParams.size())) {
            StringBuilder message = new StringBuilder();
            message.append("refining member does not have the same number of type parameters as refined member: ").append(AnalyzerUtil.message(dec)).append(" refines ").append(AnalyzerUtil.message(refined));
            that.addError(message.toString());
        }
    }

    private List<Type> checkRefiningMemberUpperBounds(Tree.Declaration that, ClassOrInterface ci, Declaration refined, List<TypeParameter> refinedTypeParams, List<TypeParameter> refiningTypeParams) {
        int refinedSize;
        int max;
        int refiningSize = refiningTypeParams.size();
        int n = max = refiningSize <= (refinedSize = refinedTypeParams.size()) ? refiningSize : refinedSize;
        if (max == 0) {
            return AnalyzerUtil.NO_TYPE_ARGS;
        }
        HashMap<TypeParameter, Type> substitution = new HashMap<TypeParameter, Type>();
        for (int i = 0; i < max; ++i) {
            TypeParameter refinedTypeParam = refinedTypeParams.get(i);
            TypeParameter refiningTypeParam = refiningTypeParams.get(i);
            substitution.put(refiningTypeParam, refinedTypeParam.getType());
        }
        Map<TypeParameter, SiteVariance> noVariances = Collections.emptyMap();
        TypeDeclaration rc = (TypeDeclaration)refined.getContainer();
        Type supertype = ci.getType().getSupertype(rc);
        Map<TypeParameter, Type> args = supertype.getTypeArguments();
        Map<TypeParameter, SiteVariance> variances = supertype.getVarianceOverrides();
        ArrayList<Type> typeArgs = new ArrayList<Type>(max);
        for (int i = 0; i < max; ++i) {
            boolean ok;
            TypeParameter refinedTypeParam = refinedTypeParams.get(i);
            TypeParameter refiningTypeParam = refiningTypeParams.get(i);
            Type refinedProducedType = refinedTypeParam.getType();
            List<Type> refinedBounds = refinedTypeParam.getSatisfiedTypes();
            List<Type> refiningBounds = refiningTypeParam.getSatisfiedTypes();
            TypecheckerUnit unit = that.getUnit();
            for (Type bound : refiningBounds) {
                Type refiningBound = bound.substitute(substitution, noVariances);
                ok = false;
                for (Type refinedBound : refinedBounds) {
                    if (!(refinedBound = refinedBound.substitute(args, variances)).isSubtypeOf(refiningBound)) continue;
                    ok = true;
                }
                if (ok) continue;
                that.addError("refining member type parameter '" + refiningTypeParam.getName() + "' has upper bound which refined member type parameter '" + refinedTypeParam.getName() + "' of " + AnalyzerUtil.message(refined) + " does not satisfy: '" + bound.asString(unit) + "' ('" + refiningTypeParam.getName() + "' should be upper bounded by '" + ModelUtil.intersectionOfSupertypes(refinedTypeParam).substitute(args, variances).asString(unit) + "')");
            }
            for (Type bound : refinedBounds) {
                Type refinedBound = bound.substitute(args, variances);
                ok = false;
                for (Type refiningBound : refiningBounds) {
                    if (!refinedBound.isSubtypeOf(refiningBound = refiningBound.substitute(substitution, noVariances))) continue;
                    ok = true;
                }
                if (ok) continue;
                that.addUnsupportedError("refined member type parameter '" + refinedTypeParam.getName() + "' of " + AnalyzerUtil.message(refined) + " has upper bound which refining member type parameter '" + refiningTypeParam.getName() + "' does not satisfy: '" + bound.asString(unit) + "' ('" + refiningTypeParam.getName() + "' should be upper bounded by '" + ModelUtil.intersectionOfSupertypes(refinedTypeParam).substitute(args, variances).asString(unit) + "')");
            }
            typeArgs.add(refinedProducedType);
        }
        return typeArgs;
    }

    private void checkRefinedMemberTypeAssignable(Reference refiningMember, Reference refinedMember, Node that, Declaration refined) {
        if (this.hasUncheckedNullType(refinedMember)) {
            Unit unit = refiningMember.getDeclaration().getUnit();
            Type optionalRefinedType = unit.getOptionalType(refinedMember.getType());
            AnalyzerUtil.checkAssignableToOneOf(refiningMember.getType(), refinedMember.getType(), optionalRefinedType, that, "type of member must be assignable to type of refined member: " + AnalyzerUtil.message(refined), 9000);
        } else {
            AnalyzerUtil.checkAssignable(refiningMember.getType(), refinedMember.getType(), that, "type of member must be assignable to type of refined member: " + AnalyzerUtil.message(refined), 9000);
        }
    }

    private void checkRefinedMemberTypeExactly(Reference refiningMember, Reference refinedMember, Node that, Declaration refined) {
        if (this.hasUncheckedNullType(refinedMember)) {
            Unit unit = refiningMember.getDeclaration().getUnit();
            Type optionalRefinedType = unit.getOptionalType(refinedMember.getType());
            AnalyzerUtil.checkIsExactlyOneOf(refiningMember.getType(), refinedMember.getType(), optionalRefinedType, that, "type of member must be exactly the same as type of variable refined member: " + AnalyzerUtil.message(refined));
        } else {
            AnalyzerUtil.checkIsExactly(refiningMember.getType(), refinedMember.getType(), that, "type of member must be exactly the same as type of variable refined member: " + AnalyzerUtil.message(refined), 9000);
        }
    }

    private boolean hasUncheckedNullType(Reference member) {
        Declaration dec = member.getDeclaration();
        return dec instanceof TypedDeclaration && ((TypedDeclaration)dec).hasUncheckedNullType();
    }

    private void checkNonrefinableDeclaration(Tree.Declaration that, Declaration dec) {
        if (dec.isActual()) {
            that.addError("actual declaration is not a method, getter, reference attribute, or class", 1301);
        }
        if (dec.isFormal()) {
            that.addError("formal declaration is not a method, getter, reference attribute, or class", 1302);
        }
        if (dec.isDefault()) {
            that.addError("default declaration is not a method, getter, reference attribute, or class", 1303);
        }
    }

    private void checkNonMember(Tree.Declaration that, Declaration dec) {
        Class clazz;
        Declaration member;
        Scope container;
        boolean mayBeShared;
        boolean bl = mayBeShared = !(dec instanceof TypeParameter);
        if (!dec.isClassOrInterfaceMember() && mayBeShared) {
            if (dec.isActual()) {
                that.addError("actual declaration is not a member of a class or interface: '" + dec.getName() + "'", 1301);
            }
            if (dec.isFormal()) {
                that.addError("formal declaration is not a member of a class or interface: '" + dec.getName() + "'", 1302);
            }
            if (dec.isDefault()) {
                that.addError("default declaration is not a member of a class or interface: '" + dec.getName() + "'", 1303);
            }
        } else if (!dec.isShared() && mayBeShared) {
            if (dec.isActual()) {
                that.addError("actual declaration must be shared: '" + dec.getName() + "'", 701);
            }
            if (dec.isFormal()) {
                that.addError("formal declaration must be shared: '" + dec.getName() + "'", 702);
            }
            if (dec.isDefault()) {
                that.addError("default declaration must be shared: '" + dec.getName() + "'", 703);
            }
        } else {
            if (dec.isActual()) {
                that.addError("declaration may not be actual: '" + dec.getName() + "'", 1301);
            }
            if (dec.isFormal()) {
                that.addError("declaration may not be formal: '" + dec.getName() + "'", 1302);
            }
            if (dec.isDefault()) {
                that.addError("declaration may not be default: '" + dec.getName() + "'", 1303);
            }
        }
        if (ModelUtil.isConstructor(dec) && dec.isShared() && (container = dec.getContainer()) instanceof Class && (member = ModelUtil.intersectionOfSupertypes(clazz = (Class)container).getDeclaration().getMember(dec.getName(), null, false)) != null && member.isShared() && !ModelUtil.isConstructor(member)) {
            Declaration supertype = (Declaration)((Object)member.getContainer());
            that.addError("constructor has same name as an inherited member '" + clazz.getName() + "' inherits '" + member.getName() + "' from '" + supertype.getName(that.getUnit()) + "'");
        }
    }

    private static String containerName(Reference member) {
        return RefinementVisitor.containerName(member.getDeclaration());
    }

    private static String containerName(Declaration member) {
        Scope container = member.getContainer();
        if (container instanceof Declaration) {
            Declaration dec = (Declaration)((Object)container);
            return dec.getName();
        }
        if (container instanceof Package) {
            Package pack = (Package)container;
            return pack.getQualifiedNameString();
        }
        return "Unknown";
    }

    private void checkParameterTypes(Tree.Declaration that, Tree.ParameterList pl, Reference member, Reference refinedMember, ParameterList params, ParameterList refinedParams, boolean forNative) {
        List<Parameter> paramsList = params.getParameters();
        List<Parameter> refinedParamsList = refinedParams.getParameters();
        if (paramsList.size() != refinedParamsList.size()) {
            this.handleWrongParameterListLength(that, member, refinedMember, forNative);
        } else {
            for (int i = 0; i < paramsList.size(); ++i) {
                Tree.ParameterDeclaration pd;
                Tree.Type type;
                Tree.Parameter parameter;
                Parameter rparam = refinedParamsList.get(i);
                Parameter param = paramsList.get(i);
                if (forNative && !param.getName().equals(rparam.getName())) {
                    that.addError("parameter does not have the same name as its header: '" + param.getName() + "' is not '" + rparam.getName() + "' for " + AnalyzerUtil.message(refinedMember.getDeclaration()));
                }
                Type refinedParameterType = refinedMember.getTypedParameter(rparam).getFullType();
                Type parameterType = member.getTypedParameter(param).getFullType();
                Node typeNode = parameter = pl.getParameters().get(i);
                if (parameter instanceof Tree.ParameterDeclaration && (type = (pd = (Tree.ParameterDeclaration)parameter).getTypedDeclaration().getType()) != null) {
                    typeNode = type;
                }
                if (parameter == null) continue;
                if (rparam.getModel().isDynamicallyTyped()) {
                    this.checkRefiningParameterDynamicallyTyped(member, refinedMember, param, typeNode);
                    continue;
                }
                if (param.getModel() != null && param.getModel().isDynamicallyTyped()) {
                    this.checkRefinedParameterDynamicallyTyped(member, refinedMember, rparam, param, typeNode);
                    continue;
                }
                if (refinedParameterType == null || parameterType == null) {
                    this.handleUnknownParameterType(member, refinedMember, param, typeNode, forNative);
                    continue;
                }
                RefinementVisitor.checkRefiningParameterType(member, refinedMember, refinedParams, rparam, refinedParameterType, param, parameterType, typeNode, forNative);
            }
        }
    }

    private void handleWrongParameterListLength(Tree.Declaration that, Reference member, Reference refinedMember, boolean forNative) {
        StringBuilder message = new StringBuilder();
        String subject = forNative ? "native header" : "refined member";
        message.append("member does not have the same number of parameters as ").append(subject).append(": '").append(member.getDeclaration().getName()).append("'");
        if (!forNative) {
            message.append(" declared by '").append(RefinementVisitor.containerName(member)).append("' refining '").append(refinedMember.getDeclaration().getName()).append("' declared by '").append(RefinementVisitor.containerName(refinedMember)).append("'");
        }
        that.addError(message.toString(), 9100);
    }

    private static void checkRefiningParameterType(Reference member, Reference refinedMember, ParameterList refinedParams, Parameter rparam, Type refinedParameterType, Parameter param, Type parameterType, Node typeNode, boolean forNative) {
        StringBuilder message = new StringBuilder();
        String subject = forNative ? "native header" : "refined member";
        message.append("type of parameter '").append(param.getName()).append("' of '").append(member.getDeclaration().getName()).append("'");
        if (!forNative) {
            message.append(" declared by '").append(RefinementVisitor.containerName(member)).append("'");
        }
        message.append(" is different to type of corresponding parameter '").append(rparam.getName()).append("' of ").append(subject).append(" '").append(refinedMember.getDeclaration().getName()).append("'");
        if (!forNative) {
            message.append(" of '").append(RefinementVisitor.containerName(refinedMember)).append("'");
        }
        AnalyzerUtil.checkIsExactlyForInterop(typeNode.getUnit(), refinedParams.isNamedParametersSupported(), parameterType, refinedParameterType, typeNode, message.toString());
    }

    private void handleUnknownParameterType(Reference member, Reference refinedMember, Parameter param, Node typeNode, boolean forNative) {
        StringBuilder message = new StringBuilder();
        String subject = forNative ? "native header" : "refined member";
        message.append("could not determine if parameter type is the same as the corresponding parameter of ").append(subject).append(": '").append(param.getName()).append("' of '").append(member.getDeclaration().getName());
        if (!forNative) {
            message.append("' declared by '").append(RefinementVisitor.containerName(member)).append("' refining '").append(refinedMember.getDeclaration().getName()).append("' declared by '").append(RefinementVisitor.containerName(refinedMember)).append("'");
        }
        typeNode.addError(message.toString());
    }

    private void checkRefinedParameterDynamicallyTyped(Reference member, Reference refinedMember, Parameter rparam, Parameter param, Node typeNode) {
        if (!rparam.getModel().isDynamicallyTyped()) {
            typeNode.addError("parameter which refines statically typed parameter must also be statically typed: '" + param.getName() + "' of '" + member.getDeclaration().getName() + "' declared by '" + RefinementVisitor.containerName(member) + "' refining '" + refinedMember.getDeclaration().getName() + "' declared by '" + RefinementVisitor.containerName(refinedMember) + "'");
        }
    }

    private void checkRefiningParameterDynamicallyTyped(Reference member, Reference refinedMember, Parameter param, Node typeNode) {
        if (!param.getModel().isDynamicallyTyped()) {
            typeNode.addError("parameter which refines dynamically typed parameter must also be dynamically typed: '" + param.getName() + "' of '" + member.getDeclaration().getName() + "' declared by '" + RefinementVisitor.containerName(member) + "' refining '" + refinedMember.getDeclaration().getName() + "' declared by '" + RefinementVisitor.containerName(refinedMember) + "'");
        }
    }

    private static Tree.ParameterList getParameterList(Tree.Declaration that, int i) {
        if (that instanceof Tree.AnyMethod) {
            Tree.AnyMethod am = (Tree.AnyMethod)that;
            return am.getParameterLists().get(i);
        }
        if (that instanceof Tree.AnyClass) {
            Tree.AnyClass ac = (Tree.AnyClass)that;
            return ac.getParameterList();
        }
        if (that instanceof Tree.Constructor) {
            Tree.Constructor con = (Tree.Constructor)that;
            return con.getParameterList();
        }
        return null;
    }

    @Override
    public void visit(Tree.ParameterList that) {
        super.visit(that);
        boolean foundSequenced = false;
        boolean foundDefault = false;
        ParameterList pl = that.getModel();
        for (Tree.Parameter p : that.getParameters()) {
            if (p == null) continue;
            Parameter pm = p.getParameterModel();
            if (pm.isDefaulted()) {
                if (foundSequenced) {
                    p.addError("defaulted parameter must occur before variadic parameter");
                }
                foundDefault = true;
                if (pl.isFirst()) continue;
                p.addError("only the first parameter list may have defaulted parameters");
                continue;
            }
            if (pm.isSequenced()) {
                if (foundSequenced) {
                    p.addError("parameter list may have at most one variadic parameter");
                }
                foundSequenced = true;
                if (!pl.isFirst()) {
                    p.addError("only the first parameter list may have a variadic parameter");
                }
                if (!foundDefault || !pm.isAtLeastOne()) continue;
                p.addError("parameter list with defaulted parameters may not have a nonempty variadic parameter");
                continue;
            }
            if (foundDefault) {
                p.addError("required parameter must occur before defaulted parameters");
            }
            if (!foundSequenced) continue;
            p.addError("required parameter must occur before variadic parameter");
        }
    }

    @Override
    public void visit(Tree.SpecifierStatement that) {
        super.visit(that);
        ArrayList<Type> sig = new ArrayList<Type>();
        Tree.Term term = that.getBaseMemberExpression();
        while (term instanceof Tree.ParameterizedExpression) {
            sig.clear();
            Tree.ParameterizedExpression pe = (Tree.ParameterizedExpression)term;
            Tree.TypeParameterList typeParameterList = pe.getTypeParameterList();
            if (typeParameterList != null) {
                typeParameterList.addError("specification statements may not have type parameters");
            }
            Tree.ParameterList pl = pe.getParameterLists().get(0);
            for (Tree.Parameter p : pl.getParameters()) {
                if (p == null) {
                    sig.add(null);
                    continue;
                }
                Parameter model = p.getParameterModel();
                if (model != null) {
                    sig.add(model.getType());
                    continue;
                }
                sig.add(null);
            }
            term = pe.getPrimary();
        }
        if (term instanceof Tree.BaseMemberExpression) {
            Tree.BaseMemberExpression bme = (Tree.BaseMemberExpression)term;
            TypecheckerUnit unit = that.getUnit();
            TypedDeclaration td = AnalyzerUtil.getTypedDeclaration(bme.getScope(), TreeUtil.name(bme.getIdentifier()), sig, false, unit);
            if (td != null) {
                that.setDeclaration(td);
                Scope scope = that.getScope();
                Scope container = scope.getContainer();
                Scope realScope = ModelUtil.getRealScope(container);
                if (realScope instanceof ClassOrInterface) {
                    ClassOrInterface ci = (ClassOrInterface)realScope;
                    Scope tdcontainer = td.getContainer();
                    if (td.isClassOrInterfaceMember()) {
                        ClassOrInterface tdci = (ClassOrInterface)tdcontainer;
                        if (!tdcontainer.equals(realScope) && ci.inherits(tdci)) {
                            if (tdcontainer == scope) {
                                that.addError("parameter declaration hides refining member: '" + td.getName(unit) + "' (rename parameter)");
                            } else if (td instanceof Value) {
                                this.refineAttribute((Value)td, bme, that, ci);
                            } else if (td instanceof Function) {
                                this.refineMethod((Function)td, bme, that, ci);
                            } else {
                                bme.addError("not a reference to a formal attribute: '" + td.getName(unit) + "'");
                            }
                        }
                    }
                }
            }
        }
    }

    private void refineAttribute(Value sv, Tree.BaseMemberExpression bme, Tree.SpecifierStatement that, ClassOrInterface c) {
        ClassOrInterface ci = (ClassOrInterface)sv.getContainer();
        Declaration refined = ci.getRefinedMember(sv.getName(), null, false);
        Value root = refined instanceof Value ? (Value)refined : sv;
        final Reference rv = ExpressionVisitor.getRefinedMember(sv, c);
        if (!(sv.isFormal() || sv.isDefault() || sv.isShortcutRefinement())) {
            that.addError("inherited attribute may not be assigned in initializer and is neither formal nor default so may not be refined: " + AnalyzerUtil.message(sv), 510);
        } else if (sv.isVariable()) {
            that.addError("inherited attribute may not be assigned in initializer and is variable so may not be refined by non-variable: " + AnalyzerUtil.message(sv));
        }
        boolean lazy = that.getSpecifierExpression() instanceof Tree.LazySpecifierExpression;
        Value v = new Value();
        v.setName(sv.getName());
        v.setShared(true);
        v.setActual(true);
        v.getAnnotations().add(new Annotation("shared"));
        v.getAnnotations().add(new Annotation("actual"));
        v.setRefinedDeclaration(root);
        TypecheckerUnit unit = that.getUnit();
        v.setUnit(unit);
        v.setContainer(c);
        v.setScope(c);
        v.setShortcutRefinement(true);
        v.setTransient(lazy);
        DeclarationVisitor.setVisibleScope(v);
        c.addMember(v);
        that.setRefinement(true);
        that.setDeclaration(v);
        that.setRefined(sv);
        unit.addDeclaration(v);
        v.setType(new LazyType(unit){

            @Override
            public Type initQualifyingType() {
                return rv.getType().getQualifyingType();
            }

            @Override
            public Map<TypeParameter, Type> initTypeArguments() {
                return rv.getType().getTypeArguments();
            }

            @Override
            public TypeDeclaration initDeclaration() {
                return rv.getType().getDeclaration();
            }
        });
    }

    private void refineMethod(Function sm, Tree.BaseMemberExpression bme, Tree.SpecifierStatement that, ClassOrInterface c) {
        ArrayList<TypeParameter> typeParams;
        List<Object> paramLists;
        Function root;
        ClassOrInterface ci = (ClassOrInterface)sm.getContainer();
        Declaration refined = ci.getRefinedMember(sm.getName(), ModelUtil.getSignature(sm), false);
        Function function = root = refined instanceof Function ? (Function)refined : sm;
        if (!(sm.isFormal() || sm.isDefault() || sm.isShortcutRefinement())) {
            that.addError("inherited method is neither formal nor default so may not be refined: " + AnalyzerUtil.message(sm), 510);
        }
        final Reference rm = ExpressionVisitor.getRefinedMember(sm, c);
        Function m = new Function();
        m.setName(sm.getName());
        Tree.Term me = that.getBaseMemberExpression();
        if (me instanceof Tree.ParameterizedExpression) {
            Tree.ParameterizedExpression pe = (Tree.ParameterizedExpression)me;
            paramLists = pe.getParameterLists();
            Tree.TypeParameterList typeParameterList = pe.getTypeParameterList();
            if (typeParameterList != null) {
                typeParams = new ArrayList<TypeParameter>();
                for (Tree.TypeParameterDeclaration tpd : typeParameterList.getTypeParameterDeclarations()) {
                    typeParams.add(tpd.getDeclarationModel());
                }
            } else {
                typeParams = null;
            }
        } else {
            paramLists = Collections.emptyList();
            typeParams = null;
        }
        int i = 0;
        TypecheckerUnit unit = that.getUnit();
        for (ParameterList pl : sm.getParameterLists()) {
            ParameterList l = new ParameterList();
            Tree.ParameterList tpl = paramLists.size() <= i ? null : (Tree.ParameterList)paramLists.get(i++);
            int j = 0;
            for (final Parameter p : pl.getParameters()) {
                if (tpl == null || tpl.getParameters().size() <= j) {
                    Parameter vp = new Parameter();
                    Value v = new Value();
                    vp.setModel(v);
                    v.setInitializerParameter(vp);
                    vp.setSequenced(p.isSequenced());
                    vp.setAtLeastOne(p.isAtLeastOne());
                    vp.setName(p.getName());
                    v.setName(p.getName());
                    vp.setDeclaration(m);
                    v.setContainer(m);
                    v.setScope(m);
                    l.getParameters().add(vp);
                    v.setType(new LazyType(unit){

                        @Override
                        public Type initQualifyingType() {
                            return rm.getTypedParameter(p).getFullType().getQualifyingType();
                        }

                        @Override
                        public Map<TypeParameter, Type> initTypeArguments() {
                            return rm.getTypedParameter(p).getFullType().getTypeArguments();
                        }

                        @Override
                        public TypeDeclaration initDeclaration() {
                            return rm.getTypedParameter(p).getFullType().getDeclaration();
                        }
                    });
                } else {
                    Tree.Parameter tp = tpl.getParameters().get(j);
                    Parameter rp = tp.getParameterModel();
                    rp.setDefaulted(p.isDefaulted());
                    rp.setDeclaration(m);
                    l.getParameters().add(rp);
                }
                ++j;
            }
            m.getParameterLists().add(l);
        }
        if (typeParams != null) {
            m.setTypeParameters(typeParams);
        } else if (!sm.getTypeParameters().isEmpty()) {
            if (me instanceof Tree.ParameterizedExpression) {
                bme.addError("refined method is generic: '" + sm.getName(unit) + "' declares type parameters");
            } else {
                TypeParameter tp;
                int j;
                List<TypeParameter> typeParameters = sm.getTypeParameters();
                ArrayList<TypeParameter> tps = new ArrayList<TypeParameter>(typeParameters.size());
                HashMap<TypeParameter, Type> subs = new HashMap<TypeParameter, Type>();
                for (j = 0; j < typeParameters.size(); ++j) {
                    TypeParameter param = typeParameters.get(j);
                    tp = new TypeParameter();
                    tp.setName(param.getName());
                    tp.setUnit(unit);
                    tp.setScope(m);
                    tp.setContainer(m);
                    tp.setDeclaration(m);
                    tp.setCovariant(param.isCovariant());
                    tp.setContravariant(param.isContravariant());
                    tps.add(tp);
                    subs.put(param, tp.getType());
                }
                for (j = 0; j < typeParameters.size(); ++j) {
                    TypeParameter param = typeParameters.get(j);
                    tp = (TypeParameter)tps.get(j);
                    List<Type> sts = param.getSatisfiedTypes();
                    ArrayList<Type> ssts = new ArrayList<Type>(sts.size());
                    for (Type st : sts) {
                        ssts.add(st.substitute(subs, null));
                    }
                    tp.setSatisfiedTypes(ssts);
                    List<Type> cts = param.getCaseTypes();
                    if (cts == null) continue;
                    ArrayList<Type> scts = new ArrayList<Type>(cts.size());
                    for (Type ct : cts) {
                        scts.add(ct.substitute(subs, null));
                    }
                    tp.setCaseTypes(scts);
                }
                m.setTypeParameters(tps);
            }
        }
        m.setShared(true);
        m.setActual(true);
        m.getAnnotations().add(new Annotation("shared"));
        m.getAnnotations().add(new Annotation("actual"));
        m.setRefinedDeclaration(root);
        m.setUnit(unit);
        m.setContainer(c);
        m.setShortcutRefinement(true);
        m.setDeclaredVoid(sm.isDeclaredVoid());
        DeclarationVisitor.setVisibleScope(m);
        c.addMember(m);
        that.setRefinement(true);
        that.setDeclaration(m);
        that.setRefined(sm);
        unit.addDeclaration(m);
        Scope scope = that.getScope();
        if (scope instanceof Specification) {
            Specification spec = (Specification)scope;
            spec.setDeclaration(m);
        }
        m.setType(new LazyType(unit){

            @Override
            public Type initQualifyingType() {
                Type type = rm.getType();
                return type == null ? null : type.getQualifyingType();
            }

            @Override
            public Map<TypeParameter, Type> initTypeArguments() {
                Type type = rm.getType();
                return type == null ? null : type.getTypeArguments();
            }

            @Override
            public TypeDeclaration initDeclaration() {
                Type type = rm.getType();
                return type == null ? null : type.getDeclaration();
            }
        });
        this.inheritDefaultedArguments(m);
    }
}

