/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.typechecker.analyzer;

import com.redhat.ceylon.compiler.typechecker.analyzer.AnalyzerUtil;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.TreeUtil;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.Constructor;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Setter;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.ArrayList;
import java.util.List;

public class SpecificationVisitor
extends Visitor {
    private final Declaration declaration;
    private SpecificationState specified = new SpecificationState(false, false);
    private boolean withinDeclaration = false;
    private int loopDepth = 0;
    private int brokenLoopDepth = 0;
    private boolean allOuterLoopsBreak = true;
    private boolean declared = false;
    private boolean hasParameter = false;
    private Tree.Statement lastExecutableStatement;
    private Tree.Declaration lastConstructor;
    private boolean declarationSection = false;
    private boolean endsInReturnThrow = false;
    private boolean endsInBreak = false;
    private boolean inExtends = false;
    private boolean inAnonFunctionOrComprehension = false;
    private Parameter parameter = null;
    private Tree.Continue lastContinue;
    private Tree.Statement lastContinueStatement;
    private TypeDeclaration delegatedConstructor;
    private List<Constructor> definitelyInitedBy = new ArrayList<Constructor>();
    private List<Constructor> possiblyInitedBy = new ArrayList<Constructor>();
    private boolean initedByEveryConstructor = true;

    @Override
    public void visit(Tree.ExtendedType that) {
        boolean oie = this.inExtends;
        this.inExtends = this.declared;
        super.visit(that);
        this.inExtends = oie;
    }

    public SpecificationVisitor(Declaration declaration) {
        this.declaration = declaration;
    }

    private void declare() {
        this.declared = true;
    }

    private boolean beginDeclarationScope() {
        return this.declared;
    }

    private void endDeclarationScope(boolean d) {
        this.declared = d;
    }

    private boolean beginDisabledSpecificationScope() {
        boolean ca = this.withinDeclaration;
        this.withinDeclaration = true;
        return ca;
    }

    private void endDisabledSpecificationScope(boolean ca) {
        this.withinDeclaration = ca;
    }

    private void specify() {
        this.specified.definitely = true;
        this.specified.possibly = true;
    }

    private void exit() {
        this.specified.possiblyExited = true;
        this.specified.definitelyExited = true;
    }

    private SpecificationState beginSpecificationScope() {
        SpecificationState as = this.specified;
        this.specified = new SpecificationState(this.specified.definitely, this.specified.possibly);
        return as;
    }

    private void endSpecificationScope(SpecificationState as) {
        this.specified = as;
    }

    private boolean isVariable() {
        if (this.declaration instanceof TypedDeclaration) {
            TypedDeclaration td = (TypedDeclaration)this.declaration;
            return td.isVariable();
        }
        return false;
    }

    private boolean isLate() {
        if (this.declaration instanceof FunctionOrValue) {
            FunctionOrValue fov = (FunctionOrValue)this.declaration;
            return fov.isLate();
        }
        return false;
    }

    @Override
    public void visit(Tree.AnnotationList that) {
    }

    @Override
    public void visit(Tree.BaseMemberExpression that) {
        super.visit(that);
        this.visitReference(that);
    }

    @Override
    public void visit(Tree.MetaLiteral that) {
        super.visit(that);
        this.visitReference(that);
    }

    @Override
    public void visit(Tree.ExtendedTypeExpression that) {
        super.visit(that);
        this.visitReference(that);
    }

    @Override
    public void visit(Tree.CaseTypes that) {
    }

    @Override
    public void visit(Tree.SatisfiedTypes that) {
    }

    @Override
    public void visit(Tree.BaseTypeExpression that) {
        super.visit(that);
        this.visitReference(that);
    }

    @Override
    public void visit(Tree.QualifiedMemberExpression that) {
        super.visit(that);
        if (TreeUtil.isSelfReference(that.getPrimary())) {
            this.visitReference(that);
        }
    }

    @Override
    public void visit(Tree.QualifiedTypeExpression that) {
        super.visit(that);
        if (TreeUtil.isSelfReference(that.getPrimary())) {
            this.visitReference(that);
        }
    }

    private void visitReference(Tree.Primary that) {
        boolean metamodel;
        boolean assigned;
        Declaration member;
        if (that instanceof Tree.MemberOrTypeExpression) {
            Tree.MemberOrTypeExpression mte = (Tree.MemberOrTypeExpression)that;
            member = mte.getDeclaration();
            assigned = mte.getAssigned();
            metamodel = false;
        } else if (that instanceof Tree.MetaLiteral) {
            Tree.MetaLiteral ml = (Tree.MetaLiteral)that;
            member = ml.getDeclaration();
            assigned = false;
            metamodel = true;
        } else {
            return;
        }
        if (member == this.declaration && member.isDefinedInScope(that.getScope())) {
            if (!this.declared) {
                if (!(metamodel || this.isForwardReferenceable() || this.hasParameter)) {
                    Scope container = this.declaration.getContainer();
                    if (container instanceof Class) {
                        that.addError("forward reference to class member in initializer: '" + member.getName() + "' is not yet declared (forward references must occur in declaration section)");
                    } else {
                        that.addError("forward reference to local declaration: '" + member.getName() + "' is not yet declared");
                    }
                }
            } else if (!this.specified.definitely || this.declaration.isFormal()) {
                if (this.declaration.isFormal()) {
                    if (!this.isForwardReferenceable()) {
                        that.addError("formal member may not be used in initializer: '" + member.getName() + "'");
                    }
                } else if (!(metamodel || ModelUtil.isNativeHeader(this.declaration) || this.isLate() && this.isForwardReferenceable())) {
                    if (this.isVariable()) {
                        that.addError("not definitely initialized: '" + member.getName() + "'");
                    } else {
                        that.addError("not definitely specified: '" + member.getName() + "'");
                    }
                }
            } else if (this.parameter != null && ModelUtil.isConstructor(this.parameter.getDeclaration()) && this.parameter.getDeclaration().getContainer().equals(this.declaration.getContainer())) {
                that.addError("default argument to constructor parameter is a member of the constructed class");
            }
            if (!assigned && member.isDefault() && !this.isForwardReferenceable()) {
                that.addError("default member may not be used in initializer: '" + member.getName() + "'");
            }
            if (this.inAnonFunctionOrComprehension && this.specified.definitely && this.isVariable()) {
                that.addError("variable member may not be captured by comprehension or function in extends clause: '" + member.getName() + "'");
            }
        }
    }

    private boolean isForwardReferenceable() {
        return this.declarationSection || this.declaration.isToplevel() || this.declaration.isInterfaceMember();
    }

    @Override
    public void visit(Tree.LogicalOp that) {
        that.getLeftTerm().visit(this);
        SpecificationState ss = this.beginSpecificationScope();
        that.getRightTerm().visit(this);
        this.endSpecificationScope(ss);
    }

    @Override
    public void visit(Tree.IfExpression that) {
        Tree.ElseClause elseClause;
        Tree.IfClause ifClause = that.getIfClause();
        if (ifClause != null) {
            SpecificationState ss = this.beginSpecificationScope();
            ifClause.visit(this);
            this.endSpecificationScope(ss);
        }
        if ((elseClause = that.getElseClause()) != null) {
            SpecificationState ss = this.beginSpecificationScope();
            elseClause.visit(this);
            this.endSpecificationScope(ss);
        }
    }

    @Override
    public void visit(Tree.SwitchExpression that) {
        Tree.SwitchCaseList switchCaseList;
        Tree.SwitchClause switchClause = that.getSwitchClause();
        if (switchClause != null) {
            switchClause.visit(this);
        }
        if ((switchCaseList = that.getSwitchCaseList()) != null) {
            for (Tree.CaseClause caseClause : switchCaseList.getCaseClauses()) {
                SpecificationState ss = this.beginSpecificationScope();
                caseClause.visit(this);
                this.endSpecificationScope(ss);
            }
            Tree.ElseClause elseClause = switchCaseList.getElseClause();
            if (elseClause != null) {
                SpecificationState ss = this.beginSpecificationScope();
                elseClause.visit(this);
                this.endSpecificationScope(ss);
            }
        }
    }

    @Override
    public void visit(Tree.Comprehension that) {
        boolean oicoaf = this.inAnonFunctionOrComprehension;
        this.inAnonFunctionOrComprehension = this.declared && this.inExtends;
        super.visit(that);
        this.inAnonFunctionOrComprehension = oicoaf;
    }

    @Override
    public void visit(Tree.FunctionArgument that) {
        boolean c = this.beginDisabledSpecificationScope();
        boolean oicoaf = this.inAnonFunctionOrComprehension;
        this.inAnonFunctionOrComprehension = this.declared && this.inExtends;
        SpecificationState ss = this.beginSpecificationScope();
        super.visit(that);
        this.endSpecificationScope(ss);
        this.inAnonFunctionOrComprehension = oicoaf;
        this.endDisabledSpecificationScope(c);
    }

    @Override
    public void visit(Tree.ObjectExpression that) {
        boolean c = this.beginDisabledSpecificationScope();
        boolean oicoaf = this.inAnonFunctionOrComprehension;
        this.inAnonFunctionOrComprehension = this.declared && this.inExtends;
        SpecificationState ss = this.beginSpecificationScope();
        super.visit(that);
        this.endSpecificationScope(ss);
        this.inAnonFunctionOrComprehension = oicoaf;
        this.endDisabledSpecificationScope(c);
    }

    @Override
    public void visit(Tree.AssignOp that) {
        Tree.Term lt = that.getLeftTerm();
        if (TreeUtil.isEffectivelyBaseMemberExpression(lt)) {
            Tree.StaticMemberOrTypeExpression m = (Tree.StaticMemberOrTypeExpression)lt;
            Declaration member = m.getDeclaration();
            if (member == this.declaration) {
                if (that.getRightTerm() != null) {
                    that.getRightTerm().visit(this);
                }
                this.checkVariable(lt, that);
                this.specify();
                lt.visit(this);
            } else {
                super.visit(that);
            }
        }
    }

    @Override
    public void visit(Tree.AssignmentOp that) {
        super.visit(that);
        this.checkVariable(that.getLeftTerm(), that);
    }

    @Override
    public void visit(Tree.PostfixOperatorExpression that) {
        super.visit(that);
        this.checkVariable(that.getTerm(), that);
    }

    @Override
    public void visit(Tree.PrefixOperatorExpression that) {
        super.visit(that);
        this.checkVariable(that.getTerm(), that);
    }

    private void checkVariable(Tree.Term term, Node node) {
        Tree.StaticMemberOrTypeExpression mte;
        Declaration member;
        if (TreeUtil.isEffectivelyBaseMemberExpression(term) && (member = (mte = (Tree.StaticMemberOrTypeExpression)term).getDeclaration()) == this.declaration) {
            if ((this.declaration.isFormal() || this.declaration.isDefault()) && !this.isForwardReferenceable()) {
                term.addError("member is formal or default and may not be assigned here: '" + member.getName() + "'");
            } else if (!this.isVariable() && !this.isLate()) {
                if (member instanceof Value) {
                    if (node instanceof Tree.AssignOp) {
                        term.addError("value is not a variable and may not be assigned here: '" + member.getName() + "'", 803);
                    } else {
                        term.addError("value is not a variable: '" + member.getName() + "'", 800);
                    }
                } else {
                    term.addError("not a variable value: '" + member.getName() + "'");
                }
            }
        }
    }

    @Override
    public void visit(Tree.Block that) {
        Scope scope = that.getScope();
        if (scope instanceof Constructor) {
            if (this.definitelyInitedBy.contains(this.delegatedConstructor)) {
                this.specified.definitely = true;
            }
            if (this.possiblyInitedBy.contains(this.delegatedConstructor)) {
                this.specified.possibly = true;
            }
            this.delegatedConstructor = null;
        }
        boolean of = this.endsInBreak;
        boolean oe = this.endsInReturnThrow;
        Tree.Continue olc = this.lastContinue;
        Tree.Statement olcs = this.lastContinueStatement;
        boolean continueInSomeBranchOfCurrentConditional = this.lastContinue != null && this.lastContinueStatement == null;
        boolean blockEndsInReturnThrow = this.blockEndsInReturnThrow(that);
        boolean blockEndsInBreak = this.blockEndsInBreak(that);
        this.endsInBreak = this.endsInBreak || blockEndsInBreak;
        this.endsInReturnThrow = this.endsInReturnThrow || blockEndsInReturnThrow;
        Tree.Continue last = null;
        Tree.Statement lastStatement = null;
        for (Tree.Statement st : that.getStatements()) {
            ContinueVisitor cv = new ContinueVisitor(olc);
            st.visit(cv);
            if (cv.node != null) {
                last = cv.node;
                lastStatement = st;
            }
            if (!cv.found) continue;
            olc = null;
            olcs = null;
        }
        if (blockEndsInReturnThrow || blockEndsInBreak || continueInSomeBranchOfCurrentConditional) {
            this.lastContinue = last;
            this.lastContinueStatement = lastStatement;
        }
        super.visit(that);
        this.endsInBreak = of;
        this.endsInReturnThrow = oe;
        this.lastContinue = olc;
        this.lastContinueStatement = olcs;
        if (scope instanceof Constructor) {
            Constructor c = (Constructor)scope;
            if (this.specified.definitely) {
                this.definitelyInitedBy.add(c);
            }
            if (this.specified.possibly) {
                this.possiblyInitedBy.add(c);
            }
        }
        if (SpecificationVisitor.isNonPartialConstructor(scope) && this.declaration.getContainer() == scope.getContainer() && !this.specified.definitely) {
            this.initedByEveryConstructor = false;
        }
    }

    @Override
    public void visit(Tree.DelegatedConstructor that) {
        super.visit(that);
        Tree.SimpleType type = that.getType();
        if (type != null) {
            this.delegatedConstructor = type.getDeclarationModel();
            if (this.delegatedConstructor instanceof Class) {
                Class c = (Class)this.delegatedConstructor;
                this.delegatedConstructor = c.getDefaultConstructor();
            }
        }
    }

    private boolean blockEndsInBreak(Tree.Block that) {
        int size = that.getStatements().size();
        if (size > 0) {
            Tree.Statement s = that.getStatements().get(size - 1);
            return s instanceof Tree.Break;
        }
        return false;
    }

    private boolean blockEndsInReturnThrow(Tree.Block that) {
        int size = that.getStatements().size();
        if (size > 0) {
            Tree.Statement s = that.getStatements().get(size - 1);
            return s instanceof Tree.Return || s instanceof Tree.Throw;
        }
        return false;
    }

    @Override
    public void visit(Tree.ForClause that) {
        boolean of = this.endsInBreak;
        boolean oe = this.endsInReturnThrow;
        Tree.Continue olc = this.lastContinue;
        this.lastContinue = null;
        this.endsInBreak = false;
        this.endsInReturnThrow = false;
        super.visit(that);
        this.endsInBreak = of;
        this.endsInReturnThrow = oe;
        this.lastContinue = olc;
    }

    @Override
    public void visit(Tree.WhileClause that) {
        boolean of = this.endsInBreak;
        boolean oe = this.endsInReturnThrow;
        Tree.Continue olc = this.lastContinue;
        this.lastContinue = null;
        this.endsInBreak = false;
        this.endsInReturnThrow = false;
        super.visit(that);
        this.endsInBreak = of;
        this.endsInReturnThrow = oe;
        this.lastContinue = olc;
    }

    @Override
    public void visit(Tree.Body that) {
        if (this.hasParameter && that.getScope() == this.declaration.getContainer()) {
            this.hasParameter = false;
        }
        super.visit(that);
    }

    private static boolean isNonPartialConstructor(Scope scope) {
        return scope instanceof Constructor && !((Constructor)scope).isAbstract();
    }

    private String longdesc() {
        if (this.declaration instanceof Value) {
            return "value is neither variable nor late and";
        }
        if (this.declaration instanceof Function) {
            return "function";
        }
        return "declaration";
    }

    private String shortdesc() {
        if (this.declaration instanceof Value) {
            return "value";
        }
        if (this.declaration instanceof Function) {
            return "function";
        }
        return "declaration";
    }

    @Override
    public void visit(Tree.SpecifierStatement that) {
        Tree.Term term = that.getBaseMemberExpression();
        boolean parameterized = false;
        while (term instanceof Tree.ParameterizedExpression) {
            Tree.ParameterizedExpression pe = (Tree.ParameterizedExpression)term;
            term = pe.getPrimary();
            parameterized = true;
        }
        if (term instanceof Tree.StaticMemberOrTypeExpression) {
            Tree.StaticMemberOrTypeExpression bme = (Tree.StaticMemberOrTypeExpression)term;
            Declaration member = bme.getDeclaration();
            if (member == this.declaration) {
                if (!this.isForwardReferenceable()) {
                    if (this.declaration.isFormal()) {
                        bme.addError("member is formal and may not be specified: '" + member.getName() + "' is declared formal");
                    } else if (this.declaration.isDefault()) {
                        bme.addError("member is default and may not be specified except in its declaration: '" + member.getName() + "' is declared default");
                    }
                }
                if (that.getRefinement()) {
                    this.declare();
                }
                Tree.SpecifierExpression se = that.getSpecifierExpression();
                boolean lazy = se instanceof Tree.LazySpecifierExpression;
                if (this.declaration instanceof Value) {
                    Value value = (Value)this.declaration;
                    if (!value.isVariable() && lazy != value.isTransient()) {
                        se.addError("value must be specified using => lazy specifier: '" + member.getName() + "'");
                    }
                    if (lazy) {
                        if (value.isVariable()) {
                            se.addError("variable value may not be specified using => lazy specifier: '" + member.getName() + "'");
                        } else if (value.isLate()) {
                            se.addError("late reference may not be specified using => lazy specifier: '" + member.getName() + "'");
                        }
                    }
                }
                if (!lazy || !parameterized) {
                    se.visit(this);
                }
                boolean constant = !this.isVariable() && !this.isLate();
                Scope scope = that.getScope();
                if (!constant || this.declaration.isDefinedInScope(scope)) {
                    if (!this.declared && constant) {
                        bme.addError(this.shortdesc() + " is not yet declared: '" + member.getName() + "'");
                    } else if (!(this.loopDepth <= 0 || !constant || this.endsInReturnThrow && this.lastContinue == null || this.endsInBreak && this.allOuterLoopsBreak && this.lastContinue == null)) {
                        if (this.specified.definitely) {
                            bme.addError(this.longdesc() + " is aready definitely specified: '" + member.getName() + "'", 803);
                        } else {
                            bme.addError(this.longdesc() + " is not definitely unspecified in loop: '" + member.getName() + "'", 803);
                            this.specify();
                        }
                    } else if (this.withinDeclaration && constant && !that.getRefinement()) {
                        Declaration dec = ModelUtil.getContainingDeclarationOfScope(scope);
                        if (dec != null && dec.equals(member)) {
                            bme.addError("cannot specify " + this.shortdesc() + " from within its own body: '" + member.getName() + "'");
                        } else {
                            bme.addError("cannot specify " + this.shortdesc() + " declared in outer scope: '" + member.getName() + "'", 803);
                        }
                    } else if (this.specified.possibly && constant) {
                        if (this.specified.definitely) {
                            bme.addError(this.longdesc() + " is aready definitely specified: '" + member.getName() + "'", 803);
                        } else {
                            bme.addError(this.longdesc() + " is not definitely unspecified: '" + member.getName() + "'", 803);
                            this.specify();
                        }
                    } else {
                        this.specify();
                        term.visit(this);
                    }
                }
                if (lazy && parameterized) {
                    se.visit(this);
                }
                this.checkDeclarationSection(that);
            } else {
                super.visit(that);
            }
        } else {
            super.visit(that);
        }
    }

    @Override
    public void visit(Tree.Declaration that) {
        boolean oe = this.endsInReturnThrow;
        boolean of = this.endsInBreak;
        Tree.Continue olc = this.lastContinue;
        this.lastContinue = null;
        this.endsInReturnThrow = false;
        this.endsInBreak = false;
        if (that.getDeclarationModel() == this.declaration) {
            this.loopDepth = 0;
            this.brokenLoopDepth = 0;
            this.beginDisabledSpecificationScope();
            this.declare();
            super.visit(that);
            this.endDisabledSpecificationScope(false);
            this.loopDepth = 0;
            this.brokenLoopDepth = 0;
        } else {
            int l = this.loopDepth;
            int bl = this.brokenLoopDepth;
            this.loopDepth = 0;
            this.brokenLoopDepth = 0;
            Scope scope = that.getScope();
            boolean constructor = scope instanceof Constructor;
            boolean valueWithInitializer = scope instanceof Value && !((Value)scope).isTransient();
            boolean c = false;
            if (!constructor) {
                c = this.beginDisabledSpecificationScope();
            }
            boolean d = this.beginDeclarationScope();
            SpecificationState as = !valueWithInitializer ? this.beginSpecificationScope() : null;
            super.visit(that);
            if (!constructor) {
                this.endDisabledSpecificationScope(c);
            }
            this.endDeclarationScope(d);
            if (!valueWithInitializer) {
                this.endSpecificationScope(as);
            }
            this.loopDepth = l;
            this.brokenLoopDepth = bl;
        }
        this.endsInReturnThrow = oe;
        this.endsInBreak = of;
        this.lastContinue = olc;
    }

    @Override
    public void visit(Tree.Constructor that) {
        Function f = that.getDeclarationModel();
        Constructor c = that.getConstructor();
        if (f == this.declaration || c == this.declaration) {
            this.declare();
            this.specify();
        }
        super.visit(that);
        if (this.declaration.getContainer() == c.getContainer() && that == this.lastConstructor && this.initedByEveryConstructor) {
            this.specified.definitely = true;
        }
    }

    @Override
    public void visit(Tree.Enumerated that) {
        Value v = that.getDeclarationModel();
        Constructor e = that.getEnumerated();
        if (v == this.declaration || e == this.declaration) {
            this.declare();
            this.specify();
        }
        super.visit(that);
        if (this.declaration.getContainer() == e.getContainer() && that == this.lastConstructor && this.initedByEveryConstructor) {
            this.specified.definitely = true;
        }
    }

    @Override
    public void visit(Tree.TypedArgument that) {
        if (that.getDeclarationModel() == this.declaration) {
            this.loopDepth = 0;
            this.brokenLoopDepth = 0;
            this.beginDisabledSpecificationScope();
            super.visit(that);
            this.declare();
            this.endDisabledSpecificationScope(false);
            this.loopDepth = 0;
            this.brokenLoopDepth = 0;
        } else {
            int l = this.loopDepth;
            int bl = this.brokenLoopDepth;
            this.loopDepth = 0;
            this.brokenLoopDepth = 0;
            boolean c = this.beginDisabledSpecificationScope();
            boolean d = this.beginDeclarationScope();
            SpecificationState as = this.beginSpecificationScope();
            super.visit(that);
            this.endDisabledSpecificationScope(c);
            this.endDeclarationScope(d);
            this.endSpecificationScope(as);
            this.loopDepth = l;
            this.brokenLoopDepth = bl;
        }
    }

    @Override
    public void visit(Tree.MethodDeclaration that) {
        if (that.getDeclarationModel() == this.declaration) {
            if (that.getSpecifierExpression() != null) {
                this.specify();
                super.visit(that);
            } else {
                super.visit(that);
                if (this.declaration.isToplevel() && !ModelUtil.isNativeHeader(this.declaration)) {
                    that.addError("toplevel function must be specified: '" + this.declaration.getName() + "' may not be forward declared");
                } else if (this.declaration.isClassMember() && !ModelUtil.isNativeHeader(this.declaration) && !this.declaration.isFormal() && that.getDeclarationModel().getInitializerParameter() == null && this.declarationSection) {
                    that.addError("forward declaration may not occur in declaration section: '" + this.declaration.getName() + "'", 1450);
                } else if (this.declaration.isInterfaceMember() && !ModelUtil.isNativeHeader(this.declaration) && !this.declaration.isFormal()) {
                    that.addError("interface method must be formal or specified: '" + this.declaration.getName() + "'", 1400);
                }
            }
        } else {
            super.visit(that);
        }
    }

    @Override
    public void visit(Tree.MethodDefinition that) {
        if (that.getDeclarationModel() == this.declaration) {
            this.declare();
            this.specify();
        }
        super.visit(that);
    }

    @Override
    public void visit(Tree.MethodArgument that) {
        if (that.getDeclarationModel() == this.declaration) {
            this.declare();
            this.specify();
        }
        super.visit(that);
    }

    @Override
    public void visit(Tree.Variable that) {
        super.visit(that);
        if (that.getDeclarationModel() == this.declaration) {
            this.specify();
        }
    }

    @Override
    public void visit(Tree.Parameter that) {
        Parameter oip = this.parameter;
        this.parameter = that.getParameterModel();
        super.visit(that);
        this.parameter = oip;
        if (that.getParameterModel().getModel() == this.declaration) {
            this.specify();
        }
    }

    @Override
    public void visit(Tree.InitializerParameter that) {
        super.visit(that);
        Parameter d = that.getParameterModel();
        Declaration a = that.getScope().getDirectMember(d.getName(), null, false);
        if (a != null && a == this.declaration) {
            this.specify();
            this.hasParameter = true;
        }
    }

    @Override
    public void visit(Tree.TypeParameterDeclaration that) {
        super.visit(that);
        if (that.getDeclarationModel() == this.declaration) {
            this.specify();
        }
    }

    @Override
    public void visit(Tree.AttributeDeclaration that) {
        if (that.getDeclarationModel() == this.declaration) {
            Tree.SpecifierOrInitializerExpression sie = that.getSpecifierOrInitializerExpression();
            if (sie != null) {
                super.visit(that);
                this.specify();
            } else {
                super.visit(that);
                if (this.declaration.isToplevel() && !ModelUtil.isNativeHeader(this.declaration) && !this.isLate()) {
                    if (this.isVariable()) {
                        that.addError("toplevel variable value must be initialized: '" + this.declaration.getName() + "'");
                    } else {
                        that.addError("toplevel value must be specified: '" + this.declaration.getName() + "'");
                    }
                } else if (this.declaration.isClassOrInterfaceMember() && !ModelUtil.isNativeHeader(this.declaration) && !this.declaration.isFormal() && that.getDeclarationModel().getInitializerParameter() == null && !that.getDeclarationModel().isLate() && this.declarationSection) {
                    that.addError("forward declaration may not occur in declaration section: '" + this.declaration.getName() + "'", 1450);
                }
            }
        } else {
            super.visit(that);
        }
    }

    @Override
    public void visit(Tree.AttributeGetterDefinition that) {
        if (that.getDeclarationModel() == this.declaration) {
            this.declare();
            super.visit(that);
            this.specify();
        } else {
            super.visit(that);
        }
    }

    @Override
    public void visit(Tree.AttributeSetterDefinition that) {
        Setter d = that.getDeclarationModel();
        if (d == this.declaration || d.getParameter().getModel() == this.declaration) {
            this.declare();
            this.specify();
        }
        super.visit(that);
    }

    @Override
    public void visit(Tree.AttributeArgument that) {
        if (that.getDeclarationModel() == this.declaration) {
            this.declare();
            this.specify();
        }
        super.visit(that);
    }

    @Override
    public void visit(Tree.ObjectDefinition that) {
        if (that.getDeclarationModel() == this.declaration) {
            this.declare();
            this.specify();
        }
        super.visit(that);
    }

    @Override
    public void visit(Tree.ObjectArgument that) {
        if (that.getDeclarationModel() == this.declaration) {
            this.declare();
            this.specify();
        }
        super.visit(that);
    }

    private Tree.Declaration getDeclaration(Tree.ClassBody that) {
        for (Tree.Statement s : that.getStatements()) {
            Tree.Declaration d;
            if (!(s instanceof Tree.Declaration) || (d = (Tree.Declaration)s).getDeclarationModel() != this.declaration) continue;
            return d;
        }
        return null;
    }

    @Override
    public void visit(Tree.ClassBody that) {
        if (that.getScope() == this.declaration.getContainer()) {
            Tree.Statement les = AnalyzerUtil.getLastExecutableStatement(that);
            Tree.Declaration lc = AnalyzerUtil.getLastConstructor(that);
            this.declarationSection = les == null;
            this.lastExecutableStatement = les;
            this.lastConstructor = lc;
            super.visit(that);
            this.declarationSection = false;
            this.lastExecutableStatement = null;
            this.lastConstructor = null;
            if (!this.declaration.isAnonymous() && this.isSharedDeclarationUninitialized()) {
                this.getDeclaration(that).addError("must be definitely specified by class initializer: " + AnalyzerUtil.message(this.declaration) + " is shared", 1401);
            }
        } else {
            super.visit(that);
        }
    }

    @Override
    public void visit(Tree.Statement that) {
        super.visit(that);
        this.checkDeclarationSection(that);
    }

    private void checkDeclarationSection(Tree.Statement that) {
        this.declarationSection = this.declarationSection || that == this.lastExecutableStatement;
    }

    @Override
    public void visit(Tree.ClassOrInterface that) {
        if (that.getDeclarationModel() == this.declaration) {
            this.declare();
            this.specify();
        }
        super.visit(that);
    }

    @Override
    public void visit(Tree.TypeAliasDeclaration that) {
        if (that.getDeclarationModel() == this.declaration) {
            this.declare();
            this.specify();
        }
        super.visit(that);
    }

    @Override
    public void visit(Tree.Return that) {
        super.visit(that);
        if (!this.withinDeclaration && this.isSharedDeclarationUninitialized()) {
            that.addError("must be definitely specified by class initializer: '" + AnalyzerUtil.message(this.declaration) + " is shared'");
        }
        this.exit();
    }

    private boolean isSharedDeclarationUninitialized() {
        return (this.declaration.isShared() || this.declaration.getOtherInstanceAccess()) && !this.declaration.isFormal() && !ModelUtil.isNativeHeader(this.declaration) && !this.isLate() && !this.specified.definitely;
    }

    @Override
    public void visit(Tree.Throw that) {
        super.visit(that);
        this.exit();
    }

    @Override
    public void visit(Tree.Assertion that) {
        super.visit(that);
        if (AnalyzerUtil.isNeverSatisfied(that.getConditionList())) {
            this.exit();
        }
    }

    @Override
    public void visit(Tree.Break that) {
        super.visit(that);
        this.exit();
        if (!this.specified.definitely) {
            this.specified.byLoopBreaks = false;
        }
    }

    @Override
    public void visit(Tree.Continue that) {
        super.visit(that);
        this.exit();
        if (this.lastContinue == that) {
            this.lastContinue = null;
        }
    }

    @Override
    public void visit(Tree.IfStatement that) {
        boolean specifiedByExitsFromElseClause;
        boolean possiblyExitedFromElseClause;
        boolean definitelyExitedFromElseClause;
        boolean possiblyAssignedByElseClause;
        boolean definitelyAssignedByElseClause;
        Tree.Block block;
        if (that == this.lastContinueStatement) {
            this.lastContinueStatement = null;
        }
        Tree.IfClause ifClause = that.getIfClause();
        Tree.ConditionList conditionList = ifClause.getConditionList();
        if (ifClause != null && conditionList != null) {
            conditionList.visit(this);
        }
        boolean d = this.beginDeclarationScope();
        SpecificationState as = this.beginSpecificationScope();
        if (ifClause != null && (block = ifClause.getBlock()) != null) {
            block.visit(this);
        }
        boolean definitelyAssignedByIfClause = this.specified.definitely || this.specified.definitelyExited;
        boolean possiblyAssignedByIfClause = this.specified.possibly;
        boolean possiblyExitedFromIfClause = this.specified.possiblyExited;
        boolean definitelyExitedFromIfClause = this.specified.definitelyExited;
        boolean specifiedByExitsFromIfClause = this.specified.byLoopBreaks;
        this.endDeclarationScope(d);
        this.endSpecificationScope(as);
        Tree.ElseClause elseClause = that.getElseClause();
        if (elseClause != null) {
            d = this.beginDeclarationScope();
            as = this.beginSpecificationScope();
            elseClause.visit(this);
            definitelyAssignedByElseClause = this.specified.definitely || this.specified.definitelyExited;
            possiblyAssignedByElseClause = this.specified.possibly;
            definitelyExitedFromElseClause = this.specified.definitelyExited;
            possiblyExitedFromElseClause = this.specified.possiblyExited;
            specifiedByExitsFromElseClause = this.specified.byLoopBreaks;
            this.endDeclarationScope(d);
            this.endSpecificationScope(as);
        } else {
            definitelyAssignedByElseClause = false;
            possiblyAssignedByElseClause = false;
            definitelyExitedFromElseClause = false;
            possiblyExitedFromElseClause = false;
            specifiedByExitsFromElseClause = true;
        }
        if (AnalyzerUtil.isAlwaysSatisfied(conditionList)) {
            this.specified.definitely = this.specified.definitely || definitelyAssignedByIfClause;
            this.specified.possibly = this.specified.possibly || possiblyAssignedByIfClause;
            this.specified.definitelyExited = this.specified.definitelyExited || definitelyExitedFromIfClause;
            this.specified.possiblyExited = this.specified.possiblyExited || possiblyExitedFromIfClause;
            this.specified.byLoopBreaks = this.specified.byLoopBreaks && specifiedByExitsFromIfClause;
        } else if (AnalyzerUtil.isNeverSatisfied(conditionList)) {
            this.specified.definitely = this.specified.definitely || definitelyAssignedByElseClause;
            this.specified.possibly = this.specified.possibly || possiblyAssignedByElseClause;
            this.specified.definitelyExited = this.specified.definitelyExited || definitelyExitedFromElseClause;
            this.specified.possiblyExited = this.specified.possiblyExited || possiblyExitedFromElseClause;
            this.specified.byLoopBreaks = this.specified.byLoopBreaks && specifiedByExitsFromElseClause;
        } else {
            this.specified.definitely = this.specified.definitely || definitelyAssignedByIfClause && definitelyAssignedByElseClause;
            this.specified.possibly = this.specified.possibly || possiblyAssignedByIfClause || possiblyAssignedByElseClause;
            this.specified.definitelyExited = this.specified.definitelyExited || definitelyExitedFromIfClause && definitelyExitedFromElseClause;
            this.specified.possiblyExited = this.specified.possiblyExited || possiblyExitedFromIfClause || possiblyExitedFromElseClause;
            this.specified.byLoopBreaks = this.specified.byLoopBreaks && specifiedByExitsFromIfClause && specifiedByExitsFromElseClause;
        }
        this.checkDeclarationSection(that);
    }

    @Override
    public void visit(Tree.TryCatchStatement that) {
        boolean specifiedByExitsFromFinallyClause;
        boolean possiblyExitedFromFinallyClause;
        boolean definitelyExitedFromFinallyClause;
        boolean possiblyAssignedByFinallyClause;
        boolean definitelyAssignedByFinallyClause;
        if (that == this.lastContinueStatement) {
            this.lastContinueStatement = null;
        }
        boolean d = this.beginDeclarationScope();
        SpecificationState as = this.beginSpecificationScope();
        Tree.TryClause tryClause = that.getTryClause();
        if (tryClause != null) {
            tryClause.visit(this);
        }
        boolean definitelyAssignedByTryClause = this.specified.definitely || this.specified.definitelyExited;
        boolean possiblyAssignedByTryClause = this.specified.possibly;
        boolean possiblyExitedFromTryClause = this.specified.possiblyExited;
        boolean specifiedByExitsFromTryClause = this.specified.byLoopBreaks;
        this.endDeclarationScope(d);
        this.endSpecificationScope(as);
        this.specified.possibly = this.specified.possibly || possiblyAssignedByTryClause;
        this.specified.possiblyExited = this.specified.possiblyExited || possiblyExitedFromTryClause;
        boolean definitelyAssignedByEveryCatchClause = true;
        boolean possiblyAssignedBySomeCatchClause = false;
        boolean definitelyExitedFromEveryCatchClause = true;
        boolean possiblyExitedFromSomeCatchClause = false;
        boolean specifiedByExitsFromEveryCatchClause = true;
        for (Tree.CatchClause cc : that.getCatchClauses()) {
            d = this.beginDeclarationScope();
            as = this.beginSpecificationScope();
            cc.visit(this);
            definitelyAssignedByEveryCatchClause = definitelyAssignedByEveryCatchClause && (this.specified.definitely || this.specified.definitelyExited);
            possiblyAssignedBySomeCatchClause = possiblyAssignedBySomeCatchClause || this.specified.possibly;
            definitelyExitedFromEveryCatchClause = definitelyExitedFromEveryCatchClause && this.specified.definitelyExited;
            possiblyExitedFromSomeCatchClause = possiblyExitedFromSomeCatchClause || this.specified.possiblyExited;
            specifiedByExitsFromEveryCatchClause = specifiedByExitsFromEveryCatchClause && this.specified.byLoopBreaks;
            this.endDeclarationScope(d);
            this.endSpecificationScope(as);
        }
        this.specified.possibly = this.specified.possibly || possiblyAssignedBySomeCatchClause;
        this.specified.possiblyExited = this.specified.possiblyExited || possiblyExitedFromSomeCatchClause;
        Tree.FinallyClause finallyClause = that.getFinallyClause();
        if (finallyClause != null) {
            d = this.beginDeclarationScope();
            as = this.beginSpecificationScope();
            finallyClause.visit(this);
            definitelyAssignedByFinallyClause = this.specified.definitely || this.specified.definitelyExited;
            possiblyAssignedByFinallyClause = this.specified.possibly;
            definitelyExitedFromFinallyClause = this.specified.definitelyExited;
            possiblyExitedFromFinallyClause = this.specified.possiblyExited;
            specifiedByExitsFromFinallyClause = this.specified.byLoopBreaks;
            this.endDeclarationScope(d);
            this.endSpecificationScope(as);
        } else {
            definitelyAssignedByFinallyClause = false;
            possiblyAssignedByFinallyClause = false;
            definitelyExitedFromFinallyClause = false;
            possiblyExitedFromFinallyClause = false;
            specifiedByExitsFromFinallyClause = true;
        }
        this.specified.possibly = this.specified.possibly || possiblyAssignedByFinallyClause;
        this.specified.definitely = this.specified.definitely || definitelyAssignedByFinallyClause || definitelyAssignedByTryClause && definitelyAssignedByEveryCatchClause;
        this.specified.definitelyExited = this.specified.definitelyExited && definitelyExitedFromFinallyClause;
        this.specified.possiblyExited = this.specified.possiblyExited || possiblyExitedFromFinallyClause;
        this.specified.byLoopBreaks = this.specified.byLoopBreaks || specifiedByExitsFromFinallyClause || specifiedByExitsFromEveryCatchClause && specifiedByExitsFromTryClause;
        this.checkDeclarationSection(that);
    }

    @Override
    public void visit(Tree.SwitchStatement that) {
        Tree.SwitchClause switchClause;
        if (that == this.lastContinueStatement) {
            this.lastContinueStatement = null;
        }
        if ((switchClause = that.getSwitchClause()) != null) {
            switchClause.visit(this);
        }
        boolean definitelyAssignedByEveryCaseClause = true;
        boolean possiblyAssignedBySomeCaseClause = false;
        boolean definitelyExitedFromEveryCaseClause = false;
        boolean possiblyExitedFromSomeCaseClause = false;
        boolean specifiedByExitsFromEveryCaseClause = true;
        Tree.SwitchCaseList switchCaseList = that.getSwitchCaseList();
        for (Tree.CaseClause cc : switchCaseList.getCaseClauses()) {
            boolean d = this.beginDeclarationScope();
            SpecificationState as = this.beginSpecificationScope();
            cc.visit(this);
            definitelyAssignedByEveryCaseClause = definitelyAssignedByEveryCaseClause && (this.specified.definitely || this.specified.definitelyExited);
            possiblyAssignedBySomeCaseClause = possiblyAssignedBySomeCaseClause || this.specified.possibly;
            definitelyExitedFromEveryCaseClause = definitelyExitedFromEveryCaseClause && this.specified.definitelyExited;
            possiblyExitedFromSomeCaseClause = possiblyExitedFromSomeCaseClause || this.specified.possiblyExited;
            specifiedByExitsFromEveryCaseClause = specifiedByExitsFromEveryCaseClause && this.specified.byLoopBreaks;
            this.endDeclarationScope(d);
            this.endSpecificationScope(as);
        }
        Tree.ElseClause elseClause = switchCaseList.getElseClause();
        if (elseClause != null) {
            boolean d = this.beginDeclarationScope();
            SpecificationState as = this.beginSpecificationScope();
            elseClause.visit(this);
            definitelyAssignedByEveryCaseClause = definitelyAssignedByEveryCaseClause && (this.specified.definitely || this.specified.definitelyExited);
            possiblyAssignedBySomeCaseClause = possiblyAssignedBySomeCaseClause || this.specified.possibly;
            definitelyExitedFromEveryCaseClause = definitelyExitedFromEveryCaseClause && this.specified.definitelyExited;
            possiblyExitedFromSomeCaseClause = possiblyExitedFromSomeCaseClause || this.specified.possiblyExited;
            specifiedByExitsFromEveryCaseClause = specifiedByExitsFromEveryCaseClause && this.specified.byLoopBreaks;
            this.endDeclarationScope(d);
            this.endSpecificationScope(as);
        }
        this.specified.possibly = this.specified.possibly || possiblyAssignedBySomeCaseClause;
        this.specified.definitely = this.specified.definitely || definitelyAssignedByEveryCaseClause;
        this.specified.definitelyExited = this.specified.definitelyExited && definitelyExitedFromEveryCaseClause;
        this.specified.possiblyExited = this.specified.possiblyExited || possiblyExitedFromSomeCaseClause;
        this.specified.byLoopBreaks = this.specified.byLoopBreaks && specifiedByExitsFromEveryCaseClause;
        this.checkDeclarationSection(that);
    }

    @Override
    public void visit(Tree.WhileStatement that) {
        Tree.WhileClause whileClause = that.getWhileClause();
        Tree.ConditionList conditionList = whileClause.getConditionList();
        if (conditionList != null) {
            conditionList.visit(this);
        }
        boolean d = this.beginDeclarationScope();
        SpecificationState as = this.beginSpecificationScope();
        Tree.Block block = whileClause.getBlock();
        if (block != null) {
            if (this.isVariable() || this.isLate()) {
                block.visit(this);
            } else {
                boolean aolb = this.allOuterLoopsBreak;
                this.allOuterLoopsBreak = this.loopDepth == this.brokenLoopDepth;
                boolean broken = this.blockEndsInBreak(block);
                if (broken) {
                    ++this.brokenLoopDepth;
                }
                ++this.loopDepth;
                block.visit(this);
                if (broken) {
                    --this.brokenLoopDepth;
                }
                --this.loopDepth;
                this.allOuterLoopsBreak = aolb;
            }
        }
        boolean definitelyAssignedByWhileClause = this.specified.definitely || this.specified.definitelyExited;
        boolean possiblyAssignedByWhileClause = this.specified.possibly;
        boolean specifiedByLoopBreaks = this.specified.byLoopBreaks;
        this.endDeclarationScope(d);
        this.endSpecificationScope(as);
        if (AnalyzerUtil.isAlwaysSatisfied(conditionList)) {
            this.specified.definitely = this.specified.definitely || specifiedByLoopBreaks || definitelyAssignedByWhileClause;
            this.specified.possibly = this.specified.possibly || possiblyAssignedByWhileClause;
        } else if (!AnalyzerUtil.isNeverSatisfied(conditionList)) {
            this.specified.possibly = this.specified.possibly || possiblyAssignedByWhileClause;
        }
        this.checkDeclarationSection(that);
    }

    @Override
    public void visit(Tree.ForStatement that) {
        boolean possiblyAssignedByElseClause;
        boolean definitelyAssignedByElseClause;
        boolean d = this.beginDeclarationScope();
        SpecificationState as = this.beginSpecificationScope();
        boolean atLeastOneIteration = false;
        Tree.ForClause forClause = that.getForClause();
        Tree.Block block = forClause.getBlock();
        if (block != null) {
            if (this.isVariable() || this.isLate()) {
                forClause.visit(this);
            } else {
                boolean aolb = this.allOuterLoopsBreak;
                this.allOuterLoopsBreak = this.loopDepth == this.brokenLoopDepth;
                boolean broken = this.blockEndsInBreak(block);
                if (broken) {
                    ++this.brokenLoopDepth;
                }
                ++this.loopDepth;
                forClause.visit(this);
                if (broken) {
                    --this.brokenLoopDepth;
                }
                --this.loopDepth;
                this.allOuterLoopsBreak = aolb;
            }
        }
        atLeastOneIteration = AnalyzerUtil.isAtLeastOne(forClause);
        boolean possiblyAssignedByForClause = this.specified.possibly;
        boolean definitelyAssignedByForClause = this.specified.definitely;
        boolean possiblyExitedFromForClause = this.specified.possiblyExited;
        boolean specifiedByLoopBreaks = this.specified.byLoopBreaks;
        this.endDeclarationScope(d);
        this.endSpecificationScope(as);
        Tree.ElseClause elseClause = that.getElseClause();
        if (elseClause != null) {
            d = this.beginDeclarationScope();
            as = this.beginSpecificationScope();
            elseClause.visit(this);
            definitelyAssignedByElseClause = this.specified.definitely || this.specified.definitelyExited;
            possiblyAssignedByElseClause = this.specified.possibly;
            this.endDeclarationScope(d);
            this.endSpecificationScope(as);
        } else {
            definitelyAssignedByElseClause = false;
            possiblyAssignedByElseClause = false;
        }
        this.specified.definitely = this.specified.definitely || !possiblyExitedFromForClause && definitelyAssignedByElseClause || atLeastOneIteration && definitelyAssignedByForClause || definitelyAssignedByElseClause && specifiedByLoopBreaks;
        this.specified.possibly = this.specified.possibly || possiblyAssignedByForClause || possiblyAssignedByElseClause;
        this.checkDeclarationSection(that);
    }

    class SpecificationState {
        boolean definitely;
        boolean possibly;
        boolean possiblyExited;
        boolean definitelyExited;
        boolean byLoopBreaks;

        SpecificationState(boolean definitely, boolean possibly) {
            this.definitely = definitely;
            this.possibly = possibly;
            this.possiblyExited = false;
            this.definitelyExited = false;
            this.byLoopBreaks = true;
        }
    }

    private final class ContinueVisitor
    extends Visitor {
        Tree.Continue node;
        boolean found;
        Tree.Statement lastContinue;

        ContinueVisitor(Tree.Statement lastContinue) {
            this.lastContinue = lastContinue;
            this.node = null;
            this.found = false;
        }

        @Override
        public void visit(Tree.Declaration that) {
        }

        @Override
        public void visit(Tree.WhileStatement that) {
        }

        @Override
        public void visit(Tree.ForStatement that) {
        }

        @Override
        public void visit(Tree.Continue that) {
            this.node = that;
            if (that == this.lastContinue) {
                this.found = true;
            }
        }
    }
}

