/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.typechecker.analyzer;

import com.redhat.ceylon.compiler.typechecker.analyzer.AnalyzerUtil;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.Functional;
import com.redhat.ceylon.model.typechecker.model.Generic;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.ParameterList;
import com.redhat.ceylon.model.typechecker.model.Reference;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.SiteVariance;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypedReference;
import com.redhat.ceylon.model.typechecker.model.Unit;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TypeArgumentInference {
    private Unit unit;

    public TypeArgumentInference(Unit unit) {
        this.unit = unit;
    }

    private Type unionOrIntersection(boolean findingUpperBounds, List<Type> inferredTypes) {
        if (findingUpperBounds) {
            return ModelUtil.canonicalIntersection(inferredTypes, this.unit);
        }
        return ModelUtil.union(inferredTypes, this.unit);
    }

    private Type unionOrIntersectionOrNull(boolean findingUpperBounds, List<Type> inferredTypes) {
        if (inferredTypes.isEmpty()) {
            return null;
        }
        return this.unionOrIntersection(findingUpperBounds, inferredTypes);
    }

    private void addToUnionOrIntersection(boolean findingUpperBounds, List<Type> list, Type pt) {
        if (findingUpperBounds) {
            ModelUtil.addToIntersection(list, pt, this.unit);
        } else {
            ModelUtil.addToUnion(list, pt);
        }
    }

    private Type unionOrNull(List<Type> types) {
        if (types.isEmpty()) {
            return null;
        }
        return ModelUtil.union(types, this.unit);
    }

    private Type intersectionOrNull(List<Type> types) {
        if (types.isEmpty()) {
            return null;
        }
        return ModelUtil.canonicalIntersection(types, this.unit);
    }

    private Type inferTypeArg(TypeParameter tp, Type template, Type type, boolean findingUpperBounds, Node node) {
        return this.inferTypeArg(tp, template, type, true, false, findingUpperBounds, new ArrayList<TypeParameter>(), node);
    }

    private Type inferTypeArg(TypeParameter tp, Type paramType, Type argType, boolean covariant, boolean contravariant, boolean findingUpperBounds, List<TypeParameter> visited, Node argNode) {
        if (paramType != null && argType != null) {
            paramType = paramType.resolveAliases();
            argType = argType.resolveAliases();
            TypeDeclaration paramTypeDec = paramType.getDeclaration();
            Map<TypeParameter, Type> paramTypeArgs = paramType.getTypeArguments();
            Map<TypeParameter, SiteVariance> paramVariances = paramType.getVarianceOverrides();
            if (paramType.isTypeParameter() && paramTypeDec.equals(tp)) {
                if (tp.isTypeConstructor()) {
                    if (argType.isTypeConstructor()) {
                        return argType;
                    }
                    return null;
                }
                if (findingUpperBounds && covariant || !findingUpperBounds && contravariant) {
                    return null;
                }
                if (argType.isUnknown()) {
                    if (argNode.getErrors().isEmpty()) {
                        argNode.addError("argument of unknown type assigned to inferred type parameter: '" + tp.getName() + "' of '" + tp.getDeclaration().getName(this.unit) + "'");
                    }
                    return null;
                }
                return this.unit.denotableType(argType);
            }
            if (paramType.isTypeParameter() && !paramTypeDec.isParameterized()) {
                TypeParameter tp2 = (TypeParameter)paramTypeDec;
                if (!findingUpperBounds && !visited.contains(tp2)) {
                    visited.add(tp2);
                    List<Type> sts = tp2.getSatisfiedTypes();
                    ArrayList<Type> list = new ArrayList<Type>(sts.size());
                    for (Type upperBound : sts) {
                        this.addToUnionOrIntersection(findingUpperBounds, list, this.inferTypeArg(tp, upperBound, argType, covariant, contravariant, findingUpperBounds, visited, argNode));
                    }
                    visited.remove(tp2);
                    return this.unionOrIntersectionOrNull(findingUpperBounds, list);
                }
                return null;
            }
            if (paramType.isUnion()) {
                Type pt = paramType;
                Type apt = argType;
                if (argType.isUnion()) {
                    for (Type act : argType.getCaseTypes()) {
                        if (act.involvesDeclaration(tp) || !act.substitute(argType).isSubtypeOf(paramType)) continue;
                        pt = pt.shallowMinus(act);
                        apt = apt.shallowMinus(act);
                    }
                }
                if (pt.isUnion()) {
                    boolean found = false;
                    for (Type ct : pt.getCaseTypes()) {
                        if (!ct.isTypeParameter()) continue;
                        if (found) {
                            return null;
                        }
                        found = true;
                    }
                    Map<TypeParameter, Type> args = pt.getTypeArguments();
                    Map<TypeParameter, SiteVariance> variances = pt.getVarianceOverrides();
                    List<Type> cts = pt.getCaseTypes();
                    ArrayList<Type> list = new ArrayList<Type>(cts.size());
                    for (Type ct : cts) {
                        this.addToUnionOrIntersection(findingUpperBounds, list, this.inferTypeArg(tp, ct.substitute(args, variances), apt, covariant, contravariant, findingUpperBounds, visited, argNode));
                    }
                    return this.unionOrIntersectionOrNull(findingUpperBounds, list);
                }
                return this.inferTypeArg(tp, pt, apt, covariant, contravariant, findingUpperBounds, visited, argNode);
            }
            if (paramType.isIntersection()) {
                List<Type> sts = paramTypeDec.getSatisfiedTypes();
                ArrayList<Type> list = new ArrayList<Type>(sts.size());
                for (Type ct : sts) {
                    this.addToUnionOrIntersection(findingUpperBounds, list, this.inferTypeArg(tp, ct.substitute(paramTypeArgs, paramVariances), argType, covariant, contravariant, findingUpperBounds, visited, argNode));
                }
                return this.unionOrIntersectionOrNull(findingUpperBounds, list);
            }
            if (argType.isUnion()) {
                List<Type> cts = argType.getCaseTypes();
                ArrayList<Type> list = new ArrayList<Type>(cts.size());
                for (Type ct : cts) {
                    ModelUtil.addToUnion(list, this.inferTypeArg(tp, paramType, ct.substitute(paramTypeArgs, paramVariances), covariant, contravariant, findingUpperBounds, visited, argNode));
                }
                return this.unionOrNull(list);
            }
            if (argType.isIntersection()) {
                List<Type> sts = argType.getSatisfiedTypes();
                ArrayList<Type> list = new ArrayList<Type>(sts.size());
                for (Type st : sts) {
                    ModelUtil.addToIntersection(list, this.inferTypeArg(tp, paramType, st.substitute(paramTypeArgs, paramVariances), covariant, contravariant, findingUpperBounds, visited, argNode), this.unit);
                }
                return this.intersectionOrNull(list);
            }
            Type supertype = argType.getSupertype(paramTypeDec);
            if (supertype != null) {
                ArrayList<Type> list = new ArrayList<Type>(2);
                Type pqt = paramType.getQualifyingType();
                Type sqt = supertype.getQualifyingType();
                if (pqt != null && sqt != null) {
                    this.addToUnionOrIntersection(findingUpperBounds, list, this.inferTypeArg(tp, pqt, sqt, covariant, contravariant, findingUpperBounds, visited, argNode));
                }
                this.inferTypeArg(tp, paramType, supertype, covariant, contravariant, findingUpperBounds, list, visited, argNode);
                return this.unionOrIntersectionOrNull(findingUpperBounds, list);
            }
            return null;
        }
        return null;
    }

    private void inferTypeArg(TypeParameter tp, Type paramType, Type supertype, boolean covariant, boolean contravariant, boolean findingUpperBounds, List<Type> list, List<TypeParameter> visited, Node argNode) {
        List<TypeParameter> typeParameters = paramType.getDeclaration().getTypeParameters();
        List<Type> paramTypeArgs = paramType.getTypeArgumentList();
        List<Type> superTypeArgs = supertype.getTypeArgumentList();
        for (int j = 0; j < paramTypeArgs.size() && j < superTypeArgs.size() && j < typeParameters.size(); ++j) {
            boolean contra;
            boolean co;
            Type paramTypeArg = paramTypeArgs.get(j);
            Type argTypeArg = superTypeArgs.get(j);
            TypeParameter typeParameter = typeParameters.get(j);
            if (paramType.isCovariant(typeParameter)) {
                co = covariant;
                contra = contravariant;
            } else if (paramType.isContravariant(typeParameter)) {
                if (covariant | contravariant) {
                    co = !covariant;
                    contra = !contravariant;
                } else {
                    co = false;
                    contra = false;
                }
            } else {
                co = false;
                contra = false;
            }
            this.addToUnionOrIntersection(findingUpperBounds, list, this.inferTypeArg(tp, paramTypeArg, argTypeArg, co, contra, findingUpperBounds, visited, argNode));
        }
    }

    private Type inferTypeArgumentFromNamedArgs(TypeParameter tp, ParameterList parameters, Type qt, Tree.NamedArgumentList nal, Declaration invoked) {
        boolean findingUpperBounds = this.isEffectivelyContravariant(tp, invoked, TypeArgumentInference.specifiedParameters(nal, parameters));
        List<Tree.NamedArgument> namedArgs = nal.getNamedArguments();
        HashSet<Parameter> foundParameters = new HashSet<Parameter>();
        ArrayList<Type> inferredTypes = new ArrayList<Type>(namedArgs.size());
        for (Tree.NamedArgument arg : namedArgs) {
            this.inferTypeArgFromNamedArg(arg, tp, qt, parameters, findingUpperBounds, inferredTypes, invoked, foundParameters);
        }
        Parameter sp = AnalyzerUtil.getUnspecifiedParameter(null, parameters, foundParameters);
        if (sp != null) {
            Tree.SequencedArgument sarg = nal.getSequencedArgument();
            this.inferTypeArgFromSequencedArg(sarg, tp, sp, findingUpperBounds, inferredTypes, sarg);
        }
        return this.unionOrIntersection(findingUpperBounds, inferredTypes);
    }

    private void inferTypeArgFromSequencedArg(Tree.SequencedArgument sa, TypeParameter tp, Parameter sp, boolean findingUpperBounds, List<Type> inferredTypes, Node argNode) {
        Type att;
        if (sa == null) {
            att = this.unit.getEmptyType();
        } else {
            List<Tree.PositionalArgument> args = sa.getPositionalArguments();
            att = AnalyzerUtil.getTupleType(args, this.unit, false);
        }
        Type spt = sp.getType();
        this.addToUnionOrIntersection(findingUpperBounds, inferredTypes, this.inferTypeArg(tp, spt, att, findingUpperBounds, argNode));
    }

    private void inferTypeArgFromNamedArg(Tree.NamedArgument arg, TypeParameter tp, Type receiverType, ParameterList parameters, boolean findingUpperBounds, List<Type> inferredTypes, Declaration invoked, Set<Parameter> foundParameters) {
        Parameter parameter;
        Type type = null;
        if (arg instanceof Tree.SpecifiedArgument) {
            Tree.SpecifiedArgument sa = (Tree.SpecifiedArgument)arg;
            Tree.SpecifierExpression se = sa.getSpecifierExpression();
            Tree.Expression e = se.getExpression();
            if (e != null) {
                type = e.getTypeModel();
            }
        } else if (arg instanceof Tree.TypedArgument) {
            Tree.TypedArgument ta = (Tree.TypedArgument)arg;
            type = ta.getDeclarationModel().getTypedReference().getFullType();
        }
        if (type != null && (parameter = AnalyzerUtil.getMatchingParameter(parameters, arg, foundParameters)) != null) {
            foundParameters.add(parameter);
            Type paramType = this.parameterType(receiverType, parameter, invoked);
            this.addToUnionOrIntersection(findingUpperBounds, inferredTypes, this.inferTypeArg(tp, paramType, type, findingUpperBounds, arg));
        }
    }

    private Type inferTypeArgumentFromPositionalArgs(TypeParameter tp, ParameterList parameters, Type receiverType, Tree.PositionalArgumentList pal, Declaration invoked) {
        boolean findingUpperBounds = this.isEffectivelyContravariant(tp, invoked, TypeArgumentInference.specifiedParameters(pal, parameters));
        List<Tree.PositionalArgument> args = pal.getPositionalArguments();
        ArrayList<Type> inferredTypes = new ArrayList<Type>(args.size());
        List<Parameter> params = parameters.getParameters();
        for (int i = 0; i < params.size(); ++i) {
            Parameter parameter = params.get(i);
            if (args.size() <= i) continue;
            Tree.PositionalArgument arg = args.get(i);
            Type at = arg.getTypeModel();
            if (arg instanceof Tree.SpreadArgument) {
                at = AnalyzerUtil.spreadType(at, this.unit, true);
                List<Parameter> subList = params.subList(i, params.size());
                Type parameterTypeTuple = this.unit.getParameterTypesAsTupleType(subList, receiverType);
                this.addToUnionOrIntersection(findingUpperBounds, inferredTypes, this.inferTypeArg(tp, parameterTypeTuple, at, findingUpperBounds, pal));
                continue;
            }
            if (arg instanceof Tree.Comprehension) {
                if (!parameter.isSequenced()) continue;
                Tree.Comprehension c = (Tree.Comprehension)arg;
                this.inferTypeArgFromComprehension(tp, parameter, c, findingUpperBounds, inferredTypes);
                continue;
            }
            if (parameter.isSequenced()) {
                this.inferTypeArgFromPositionalArgs(tp, parameter, args.subList(i, args.size()), findingUpperBounds, inferredTypes);
                break;
            }
            Type parameterType = this.parameterType(receiverType, parameter, invoked);
            this.addToUnionOrIntersection(findingUpperBounds, inferredTypes, this.inferTypeArg(tp, parameterType, at, findingUpperBounds, pal));
        }
        return this.unionOrIntersection(findingUpperBounds, inferredTypes);
    }

    private Type parameterType(Type receiverType, Parameter parameter, Declaration invoked) {
        if (receiverType == null || !invoked.isClassOrInterfaceMember() || this.unit.isCallableType(receiverType)) {
            return parameter.getModel().getReference().getFullType();
        }
        Type supertype = TypeArgumentInference.getDeclaringSupertype(receiverType, invoked);
        if (supertype == null) {
            return null;
        }
        return supertype.getTypedParameter(parameter).getFullType();
    }

    private static Type getDeclaringSupertype(Type qualifyingType, Declaration invoked) {
        Scope supertypeDec;
        if (ModelUtil.isConstructor(invoked)) {
            Scope container = invoked.getContainer();
            if (container instanceof Declaration) {
                invoked = (Declaration)((Object)container);
            } else {
                return null;
            }
        }
        if ((supertypeDec = invoked.getContainer()) instanceof TypeDeclaration) {
            return qualifyingType.getSupertype((TypeDeclaration)supertypeDec);
        }
        return null;
    }

    private Type inferTypeArgumentFromPositionalArgs(TypeParameter tp, List<Type> paramTypes, Type paramTypesAsTuple, boolean sequenced, Type qt, Tree.PositionalArgumentList pal, boolean findingUpperBounds) {
        List<Tree.PositionalArgument> args = pal.getPositionalArguments();
        ArrayList<Type> inferredTypes = new ArrayList<Type>();
        int paramSize = paramTypes.size();
        int argCount = args.size();
        for (int i = 0; i < paramSize && i < argCount; ++i) {
            Type pt = paramTypes.get(i);
            Tree.PositionalArgument arg = args.get(i);
            Type at = arg.getTypeModel();
            if (arg instanceof Tree.SpreadArgument) {
                Type tailType = this.unit.getTailType(paramTypesAsTuple, i);
                this.addToUnionOrIntersection(findingUpperBounds, inferredTypes, this.inferTypeArg(tp, tailType, at, findingUpperBounds, pal));
                continue;
            }
            if (arg instanceof Tree.Comprehension) {
                if (!sequenced || i != paramSize - 1) break;
                Type set = pt == null ? null : this.unit.getIteratedType(pt);
                this.addToUnionOrIntersection(findingUpperBounds, inferredTypes, this.inferTypeArg(tp, set, at, findingUpperBounds, pal));
                break;
            }
            if (sequenced && i == paramSize - 1) {
                for (int j = i; j < argCount; ++j) {
                    Type spt = this.unit.getSequentialElementType(pt);
                    Type vat = args.get(j).getTypeModel();
                    this.addToUnionOrIntersection(findingUpperBounds, inferredTypes, this.inferTypeArg(tp, spt, vat, findingUpperBounds, pal));
                }
                continue;
            }
            this.addToUnionOrIntersection(findingUpperBounds, inferredTypes, this.inferTypeArg(tp, pt, at, findingUpperBounds, pal));
        }
        return this.unionOrIntersection(findingUpperBounds, inferredTypes);
    }

    private void inferTypeArgFromPositionalArgs(TypeParameter tp, Parameter parameter, List<Tree.PositionalArgument> args, boolean findingUpperBounds, List<Type> inferredTypes) {
        for (int k = 0; k < args.size(); ++k) {
            Tree.PositionalArgument pa = args.get(k);
            Type sat = pa.getTypeModel();
            if (sat == null) continue;
            Type pt = parameter.getType();
            if (pa instanceof Tree.SpreadArgument) {
                sat = AnalyzerUtil.spreadType(sat, this.unit, true);
                this.addToUnionOrIntersection(findingUpperBounds, inferredTypes, this.inferTypeArg(tp, pt, sat, findingUpperBounds, pa));
                continue;
            }
            Type spt = this.unit.getIteratedType(pt);
            this.addToUnionOrIntersection(findingUpperBounds, inferredTypes, this.inferTypeArg(tp, spt, sat, findingUpperBounds, pa));
        }
    }

    private void inferTypeArgFromComprehension(TypeParameter tp, Parameter parameter, Tree.Comprehension c, boolean findingUpperBounds, List<Type> inferredTypes) {
        Type sat = c.getTypeModel();
        Type pt = parameter.getType();
        if (sat != null && pt != null) {
            Type spt = this.unit.getIteratedType(pt);
            this.addToUnionOrIntersection(findingUpperBounds, inferredTypes, this.inferTypeArg(tp, spt, sat, findingUpperBounds, c));
        }
    }

    List<Type> getInferredTypeArgsForFunctionRef(Tree.StaticMemberOrTypeExpression smte, Type receiverType) {
        Tree.TypeArguments typeArguments = smte.getTypeArguments();
        if (typeArguments instanceof Tree.InferredTypeArguments) {
            Declaration parameterizedDec;
            TypedDeclaration paramDec;
            Declaration reference = smte.getDeclaration();
            List<TypeParameter> typeParameters = this.getTypeParametersAccountingForTypeConstructor(reference);
            if (typeParameters == null || typeParameters.isEmpty()) {
                return AnalyzerUtil.NO_TYPE_ARGS;
            }
            TypedReference paramTypedRef = smte.getTargetParameter();
            Type paramType = smte.getParameterType();
            if (paramType == null && paramTypedRef != null) {
                paramType = paramTypedRef.getFullType();
            }
            if (paramType == null) {
                return null;
            }
            if (TypeArgumentInference.isArgumentToGenericParameter(paramTypedRef, paramType)) {
                return null;
            }
            if (paramTypedRef != null) {
                paramDec = paramTypedRef.getDeclaration();
                parameterizedDec = (Declaration)((Object)paramDec.getContainer());
            } else {
                paramDec = null;
                parameterizedDec = null;
            }
            Reference arg = this.appliedReference(smte);
            if (!smte.getStaticMethodReferencePrimary() && reference instanceof Functional && paramDec instanceof Functional && paramTypedRef != null) {
                Functional fun = (Functional)((Object)reference);
                List<ParameterList> apls = fun.getParameterLists();
                Functional pfun = (Functional)((Object)paramDec);
                List<ParameterList> ppls = pfun.getParameterLists();
                if (apls.isEmpty() || ppls.isEmpty()) {
                    return null;
                }
                ParameterList aplf = apls.get(0);
                ParameterList pplf = ppls.get(0);
                List<Parameter> apl = aplf.getParameters();
                List<Parameter> ppl = pplf.getParameters();
                boolean[] specifiedParams = TypeArgumentInference.specifiedParameters(apl.size(), ppl.size());
                ArrayList<Type> inferredTypes = new ArrayList<Type>(typeParameters.size());
                for (TypeParameter tp : typeParameters) {
                    boolean findUpperBounds = this.isEffectivelyContravariant(tp, reference, specifiedParams);
                    Type it = this.inferFunctionRefTypeArg(smte, typeParameters, paramTypedRef, parameterizedDec, arg, apl, ppl, tp, findUpperBounds);
                    inferredTypes.add(it);
                }
                return this.constrainInferredTypes(typeParameters, inferredTypes, receiverType, reference);
            }
            if (this.unit.isSequentialType(paramType)) {
                paramType = this.unit.getSequentialElementType(paramType);
            }
            if (this.unit.isCallableType(paramType)) {
                Type fullType;
                Type parameterListType;
                if (smte.getStaticMethodReferencePrimary()) {
                    Type type = arg.getType();
                    Type et = this.unit.getEmptyType();
                    parameterListType = ModelUtil.appliedType((TypeDeclaration)this.unit.getTupleDeclaration(), type, type, et);
                    fullType = ModelUtil.appliedType((TypeDeclaration)this.unit.getCallableDeclaration(), type, parameterListType);
                } else {
                    fullType = arg.getFullType();
                    parameterListType = this.unit.getCallableTuple(fullType);
                }
                Type argumentListType = this.unit.getCallableTuple(paramType);
                int argCount = this.unit.getTupleElementTypes(argumentListType).size();
                ArrayList<Type> inferredTypes = new ArrayList<Type>(typeParameters.size());
                for (TypeParameter tp : typeParameters) {
                    boolean findUpperBounds = this.isEffectivelyContravariant(tp, fullType, argCount);
                    Type it = this.inferFunctionRefTypeArg(smte, typeParameters, parameterizedDec, parameterListType, argumentListType, tp, findUpperBounds);
                    inferredTypes.add(it);
                }
                return this.constrainInferredTypes(typeParameters, inferredTypes, receiverType, reference);
            }
            return null;
        }
        return null;
    }

    private static boolean isArgumentToGenericParameter(TypedReference paramTypedRef, Type paramType) {
        return paramType.resolveAliases().isTypeConstructor() || paramTypedRef != null && AnalyzerUtil.isGeneric(paramTypedRef.getDeclaration());
    }

    private Type inferFunctionRefTypeArg(Tree.StaticMemberOrTypeExpression smte, List<TypeParameter> typeParams, TypedReference param, Declaration pd, Reference arg, List<Parameter> apl, List<Parameter> ppl, TypeParameter tp, boolean findingUpperBounds) {
        ArrayList<Type> list = new ArrayList<Type>();
        for (int i = 0; i < apl.size() && i < ppl.size(); ++i) {
            Parameter ap = apl.get(i);
            Parameter pp = ppl.get(i);
            Type type = param.getTypedParameter(pp).getFullType();
            Type template = arg.getTypedParameter(ap).getFullType();
            Type it = this.inferTypeArg(tp, template, type, findingUpperBounds, smte);
            if (ModelUtil.isTypeUnknown(it) || AnalyzerUtil.involvesTypeParams(pd, it)) continue;
            this.addToUnionOrIntersection(findingUpperBounds, list, it);
        }
        return this.unionOrIntersection(findingUpperBounds, list);
    }

    private Type inferFunctionRefTypeArg(Tree.StaticMemberOrTypeExpression smte, List<TypeParameter> typeParams, Declaration pd, Type template, Type type, TypeParameter tp, boolean findingUpperBounds) {
        Type it = this.inferTypeArg(tp, template, type, findingUpperBounds, smte);
        if (ModelUtil.isTypeUnknown(it) || AnalyzerUtil.involvesTypeParams(pd, it)) {
            return this.unit.getNothingType();
        }
        return it;
    }

    List<Type> getInferredTypeArgsForTypeConstructor(Tree.InvocationExpression that, Type receiverType, Type type, List<TypeParameter> typeParameters) {
        Tree.PositionalArgumentList pal = that.getPositionalArgumentList();
        if (pal == null) {
            return null;
        }
        ArrayList<Type> typeArguments = new ArrayList<Type>();
        for (TypeParameter tp : typeParameters) {
            List<Type> paramTypes = this.unit.getCallableArgumentTypes(type);
            Type paramTypesAsTuple = this.unit.getCallableTuple(type);
            boolean sequenced = this.unit.isTupleLengthUnbounded(paramTypesAsTuple);
            int argCount = pal.getPositionalArguments().size();
            boolean findUpperBounds = this.isEffectivelyContravariant(tp, type, argCount);
            Type it = this.inferTypeArgumentFromPositionalArgs(tp, paramTypes, paramTypesAsTuple, sequenced, receiverType, pal, findUpperBounds);
            typeArguments.add(it);
        }
        return typeArguments;
    }

    List<Type> getInferredTypeArgsForStaticReference(Tree.InvocationExpression that, TypeDeclaration type, Type receiverType) {
        Tree.PositionalArgumentList pal = that.getPositionalArgumentList();
        Tree.MemberOrTypeExpression primary = (Tree.MemberOrTypeExpression)that.getPrimary();
        Declaration invoked = primary.getDeclaration();
        if (pal == null) {
            return null;
        }
        if (invoked instanceof Functional) {
            List<Tree.PositionalArgument> args = pal.getPositionalArguments();
            Functional fun = (Functional)((Object)invoked);
            List<ParameterList> parameterLists = fun.getParameterLists();
            if (args.isEmpty() || parameterLists.isEmpty()) {
                return null;
            }
            Tree.PositionalArgument arg = args.get(0);
            if (arg == null) {
                return null;
            }
            Type at = arg.getTypeModel();
            Type tt = type.getType();
            List<TypeParameter> typeParams = type.getTypeParameters();
            ArrayList<Type> typeArgs = new ArrayList<Type>(typeParams.size());
            for (TypeParameter tp : typeParams) {
                Type it = this.inferTypeArg(tp, tt, at, false, arg);
                if (it == null || it.containsUnknowns()) {
                    that.addError("could not infer type argument from given arguments: type parameter '" + tp.getName() + "' could not be inferred");
                }
                typeArgs.add(it);
            }
            return this.constrainInferredTypes(typeParams, typeArgs, receiverType, invoked);
        }
        return null;
    }

    List<Type> getInferredTypeArgsForReference(Tree.InvocationExpression that, Declaration invoked, Generic generic, Type receiverType) {
        if (invoked instanceof Functional) {
            Functional functional = (Functional)((Object)invoked);
            List<ParameterList> parameterLists = functional.getParameterLists();
            if (parameterLists.isEmpty()) {
                return null;
            }
            ArrayList<Type> typeArgs = new ArrayList<Type>();
            List<TypeParameter> typeParameters = generic.getTypeParameters();
            for (TypeParameter tp : typeParameters) {
                ParameterList pl;
                Type it = this.inferTypeArgument(that, receiverType, tp, pl = parameterLists.get(0), invoked);
                if (it == null || it.containsUnknowns()) {
                    that.addError("could not infer type argument from given arguments: type parameter '" + tp.getName() + "' could not be inferred");
                }
                typeArgs.add(it);
            }
            return this.constrainInferredTypes(typeParameters, typeArgs, receiverType, invoked);
        }
        return null;
    }

    private Type inferTypeArgument(Tree.InvocationExpression that, Type receiverType, TypeParameter tp, ParameterList parameters, Declaration invoked) {
        Tree.PositionalArgumentList pal = that.getPositionalArgumentList();
        Tree.NamedArgumentList nal = that.getNamedArgumentList();
        if (pal != null) {
            return this.inferTypeArgumentFromPositionalArgs(tp, parameters, receiverType, pal, invoked);
        }
        if (nal != null) {
            return this.inferTypeArgumentFromNamedArgs(tp, parameters, receiverType, nal, invoked);
        }
        return null;
    }

    private static boolean[] specifiedParameters(int argumentCount, int total) {
        boolean[] specified = new boolean[total];
        for (int i = 0; i < argumentCount && i < total; ++i) {
            specified[i] = true;
        }
        return specified;
    }

    private static boolean[] specifiedParameters(Tree.PositionalArgumentList args, ParameterList parameters) {
        List<Parameter> params = parameters.getParameters();
        boolean[] specified = new boolean[params.size()];
        for (Tree.PositionalArgument arg : args.getPositionalArguments()) {
            int loc;
            Parameter p = arg.getParameter();
            if (p == null || (loc = params.indexOf(p)) < 0) continue;
            specified[loc] = true;
        }
        return specified;
    }

    private static boolean[] specifiedParameters(Tree.NamedArgumentList args, ParameterList parameters) {
        int loc;
        Parameter p;
        List<Parameter> params = parameters.getParameters();
        boolean[] specified = new boolean[params.size()];
        for (Tree.NamedArgument arg : args.getNamedArguments()) {
            int loc2;
            Parameter p2 = arg.getParameter();
            if (p2 == null || (loc2 = params.indexOf(p2)) < 0) continue;
            specified[loc2] = true;
        }
        Tree.SequencedArgument arg = args.getSequencedArgument();
        if (arg != null && (p = arg.getParameter()) != null && (loc = params.indexOf(p)) >= 0) {
            specified[loc] = true;
        }
        return specified;
    }

    private boolean isEffectivelyContravariant(TypeParameter tp, Type fullType, int argumentListLength) {
        List<Type> parameterTypes;
        if (tp.isCovariant()) {
            return false;
        }
        if (tp.isContravariant()) {
            return true;
        }
        Type returnType = this.unit.getCallableReturnType(fullType);
        if (returnType != null) {
            boolean occursInvariantly = returnType.occursInvariantly(tp);
            boolean occursCovariantly = returnType.occursCovariantly(tp);
            boolean occursContravariantly = returnType.occursContravariantly(tp);
            if (occursCovariantly && !occursContravariantly && !occursInvariantly) {
                return false;
            }
            if (!occursCovariantly && occursContravariantly && !occursInvariantly) {
                return true;
            }
        }
        if ((parameterTypes = this.unit.getCallableArgumentTypes(fullType)) != null) {
            boolean occursContravariantly = false;
            boolean occursCovariantly = false;
            boolean occursInvariantly = false;
            int size = parameterTypes.size();
            for (int i = 0; i < size && i < argumentListLength; ++i) {
                Type pt = parameterTypes.get(i);
                if (pt == null) continue;
                occursContravariantly = occursContravariantly || pt.occursContravariantly(tp);
                occursCovariantly = occursCovariantly || pt.occursCovariantly(tp);
                occursInvariantly = occursInvariantly || pt.occursInvariantly(tp);
            }
            return occursContravariantly && !occursCovariantly && !occursInvariantly;
        }
        return false;
    }

    private boolean isEffectivelyContravariant(TypeParameter tp, Declaration invoked, boolean[] specifiedArguments) {
        boolean occursContravariantly;
        if (tp.isCovariant()) {
            return false;
        }
        if (tp.isContravariant()) {
            return true;
        }
        Type fullType = invoked.getReference().getFullType();
        Type returnType = this.unit.getCallableReturnType(fullType);
        if (returnType != null) {
            boolean occursInvariantly = returnType.occursInvariantly(tp);
            boolean occursCovariantly = returnType.occursCovariantly(tp);
            occursContravariantly = returnType.occursContravariantly(tp);
            if (occursCovariantly && !occursContravariantly && !occursInvariantly) {
                return false;
            }
            if (!occursCovariantly && occursContravariantly && !occursInvariantly) {
                return true;
            }
        }
        if (invoked instanceof Functional) {
            Functional fun = (Functional)((Object)invoked);
            List<ParameterList> paramLists = fun.getParameterLists();
            occursContravariantly = false;
            boolean occursCovariantly = false;
            boolean occursInvariantly = false;
            if (!paramLists.isEmpty()) {
                List<Parameter> params = paramLists.get(0).getParameters();
                int size = params.size();
                for (int i = 0; i < size; ++i) {
                    Type pt;
                    Parameter p;
                    FunctionOrValue model;
                    if (specifiedArguments != null && !specifiedArguments[i] || (model = (p = params.get(i)).getModel()) == null || (pt = model.getTypedReference().getFullType()) == null) continue;
                    occursContravariantly = occursContravariantly || pt.occursContravariantly(tp);
                    occursCovariantly = occursCovariantly || pt.occursCovariantly(tp);
                    occursInvariantly = occursInvariantly || pt.occursInvariantly(tp);
                }
            }
            return occursContravariantly && !occursCovariantly && !occursInvariantly;
        }
        return false;
    }

    private List<TypeParameter> getTypeParametersAccountingForTypeConstructor(Declaration dec) {
        Value value;
        Type type;
        if (AnalyzerUtil.isGeneric(dec)) {
            Generic generic = (Generic)((Object)dec);
            return generic.getTypeParameters();
        }
        if (dec instanceof Value && (type = (value = (Value)dec).getType()) != null && (type = type.resolveAliases()).isTypeConstructor()) {
            return type.getDeclaration().getTypeParameters();
        }
        return null;
    }

    private Reference appliedReference(Tree.StaticMemberOrTypeExpression smte) {
        List<Type> list;
        Declaration dec = smte.getDeclaration();
        if (smte.getStaticMethodReferencePrimary()) {
            TypeDeclaration td = (TypeDeclaration)dec;
            return td.getType();
        }
        if (AnalyzerUtil.isGeneric(dec)) {
            Generic generic = (Generic)((Object)dec);
            list = ModelUtil.typeParametersAsArgList(generic);
        } else {
            list = AnalyzerUtil.NO_TYPE_ARGS;
        }
        Type qt = TypeArgumentInference.getQualifyingType(smte);
        return dec.appliedReference(qt, list);
    }

    private static Type getQualifyingType(Tree.StaticMemberOrTypeExpression smte) {
        if (smte instanceof Tree.QualifiedMemberOrTypeExpression) {
            Tree.QualifiedMemberOrTypeExpression qte = (Tree.QualifiedMemberOrTypeExpression)smte;
            return qte.getPrimary().getTypeModel();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<Type> constrainInferredTypes(List<TypeParameter> typeParameters, List<Type> inferredTypeArgs, Type qualifyingType, Declaration declaration) {
        Reference ref;
        int size = inferredTypeArgs.size();
        boolean found = false;
        for (int i = 0; i < size; ++i) {
            List<Type> bounds = typeParameters.get(i).getSatisfiedTypes();
            if (bounds.isEmpty()) continue;
            found = true;
        }
        if (!found) return inferredTypeArgs;
        if (declaration instanceof Value) {
            Value value = (Value)declaration;
            if (!value.getType().isTypeConstructor()) return inferredTypeArgs;
            ref = qualifyingType == null ? declaration.appliedReference(null, AnalyzerUtil.NO_TYPE_ARGS) : qualifyingType.getTypedReference(declaration, AnalyzerUtil.NO_TYPE_ARGS);
            TypeDeclaration dec = ref.getType().getDeclaration();
            ref = dec.appliedReference(null, inferredTypeArgs);
        } else {
            ref = qualifyingType == null ? declaration.appliedReference(null, inferredTypeArgs) : qualifyingType.getTypedReference(declaration, inferredTypeArgs);
        }
        Map<TypeParameter, Type> args = ref.getTypeArguments();
        ArrayList<Type> result = new ArrayList<Type>(size);
        for (int i = 0; i < size; ++i) {
            TypeParameter tp = typeParameters.get(i);
            Type arg = inferredTypeArgs.get(i);
            Type constrainedArg = this.constrainInferredType(tp, arg, args);
            result.add(constrainedArg);
        }
        return result;
    }

    private Type constrainInferredType(TypeParameter tp, Type inferredTypeArg, Map<TypeParameter, Type> argMap) {
        Type bounds = ModelUtil.intersectionOfSupertypes(tp).substitute(argMap, null);
        return ModelUtil.intersectionType(bounds, inferredTypeArg, this.unit);
    }
}

