/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.typechecker.analyzer;

import com.redhat.ceylon.common.Backends;
import com.redhat.ceylon.compiler.typechecker.analyzer.AnalyzerUtil;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.Functional;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.ParameterList;
import com.redhat.ceylon.model.typechecker.model.Reference;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TypeHierarchyVisitor
extends Visitor {
    private final Map<TypeDeclKey, Type> types = new HashMap<TypeDeclKey, Type>();

    @Override
    public void visit(Tree.ObjectDefinition that) {
        Value value = that.getDeclarationModel();
        Class anonymousClass = that.getAnonymousClass();
        this.validateMemberRefinement(that, anonymousClass);
        super.visit(that);
        List<Type> orderedTypes = this.sortDAGAndBuildMetadata(value.getTypeDeclaration(), that);
        this.checkForFormalsNotImplemented(that, orderedTypes, anonymousClass);
        this.checkForDoubleMemberInheritanceNotOverridden(that, orderedTypes, anonymousClass);
        this.checkForDoubleMemberInheritanceWoCommonAncestor(that, orderedTypes, anonymousClass);
    }

    @Override
    public void visit(Tree.ObjectArgument that) {
        Class anonymousClass = that.getAnonymousClass();
        this.validateMemberRefinement(that, anonymousClass);
        super.visit(that);
        List<Type> orderedTypes = this.sortDAGAndBuildMetadata(anonymousClass, that);
        this.checkForFormalsNotImplemented(that, orderedTypes, anonymousClass);
        this.checkForDoubleMemberInheritanceNotOverridden(that, orderedTypes, anonymousClass);
        this.checkForDoubleMemberInheritanceWoCommonAncestor(that, orderedTypes, anonymousClass);
    }

    @Override
    public void visit(Tree.ObjectExpression that) {
        Class anonymousClass = that.getAnonymousClass();
        this.validateMemberRefinement(that, anonymousClass);
        super.visit(that);
        List<Type> orderedTypes = this.sortDAGAndBuildMetadata(anonymousClass, that);
        this.checkForFormalsNotImplemented(that, orderedTypes, anonymousClass);
        this.checkForDoubleMemberInheritanceNotOverridden(that, orderedTypes, anonymousClass);
        this.checkForDoubleMemberInheritanceWoCommonAncestor(that, orderedTypes, anonymousClass);
    }

    @Override
    public void visit(Tree.ClassOrInterface that) {
        ClassOrInterface classOrInterface = that.getDeclarationModel();
        this.validateMemberRefinement(that, classOrInterface);
        super.visit(that);
        if (!classOrInterface.isAlias()) {
            boolean concrete = !classOrInterface.isAbstract() && !classOrInterface.isFormal();
            List<Type> orderedTypes = this.sortDAGAndBuildMetadata(classOrInterface, that);
            if (concrete) {
                this.checkForFormalsNotImplemented(that, orderedTypes, (Class)classOrInterface);
            }
            this.checkForDoubleMemberInheritanceNotOverridden(that, orderedTypes, classOrInterface);
            this.checkForDoubleMemberInheritanceWoCommonAncestor(that, orderedTypes, classOrInterface);
        }
    }

    @Override
    public void visit(Tree.TypeConstraint that) {
        super.visit(that);
        this.sortDAGAndBuildMetadata(that.getDeclarationModel(), that);
    }

    @Override
    public void visit(Tree.Declaration that) {
        super.visit(that);
        Declaration dec = that.getDeclarationModel();
        if (dec.isClassOrInterfaceMember() && dec.isActual()) {
            TypeHierarchyVisitor.checkForShortcutRefinement(that, dec);
        }
    }

    @Override
    public void visit(Tree.BaseMemberExpression that) {
        super.visit(that);
        Declaration dec = that.getDeclaration();
        if (dec instanceof FunctionOrValue && ((FunctionOrValue)dec).isShortcutRefinement()) {
            TypeHierarchyVisitor.checkForShortcutRefinement(that, dec);
        }
    }

    private static void checkForShortcutRefinement(Node that, Declaration dec) {
        ClassOrInterface classOrInterface = (ClassOrInterface)dec.getContainer();
        for (Declaration im : classOrInterface.getInheritedMembers(dec.getName())) {
            if (!(im instanceof FunctionOrValue) || !((FunctionOrValue)im).isShortcutRefinement()) continue;
            that.addError("refines a non-formal, non-default member: " + AnalyzerUtil.message(im));
        }
    }

    private void checkForDoubleMemberInheritanceWoCommonAncestor(Node that, List<Type> orderedTypes, ClassOrInterface classOrInterface) {
        Type aggregateType = new Type();
        for (Type currentType : orderedTypes) {
            for (Type.Members currentTypeMembers : currentType.membersByName.values()) {
                String name = currentTypeMembers.name;
                Type.Members aggregateMembers = aggregateType.membersByName.get(name);
                if (aggregateMembers == null) {
                    aggregateMembers = new Type.Members();
                    aggregateMembers.name = name;
                    aggregateType.membersByName.put(name, aggregateMembers);
                } else {
                    TypeDeclaration otherType;
                    boolean isMemberNameOnAncestor;
                    boolean currentMemberIsShared;
                    boolean superMemberIsShared = !aggregateMembers.shared.isEmpty();
                    boolean bl = currentMemberIsShared = !currentTypeMembers.shared.isEmpty();
                    if (superMemberIsShared && currentMemberIsShared && !(isMemberNameOnAncestor = this.isMemberNameOnAncestor(currentType, name)) && !this.mixedInBySupertype(currentType.declaration, otherType = this.getTypeDeclarationFor(aggregateMembers), classOrInterface)) {
                        StringBuilder sb = new StringBuilder("may not inherit two declarations with the same name that do not share a common supertype: '");
                        sb.append(name).append("' is defined by supertypes '").append(currentType.declaration.getName()).append("' and '").append(otherType.getName()).append("'");
                        that.addError(sb.toString());
                    }
                }
                this.pourCurrentTypeInfoIntoAggregatedType(currentTypeMembers, aggregateMembers);
            }
        }
    }

    private void checkForDoubleMemberInheritanceNotOverridden(Node that, List<Type> orderedTypes, ClassOrInterface classOrInterface) {
        Type aggregateType = new Type();
        int size = orderedTypes.size();
        for (int index = size - 1; index >= 0; --index) {
            Type currentType = orderedTypes.get(index);
            for (Type.Members currentTypeMembers : currentType.membersByName.values()) {
                String name = currentTypeMembers.name;
                Type.Members aggregateMembers = aggregateType.membersByName.get(name);
                if (aggregateMembers == null) {
                    aggregateMembers = new Type.Members();
                    aggregateMembers.name = name;
                    aggregateType.membersByName.put(name, aggregateMembers);
                } else {
                    boolean currentMemberIsShared;
                    boolean subtypeMemberIsShared = !aggregateMembers.shared.isEmpty();
                    boolean bl = currentMemberIsShared = !currentTypeMembers.shared.isEmpty();
                    if (subtypeMemberIsShared && currentMemberIsShared) {
                        TypeDeclaration otherType;
                        boolean isMemberRefined = this.isMemberRefined(orderedTypes, index, name, currentTypeMembers);
                        boolean isMemberNameOnAncestor = this.isMemberNameOnAncestor(currentType, name);
                        if (!isMemberRefined && isMemberNameOnAncestor && !this.mixedInBySupertype(currentType.declaration, otherType = this.getTypeDeclarationFor(aggregateMembers), classOrInterface)) {
                            StringBuilder sb = new StringBuilder("may not inherit two declarations with the same name unless redefined in subclass: '");
                            sb.append(name).append("' is defined by supertypes '").append(currentType.declaration.getName()).append("' and '").append(otherType.getName()).append("'");
                            that.addError(sb.toString());
                        }
                    }
                }
                this.pourCurrentTypeInfoIntoAggregatedType(currentTypeMembers, aggregateMembers);
            }
        }
    }

    private void pourCurrentTypeInfoIntoAggregatedType(Type.Members currentTypeMembers, Type.Members aggregateMembers) {
        aggregateMembers.nonFormalsNonDefaults.addAll(currentTypeMembers.nonFormalsNonDefaults);
        aggregateMembers.actuals.addAll(currentTypeMembers.actuals);
        aggregateMembers.formals.addAll(currentTypeMembers.formals);
        aggregateMembers.actualsNonFormals.addAll(currentTypeMembers.actualsNonFormals);
        aggregateMembers.defaults.addAll(currentTypeMembers.defaults);
        aggregateMembers.shared.addAll(currentTypeMembers.shared);
    }

    private boolean isMemberNameOnAncestor(Type currentType, String name) {
        return !currentType.declaration.getInheritedMembers(name).isEmpty();
    }

    private boolean mixedInBySupertype(TypeDeclaration currentType, TypeDeclaration otherType, ClassOrInterface classOrInterface) {
        TypeDeclaration etd;
        com.redhat.ceylon.model.typechecker.model.Type et = classOrInterface.getExtendedType();
        if (et != null && (etd = et.getDeclaration()).inherits(currentType) && etd.inherits(otherType)) {
            return true;
        }
        for (com.redhat.ceylon.model.typechecker.model.Type st : classOrInterface.getSatisfiedTypes()) {
            TypeDeclaration std;
            if (st == null || !(std = st.getDeclaration()).inherits(currentType) || !std.inherits(otherType)) continue;
            return true;
        }
        return false;
    }

    private boolean isMemberRefined(List<Type> orderedTypes, int index, String name, Type.Members currentTypeMembers) {
        int size = orderedTypes.size();
        Declaration declarationOfSupertypeMember = this.getMemberDeclaration(currentTypeMembers);
        for (int subIndex = size - 1; subIndex > index; --subIndex) {
            Type type = orderedTypes.get(subIndex);
            Declaration directMember = type.declaration.getDirectMember(name, null, false);
            boolean isMemberRefined = directMember != null && directMember.isShared();
            boolean bl = isMemberRefined = isMemberRefined && type.declaration.getInheritedMembers(name).contains(declarationOfSupertypeMember);
            if (!isMemberRefined) continue;
            return true;
        }
        return false;
    }

    private TypeDeclaration getTypeDeclarationFor(Type.Members aggregateMembers) {
        Declaration memberDeclaration = this.getMemberDeclaration(aggregateMembers);
        return memberDeclaration == null ? null : memberDeclaration.getDeclaringType(memberDeclaration).getDeclaration();
    }

    private Declaration getMemberDeclaration(Type.Members aggregateMembers) {
        if (!aggregateMembers.formals.isEmpty()) {
            return aggregateMembers.formals.iterator().next();
        }
        if (!aggregateMembers.defaults.isEmpty()) {
            return aggregateMembers.defaults.iterator().next();
        }
        if (!aggregateMembers.actuals.isEmpty()) {
            return aggregateMembers.actuals.iterator().next();
        }
        if (!aggregateMembers.nonFormalsNonDefaults.isEmpty()) {
            return aggregateMembers.nonFormalsNonDefaults.iterator().next();
        }
        return null;
    }

    private void checkForFormalsNotImplemented(Node that, List<Type> orderedTypes, Class clazz) {
        Type aggregation = this.buildAggregatedType(orderedTypes);
        for (Type.Members members : aggregation.membersByName.values()) {
            Declaration example;
            Declaration declaringType;
            if (members.formals.isEmpty()) continue;
            if (members.actualsNonFormals.isEmpty() && !clazz.equals(declaringType = (Declaration)((Object)(example = members.formals.iterator().next()).getContainer()))) {
                this.addUnimplementedFormal(clazz, example);
                that.addError("formal member '" + example.getName() + "' of '" + declaringType.getName() + "' not implemented in class hierarchy", 300);
                continue;
            }
            for (Declaration f : members.formals) {
                if (!ModelUtil.isOverloadedVersion(f)) continue;
                boolean found = false;
                for (Declaration a : members.actualsNonFormals) {
                    if (!a.getRefinedDeclaration().equals(f.getRefinedDeclaration())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                StringBuilder paramTypes = new StringBuilder();
                List<ParameterList> parameterLists = ((Functional)((Object)f)).getParameterLists();
                if (!parameterLists.isEmpty()) {
                    for (Parameter p : parameterLists.get(0).getParameters()) {
                        if (paramTypes.length() > 0) {
                            paramTypes.append(", ");
                        }
                        if (ModelUtil.isTypeUnknown(p.getType())) continue;
                        paramTypes.append(p.getType().asString());
                    }
                }
                Declaration declaringType2 = (Declaration)((Object)f.getContainer());
                this.addUnimplementedFormal(clazz, f);
                that.addError("overloaded formal member '" + f.getName() + "(" + paramTypes + ")' of '" + declaringType2.getName() + "' not implemented in class hierarchy");
            }
        }
    }

    private void addUnimplementedFormal(Class clazz, Declaration member) {
        Reference unimplemented = member.appliedReference(clazz.getType(), AnalyzerUtil.NO_TYPE_ARGS);
        List<Reference> list = clazz.getUnimplementedFormals();
        if (list.isEmpty()) {
            list = new ArrayList<Reference>();
            clazz.setUnimplementedFormals(list);
        }
        list.add(unimplemented);
    }

    private Type buildAggregatedType(List<Type> orderedTypes) {
        int size = orderedTypes.size();
        Type aggregation = new Type();
        for (int index = size - 1; index >= 0; --index) {
            Type current = orderedTypes.get(index);
            for (Type.Members currentMembers : current.membersByName.values()) {
                Type.Members aggregateMembers = aggregation.membersByName.get(currentMembers.name);
                if (aggregateMembers == null) {
                    aggregateMembers = new Type.Members();
                    aggregateMembers.name = currentMembers.name;
                    aggregation.membersByName.put(currentMembers.name, aggregateMembers);
                }
                this.pourCurrentTypeInfoIntoAggregatedType(currentMembers, aggregateMembers);
                block2: for (Declaration actualNonFormal : currentMembers.actualsNonFormals) {
                    for (Declaration formal : aggregateMembers.formals) {
                        if (!formal.getName().equals(actualNonFormal.getName()) || formal.getUnit().getPackage().getModule().isJava() && formal.isInterfaceMember()) continue;
                        aggregateMembers.actualsNonFormals.remove(actualNonFormal);
                        continue block2;
                    }
                }
            }
        }
        return aggregation;
    }

    private List<Type> sortDAGAndBuildMetadata(TypeDeclaration declaration, Node errorReporter) {
        ArrayList<Type> sortedDag = new ArrayList<Type>();
        ArrayList<TypeDeclaration> visitedDeclarationPerBranch = new ArrayList<TypeDeclaration>();
        HashSet<TypeDeclaration> visited = new HashSet<TypeDeclaration>();
        this.visitDAGNode(declaration, sortedDag, visited, visitedDeclarationPerBranch, errorReporter);
        return sortedDag;
    }

    private void visitDAGNode(TypeDeclaration declaration, List<Type> sortedDag, Set<TypeDeclaration> visited, List<TypeDeclaration> stackOfProcessedType, Node errorReporter) {
        if (declaration == null) {
            return;
        }
        if (this.checkCyclicInheritance(declaration, stackOfProcessedType, errorReporter)) {
            return;
        }
        if (visited.contains(declaration)) {
            return;
        }
        visited.add(declaration);
        Type type = this.getOrBuildType(declaration);
        stackOfProcessedType.add(declaration);
        com.redhat.ceylon.model.typechecker.model.Type extendedType = declaration.getExtendedType();
        if (extendedType != null) {
            this.visitDAGNode(extendedType.getDeclaration(), sortedDag, visited, stackOfProcessedType, errorReporter);
        }
        for (com.redhat.ceylon.model.typechecker.model.Type superSatisfiedType : declaration.getSatisfiedTypes()) {
            if (superSatisfiedType == null) continue;
            this.visitDAGNode(superSatisfiedType.getDeclaration(), sortedDag, visited, stackOfProcessedType, errorReporter);
        }
        for (com.redhat.ceylon.model.typechecker.model.Type superSatisfiedType : declaration.getBrokenSupertypes()) {
            this.visitDAGNode(superSatisfiedType.getDeclaration(), sortedDag, visited, stackOfProcessedType, errorReporter);
        }
        stackOfProcessedType.remove(stackOfProcessedType.size() - 1);
        sortedDag.add(type);
    }

    private boolean checkCyclicInheritance(TypeDeclaration declaration, List<TypeDeclaration> stackOfProcessedType, Node errorReporter) {
        int matchingIndex = stackOfProcessedType.indexOf(declaration);
        if (matchingIndex != -1) {
            // empty if block
        }
        return false;
    }

    private Type getOrBuildType(TypeDeclaration declaration) {
        Type type = this.types.get(new TypeDeclKey(declaration));
        if (type == null) {
            type = new Type();
            type.declaration = declaration;
            for (Declaration member : declaration.getMembers()) {
                Backends backends;
                if (!(member instanceof FunctionOrValue) && !(member instanceof Class) || ModelUtil.isConstructor(member) || member.isStaticallyImportable() || ModelUtil.isAbstraction(member) || declaration.isNative() && member.isNative() && (member = ModelUtil.getNativeDeclaration(member, backends = declaration.getNativeBackends())) == null) continue;
                String name = member.getName();
                Type.Members members = type.membersByName.get(name);
                if (members == null) {
                    members = new Type.Members();
                    members.name = name;
                    type.membersByName.put(name, members);
                }
                if (member.isActual()) {
                    members.actuals.add(member);
                    if (!member.isFormal()) {
                        members.actualsNonFormals.add(member);
                    }
                }
                if (member.isFormal()) {
                    members.formals.add(member);
                }
                if (member.isDefault()) {
                    members.defaults.add(member);
                }
                if (!member.isFormal() && !member.isDefault() && member.isShared()) {
                    members.nonFormalsNonDefaults.add(member);
                }
                if (!member.isShared()) continue;
                members.shared.add(member);
            }
            this.types.put(new TypeDeclKey(declaration), type);
        }
        return type;
    }

    private void validateMemberRefinement(Node that, TypeDeclaration td) {
        if (!td.isInconsistentType()) {
            HashSet<String> errors = new HashSet<String>();
            for (TypeDeclaration std : td.getSupertypeDeclarations()) {
                if (!(td instanceof ClassOrInterface) || td.isAbstract() || td.isAlias()) continue;
                for (Declaration d : std.getMembers()) {
                    Declaration r;
                    if (!d.isShared() || ModelUtil.isOverloadedVersion(d) || !ModelUtil.isResolvable(d) || errors.contains(d.getName()) || (r = td.getMember(d.getName(), null, false)) != null && (r.refines(d) || r.getContainer().equals(td))) continue;
                    if (r == null) {
                        that.addError("member '" + d.getName() + "' is inherited ambiguously by '" + td.getName() + "' from '" + std.getName() + "' and another unrelated supertype");
                    } else if (!(d.getUnit().getPackage().getModule().isJava() && r.getUnit().getPackage().getModule().isJava() && r.isInterfaceMember() && d.isClassMember())) {
                        that.addError("member '" + d.getName() + "' is inherited ambiguously by '" + td.getName() + "' from '" + std.getName() + "' and another subtype of '" + ((TypeDeclaration)r.getContainer()).getName() + "' and so must be refined by '" + td.getName() + "'", 350);
                    }
                    errors.add(d.getName());
                }
            }
        }
    }

    private static final class TypeDeclKey {
        public final TypeDeclaration decl;

        public TypeDeclKey(TypeDeclaration decl) {
            this.decl = decl;
        }

        public int hashCode() {
            return this.decl.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TypeDeclKey other = (TypeDeclKey)obj;
            return this.decl.equals(other.decl) && (!this.decl.isNative() || this.decl.getNativeBackends().supports(other.decl.getNativeBackends()));
        }
    }

    private static final class Type {
        public Map<String, Members> membersByName = new HashMap<String, Members>();
        public TypeDeclaration declaration;

        private Type() {
        }

        public String toString() {
            return this.declaration.getName();
        }

        public static final class Members {
            public String name;
            public Set<Declaration> formals = new LinkedHashSet<Declaration>();
            public Set<Declaration> actuals = new HashSet<Declaration>();
            public Set<Declaration> actualsNonFormals = new HashSet<Declaration>();
            public Set<Declaration> defaults = new HashSet<Declaration>();
            public Set<Declaration> nonFormalsNonDefaults = new HashSet<Declaration>();
            public Set<Declaration> shared = new HashSet<Declaration>();
        }
    }
}

