/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.typechecker.context;

import com.redhat.ceylon.compiler.typechecker.context.PhasedUnit;
import com.redhat.ceylon.compiler.typechecker.context.TypecheckerUnit;
import com.redhat.ceylon.compiler.typechecker.io.VirtualFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class PhasedUnitMap<ReturnedType extends PhasedUnit, StoredType> {
    protected Map<String, StoredType> phasedUnitPerPath = new LinkedHashMap<String, StoredType>();
    protected Map<String, String> relativePathToPath = new HashMap<String, String>();

    protected abstract StoredType toStoredType(ReturnedType var1);

    protected abstract ReturnedType fromStoredType(StoredType var1, String var2);

    public void addPhasedUnit(VirtualFile unitFile, ReturnedType phasedUnit) {
        this.phasedUnitPerPath.put(unitFile.getPath(), this.toStoredType(phasedUnit));
        this.relativePathToPath.put(((PhasedUnit)phasedUnit).getPathRelativeToSrcDir(), unitFile.getPath());
    }

    public void removePhasedUnitForRelativePath(String relativePath) {
        TypecheckerUnit unit;
        String path = this.relativePathToPath.get(relativePath);
        ReturnedType phasedUnit = this.fromStoredType(this.phasedUnitPerPath.get(path), path);
        if (phasedUnit != null && (unit = ((PhasedUnit)phasedUnit).getUnit()) != null) {
            unit.getPackage().removeUnit(unit);
        }
        this.relativePathToPath.remove(relativePath);
        this.phasedUnitPerPath.remove(path);
    }

    protected void addInReturnedList(List<ReturnedType> list, ReturnedType phasedUnit) {
        list.add(phasedUnit);
    }

    public List<ReturnedType> getPhasedUnits() {
        ArrayList list = new ArrayList(this.phasedUnitPerPath.size());
        for (Map.Entry<String, StoredType> entry : this.phasedUnitPerPath.entrySet()) {
            this.addInReturnedList(list, this.fromStoredType(entry.getValue(), entry.getKey()));
        }
        return list;
    }

    public ReturnedType getPhasedUnit(VirtualFile file) {
        return this.getPhasedUnit(file.getPath());
    }

    public ReturnedType getPhasedUnit(String path) {
        StoredType storedValue = this.phasedUnitPerPath.get(path);
        return storedValue == null ? null : (ReturnedType)this.fromStoredType(storedValue, path);
    }

    public ReturnedType getPhasedUnitFromRelativePath(String relativePath) {
        if (relativePath.startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        return this.getPhasedUnit(this.relativePathToPath.get(relativePath));
    }
}

