/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.typechecker.context;

import com.redhat.ceylon.compiler.typechecker.analyzer.ModuleSourceMapper;
import com.redhat.ceylon.compiler.typechecker.context.Context;
import com.redhat.ceylon.compiler.typechecker.context.PhasedUnit;
import com.redhat.ceylon.compiler.typechecker.context.PhasedUnitMap;
import com.redhat.ceylon.compiler.typechecker.io.VirtualFile;
import com.redhat.ceylon.compiler.typechecker.parser.CeylonLexer;
import com.redhat.ceylon.compiler.typechecker.parser.CeylonParser;
import com.redhat.ceylon.compiler.typechecker.parser.LexError;
import com.redhat.ceylon.compiler.typechecker.parser.ParseError;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.util.ModuleManagerFactory;
import com.redhat.ceylon.model.typechecker.model.Modules;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.util.ModuleManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.CommonTokenStream;

public class PhasedUnits
extends PhasedUnitMap<PhasedUnit, PhasedUnit> {
    private final Context context;
    private final ModuleManager moduleManager;
    private final ModuleSourceMapper moduleSourceMapper;
    private List<String> moduleFilters;
    private Set<VirtualFile> sourceFiles = new HashSet<VirtualFile>();
    private String encoding;

    public PhasedUnits(Context context) {
        this.context = context;
        if (context.getModules() == null) {
            context.setModules(new Modules());
        }
        this.moduleManager = new ModuleManager();
        this.moduleSourceMapper = new ModuleSourceMapper(context, this.moduleManager);
        this.moduleSourceMapper.initCoreModules();
    }

    public PhasedUnits(Context context, ModuleManagerFactory moduleManagerFactory) {
        this.context = context;
        if (context.getModules() == null) {
            context.setModules(new Modules());
        }
        if (moduleManagerFactory != null) {
            this.moduleManager = moduleManagerFactory.createModuleManager(context);
            this.moduleSourceMapper = moduleManagerFactory.createModuleManagerUtil(context, this.moduleManager);
        } else {
            this.moduleManager = new ModuleManager();
            this.moduleSourceMapper = new ModuleSourceMapper(context, this.moduleManager);
        }
        this.moduleSourceMapper.initCoreModules();
    }

    public void setSourceFiles(List<VirtualFile> sourceFiles) {
        if (sourceFiles != null) {
            this.sourceFiles.addAll(sourceFiles);
        } else {
            this.sourceFiles.clear();
        }
    }

    public void setModuleFilters(List<String> moduleFilters) {
        this.moduleFilters = moduleFilters;
    }

    public ModuleManager getModuleManager() {
        return this.moduleManager;
    }

    public ModuleSourceMapper getModuleSourceMapper() {
        return this.moduleSourceMapper;
    }

    public void parseUnits(List<VirtualFile> srcDirectories) {
        for (VirtualFile file : srcDirectories) {
            this.parseUnit(file, file);
        }
    }

    public void parseUnit(VirtualFile srcDir) {
        this.parseUnit(srcDir, srcDir);
    }

    public void parseUnit(VirtualFile file, VirtualFile srcDir) {
        try {
            if (file.isFolder()) {
                List<? extends VirtualFile> files = file.getChildren();
                for (VirtualFile virtualFile : files) {
                    this.parseFileOrDirectory(virtualFile, srcDir);
                }
            } else {
                this.parseFileOrDirectory(file, srcDir);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Error while parsing the source directory: " + file.toString(), e);
        }
    }

    protected void parseFile(VirtualFile file, VirtualFile srcDir) throws Exception {
        if (file.getName().endsWith(".ceylon") && (this.sourceFiles.isEmpty() || this.sourceFiles.contains(file))) {
            CeylonLexer lexer = new CeylonLexer(new ANTLRInputStream(file.getInputStream(), this.getEncoding()));
            CommonTokenStream tokenStream = new CommonTokenStream(lexer);
            CeylonParser parser = new CeylonParser(tokenStream);
            Tree.CompilationUnit cu = parser.compilationUnit();
            ArrayList<CommonToken> tokens = new ArrayList<CommonToken>(tokenStream.getTokens().size());
            tokens.addAll(tokenStream.getTokens());
            PhasedUnit phasedUnit = new PhasedUnit(file, srcDir, cu, this.moduleSourceMapper.getCurrentPackage(), this.moduleManager, this.moduleSourceMapper, this.context, tokens);
            this.addPhasedUnit(file, phasedUnit);
            List<LexError> lexerErrors = lexer.getErrors();
            for (LexError le : lexerErrors) {
                cu.addLexError(le);
            }
            lexerErrors.clear();
            List<ParseError> parserErrors = parser.getErrors();
            for (ParseError pe : parserErrors) {
                cu.addParseError(pe);
            }
            parserErrors.clear();
        }
    }

    protected String getEncoding() {
        return this.encoding != null ? this.encoding : System.getProperty("file.encoding");
    }

    private void parseFileOrDirectory(VirtualFile file, VirtualFile srcDir) throws Exception {
        if (this.checkModuleFiltersByName(file, srcDir)) {
            if (file.isFolder()) {
                this.processDirectory(file, srcDir);
            } else {
                this.parseFile(file, srcDir);
            }
        }
    }

    private boolean checkModuleFiltersByName(VirtualFile file, VirtualFile srcDir) {
        String folderName;
        if (this.moduleFilters == null || this.moduleFilters.isEmpty()) {
            return true;
        }
        String srcPath = srcDir.getPath();
        String filePath = file.getPath();
        if (filePath.length() == srcPath.length()) {
            folderName = "";
        } else {
            folderName = filePath.substring(srcPath.length() + 1);
            if (!file.isFolder()) {
                folderName = folderName.substring(0, folderName.length() - file.getName().length());
            }
        }
        for (String module : this.moduleFilters) {
            if (module.equals("default")) {
                return true;
            }
            String modulePathEx = module.replace('.', '/') + "/";
            String folderNameEx = folderName + "/";
            if (!folderNameEx.startsWith(modulePathEx) && !modulePathEx.startsWith(folderNameEx)) continue;
            return true;
        }
        return false;
    }

    private void processDirectory(VirtualFile dir, VirtualFile srcDir) throws Exception {
        this.moduleSourceMapper.push(dir.getName());
        List<? extends VirtualFile> files = dir.getChildren();
        boolean definesModule = false;
        for (VirtualFile virtualFile : files) {
            if (!"module.ceylon".equals(virtualFile.getName())) continue;
            definesModule = true;
            break;
        }
        if (this.checkModuleFilters(definesModule)) {
            if (definesModule) {
                this.moduleSourceMapper.visitModuleFile();
            }
            for (VirtualFile virtualFile : files) {
                this.parseFileOrDirectory(virtualFile, srcDir);
            }
        }
        this.moduleSourceMapper.pop();
    }

    private boolean checkModuleFilters(boolean definesModule) {
        if (this.moduleFilters == null || this.moduleFilters.isEmpty()) {
            return true;
        }
        Package pkg = this.moduleSourceMapper.getCurrentPackage();
        String pkgName = pkg.getNameAsString();
        for (String module : this.moduleFilters) {
            if (module.equals("default")) {
                if (!pkg.getModule().isDefault() || definesModule) continue;
                return true;
            }
            if (pkgName.equals(module)) {
                return true;
            }
            if (pkgName.startsWith(module + ".") && pkg.getModule().getNameAsString().equals(module)) {
                return true;
            }
            if (!module.startsWith(pkgName + ".") || !pkg.getModule().isDefault() || definesModule) continue;
            return true;
        }
        return false;
    }

    public void visitModules() {
        List listOfUnits = this.getPhasedUnits();
        for (PhasedUnit pu : listOfUnits) {
            pu.visitSrcModulePhase();
        }
        for (PhasedUnit pu : listOfUnits) {
            pu.visitRemainingModulePhase();
        }
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    protected PhasedUnit toStoredType(PhasedUnit phasedUnit) {
        return phasedUnit;
    }

    @Override
    protected PhasedUnit fromStoredType(PhasedUnit storedValue, String path) {
        return storedValue;
    }
}

