/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.typechecker.context;

import com.redhat.ceylon.common.BackendSupport;
import com.redhat.ceylon.common.Backends;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.model.Unit;
import java.util.HashSet;
import java.util.Set;

public class TypecheckerUnit
extends Unit
implements BackendSupport {
    private Set<Tree.Identifier> unresolvedReferences = new HashSet<Tree.Identifier>();
    private Package javaLangPackage;
    private Set<Declaration> missingNativeImplementations = new HashSet<Declaration>();
    private Backends supportedBackends = Backends.ANY;

    public TypecheckerUnit() {
    }

    public TypecheckerUnit(Iterable<Module> modules) {
        for (Module m : modules) {
            if (!"java.base".equals(m.getNameAsString())) continue;
            this.javaLangPackage = m.getPackage("java.lang");
            break;
        }
    }

    public Set<Tree.Identifier> getUnresolvedReferences() {
        return this.unresolvedReferences;
    }

    public Set<Declaration> getMissingNativeImplementations() {
        return this.missingNativeImplementations;
    }

    @Override
    public Backends getSupportedBackends() {
        return this.supportedBackends;
    }

    public void setSupportedBackends(Backends backends) {
        this.supportedBackends = backends;
    }

    @Override
    protected Package getJavaLangPackage() {
        return this.javaLangPackage != null ? this.javaLangPackage : super.getJavaLangPackage();
    }
}

