/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.typechecker.io;

import com.redhat.ceylon.compiler.typechecker.io.ClosableVirtualFile;
import com.redhat.ceylon.compiler.typechecker.io.VirtualFile;
import com.redhat.ceylon.compiler.typechecker.io.impl.FileSystemVirtualFile;
import com.redhat.ceylon.compiler.typechecker.io.impl.ZipFileVirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipFile;

public class VFS {
    public VirtualFile getFromZipFile(ZipFile file) {
        return new ZipFileVirtualFile(file);
    }

    public ClosableVirtualFile getFromZipFile(File file) {
        try {
            return new ZipFileVirtualFile(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public VirtualFile getFromFile(File file) {
        return new FileSystemVirtualFile(file);
    }

    public ClosableVirtualFile openAsContainer(VirtualFile file) {
        if (file instanceof ZipFileVirtualFile) {
            return (ZipFileVirtualFile)file;
        }
        if (file instanceof FileSystemVirtualFile) {
            File realFile = ((FileSystemVirtualFile)file).getFile();
            return this.getFromZipFile(realFile);
        }
        throw new RuntimeException("Unknown type: " + file.getClass());
    }
}

