/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.typechecker.io.impl;

import com.redhat.ceylon.compiler.typechecker.io.VirtualFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FileSystemVirtualFile
implements VirtualFile {
    private final File file;

    public FileSystemVirtualFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public boolean exists() {
        return this.file.exists() && this.file.canRead();
    }

    @Override
    public boolean isFolder() {
        return this.file.isDirectory();
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public String getPath() {
        if ('\\' == File.separatorChar) {
            return this.file.getPath().replace('\\', '/');
        }
        return this.file.getPath();
    }

    @Override
    public InputStream getInputStream() {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public List<VirtualFile> getChildren() {
        ArrayList<FileSystemVirtualFile> localFiles;
        File[] fsFiles = this.file.listFiles();
        if (fsFiles == null) {
            localFiles = new ArrayList<FileSystemVirtualFile>(0);
        } else {
            localFiles = new ArrayList(fsFiles.length);
            for (File f : fsFiles) {
                localFiles.add(new FileSystemVirtualFile(f));
            }
        }
        List<VirtualFile> files = Collections.unmodifiableList(localFiles);
        return files;
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof VirtualFile) {
            return ((VirtualFile)obj).getPath().equals(this.getPath());
        }
        return super.equals(obj);
    }

    @Override
    public int compareTo(VirtualFile o) {
        return this.getPath().compareTo(o.getPath());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FileSystemVirtualFile");
        sb.append("{name='").append(this.file.getName()).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

