/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.typechecker.io.impl;

import com.redhat.ceylon.common.FileUtil;
import com.redhat.ceylon.compiler.typechecker.io.VirtualFile;
import java.io.File;
import java.util.zip.ZipEntry;

public class Helper {
    public static String getSimpleName(ZipEntry entry) {
        return Helper.getSimpleName(entry.getName());
    }

    public static String getSimpleName(String entryName) {
        if (entryName.endsWith("/")) {
            int lastIndex = entryName.length() - 2;
            int firstIndex = entryName.lastIndexOf("/", lastIndex);
            return firstIndex == -1 ? entryName.substring(0, lastIndex + 1) : entryName.substring(firstIndex + 1, lastIndex + 1);
        }
        int firstIndex = entryName.lastIndexOf("/");
        return firstIndex == -1 ? entryName : entryName.substring(firstIndex + 1);
    }

    public static File getHomeRepository() {
        File repo;
        String ceylonUserRepo = System.getProperty("ceylon.user.repo");
        if (ceylonUserRepo == null) {
            File home = new File(System.getProperty("user.home"));
            File ceylon = new File(home, ".ceylon");
            repo = new File(ceylon, "repo");
        } else {
            repo = new File(ceylonUserRepo);
        }
        FileUtil.mkdirs(repo);
        return repo;
    }

    public static String computeRelativePath(VirtualFile unitFile, VirtualFile srcDir) {
        String rawRelativePath = unitFile.getPath().substring(srcDir.getPath().length());
        if (rawRelativePath.startsWith("/")) {
            return rawRelativePath.substring(1);
        }
        if (rawRelativePath.startsWith("!/")) {
            return rawRelativePath.substring(2);
        }
        return rawRelativePath;
    }
}

