/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.typechecker.io.impl;

import com.redhat.ceylon.compiler.typechecker.io.ClosableVirtualFile;
import com.redhat.ceylon.compiler.typechecker.io.VirtualFile;
import com.redhat.ceylon.compiler.typechecker.io.impl.ZipEntryVirtualFile;
import com.redhat.ceylon.compiler.typechecker.io.impl.ZipFolderVirtualFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipFileVirtualFile
implements ClosableVirtualFile {
    protected final ZipFile zipFile;
    private final String name;
    private final List<VirtualFile> children;
    private final boolean closable;

    public ZipFileVirtualFile(File file) throws IOException {
        this(new ZipFile(file), true);
    }

    public ZipFileVirtualFile(ZipFile zipFile) {
        this(zipFile, false);
    }

    private ZipFileVirtualFile(ZipFile zipFile, boolean closable) {
        this.closable = closable;
        this.zipFile = zipFile;
        String path = zipFile.getName();
        int lastIndex = path.lastIndexOf(File.separator);
        this.name = lastIndex == -1 ? path : path.substring(lastIndex + 1);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        TreeSet<String> entryNames = new TreeSet<String>();
        while (entries.hasMoreElements()) {
            String entryName = entries.nextElement().getName();
            List<String> parentEntriesNames = this.getParentEntriesNames(entryName);
            entryNames.add(entryName);
            entryNames.addAll(parentEntriesNames);
        }
        ArrayList<VirtualFile> directChildren = new ArrayList<VirtualFile>();
        LinkedList<ZipFolderVirtualFile> directoryStack = new LinkedList<ZipFolderVirtualFile>();
        for (String entryName : entryNames) {
            if (entryName.endsWith("/")) {
                ZipFolderVirtualFile folder = new ZipFolderVirtualFile(entryName, path);
                this.addToParentfolder(directChildren, directoryStack, entryName, folder);
                directoryStack.addLast(folder);
                continue;
            }
            ZipEntry entry = zipFile.getEntry(entryName);
            ZipEntryVirtualFile file = new ZipEntryVirtualFile(entry, zipFile);
            this.addToParentfolder(directChildren, directoryStack, entryName, file);
        }
        this.children = directChildren;
    }

    private List<String> getParentEntriesNames(String entryName) {
        ArrayList<String> parentEntries = new ArrayList<String>();
        String[] entrySegments = entryName.split("/");
        if (entrySegments.length == 0) {
            return parentEntries;
        }
        String ancestor = "";
        for (int i = 0; i < entrySegments.length - 1; ++i) {
            ancestor = ancestor + entrySegments[i] + "/";
            parentEntries.add(ancestor);
        }
        return parentEntries;
    }

    private void addToParentfolder(List<VirtualFile> directChildren, LinkedList<ZipFolderVirtualFile> directoryStack, String entryName, VirtualFile file) {
        ZipFolderVirtualFile up = directoryStack.peekLast();
        while (!this.isChildOf(entryName, up)) {
            directoryStack.pollLast();
            up = directoryStack.peekLast();
        }
        if (up == null) {
            directChildren.add(file);
        } else {
            up.addChild(file);
        }
    }

    private boolean isChildOf(String entryName, ZipFolderVirtualFile lastFolder) {
        if (lastFolder == null) {
            return true;
        }
        return entryName.startsWith(lastFolder.getEntryName());
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    public String getName() {
        return this.zipFile.getName();
    }

    @Override
    public String getPath() {
        return this.zipFile.getName();
    }

    @Override
    public InputStream getInputStream() {
        throw new IllegalStateException("Cannot call getInputStream() on a directory: " + this.getPath());
    }

    public List<VirtualFile> getChildren() {
        return this.children;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ZipFileVirtualFile");
        sb.append("{name='").append(this.name).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof VirtualFile) {
            return ((VirtualFile)obj).getPath().equals(this.getPath());
        }
        return super.equals(obj);
    }

    @Override
    public int compareTo(VirtualFile o) {
        return this.getPath().compareTo(o.getPath());
    }

    @Override
    public void close() {
        if (this.closable) {
            try {
                this.zipFile.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

