/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.typechecker.parser;

public class ParseUtil {
    private static String[] keywords = new String[]{"abstracts", "alias", "assembly", "assert", "assign", "break", "case", "catch", "class", "continue", "dynamic", "else", "exists", "extends", "finally", "for", "function", "given", "if", "import", "in", "interface", "is", "let", "module", "new", "nonempty", "object", "of", "out", "outer", "package", "return", "satisfies", "super", "switch", "then", "this", "throw", "try", "value", "void", "while"};

    public static boolean isCeylonKeyword(String token) {
        for (String keyword : keywords) {
            if (!keyword.equals(token)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCeylonKeyword(String string, int start, int end) {
        int length = end - start;
        block0: for (int i = 0; i < keywords.length; ++i) {
            String token = keywords[i];
            if (token.length() != length) continue;
            for (int c = 0; c < length; ++c) {
                if (string.charAt(c + start) != token.charAt(c)) continue block0;
            }
            return true;
        }
        return false;
    }

    public static String quoteIfCeylonKeyword(String name) {
        if (ParseUtil.isCeylonKeyword(name)) {
            return "\\i" + name;
        }
        return name;
    }

    public static String quoteCeylonKeywords(String qualifiedName) {
        if (ParseUtil.needsCeylonKeywordsQuoting(qualifiedName)) {
            return ParseUtil.join(".", ParseUtil.quoteCeylonKeywords(qualifiedName.split("\\.")));
        }
        return qualifiedName;
    }

    public static String[] quoteCeylonKeywords(String[] name) {
        String[] result = new String[name.length];
        for (int ii = 0; ii < name.length; ++ii) {
            result[ii] = ParseUtil.quoteIfCeylonKeyword(name[ii]);
        }
        return result;
    }

    private static boolean needsCeylonKeywordsQuoting(String qualifiedName) {
        int nextDot = qualifiedName.indexOf(46);
        int start = 0;
        while (nextDot != -1) {
            if (ParseUtil.isCeylonKeyword(qualifiedName, start, nextDot)) {
                return true;
            }
            start = nextDot + 1;
            nextDot = qualifiedName.indexOf(46, start);
        }
        return ParseUtil.isCeylonKeyword(qualifiedName, start, qualifiedName.length());
    }

    public static String join(String sep, String ... parts) {
        StringBuilder sb = new StringBuilder();
        for (String part : parts) {
            sb.append(part).append(sep);
        }
        return sb.subSequence(0, sb.length() - sep.length()).toString();
    }
}

