/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.typechecker.util;

import com.redhat.ceylon.compiler.typechecker.analyzer.AnalysisError;
import com.redhat.ceylon.compiler.typechecker.analyzer.UnsupportedError;
import com.redhat.ceylon.compiler.typechecker.analyzer.UsageWarning;
import com.redhat.ceylon.compiler.typechecker.context.TypecheckerUnit;
import com.redhat.ceylon.compiler.typechecker.parser.LexError;
import com.redhat.ceylon.compiler.typechecker.parser.ParseError;
import com.redhat.ceylon.compiler.typechecker.tree.AnalysisMessage;
import com.redhat.ceylon.compiler.typechecker.tree.Message;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.UnexpectedError;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.model.typechecker.model.Type;
import java.util.ArrayList;
import java.util.List;

public class AssertionVisitor
extends Visitor {
    private boolean expectingError = false;
    private String errMessage;
    private List<Message> foundErrors = new ArrayList<Message>();
    private int errors = 0;
    private int warnings = 0;
    private boolean usageWarnings = false;
    boolean ignore;

    @Override
    public void visit(Tree.TypedDeclaration that) {
        if (that.getType() != null) {
            this.checkType(that, that.getType().getTypeModel(), that.getType());
        }
        super.visit(that);
    }

    @Override
    public void visit(Tree.ExpressionStatement that) {
        this.checkType(that, that.getExpression().getTypeModel(), that.getExpression());
        super.visit(that);
    }

    protected void checkType(Tree.Statement that, Type type, Node typedNode) {
        for (Tree.CompilerAnnotation c : that.getCompilerAnnotations()) {
            if (!c.getIdentifier().getText().equals("type")) continue;
            Tree.StringLiteral sl = c.getStringLiteral();
            if (sl == null) {
                this.out((Node)that, "missing asserted type");
                continue;
            }
            String expectedType = sl.getText();
            if (typedNode == null || type == null || type.getDeclaration() == null) {
                this.out((Node)that, "type not known");
                continue;
            }
            String actualType = type.asString(false);
            String abbreviatedActualType = type.asString();
            if (actualType.equals(expectedType) || abbreviatedActualType.equals(expectedType)) continue;
            String desc = "'" + abbreviatedActualType + "'";
            if (!actualType.equals(abbreviatedActualType)) {
                desc = desc + " ('" + actualType + "')";
            }
            this.out((Node)that, "type " + desc + " not of expected type '" + expectedType + "'");
        }
    }

    @Override
    public void visit(Tree.StatementOrArgument that) {
        if (this.ignore) {
            super.visit(that);
            return;
        }
        if (that instanceof Tree.Variable && ((Tree.Variable)that).getType() instanceof Tree.SyntheticVariable) {
            super.visit(that);
            return;
        }
        if (that instanceof Tree.ForIterator) {
            super.visit(that);
            return;
        }
        boolean b = this.expectingError;
        List<Message> f = this.foundErrors;
        this.expectingError = false;
        this.foundErrors = new ArrayList<Message>();
        this.initExpectingError(that.getCompilerAnnotations());
        super.visit(that);
        this.checkErrors(that);
        this.expectingError = b;
        this.errMessage = null;
        this.foundErrors = f;
    }

    @Override
    public void visit(Tree.ParameterDeclaration that) {
        boolean b = this.expectingError;
        List<Message> f = this.foundErrors;
        this.expectingError = false;
        this.errMessage = null;
        this.foundErrors = new ArrayList<Message>();
        this.initExpectingError(that.getTypedDeclaration().getCompilerAnnotations());
        this.ignore = true;
        super.visit(that);
        this.ignore = false;
        this.checkErrors(that);
        this.expectingError = b;
        this.errMessage = null;
        this.foundErrors = f;
    }

    @Override
    public void visit(Tree.CompilationUnit that) {
        this.expectingError = false;
        this.foundErrors = new ArrayList<Message>();
        this.initExpectingError(that.getCompilerAnnotations());
        this.foundErrors.addAll(that.getErrors());
        this.checkErrors(that);
        this.foundErrors = new ArrayList<Message>();
        this.expectingError = false;
        this.errMessage = null;
        super.visitAny(that);
    }

    protected void out(Node that, String message) {
        System.err.println(message + " at " + that.getLocation() + " of " + this.file(that));
    }

    protected void out(Node that, LexError err) {
        ++this.errors;
        System.err.println("lex error [" + err.getMessage() + "] at " + err.getHeader() + " of " + this.file(that));
    }

    protected void out(Node that, ParseError err) {
        ++this.errors;
        System.err.println("parse error [" + err.getMessage() + "] at " + err.getHeader() + " of " + this.file(that));
    }

    protected void out(UnexpectedError err) {
        ++this.errors;
        System.err.println("unexpected error [" + err.getMessage() + "] at " + this.loc(err));
    }

    protected void out(AnalysisError err) {
        ++this.errors;
        System.err.println("error [" + err.getMessage() + "] at " + this.loc(err));
    }

    protected void out(UnsupportedError err) {
        ++this.warnings;
        System.out.println("warning [" + err.getMessage() + "] at " + this.loc(err));
    }

    protected void out(UsageWarning err) {
        System.out.println("warning [" + err.getMessage() + "] at " + this.loc(err));
    }

    private String loc(AnalysisMessage err) {
        return err.getTreeNode().getLocation() + " of " + this.file(err.getTreeNode());
    }

    private String file(Node that) {
        TypecheckerUnit unit = that.getUnit();
        if (unit == null) {
            return null;
        }
        String relativePath = unit.getRelativePath();
        return !relativePath.isEmpty() ? relativePath : unit.getFilename();
    }

    private void checkErrors(Node that) {
        try {
            for (Message err : this.foundErrors) {
                if (!this.includeError(err, 1) || !(err instanceof UnexpectedError)) continue;
                this.out((UnexpectedError)err);
            }
            if (this.expectingError) {
                boolean found = false;
                for (Message err : this.foundErrors) {
                    if (!this.includeError(err, 2) || !(err instanceof AnalysisError) && !(err instanceof LexError) && !(err instanceof ParseError)) continue;
                    if (this.errMessage == null || err.getMessage().contains(this.errMessage)) {
                        return;
                    }
                    found = true;
                }
                if (found) {
                    this.out(that, "error message should contain \"" + this.errMessage);
                } else {
                    this.out(that, "no errors");
                    return;
                }
            }
            for (Message err : this.foundErrors) {
                if (!this.includeError(err, 3)) continue;
                if (err instanceof LexError) {
                    this.out(that, (LexError)err);
                    continue;
                }
                if (err instanceof ParseError) {
                    this.out(that, (ParseError)err);
                    continue;
                }
                if (err instanceof UnsupportedError) {
                    this.out((UnsupportedError)err);
                    continue;
                }
                if (err instanceof AnalysisError) {
                    this.out((AnalysisError)err);
                    continue;
                }
                if (!(err instanceof UsageWarning) || !this.usageWarnings) continue;
                this.out((UsageWarning)err);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void initExpectingError(List<Tree.CompilerAnnotation> annotations) {
        for (Tree.CompilerAnnotation c : annotations) {
            if (!c.getIdentifier().getText().equals("error")) continue;
            this.expectingError = true;
            Tree.StringLiteral sl = c.getStringLiteral();
            if (sl == null) continue;
            this.errMessage = sl.getText();
        }
    }

    protected boolean includeError(Message err, int phase) {
        return true;
    }

    public void includeUsageWarnings(boolean usageWarnings) {
        this.usageWarnings = usageWarnings;
    }

    @Override
    public void visitAny(Node that) {
        this.foundErrors.addAll(that.getErrors());
        super.visitAny(that);
    }

    public void print(boolean verbose) {
        if (!verbose && this.errors == 0 && this.warnings == 0) {
            return;
        }
        System.out.println(this.errors + " errors, " + this.warnings + " warnings");
    }

    public List<Message> getFoundErrors() {
        return this.foundErrors;
    }

    public int getErrors() {
        return this.errors;
    }

    public int getWarnings() {
        return this.warnings;
    }
}

